package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.component.UITreeNodesAdaptor;

public class HtmlTreeNodesAdaptor extends UITreeNodesAdaptor{

final public static  String COMPONENT_FAMILY = "org.richfaces.TreeNodesAdaptor";

final public static  String COMPONENT_TYPE = "org.richfaces.TreeNodesAdaptor";

/*
* This boolean expression is used to define which elements are processed
*/
private  boolean _includedNode = true;

private  boolean _includedNodeSet = false;

/*
* Defines collection to use at the other (non-top) levels of iteration
*/
private  Object _nodes = null;

/*
* A request-scope attribute via which the data object for the current collection element will be used when iterating
*/
private  String _var = null;


public HtmlTreeNodesAdaptor(){

}

public boolean isIncludedNode(){
	if (this._includedNodeSet) {
	    return (this._includedNode);
	}
	ValueExpression ve = getValueExpression("includedNode");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._includedNode);
	    }
	    
	    return value;
	} else {
	    return (this._includedNode);
	}

}

public void setIncludedNode(boolean _includedNode){
this._includedNode = _includedNode;
this._includedNodeSet = true;
}

public Object getNodes(){
	if (this._nodes != null) {
		return this._nodes;
	}
	ValueExpression ve = getValueExpression("nodes");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setNodes(Object _nodes){
this._nodes = _nodes;
}

public String getVar(){
	if (this._var != null) {
		return this._var;
	}
	ValueExpression ve = getValueExpression("var");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setVar(String _var){
this._var = _var;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[5];
state[0] = super.saveState(context);
state[1] = Boolean.valueOf(_includedNode);
state[2] = Boolean.valueOf(_includedNodeSet);
state[3] = saveAttachedState(context, _nodes);
state[4] = _var;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_includedNode = ((Boolean)states[1]).booleanValue();
		_includedNodeSet = ((Boolean)states[2]).booleanValue();
		_nodes = (Object)restoreAttachedState(context, states[3]);
		_var = (String)states[4];;
	
}

}
