/**
 * 
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Iterator;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

import org.richfaces.component.Column;
import org.richfaces.component.UIScrollableDataTable;

/**
 * @author Anton Belevich
 *
 */
public class ColumnWalker{
	
	static int iterateOverColumns(FacesContext context, UIComponent component, ColumnVisitor visitor, 
								   ResponseWriter writer, ScrollableDataTableRendererState state) throws IOException{
		
		int columnsCount = 0;
		
		if(context == null || component == null){
			throw new NullPointerException();
		}

		if(!component.isRendered()){
			return 0;
		}

		try {
			
			if(component instanceof UIScrollableDataTable){
				for (Iterator<UIComponent> iter = component.getChildren().iterator(); iter.hasNext(); ) {
					UIComponent kid = (UIComponent) iter.next();
					if (kid.isRendered()) {
						if (kid instanceof Column){
							columnsCount += visitor.visit(context, kid, writer, state);
							state.nextCell();
						}
					}
				}
				state.setCellIndex(0);
			}

		} finally {
		}
		

		return columnsCount;
	}
}
