/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;


// 
// Imports
//
import java.util.Iterator;
import java.util.Collection;
import java.util.Map;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.ComponentVariables;
//
//
//


import org.richfaces.renderkit.html.PanelBarItemRendererBase;



/**
 * Renderer for component class org.richfaces.renderkit.html.PanelBarItemRenderer
 */
public class PanelBarItemRenderer extends PanelBarItemRendererBase {

	public PanelBarItemRenderer () {
		super();
	}

	// 
	// Declarations
	//
	// 
	// 
	//


	private String convertToString(Object obj ) {
		return ( obj == null ? "" : obj.toString() );
	}
	private String convertToString(boolean b ) {
		return String.valueOf(b);
	}
	private String convertToString(int b ) {
		return b!=Integer.MIN_VALUE?String.valueOf(b):"";
	}
	private String convertToString(long b ) {
		return b!=Long.MIN_VALUE?String.valueOf(b):"";
	}
	
	private boolean isEmpty(Object o) {
		if (null == o) {
			return true;
		}
		if (o instanceof String ) {
			return (0 == ((String)o).length());
		}
		if (o instanceof Collection) {
			return (0 == ((Collection)o).size());
		}
		if (o instanceof Map) {
			return (0 == ((Map)o).size());
		}
		if (o.getClass().isArray()) {
			return (0 == ((Object [])o).length);
		}
		return false;
	}
	
	/**
	 * Get base component class, targetted for this renderer. Used for check arguments in decode/encode.
	 * @return
	 */
	protected Class getComponentClass() {
		return org.richfaces.component.UIPanelBarItem.class;
	}

	
	public void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component ) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeBegin(writer, context, (org.richfaces.component.UIPanelBarItem)component, variables );
	}		

	public void doEncodeBegin(ResponseWriter writer, FacesContext context, org.richfaces.component.UIPanelBarItem component, ComponentVariables variables ) throws IOException {
	    java.lang.String clientId = component.getClientId(context);
javax.faces.component.UIComponent panel  = component.getPanel() ;
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "dr-pnlbar rich-panelbar dr-pnlbar-ext " + convertToString(panel.getAttributes().get("styleClass")) );
						getUtils().writeAttribute(writer, "id", clientId );
						getUtils().writeAttribute(writer, "style", panel.getAttributes().get("style") );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "dr-pnlbar-h rich-panelbar-header " + convertToString(panel.getAttributes().get("headerClass")) + " " + convertToString(component.getAttributes().get("headerClass")) );
						getUtils().writeAttribute(writer, "style", convertToString(panel.getAttributes().get("headerStyle")) + ";" + convertToString(component.getAttributes().get("headerStyle")) );
			

            if(component.getFacet("label")!=null && component.getFacet("label").isRendered()) {
        
UIComponent indexChildren_2 = component.getFacet("label");
if (null != indexChildren_2 && indexChildren_2 .isRendered()) {
	renderChild(context, indexChildren_2);
}


            } else {
        
writer.writeText(convertToString(component.getAttributes().get("label")),null);


            }
        
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "dr-pnlbar-h-act rich-panelbar-header-act " + convertToString(panel.getAttributes().get("headerClass")) + " " + convertToString(component.getAttributes().get("headerClass")) + " " + convertToString(panel.getAttributes().get("headerClassActive")) + " " + convertToString(component.getAttributes().get("headerClassActive")) );
						getUtils().writeAttribute(writer, "style", convertToString(panel.getAttributes().get("headerStyle")) + ";" + convertToString(component.getAttributes().get("headerStyle")) + ";" + convertToString(panel.getAttributes().get("headerStyleActive")) + ";" + convertToString(component.getAttributes().get("headerStyleActive")) + ";display: none;" );
			

            if(component.getFacet("label")!=null && component.getFacet("label").isRendered()) {
        
UIComponent indexChildren_3 = component.getFacet("label");
if (null != indexChildren_3 && indexChildren_3 .isRendered()) {
	renderChild(context, indexChildren_3);
}


            } else {
        
writer.writeText(convertToString(component.getAttributes().get("label")),null);


            }
        
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "style", "display: none; width: 100%;" );
			
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "style", "height: 100%;" );
						getUtils().writeAttribute(writer, "width", "100%" );
			
writer.startElement("tbody", component);

writer.startElement("tr", component);

writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "dr-pnlbar-c rich-panelbar-content " + convertToString(panel.getAttributes().get("contentClass")) + " " + convertToString(component.getAttributes().get("contentClass")) );
						getUtils().writeAttribute(writer, "style", convertToString(panel.getAttributes().get("contentStyle")) + ";" + convertToString(component.getAttributes().get("contentStyle")) );
			

	}		
	
    public void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeChildren(writer, context, (org.richfaces.component.UIPanelBarItem)component, variables );
	}		

    public void doEncodeChildren(ResponseWriter writer, FacesContext context, org.richfaces.component.UIPanelBarItem component, ComponentVariables variables) throws IOException {
	    
renderChildren(context, component);


	}		

	/* (non-Javadoc)
	 * @see javax.faces.render.Renderer#getRendersChildren()
	 */
	public boolean getRendersChildren() {
		return true;
	}

	public void doEncodeEnd(ResponseWriter writer, FacesContext context, org.richfaces.component.UIPanelBarItem component, ComponentVariables variables) throws IOException {
	  
writer.endElement("td");
writer.endElement("tr");
writer.endElement("tbody");
writer.endElement("table");
writer.endElement("div");
writer.endElement("div");

	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeEnd(writer, context, (org.richfaces.component.UIPanelBarItem)component, variables );

		ComponentsVariableResolver.removeVariables(this, component);
	}		
	

}
