package org.richfaces.renderkit.html.iconimages;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;

import org.ajax4jsf.resource.ResourceContext;

public class DataTableIconSortDesc extends DataTableIconBasic {

	public Dimension calculateDimensions() {
		return new Dimension(13, 4);
	}
	
	protected void paint(ResourceContext context, Graphics2D g2d) {
		g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
		g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
		GeneralPath path = new GeneralPath();
		
		path.moveTo(1,0);
		path.lineTo(4,4);
		path.lineTo(8,0);
		path.closePath();
		Object [] data = (Object[]) restoreData(context);
		Color col = (Color)data[0];
		
		g2d.setColor(col);
		g2d.fill(path);
	}
}
