/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;


// 
// Imports
//
import java.util.Iterator;
import java.util.Collection;
import java.util.Map;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResource;
//
//
//


import org.richfaces.renderkit.DataFilterSliderRendererBase;



/**
 * Renderer for component class org.richfaces.renderkit.html.DataFilterSliderRenderer
 */
public class DataFilterSliderRenderer extends DataFilterSliderRendererBase {

	public DataFilterSliderRenderer () {
		super();
	}

	// 
	// Declarations
	//
	private final InternetResource[] styles = {
						getResource("css/dataFilterSlider.xcss")
	};

private InternetResource[] stylesAll = null;

protected InternetResource[] getStyles() {
	synchronized (this) {
		if (stylesAll == null) {
			InternetResource[] rsrcs = super.getStyles();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = styles == null || styles.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					stylesAll = new InternetResource[0];	
				} else {
					stylesAll = styles;
				}
			} else {
				if (ignoreThis) {
					stylesAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < styles.length; i++ ) {
						rsrcsSet.add(styles[i]);
					}

					stylesAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return stylesAll;
}
	private final InternetResource[] scripts = {
						new org.ajax4jsf.javascript.PrototypeScript()
						,
				getResource("scripts/scriptaculous-js-1.6.5/src/slider.js")
	};

private InternetResource[] scriptsAll = null;

protected InternetResource[] getScripts() {
	synchronized (this) {
		if (scriptsAll == null) {
			InternetResource[] rsrcs = super.getScripts();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = scripts == null || scripts.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					scriptsAll = new InternetResource[0];	
				} else {
					scriptsAll = scripts;
				}
			} else {
				if (ignoreThis) {
					scriptsAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < scripts.length; i++ ) {
						rsrcsSet.add(scripts[i]);
					}

					scriptsAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return scriptsAll;
}
	// 
	// 
	//


	private String convertToString(Object obj ) {
		return ( obj == null ? "" : obj.toString() );
	}
	private String convertToString(boolean b ) {
		return String.valueOf(b);
	}
	private String convertToString(int b ) {
		return b!=Integer.MIN_VALUE?String.valueOf(b):"";
	}
	private String convertToString(long b ) {
		return b!=Long.MIN_VALUE?String.valueOf(b):"";
	}
	
	private boolean isEmpty(Object o) {
		if (null == o) {
			return true;
		}
		if (o instanceof String ) {
			return (0 == ((String)o).length());
		}
		if (o instanceof Collection) {
			return (0 == ((Collection)o).size());
		}
		if (o instanceof Map) {
			return (0 == ((Map)o).size());
		}
		if (o.getClass().isArray()) {
			return (0 == ((Object [])o).length);
		}
		return false;
	}
	
	/**
	 * Get base component class, targetted for this renderer. Used for check arguments in decode/encode.
	 * @return
	 */
	protected Class getComponentClass() {
		return org.richfaces.component.UIDataFltrSlider.class;
	}


	public void doEncodeEnd(ResponseWriter writer, FacesContext context, org.richfaces.component.UIDataFltrSlider component, ComponentVariables variables) throws IOException {
	  java.lang.String clientId = component.getClientId(context);
variables.setVariable("arrow", getResource( "org.richfaces.renderkit.html.images.SliderArrowImage" ).getUri(context, component) );


		org.richfaces.component.util.FormUtil.throwEnclFormReqExceptionIfNeed(context,component);
    
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "slider-container rich-dataFilterSlider-container " + convertToString(component.getStyleClass()) );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "range rich-dataFilterSlider-range " + convertToString(component.getRangeStyleClass()) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "slider-range" );
						getUtils().writeAttribute(writer, "style", "width:" + convertToString(component.getAttributes().get("width")) );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "range-decor rich-dataFilterSlider-range-decor" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "slider-range-decor" );
			

                   
                        boolean trailer = attributeToBoolean(component, "trailer");
                        if (trailer) {
                    
                  
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "trailer rich-dataFilterSlider-trailer " + convertToString(component.getTrailerStyleClass()) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "slider-trailer" );
			

                       
                            }
                        
                      
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "track rich-dataFilterSlider-track " + convertToString(component.getTrackStyleClass()) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "slider-track" );
						getUtils().writeAttribute(writer, "style", "width:" + convertToString(component.getAttributes().get("width")) );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "handle rich-dataFilterSlider-handle " + convertToString(component.getHandleStyleClass()) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "slider-handle" );
			
writer.startElement("img", component);
			getUtils().writeAttribute(writer, "alt", "" );
						getUtils().writeAttribute(writer, "border", "0" );
						getUtils().writeAttribute(writer, "height", "8" );
						getUtils().writeAttribute(writer, "src", variables.getVariable("arrow") );
						getUtils().writeAttribute(writer, "width", "7" );
			
writer.endElement("img");
writer.endElement("div");
writer.endElement("div");

                   
                        if (trailer) {
                    
                  
writer.endElement("div");

                       
                            }
                        
                      
writer.endElement("div");
writer.endElement("div");

               
                    boolean manualInput = attributeToBoolean(component, "manualInput");
                    if (manualInput) {
                
              
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "class", "slider-input-field rich-dataFilterSlider-input-field " + convertToString(component.getFieldStyleClass()) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "slider_val" );
						getUtils().writeAttribute(writer, "name", convertToString(clientId) + "slider_val" );
						getUtils().writeAttribute(writer, "onchange", "dataFilterSlider.valueChanged(event,this.value);" );
						getUtils().writeAttribute(writer, "type", "text" );
						getUtils().writeAttribute(writer, "value", component.getHandleValue() );
			
writer.endElement("input");

               
                    }else{
                
              
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + "slider_val" );
						getUtils().writeAttribute(writer, "name", convertToString(clientId) + "slider_val" );
						getUtils().writeAttribute(writer, "type", "hidden" );
						getUtils().writeAttribute(writer, "value", component.getHandleValue() );
			
writer.endElement("input");

               
                    }
                
              
writer.startElement("script", component);
			getUtils().writeAttribute(writer, "language", "javascript" );
						getUtils().writeAttribute(writer, "type", "text/javascript" );
			
writer.writeText(convertToString(convertToString(renderSliderJs1(context,component)) + "\n\n             " + convertToString(renderSliderJs2(context,component))),null);

writer.endElement("script");
writer.startElement("br", component);
			getUtils().writeAttribute(writer, "style", "clear:both" );
			
writer.endElement("br");
writer.endElement("div");

	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeEnd(writer, context, (org.richfaces.component.UIDataFltrSlider)component, variables );

		ComponentsVariableResolver.removeVariables(this, component);
	}		
	

}
