/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;

import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.renderkit.RendererBase;

public class MenuItemRendererDelegate extends RendererBase {
	
	protected void initializeStyles(FacesContext context, UIComponent menuItem, 
			boolean disabled, ComponentVariables variables) {
		UIComponent parentMenu = getParentMenu(context, menuItem);
		Object itemClass = parentMenu.getAttributes().get("itemClass");
		Object itemStyle = parentMenu.getAttributes().get("itemStyle");
		Object disabledItemClass = parentMenu.getAttributes().get("disabledItemClass");
		Object disabledItemStyle = parentMenu.getAttributes().get("disabledItemStyle");
		Object selectItemClass = parentMenu.getAttributes().get("selectItemClass");
		Object selectClass = menuItem.getAttributes().get("selectClass");
		Object styleClass = menuItem.getAttributes().get("styleClass");
		Object style = parentMenu.getAttributes().get("style");
		Object labelClass = (String)menuItem.getAttributes().get("labelClass");
		Object disabledLabelClass = (String)menuItem.getAttributes().get("labelClass");
		Object selectedLabelClass = (String)menuItem.getAttributes().get("labelClass");
		
        if (null == labelClass) {
        	labelClass = "";
        }
        if (null == disabledLabelClass) {
        	disabledLabelClass = "";
        }
        if (null == selectedLabelClass) {
        	selectedLabelClass = "";
        }
		if (null == itemClass) {
			itemClass = "";
		}
		if (null == itemStyle) {
			itemStyle = "";
		}
		if (null == disabledItemClass) {
			disabledItemClass = "";
		}
		if (null == disabledItemStyle) {
			disabledItemStyle = "";
		}
		if (null == selectItemClass) {
			selectItemClass = "";
		}
		if (null == styleClass) {
			styleClass = "";
		}
		if (null == selectClass) {
			selectClass = "";
		}
		if (null == style) {
			style = "";
		}
		
		if (disabled) {
			variables.setVariable("menuItemClass", 
					"dr-menu-item dr-menu-item-disabled rich-menu-item rich-menu-item-disabled " +
					styleClass + " " +
					itemClass + " " + disabledItemClass);
			variables.setVariable("menuItemStyle", 
					itemStyle + "; " +	disabledItemStyle + "; " + style);
			variables.setVariable("menuItemLabelClass", "rich-menu-item-label rich-menu-item-label-disabled " +
            		labelClass + " " + disabledLabelClass);
			variables.setVariable("menuGroupClass", "dr-menu-item dr-menu-item-disabled rich-menu-group rich-menu-group-disabled " + 
					itemClass + " " + disabledItemClass + " " + styleClass);
			variables.setVariable("menuItemMouseMove", "");
			variables.setVariable("menuItemItemIconClass", "rich-menu-item-icon-disabled");
			variables.setVariable("menuItemItemLabelClass", "rich-menu-item-label-disabled " + labelClass);
			variables.setVariable("menuItemItemFolderClass", "rich-menu-item-folder-disabled");
		} else {
			variables.setVariable("menuItemClass", 
					"dr-menu-item dr-menu-item-enabled rich-menu-item rich-menu-item-enabled " +
					styleClass + " " + itemClass);
			variables.setVariable("menuItemStyle", itemStyle + "; " + style);
			variables.setVariable("menuItemHoverClass",
					"this.className='dr-menu-item dr-menu-item-hover rich-menu-item rich-menu-item-hover " +
					styleClass + " " + selectClass + 
					selectItemClass + "';");
			variables.setVariable("menuItemLabelClass", "rich-menu-item-label " + labelClass);
			variables.setVariable("selectLabelClass", selectedLabelClass);
			variables.setVariable("menuGroupClass", "dr-menu-item dr-menu-item-enabled rich-menu-group " +
					itemClass + " " + styleClass);
			variables.setVariable("menuItemMouseMove", menuItem.getAttributes().get("onmousemove"));
			variables.setVariable("menuGroupItemIconClass", "rich-menu-item-icon-enabled");
			variables.setVariable("menuGroupItemLabelClass", "rich-menu-item-label " + labelClass);
			variables.setVariable("menuGroupItemFolderClass", "rich-menu-item-folder");
			variables.setVariable("onmouseoutInlineStyles", processInlineStyles(context, menuItem, false));
            variables.setVariable("onmouseoverInlineStyles", processInlineStyles(context, menuItem, true));
            
            variables.setVariable("menuGroupHoverClass", "this.className='dr-menu-item dr-menu-item-enabled rich-menu-group " +
					itemClass + " " +  selectItemClass + " " + styleClass + "'");
		}
	}
	
	protected String processInlineStyles(FacesContext context, UIComponent menuItem, boolean isOnmouseover) {

		StringBuffer buffer = new StringBuffer();
		Object style = menuItem.getAttributes().get("style");
		Object selectStyle = menuItem.getAttributes().get("selectStyle");

		UIComponent parentMenu = getParentMenu(context, menuItem);
		Object selectItemStyle = parentMenu.getAttributes().get("selectItemStyle");
		Object itemStyle = parentMenu.getAttributes().get("itemStyle");

		if (null == selectStyle) {
			selectStyle = "";
		}
		if (null == selectItemStyle) {
			selectItemStyle = "";
		}
		if (null == itemStyle) {
			itemStyle = "";
		}

		selectStyle = itemStyle + "; " + selectItemStyle + "; " + selectStyle;

		buffer.append("$('" + menuItem.getClientId(context) + "').style.cssText='");

		if (null != style) {
			buffer.append(style.toString() + "; ");
		}

		if (isOnmouseover) {
			buffer.append(selectStyle.toString() + ";';");
		} else {
			buffer.append(itemStyle.toString() + ";';");
		}

		return buffer.toString();
	}
	
	protected UIComponent getParentMenu(FacesContext context, UIComponent menuItem) {
		UIComponent parent = menuItem.getParent();
		while (null != parent) {
			if (parent instanceof org.richfaces.component.MenuComponent) {
				return parent;
			}
			parent = parent.getParent();
		}
		throw new FacesException( "Parent menu for menu group (id=" 
   			 + menuItem.getClientId(context) + ") has not been found.");
	}
	
	protected Class getComponentClass() {
		return null;
	}

}
