/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;


import java.io.IOException;

import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

import org.ajax4jsf.renderkit.RendererBase;
import org.ajax4jsf.util.HtmlDimensions;
import org.ajax4jsf.util.style.CSSFormat;
import org.richfaces.component.UISeparator;
import org.richfaces.renderkit.html.images.BevelSeparatorImage;
import org.richfaces.renderkit.html.images.SimpleSeparatorImage;

public class SeparatorRendererBase extends RendererBase {

    private static final String[] SUPPORTED_TYPES = {
            UISeparator.LINE_TYPE_BEVEL,
            UISeparator.LINE_TYPE_DASHED,
            UISeparator.LINE_TYPE_DOTTED,
            UISeparator.LINE_TYPE_DOUBLE,
            UISeparator.LINE_TYPE_SOLID
    };

    private String getCSSDimension(UIComponent component, String attributeName, String defaultValue) {
        Object hO = component.getAttributes().get(attributeName);
        String height;
        if (hO == null) {
            height = defaultValue;
        } else if (hO instanceof String) {
            height = (String) hO;
            if (height.trim().length() == 0) {
                height = defaultValue;
            }
        } else {
            height = hO.toString();
        }
        if (height.trim().length() == 0) {
        	return height;
        } else {
        	return getUtils().encodePctOrPx(height);
        }
    }

    protected Class getComponentClass() {
        return UISeparator.class;
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected boolean isSupportedLineType(String lineType) {
        for (int i = 0; i < SUPPORTED_TYPES.length; i++) {
            if (lineType.equalsIgnoreCase(SUPPORTED_TYPES[i])) return true;
        }
        return false;
    }

    public String backgroundImage(FacesContext context, UIComponent component) throws IOException {
        UISeparator separator = (UISeparator) component;
        String lineType = separator.getLineType();
        if (! isSupportedLineType(lineType)) {
            lineType = UISeparator.LINE_TYPE_BEVEL;
        }
        String height = getHeight(context, component);
        if (height.trim().endsWith("%"))
            throw new FacesException("It is not allowed to set height of separator in percent (component " + component.getId() + ")!");
        int h = HtmlDimensions.decode(height).intValue();

        if (lineType == null || lineType.trim().length() == 0) {
            lineType = UISeparator.LINE_TYPE_BEVEL;
        }
        //XXX by nick - fantonov - equalsIgnoreCase here?
        if (lineType.equalsIgnoreCase(UISeparator.LINE_TYPE_BEVEL) && h < 3) {
            lineType = UISeparator.LINE_TYPE_SOLID;
        }
        String uri = null;
        if (lineType.equalsIgnoreCase(UISeparator.LINE_TYPE_BEVEL)) {
            uri = getResource(BevelSeparatorImage.class.getName()).getUri(context, component);
        } else {
            uri = getResource(SimpleSeparatorImage.class.getName()).getUri(context, component);
        }
        
        if (uri != null) {
        	uri = CSSFormat.url(uri);
        }
        
        return uri;
    }

    public String getHeight(FacesContext context, UIComponent component) {
        return getCSSDimension(component, "height", UISeparator.DEFAULT_HEIGHT);
    }

    public String getWidth(FacesContext context, UIComponent component) {
        return getCSSDimension(component, "width", UISeparator.DEFAULT_WIDTH);
    }
}
