package org.richfaces.ui.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.ui.component.UIInsert;

public class HtmlInsert extends UIInsert{

static final public  String COMPONENT_FAMILY = "org.richfaces.ui.Insert";

static final public  String COMPONENT_TYPE = "org.richfaces.ui.Insert";

/*
* Attribute defines encoding for inserted content
*/
private  String _encoding = null;

/*
* Attribute defines the alternative content that will be shown in case
component cannot read the resource defined with 'src' attribute. If "errorContent" attribute is not defined,
the component shown the actual error message in the place where the content is expected
*/
private  String _errorContent = null;

/*
* Defines a type of code
*/
private  String _highlight = null;

/*
* Defines the path to the file with source code
*/
private  String _src = null;


public HtmlInsert(){
setRendererType("org.richfaces.ui.InsertRenderer");
}

public String getEncoding(){
	if (this._encoding != null) {
		return this._encoding;
	}
	ValueExpression ve = getValueExpression("encoding");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setEncoding(String _encoding){
this._encoding = _encoding;
}

public String getErrorContent(){
	if (this._errorContent != null) {
		return this._errorContent;
	}
	ValueExpression ve = getValueExpression("errorContent");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setErrorContent(String _errorContent){
this._errorContent = _errorContent;
}

public String getHighlight(){
	if (this._highlight != null) {
		return this._highlight;
	}
	ValueExpression ve = getValueExpression("highlight");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setHighlight(String _highlight){
this._highlight = _highlight;
}

public String getSrc(){
	if (this._src != null) {
		return this._src;
	}
	ValueExpression ve = getValueExpression("src");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSrc(String _src){
this._src = _src;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[5];
state[0] = super.saveState(context);
state[1] = _encoding;
state[2] = _errorContent;
state[3] = _highlight;
state[4] = _src;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_encoding = (String)states[1];;
		_errorContent = (String)states[2];;
		_highlight = (String)states[3];;
		_src = (String)states[4];;
	
}

}
