/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.component.AjaxSupport;
import org.ajax4jsf.component.SequenceDataAdaptor;
import org.ajax4jsf.model.ExtendedDataModel;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.collections.iterators.IteratorChain;
import org.richfaces.component.Column;
import org.richfaces.component.Dropzone;
import org.richfaces.component.Filterable;
import org.richfaces.component.Sortable2;
import org.richfaces.component.UIColumn;
import org.richfaces.model.FilterField;
import org.richfaces.model.ModifiableModel;
import org.richfaces.model.SortField2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIDataTable
extends SequenceDataAdaptor
implements Sortable2,
Filterable {
    Collection<Object> sortPriority = new ArrayList<Object>();
    public static final Predicate isColumn = new ColumnPredicate();
    public static final Predicate isNotColumn = new NotColumnPredicate();
    public static final Predicate isAjaxSupport = new AjaxSupportPredicate();
    public static final String COMPONENT_TYPE = "org.richfaces.DataTable";
    public static final String COMPONENT_FAMILY = "org.richfaces.DataTable";

    public Iterator<UIComponent> dataChildren() {
        IteratorChain dataChildren = new IteratorChain();
        dataChildren.addIterator((Iterator)new FilterIterator(this.getFacets().values().iterator(), isAjaxSupport));
        dataChildren.addIterator(this.columns());
        dataChildren.hasNext();
        return dataChildren;
    }

    public Iterator<UIComponent> fixedChildren() {
        IteratorChain fixedChildren = new IteratorChain(this.getFacets().values().iterator());
        fixedChildren.addIterator((Iterator)new FilterIterator(this.getChildren().iterator(), isNotColumn));
        Iterator<UIComponent> iter = this.columns();
        while (iter.hasNext()) {
            UIComponent column = iter.next();
            if (!column.isRendered()) continue;
            fixedChildren.addIterator(column.getFacets().values().iterator());
        }
        fixedChildren.hasNext();
        return fixedChildren;
    }

    public Iterator<UIComponent> columns() {
        return new FilterIterator(this.getChildren().iterator(), isColumn);
    }

    protected ExtendedDataModel createDataModel() {
        LinkedList<FilterField> filterFields = new LinkedList<FilterField>();
        LinkedHashMap<String, SortField2> sortFieldsMap = new LinkedHashMap<String, SortField2>();
        List list = this.getChildren();
        for (UIComponent component : list) {
            SortField2 sortField;
            if (!(component instanceof UIColumn)) continue;
            UIColumn column = (UIColumn)component;
            FilterField filterField = column.getFilterField();
            if (filterField != null) {
                filterFields.add(filterField);
            }
            if ((sortField = column.getSortField()) == null) continue;
            sortFieldsMap.put(component.getId(), sortField);
        }
        LinkedList<Object> sortFields = new LinkedList<Object>();
        Collection<Object> sortPriority = this.getSortPriority();
        if (sortPriority != null) {
            for (Object object : sortPriority) {
                String id;
                SortField2 sortField;
                if (!(object instanceof String) || (sortField = (SortField2)sortFieldsMap.get(id = (String)object)) == null) continue;
                sortFields.add(sortField);
                sortFieldsMap.remove(id);
            }
        }
        sortFields.addAll(sortFieldsMap.values());
        this.setFilterFields(filterFields);
        this.setSortFields(sortFields);
        ExtendedDataModel dataModel = super.createDataModel();
        return new ModifiableModel(dataModel, this.getVar(), this.getFilterFields(), this.getSortFields());
    }

    public Collection<Object> getSortPriority() {
        ValueExpression ve = this.getValueExpression("sortPriority");
        if (ve != null) {
            Collection value = null;
            try {
                value = (Collection)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
            return value;
        }
        return this.sortPriority;
    }

    public void setSortPriority(Collection<Object> sortPriority) {
        ELContext context = this.getFacesContext().getELContext();
        ValueExpression ve = this.getValueExpression("sortPriority");
        if (ve != null && !ve.isReadOnly(context)) {
            try {
                ve.setValue(context, sortPriority);
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        } else {
            this.sortPriority = sortPriority;
        }
    }

    public abstract String getSortMode();

    public abstract void setSortMode(String var1);

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{super.saveState(context), this.sortPriority};
        return state;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] states = (Object[])state;
        super.restoreState(context, states[0]);
        this.sortPriority = (Collection)states[1];
    }

    private static final class AjaxSupportPredicate
    implements Predicate {
        private AjaxSupportPredicate() {
        }

        public boolean evaluate(Object input) {
            return input instanceof AjaxSupport || input instanceof Dropzone;
        }
    }

    private static final class ColumnPredicate
    implements Predicate {
        private ColumnPredicate() {
        }

        public boolean evaluate(Object input) {
            return input instanceof javax.faces.component.UIColumn || input instanceof Column;
        }
    }

    private static final class NotColumnPredicate
    implements Predicate {
        private NotColumnPredicate() {
        }

        public boolean evaluate(Object input) {
            return !(input instanceof javax.faces.component.UIColumn) && !(input instanceof Column);
        }
    }
}

