if (!window.Richfaces) window.Richfaces = {};

Richfaces.getDocumentHeight = function() {
	if (self.innerHeight) { // all except Explorer
	    return self.innerHeight;
	}
	else if (document.documentElement && document.documentElement.clientHeight) {
	    // Explorer 6 Strict Mode
	    return document.documentElement.clientHeight;
	}
	else if (document.body) { // other Explorers
	    return document.body.clientHeight;
	} 
}

Richfaces.getScrollWidth = function(elem) {
	if (elem.clientWidth != 0) { 
		return elem.offsetWidth - elem.clientWidth;
	}
	return 0;
}

Richfaces.getBorderWidth = function(el, side) {
	return Richfaces.getStyles(el, side, Richfaces.borders);
}
      
Richfaces.getPaddingWidth = function(el, side) {
	return Richfaces.getStyles(el, side, Richfaces.paddings);
}

Richfaces.getMarginWidth = function(el, side) {
	return Richfaces.getStyles(el, side, Richfaces.margins);
}
       
Richfaces.getStyles = function(el, sides, styles) {
   var val = 0;
   for(var i = 0, len = sides.length; i < len; i++){
	//if (el.getStyle) {
		var w = parseInt(Element.getStyle(el, styles[sides.charAt(i)]), 10);
   	 	if(!isNaN(w)) val += w;
	//}
   }
   return val;
}

Richfaces.borders = {l: 'border-left-width', r: 'border-right-width', t: 'border-top-width', b: 'border-bottom-width'},
Richfaces.paddings = {l: 'padding-left', r: 'padding-right', t: 'padding-top', b: 'padding-bottom'},
Richfaces.margins = {l: 'margin-left', r: 'margin-right', t: 'margin-top', b: 'margin-bottom'}