package org.richfaces.taglib;

import javax.faces.context.FacesContext;

import org.ajax4jsf.webapp.taglib.AjaxComponentHandler;

import com.sun.facelets.tag.MetaRuleset;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributes;
import com.sun.facelets.tag.jsf.ComponentConfig;

public abstract class ToolTipTagHandlerBase extends AjaxComponentHandler {
	
	public ToolTipTagHandlerBase(ComponentConfig config) {
		super(config);
	}
		
	protected MetaRuleset createMetaRuleset(Class type) {
		TagAttributes attributes = this.tag.getAttributes();
		TagAttribute attribute = attributes.get("event");
		if (attribute != null && attributes.get("showEvent") != null) {
			TagAttribute idAttribute = attributes.get("id");
			FacesContext facesContext = FacesContext.getCurrentInstance();
			facesContext.getExternalContext().log("showEvent attribute has been already set for component with id: " + 
					idAttribute != null ? idAttribute.getValue() : null + 
					"[" + attribute.getValue() + "]. event attribute is deprecated and thus has been dropped!");
		}
		return super.createMetaRuleset(type).alias("showEvent", "event");
	}

	
}
