/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;


// 
// Imports
//
import java.util.Iterator;
import java.util.Collection;
import java.util.Map;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResource;
//
//
//


import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;



/**
 * Renderer for component class org.richfaces.renderkit.html.GmapRenderer
 */
public class GmapRenderer extends HeaderResourcesRendererBase {

	public GmapRenderer () {
		super();
	}

	// 
	// Declarations
	//
	private final InternetResource[] styles = {
						getResource("css/gmap.xcss")
	};

private InternetResource[] stylesAll = null;

protected InternetResource[] getStyles() {
	synchronized (this) {
		if (stylesAll == null) {
			InternetResource[] rsrcs = super.getStyles();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = styles == null || styles.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					stylesAll = new InternetResource[0];	
				} else {
					stylesAll = styles;
				}
			} else {
				if (ignoreThis) {
					stylesAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < styles.length; i++ ) {
						rsrcsSet.add(styles[i]);
					}

					stylesAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return stylesAll;
}
	private final InternetResource[] scripts = {
						new org.ajax4jsf.javascript.PrototypeScript()
						,
				getResource("script/gmap.js")
	};

private InternetResource[] scriptsAll = null;

protected InternetResource[] getScripts() {
	synchronized (this) {
		if (scriptsAll == null) {
			InternetResource[] rsrcs = super.getScripts();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = scripts == null || scripts.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					scriptsAll = new InternetResource[0];	
				} else {
					scriptsAll = scripts;
				}
			} else {
				if (ignoreThis) {
					scriptsAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < scripts.length; i++ ) {
						rsrcsSet.add(scripts[i]);
					}

					scriptsAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return scriptsAll;
}
	// 
	// 
	//


	private String convertToString(Object obj ) {
		return ( obj == null ? "" : obj.toString() );
	}
	private String convertToString(boolean b ) {
		return String.valueOf(b);
	}
	private String convertToString(int b ) {
		return b!=Integer.MIN_VALUE?String.valueOf(b):"";
	}
	private String convertToString(long b ) {
		return b!=Long.MIN_VALUE?String.valueOf(b):"";
	}
	
	private boolean isEmpty(Object o) {
		if (null == o) {
			return true;
		}
		if (o instanceof String ) {
			return (0 == ((String)o).length());
		}
		if (o instanceof Collection) {
			return (0 == ((Collection)o).size());
		}
		if (o instanceof Map) {
			return (0 == ((Map)o).size());
		}
		if (o.getClass().isArray()) {
			return (0 == ((Object [])o).length);
		}
		return false;
	}
	
	/**
	 * Get base component class, targetted for this renderer. Used for check arguments in decode/encode.
	 * @return
	 */
	protected Class getComponentClass() {
		return org.richfaces.component.UIGmap.class;
	}


	public void doEncodeEnd(ResponseWriter writer, FacesContext context, org.richfaces.component.UIGmap component, ComponentVariables variables) throws IOException {
	  java.lang.String clientId = component.getClientId(context);
variables.setVariable("key", component.getAttributes().get("gmapKey") );
variables.setVariable("zoom", component.getAttributes().get("zoom") );
variables.setVariable("map", component.getAttributes().get("gmapVar") );
variables.setVariable("lat", component.getAttributes().get("lat") );
variables.setVariable("lng", component.getAttributes().get("lng") );
variables.setVariable("mapType", component.getAttributes().get("mapType") );
variables.setVariable("oninit", component.getAttributes().get("oninit") );
variables.setVariable("warningMessage", component.getAttributes().get("warningMessage") );
variables.setVariable("isGScale", component.getAttributes().get("showGScaleControl") );
variables.setVariable("isGMapType", component.getAttributes().get("showGMapTypeControl") );
variables.setVariable("isGLarge", component.getAttributes().get("showGLargeMapControl") );
variables.setVariable("enableDragging", component.getAttributes().get("enableDragging") );
variables.setVariable("enableInfoWindow", component.getAttributes().get("enableInfoWindow") );
variables.setVariable("enableDoubleClickZoom", component.getAttributes().get("enableDoubleClickZoom") );
variables.setVariable("enableContinuousZoom", component.getAttributes().get("enableContinuousZoom") );
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "dr-gmap rich-gmap " + convertToString(component.getAttributes().get("styleClass")) );
						getUtils().writeAttribute(writer, "id", clientId );
			//
// pass thru attributes
//
getUtils().encodeAttributesFromArray(context,component,new String[] {
    "align" ,
	    "dir" ,
	    "lang" ,
	    "onclick" ,
	    "ondblclick" ,
	    "onkeydown" ,
	    "onkeypress" ,
	    "onkeyup" ,
	    "onmousedown" ,
	    "onmousemove" ,
	    "onmouseout" ,
	    "onmouseover" ,
	    "onmouseup" ,
	    "style" ,
	    "title" ,
	    "xml:lang" });
//
//
//

writer.startElement("script", component);
			getUtils().writeAttribute(writer, "src", "http://maps.google.com/maps?file=api&v=2&key=" + convertToString(variables.getVariable("key")) );
						getUtils().writeAttribute(writer, "type", "text/javascript" );
			
writer.endElement("script");
writer.startElement("script", component);
			getUtils().writeAttribute(writer, "type", "text/javascript" );
			
writer.writeText(convertToString("//"),null);

     writer.write("<![CDATA[");
     writer.write(convertToString("\n\nfunction __initGMap() { __initGmapdiv(\"" + convertToString(variables.getVariable("map")) + "\",\"" + convertToString(clientId) + "\", \"" + convertToString(variables.getVariable("warningMessage")) + "\");\n __applyGmapparam(\"" + convertToString(variables.getVariable("map")) + "\"," + convertToString(variables.getVariable("lat")) + ", " + convertToString(variables.getVariable("lng")) + "," + convertToString(variables.getVariable("zoom")) + "," + convertToString(variables.getVariable("mapType")) + "," + convertToString(variables.getVariable("enableDragging")) + "," + convertToString(variables.getVariable("enableInfoWindow")) + "," + convertToString(variables.getVariable("enableDoubleClickZoom")) + "," + convertToString(variables.getVariable("enableContinuousZoom")) + "," + convertToString(variables.getVariable("isGMapType")) + "," + convertToString(variables.getVariable("isGScale")) + "," + convertToString(variables.getVariable("isGLarge")) + ");\n var userfunc = function(event) { " + convertToString(variables.getVariable("oninit")) + " }; userfunc();};__addLoadEvent(__initGMap);__addUnLoadEvent(GUnload); \n//"));
     writer.write("]]>");

writer.endElement("script");
writer.endElement("div");

	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeEnd(writer, context, (org.richfaces.component.UIGmap)component, variables );

		ComponentsVariableResolver.removeVariables(this, component);
	}		
	

}
