package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import org.richfaces.component.UITree;

public class HtmlTree extends UITree{

public static final  String COMPONENT_FAMILY = "org.richfaces.Tree";

public static final  String COMPONENT_TYPE = "org.richfaces.Tree";

/*
* List of comma separated cursors that indicates when acceptable draggable over dropzone
*/
private  String _acceptCursors = null;

/*
* A list of drag zones types, which elements are accepted by a drop zone
*/
private  Object _acceptedTypes = null;

/*
* MethodBinding pointing at a method accepting an org.richfaces.component.UITree with return of java.lang.Boolean type.
If returned value is:
java.lang.Boolean. TRUE, a particular treeNode is expanded;
java.lang.Boolean.FALSE, a particular treeNode is collapsed;
null, a particular treeNode saves the current state
*/
private  MethodBinding _adviseNodeOpened = null;

/*
* MethodBinding pointing at a method accepting an org.richfaces.component.UITree with return of java.lang.Boolean type.
If returned value is:
java.lang.Boolean. TRUE, a particular treeNode is selected;
java.lang.Boolean.FALSE, a particular treeNode is unselected;
null, a particular treeNode saves the current state
*/
private  MethodBinding _adviseNodeSelected = null;

/*
* if "true", submits ONLY one field/link, instead of all form controls
*/
private  boolean _ajaxSingle = false;

private  boolean _ajaxSingleSet = false;

/*
* If "true", an Ajax request to be submit when selecting node
*/
private  boolean _ajaxSubmitSelection = false;

private  boolean _ajaxSubmitSelectionSet = false;

/*
* If "true", after process validations phase it skips updates of model beans on a force render response. It can be used for validating components input
*/
private  boolean _bypassUpdates = false;

private  boolean _bypassUpdatesSet = false;

/*
* Listener called on expand/collapse event on the node
*/
private  MethodBinding _changeExpandListener = null;

/*
* Mapping between drop types and acceptable cursors
*/
private  Object _cursorTypeMapping = null;

/*
* Serialized (on default with JSON) data passed on the client by a developer on AJAX request. It's accessible via "data.foo" syntax
*/
private  Object _data = null;

/*
* Id of a component that is used as drag pointer during the drag operation
*/
private  String _dragIndicator = null;

/*
* MethodBinding representing an action listener method that will be notified after drag operation
*/
private  MethodBinding _dragListener = null;

/*
* A drag zone type that is used for zone definition, which elements can be accepted by a drop zone
*/
private  String _dragType = null;

/*
* Data to be sent to the drop zone after a drop event
*/
private  Object _dragValue = null;

/*
* MethodBinding representing an action listener method that will be notified after drop operation
*/
private  MethodBinding _dropListener = null;

/*
* Data to be processed after a drop event
*/
private  Object _dropValue = null;

/*
* Name of requests queue to avoid send next request before complete other from same event. Can be used to reduce number of requests of frequently events (key press, mouse move etc.)
*/
private  String _eventsQueue = null;

/*
* id of element to set focus after request completed on client side
*/
private  String _focus = null;

/*
* List of comma separated cursors that indicates when you can grab and drag an object
*/
private  String _grabCursors = null;

/*
* List of comma separated cursors that indicates when you has grabbed something
*/
private  String _grabbingCursors = null;

/*
* Corresponds to the HTML class attribute. Applied to highlighted node
*/
private  String _highlightedClass = null;

/*
* The icon for node
*/
private  String _icon = null;

/*
* The icon for collapsed node
*/
private  String _iconCollapsed = null;

/*
* The icon for expanded node
*/
private  String _iconExpanded = null;

/*
* An icon for component leaves
*/
private  String _iconLeaf = null;

/*
* Attribute allows to ignore an Ajax Response produced by a request if the newest 'similar' request is
in a queue already. ignoreDupResponses="true" does not cancel the request while it is processed on the server,
but just allows to avoid unnecessary updates on the client side if the response isn't actual now
*/
private  boolean _ignoreDupResponses = false;

private  boolean _ignoreDupResponsesSet = false;

/*
* A flag indicating that this component value must be
				converted and validated immediately (during an
				Apply Request Values phase), rather than waiting until a
				Process Validations phase
*/
private  boolean _immediate = false;

private  boolean _immediateSet = false;

/*
* If "true", updates on client side ONLY elements from this 'reRender' property. If "false" (default) updates all rendered by ajax region components
*/
private  boolean _limitToList = false;

private  boolean _limitToListSet = false;

/*
* Node face facet name
*/
private  String _nodeFace = null;

/*
* MethodBinding representing an action listener method that will be notified after selection of node.
*/
private  MethodBinding _nodeSelectListener = null;

/*
* JavaScript code for call before DOM has been updated on client side
*/
private  String _onbeforedomupdate = null;

/*
* HTML: a script expression; a pointer button is clicked
*/
private  String _onclick = null;

/*
* HTML: script expression to invoke on node collapsing
*/
private  String _oncollapse = null;

/*
* JavaScript code for call after request completed on client side
*/
private  String _oncomplete = null;

/*
* HTML: a script expression; a pointer button is double-clicked
*/
private  String _ondblclick = null;

/*
* A JavaScript event handler called after a drag operation
*/
private  String _ondragend = null;

/*
* A JavaScript event handler called on enter draggable object to zone
*/
private  String _ondragenter = null;

/*
* A JavaScript event handler called after a drag object leaves zone
*/
private  String _ondragexit = null;

/*
* A JavaScript event handler called before drag operation
*/
private  String _ondragstart = null;

/*
* It's an event that is called when something is dropped on a drop zone
*/
private  String _ondrop = null;

/*
* A JavaScript handler for event fired on a drop even the drop for a given type is not available
*/
private  String _ondropend = null;

/*
* A JavaScript event handler called after a out operation
*/
private  String _ondropout = null;

/*
* A JavaScript event handler called after a drop operation
*/
private  String _ondropover = null;

/*
* HTML: script expression to invoke on node expansion
*/
private  String _onexpand = null;

/*
* HTML: a script expression; a key is pressed down
*/
private  String _onkeydown = null;

/*
* HTML: a script expression; a key is pressed and released
*/
private  String _onkeypress = null;

/*
* HTML: a script expression; a key is released
*/
private  String _onkeyup = null;

/*
* HTML: script expression; a pointer button is pressed down
*/
private  String _onmousedown = null;

/*
* HTML: a script expression; a pointer is moved within
*/
private  String _onmousemove = null;

/*
* HTML: a script expression; a pointer is moved away
*/
private  String _onmouseout = null;

/*
* HTML: a script expression; a pointer is moved onto
*/
private  String _onmouseover = null;

/*
* HTML: script expression; a pointer button is released
*/
private  String _onmouseup = null;

/*
* HTML: script expression to invoke on node selection
*/
private  String _onselected = null;

/*
* If "true", data is preserved in a request
*/
private  boolean _preserveDataInRequest = true;

private  boolean _preserveDataInRequestSet = false;

/*
* It can be "state", "request", "none". The default is "request"
*/
private  String _preserveModel = null;

/*
* Id['s] (in format of call  UIComponent.findComponent()) of components, processed at the phases 2-5 in case of AjaxRequest  caused by this component. Can be single id, comma-separated list of Id's, or EL Expression  with array or Collection
*/
private  Object _process = null;

/*
* Id['s] (in format of call  UIComponent.findComponent()) of components, rendered in case of AjaxRequest  caused by this component. Can be single id, comma-separated list of Id's, or EL Expression  with array or Collection
*/
private  Object _reRender = null;

/*
* List of comma separated cursors that indicates when rejectable draggable over dropzone
*/
private  String _rejectCursors = null;

/*
* Attribute defines the time (in ms.) that the request will be wait in the queue before it is ready to send.
When the delay time is over, the request will be sent to the server or removed if the newest 'similar' request is in a queue already
*/
private  int _requestDelay = Integer.MIN_VALUE;

private  boolean _requestDelaySet = false;

/*
* Corresponds to the HTML class attribute. Applied to selected node
*/
private  String _selectedClass = null;

/*
* If "true", connecting lines are show
*/
private  boolean _showConnectingLines = true;

private  boolean _showConnectingLinesSet = false;

/*
* ValueBinding pointing at instance of class implementing org.richfaces.component.state.TreeStateAdvisor interface.
*/
private  Object _stateAdvisor = null;

/*
* ID (in format of call UIComponent.findComponent()) of Request status component
*/
private  String _status = null;

/*
* CSS style(s) is/are to be applied when this component is rendered
*/
private  String _style = null;

/*
* Corresponds to the HTML class attribute
*/
private  String _styleClass = null;

/*
* Tree switch algorithm: "client", "server", "ajax"
*/
private  String _switchType = null;

/*
* Response waiting time on a particular request. If a response is not received during this time, the request is aborted
*/
private  int _timeout = Integer.MIN_VALUE;

private  boolean _timeoutSet = false;

/*
* If "false" do not toggle node state on click.
				If "true", than node will be toggles on click on ether node content, 
				or node icon. 
 				Default value is false.
*/
private  boolean _toggleOnClick = false;

private  boolean _toggleOnClickSet = false;

/*
* Map between a draggable type and an indicator name on zone. it's defined with the pair (drag type:indicator name))
*/
private  Object _typeMapping = null;

/*
* null
*/
private  String _varState = null;


public HtmlTree(){
setRendererType("org.richfaces.TreeRenderer");
}

public String getAcceptCursors(){
	if (this._acceptCursors != null) {
		return this._acceptCursors;
	}
	ValueExpression ve = getValueExpression("acceptCursors");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setAcceptCursors(String _acceptCursors){
this._acceptCursors = _acceptCursors;
}

public Object getAcceptedTypes(){
	if (this._acceptedTypes != null) {
		return this._acceptedTypes;
	}
	ValueExpression ve = getValueExpression("acceptedTypes");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAcceptedTypes(Object _acceptedTypes){
this._acceptedTypes = _acceptedTypes;
}

public MethodBinding getAdviseNodeOpened(){
return _adviseNodeOpened;
}

public void setAdviseNodeOpened(MethodBinding _adviseNodeOpened){
this._adviseNodeOpened = _adviseNodeOpened;
}

public MethodBinding getAdviseNodeSelected(){
return _adviseNodeSelected;
}

public void setAdviseNodeSelected(MethodBinding _adviseNodeSelected){
this._adviseNodeSelected = _adviseNodeSelected;
}

public boolean isAjaxSingle(){
	if (this._ajaxSingleSet) {
	    return (this._ajaxSingle);
	}
	ValueExpression ve = getValueExpression("ajaxSingle");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._ajaxSingle);
	    }
	    
	    return value;
	} else {
	    return (this._ajaxSingle);
	}

}

public void setAjaxSingle(boolean _ajaxSingle){
this._ajaxSingle = _ajaxSingle;
this._ajaxSingleSet = true;
}

public boolean isAjaxSubmitSelection(){
	if (this._ajaxSubmitSelectionSet) {
	    return (this._ajaxSubmitSelection);
	}
	ValueExpression ve = getValueExpression("ajaxSubmitSelection");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._ajaxSubmitSelection);
	    }
	    
	    return value;
	} else {
	    return (this._ajaxSubmitSelection);
	}

}

public void setAjaxSubmitSelection(boolean _ajaxSubmitSelection){
this._ajaxSubmitSelection = _ajaxSubmitSelection;
this._ajaxSubmitSelectionSet = true;
}

public boolean isBypassUpdates(){
	if (this._bypassUpdatesSet) {
	    return (this._bypassUpdates);
	}
	ValueExpression ve = getValueExpression("bypassUpdates");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._bypassUpdates);
	    }
	    
	    return value;
	} else {
	    return (this._bypassUpdates);
	}

}

public void setBypassUpdates(boolean _bypassUpdates){
this._bypassUpdates = _bypassUpdates;
this._bypassUpdatesSet = true;
}

public MethodBinding getChangeExpandListener(){
return _changeExpandListener;
}

public void setChangeExpandListener(MethodBinding _changeExpandListener){
this._changeExpandListener = _changeExpandListener;
}

public Object getCursorTypeMapping(){
	if (this._cursorTypeMapping != null) {
		return this._cursorTypeMapping;
	}
	ValueExpression ve = getValueExpression("cursorTypeMapping");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setCursorTypeMapping(Object _cursorTypeMapping){
this._cursorTypeMapping = _cursorTypeMapping;
}

public Object getData(){
	if (this._data != null) {
		return this._data;
	}
	ValueExpression ve = getValueExpression("data");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setData(Object _data){
this._data = _data;
}

public String getDragIndicator(){
	if (this._dragIndicator != null) {
		return this._dragIndicator;
	}
	ValueExpression ve = getValueExpression("dragIndicator");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setDragIndicator(String _dragIndicator){
this._dragIndicator = _dragIndicator;
}

public MethodBinding getDragListener(){
return _dragListener;
}

public void setDragListener(MethodBinding _dragListener){
this._dragListener = _dragListener;
}

public String getDragType(){
	if (this._dragType != null) {
		return this._dragType;
	}
	ValueExpression ve = getValueExpression("dragType");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setDragType(String _dragType){
this._dragType = _dragType;
}

public Object getDragValue(){
	if (this._dragValue != null) {
		return this._dragValue;
	}
	ValueExpression ve = getValueExpression("dragValue");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return getRowKey();
	

}

public void setDragValue(Object _dragValue){
this._dragValue = _dragValue;
}

public MethodBinding getDropListener(){
return _dropListener;
}

public void setDropListener(MethodBinding _dropListener){
this._dropListener = _dropListener;
}

public Object getDropValue(){
	if (this._dropValue != null) {
		return this._dropValue;
	}
	ValueExpression ve = getValueExpression("dropValue");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return getRowKey();
	

}

public void setDropValue(Object _dropValue){
this._dropValue = _dropValue;
}

public String getEventsQueue(){
	if (this._eventsQueue != null) {
		return this._eventsQueue;
	}
	ValueExpression ve = getValueExpression("eventsQueue");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setEventsQueue(String _eventsQueue){
this._eventsQueue = _eventsQueue;
}

public String getFocus(){
	if (this._focus != null) {
		return this._focus;
	}
	ValueExpression ve = getValueExpression("focus");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFocus(String _focus){
this._focus = _focus;
}

public String getGrabCursors(){
	if (this._grabCursors != null) {
		return this._grabCursors;
	}
	ValueExpression ve = getValueExpression("grabCursors");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setGrabCursors(String _grabCursors){
this._grabCursors = _grabCursors;
}

public String getGrabbingCursors(){
	if (this._grabbingCursors != null) {
		return this._grabbingCursors;
	}
	ValueExpression ve = getValueExpression("grabbingCursors");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setGrabbingCursors(String _grabbingCursors){
this._grabbingCursors = _grabbingCursors;
}

public String getHighlightedClass(){
	if (this._highlightedClass != null) {
		return this._highlightedClass;
	}
	ValueExpression ve = getValueExpression("highlightedClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setHighlightedClass(String _highlightedClass){
this._highlightedClass = _highlightedClass;
}

public String getIcon(){
	if (this._icon != null) {
		return this._icon;
	}
	ValueExpression ve = getValueExpression("icon");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setIcon(String _icon){
this._icon = _icon;
}

public String getIconCollapsed(){
	if (this._iconCollapsed != null) {
		return this._iconCollapsed;
	}
	ValueExpression ve = getValueExpression("iconCollapsed");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setIconCollapsed(String _iconCollapsed){
this._iconCollapsed = _iconCollapsed;
}

public String getIconExpanded(){
	if (this._iconExpanded != null) {
		return this._iconExpanded;
	}
	ValueExpression ve = getValueExpression("iconExpanded");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setIconExpanded(String _iconExpanded){
this._iconExpanded = _iconExpanded;
}

public String getIconLeaf(){
	if (this._iconLeaf != null) {
		return this._iconLeaf;
	}
	ValueExpression ve = getValueExpression("iconLeaf");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setIconLeaf(String _iconLeaf){
this._iconLeaf = _iconLeaf;
}

public boolean isIgnoreDupResponses(){
	if (this._ignoreDupResponsesSet) {
	    return (this._ignoreDupResponses);
	}
	ValueExpression ve = getValueExpression("ignoreDupResponses");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._ignoreDupResponses);
	    }
	    
	    return value;
	} else {
	    return (this._ignoreDupResponses);
	}

}

public void setIgnoreDupResponses(boolean _ignoreDupResponses){
this._ignoreDupResponses = _ignoreDupResponses;
this._ignoreDupResponsesSet = true;
}

public boolean isImmediate(){
	if (this._immediateSet) {
	    return (this._immediate);
	}
	ValueExpression ve = getValueExpression("immediate");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._immediate);
	    }
	    
	    return value;
	} else {
	    return (this._immediate);
	}

}

public void setImmediate(boolean _immediate){
this._immediate = _immediate;
this._immediateSet = true;
}

public boolean isLimitToList(){
	if (this._limitToListSet) {
	    return (this._limitToList);
	}
	ValueExpression ve = getValueExpression("limitToList");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._limitToList);
	    }
	    
	    return value;
	} else {
	    return (this._limitToList);
	}

}

public void setLimitToList(boolean _limitToList){
this._limitToList = _limitToList;
this._limitToListSet = true;
}

public String getNodeFace(){
	if (this._nodeFace != null) {
		return this._nodeFace;
	}
	ValueExpression ve = getValueExpression("nodeFace");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setNodeFace(String _nodeFace){
this._nodeFace = _nodeFace;
}

public MethodBinding getNodeSelectListener(){
return _nodeSelectListener;
}

public void setNodeSelectListener(MethodBinding _nodeSelectListener){
this._nodeSelectListener = _nodeSelectListener;
}

public String getOnbeforedomupdate(){
	if (this._onbeforedomupdate != null) {
		return this._onbeforedomupdate;
	}
	ValueExpression ve = getValueExpression("onbeforedomupdate");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnbeforedomupdate(String _onbeforedomupdate){
this._onbeforedomupdate = _onbeforedomupdate;
}

public String getOnclick(){
	if (this._onclick != null) {
		return this._onclick;
	}
	ValueExpression ve = getValueExpression("onclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnclick(String _onclick){
this._onclick = _onclick;
}

public String getOncollapse(){
	if (this._oncollapse != null) {
		return this._oncollapse;
	}
	ValueExpression ve = getValueExpression("oncollapse");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOncollapse(String _oncollapse){
this._oncollapse = _oncollapse;
}

public String getOncomplete(){
	if (this._oncomplete != null) {
		return this._oncomplete;
	}
	ValueExpression ve = getValueExpression("oncomplete");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOncomplete(String _oncomplete){
this._oncomplete = _oncomplete;
}

public String getOndblclick(){
	if (this._ondblclick != null) {
		return this._ondblclick;
	}
	ValueExpression ve = getValueExpression("ondblclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndblclick(String _ondblclick){
this._ondblclick = _ondblclick;
}

public String getOndragend(){
	if (this._ondragend != null) {
		return this._ondragend;
	}
	ValueExpression ve = getValueExpression("ondragend");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndragend(String _ondragend){
this._ondragend = _ondragend;
}

public String getOndragenter(){
	if (this._ondragenter != null) {
		return this._ondragenter;
	}
	ValueExpression ve = getValueExpression("ondragenter");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndragenter(String _ondragenter){
this._ondragenter = _ondragenter;
}

public String getOndragexit(){
	if (this._ondragexit != null) {
		return this._ondragexit;
	}
	ValueExpression ve = getValueExpression("ondragexit");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndragexit(String _ondragexit){
this._ondragexit = _ondragexit;
}

public String getOndragstart(){
	if (this._ondragstart != null) {
		return this._ondragstart;
	}
	ValueExpression ve = getValueExpression("ondragstart");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndragstart(String _ondragstart){
this._ondragstart = _ondragstart;
}

public String getOndrop(){
	if (this._ondrop != null) {
		return this._ondrop;
	}
	ValueExpression ve = getValueExpression("ondrop");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndrop(String _ondrop){
this._ondrop = _ondrop;
}

public String getOndropend(){
	if (this._ondropend != null) {
		return this._ondropend;
	}
	ValueExpression ve = getValueExpression("ondropend");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndropend(String _ondropend){
this._ondropend = _ondropend;
}

public String getOndropout(){
	if (this._ondropout != null) {
		return this._ondropout;
	}
	ValueExpression ve = getValueExpression("ondropout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndropout(String _ondropout){
this._ondropout = _ondropout;
}

public String getOndropover(){
	if (this._ondropover != null) {
		return this._ondropover;
	}
	ValueExpression ve = getValueExpression("ondropover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndropover(String _ondropover){
this._ondropover = _ondropover;
}

public String getOnexpand(){
	if (this._onexpand != null) {
		return this._onexpand;
	}
	ValueExpression ve = getValueExpression("onexpand");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnexpand(String _onexpand){
this._onexpand = _onexpand;
}

public String getOnkeydown(){
	if (this._onkeydown != null) {
		return this._onkeydown;
	}
	ValueExpression ve = getValueExpression("onkeydown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeydown(String _onkeydown){
this._onkeydown = _onkeydown;
}

public String getOnkeypress(){
	if (this._onkeypress != null) {
		return this._onkeypress;
	}
	ValueExpression ve = getValueExpression("onkeypress");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeypress(String _onkeypress){
this._onkeypress = _onkeypress;
}

public String getOnkeyup(){
	if (this._onkeyup != null) {
		return this._onkeyup;
	}
	ValueExpression ve = getValueExpression("onkeyup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeyup(String _onkeyup){
this._onkeyup = _onkeyup;
}

public String getOnmousedown(){
	if (this._onmousedown != null) {
		return this._onmousedown;
	}
	ValueExpression ve = getValueExpression("onmousedown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousedown(String _onmousedown){
this._onmousedown = _onmousedown;
}

public String getOnmousemove(){
	if (this._onmousemove != null) {
		return this._onmousemove;
	}
	ValueExpression ve = getValueExpression("onmousemove");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousemove(String _onmousemove){
this._onmousemove = _onmousemove;
}

public String getOnmouseout(){
	if (this._onmouseout != null) {
		return this._onmouseout;
	}
	ValueExpression ve = getValueExpression("onmouseout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseout(String _onmouseout){
this._onmouseout = _onmouseout;
}

public String getOnmouseover(){
	if (this._onmouseover != null) {
		return this._onmouseover;
	}
	ValueExpression ve = getValueExpression("onmouseover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseover(String _onmouseover){
this._onmouseover = _onmouseover;
}

public String getOnmouseup(){
	if (this._onmouseup != null) {
		return this._onmouseup;
	}
	ValueExpression ve = getValueExpression("onmouseup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseup(String _onmouseup){
this._onmouseup = _onmouseup;
}

public String getOnselected(){
	if (this._onselected != null) {
		return this._onselected;
	}
	ValueExpression ve = getValueExpression("onselected");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnselected(String _onselected){
this._onselected = _onselected;
}

public boolean isPreserveDataInRequest(){
	if (this._preserveDataInRequestSet) {
	    return (this._preserveDataInRequest);
	}
	ValueExpression ve = getValueExpression("preserveDataInRequest");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._preserveDataInRequest);
	    }
	    
	    return value;
	} else {
	    return (this._preserveDataInRequest);
	}

}

public void setPreserveDataInRequest(boolean _preserveDataInRequest){
this._preserveDataInRequest = _preserveDataInRequest;
this._preserveDataInRequestSet = true;
}

public String getPreserveModel(){
	if (this._preserveModel != null) {
		return this._preserveModel;
	}
	ValueExpression ve = getValueExpression("preserveModel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "request";
	

}

public void setPreserveModel(String _preserveModel){
this._preserveModel = _preserveModel;
}

public Object getProcess(){
	if (this._process != null) {
		return this._process;
	}
	ValueExpression ve = getValueExpression("process");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setProcess(Object _process){
this._process = _process;
}

public Object getReRender(){
	if (this._reRender != null) {
		return this._reRender;
	}
	ValueExpression ve = getValueExpression("reRender");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setReRender(Object _reRender){
this._reRender = _reRender;
}

public String getRejectCursors(){
	if (this._rejectCursors != null) {
		return this._rejectCursors;
	}
	ValueExpression ve = getValueExpression("rejectCursors");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setRejectCursors(String _rejectCursors){
this._rejectCursors = _rejectCursors;
}

public int getRequestDelay(){
	if (this._requestDelaySet) {
	    return (this._requestDelay);
	}
	ValueExpression ve = getValueExpression("requestDelay");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._requestDelay);
	    }
	    
	    return value;
	} else {
	    return (this._requestDelay);
	}

}

public void setRequestDelay(int _requestDelay){
this._requestDelay = _requestDelay;
this._requestDelaySet = true;
}

public String getSelectedClass(){
	if (this._selectedClass != null) {
		return this._selectedClass;
	}
	ValueExpression ve = getValueExpression("selectedClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSelectedClass(String _selectedClass){
this._selectedClass = _selectedClass;
}

public boolean isShowConnectingLines(){
	if (this._showConnectingLinesSet) {
	    return (this._showConnectingLines);
	}
	ValueExpression ve = getValueExpression("showConnectingLines");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._showConnectingLines);
	    }
	    
	    return value;
	} else {
	    return (this._showConnectingLines);
	}

}

public void setShowConnectingLines(boolean _showConnectingLines){
this._showConnectingLines = _showConnectingLines;
this._showConnectingLinesSet = true;
}

public Object getStateAdvisor(){
	if (this._stateAdvisor != null) {
		return this._stateAdvisor;
	}
	ValueExpression ve = getValueExpression("stateAdvisor");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStateAdvisor(Object _stateAdvisor){
this._stateAdvisor = _stateAdvisor;
}

public String getStatus(){
	if (this._status != null) {
		return this._status;
	}
	ValueExpression ve = getValueExpression("status");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStatus(String _status){
this._status = _status;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public String getSwitchType(){
	if (this._switchType != null) {
		return this._switchType;
	}
	ValueExpression ve = getValueExpression("switchType");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "ajax";
	

}

public void setSwitchType(String _switchType){
this._switchType = _switchType;
}

public int getTimeout(){
	if (this._timeoutSet) {
	    return (this._timeout);
	}
	ValueExpression ve = getValueExpression("timeout");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._timeout);
	    }
	    
	    return value;
	} else {
	    return (this._timeout);
	}

}

public void setTimeout(int _timeout){
this._timeout = _timeout;
this._timeoutSet = true;
}

public boolean isToggleOnClick(){
	if (this._toggleOnClickSet) {
	    return (this._toggleOnClick);
	}
	ValueExpression ve = getValueExpression("toggleOnClick");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._toggleOnClick);
	    }
	    
	    return value;
	} else {
	    return (this._toggleOnClick);
	}

}

public void setToggleOnClick(boolean _toggleOnClick){
this._toggleOnClick = _toggleOnClick;
this._toggleOnClickSet = true;
}

public Object getTypeMapping(){
	if (this._typeMapping != null) {
		return this._typeMapping;
	}
	ValueExpression ve = getValueExpression("typeMapping");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTypeMapping(Object _typeMapping){
this._typeMapping = _typeMapping;
}

public String getVarState(){
	if (this._varState != null) {
		return this._varState;
	}
	ValueExpression ve = getValueExpression("varState");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setVarState(String _varState){
this._varState = _varState;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[82];
state[0] = super.saveState(context);
state[1] = _acceptCursors;
state[2] = saveAttachedState(context, _acceptedTypes);
state[3] = saveAttachedState(context, _adviseNodeOpened);
state[4] = saveAttachedState(context, _adviseNodeSelected);
state[5] = Boolean.valueOf(_ajaxSingle);
state[6] = Boolean.valueOf(_ajaxSingleSet);
state[7] = Boolean.valueOf(_ajaxSubmitSelection);
state[8] = Boolean.valueOf(_ajaxSubmitSelectionSet);
state[9] = Boolean.valueOf(_bypassUpdates);
state[10] = Boolean.valueOf(_bypassUpdatesSet);
state[11] = saveAttachedState(context, _changeExpandListener);
state[12] = saveAttachedState(context, _cursorTypeMapping);
state[13] = saveAttachedState(context, _data);
state[14] = _dragIndicator;
state[15] = saveAttachedState(context, _dragListener);
state[16] = _dragType;
state[17] = saveAttachedState(context, _dragValue);
state[18] = saveAttachedState(context, _dropListener);
state[19] = saveAttachedState(context, _dropValue);
state[20] = _eventsQueue;
state[21] = _focus;
state[22] = _grabCursors;
state[23] = _grabbingCursors;
state[24] = _highlightedClass;
state[25] = _icon;
state[26] = _iconCollapsed;
state[27] = _iconExpanded;
state[28] = _iconLeaf;
state[29] = Boolean.valueOf(_ignoreDupResponses);
state[30] = Boolean.valueOf(_ignoreDupResponsesSet);
state[31] = Boolean.valueOf(_immediate);
state[32] = Boolean.valueOf(_immediateSet);
state[33] = Boolean.valueOf(_limitToList);
state[34] = Boolean.valueOf(_limitToListSet);
state[35] = _nodeFace;
state[36] = saveAttachedState(context, _nodeSelectListener);
state[37] = _onbeforedomupdate;
state[38] = _onclick;
state[39] = _oncollapse;
state[40] = _oncomplete;
state[41] = _ondblclick;
state[42] = _ondragend;
state[43] = _ondragenter;
state[44] = _ondragexit;
state[45] = _ondragstart;
state[46] = _ondrop;
state[47] = _ondropend;
state[48] = _ondropout;
state[49] = _ondropover;
state[50] = _onexpand;
state[51] = _onkeydown;
state[52] = _onkeypress;
state[53] = _onkeyup;
state[54] = _onmousedown;
state[55] = _onmousemove;
state[56] = _onmouseout;
state[57] = _onmouseover;
state[58] = _onmouseup;
state[59] = _onselected;
state[60] = Boolean.valueOf(_preserveDataInRequest);
state[61] = Boolean.valueOf(_preserveDataInRequestSet);
state[62] = _preserveModel;
state[63] = saveAttachedState(context, _process);
state[64] = saveAttachedState(context, _reRender);
state[65] = _rejectCursors;
state[66] = Integer.valueOf(_requestDelay);
state[67] = Boolean.valueOf(_requestDelaySet);
state[68] = _selectedClass;
state[69] = Boolean.valueOf(_showConnectingLines);
state[70] = Boolean.valueOf(_showConnectingLinesSet);
state[71] = saveAttachedState(context, _stateAdvisor);
state[72] = _status;
state[73] = _style;
state[74] = _styleClass;
state[75] = _switchType;
state[76] = Integer.valueOf(_timeout);
state[77] = Boolean.valueOf(_timeoutSet);
state[78] = Boolean.valueOf(_toggleOnClick);
state[79] = Boolean.valueOf(_toggleOnClickSet);
state[80] = saveAttachedState(context, _typeMapping);
state[81] = _varState;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_acceptCursors = (String)states[1];;
		_acceptedTypes = (Object)restoreAttachedState(context, states[2]);
		_adviseNodeOpened = (MethodBinding)restoreAttachedState(context, states[3]);
		_adviseNodeSelected = (MethodBinding)restoreAttachedState(context, states[4]);
		_ajaxSingle = ((Boolean)states[5]).booleanValue();
		_ajaxSingleSet = ((Boolean)states[6]).booleanValue();
		_ajaxSubmitSelection = ((Boolean)states[7]).booleanValue();
		_ajaxSubmitSelectionSet = ((Boolean)states[8]).booleanValue();
		_bypassUpdates = ((Boolean)states[9]).booleanValue();
		_bypassUpdatesSet = ((Boolean)states[10]).booleanValue();
		_changeExpandListener = (MethodBinding)restoreAttachedState(context, states[11]);
		_cursorTypeMapping = (Object)restoreAttachedState(context, states[12]);
		_data = (Object)restoreAttachedState(context, states[13]);
		_dragIndicator = (String)states[14];;
		_dragListener = (MethodBinding)restoreAttachedState(context, states[15]);
		_dragType = (String)states[16];;
		_dragValue = (Object)restoreAttachedState(context, states[17]);
		_dropListener = (MethodBinding)restoreAttachedState(context, states[18]);
		_dropValue = (Object)restoreAttachedState(context, states[19]);
		_eventsQueue = (String)states[20];;
		_focus = (String)states[21];;
		_grabCursors = (String)states[22];;
		_grabbingCursors = (String)states[23];;
		_highlightedClass = (String)states[24];;
		_icon = (String)states[25];;
		_iconCollapsed = (String)states[26];;
		_iconExpanded = (String)states[27];;
		_iconLeaf = (String)states[28];;
		_ignoreDupResponses = ((Boolean)states[29]).booleanValue();
		_ignoreDupResponsesSet = ((Boolean)states[30]).booleanValue();
		_immediate = ((Boolean)states[31]).booleanValue();
		_immediateSet = ((Boolean)states[32]).booleanValue();
		_limitToList = ((Boolean)states[33]).booleanValue();
		_limitToListSet = ((Boolean)states[34]).booleanValue();
		_nodeFace = (String)states[35];;
		_nodeSelectListener = (MethodBinding)restoreAttachedState(context, states[36]);
		_onbeforedomupdate = (String)states[37];;
		_onclick = (String)states[38];;
		_oncollapse = (String)states[39];;
		_oncomplete = (String)states[40];;
		_ondblclick = (String)states[41];;
		_ondragend = (String)states[42];;
		_ondragenter = (String)states[43];;
		_ondragexit = (String)states[44];;
		_ondragstart = (String)states[45];;
		_ondrop = (String)states[46];;
		_ondropend = (String)states[47];;
		_ondropout = (String)states[48];;
		_ondropover = (String)states[49];;
		_onexpand = (String)states[50];;
		_onkeydown = (String)states[51];;
		_onkeypress = (String)states[52];;
		_onkeyup = (String)states[53];;
		_onmousedown = (String)states[54];;
		_onmousemove = (String)states[55];;
		_onmouseout = (String)states[56];;
		_onmouseover = (String)states[57];;
		_onmouseup = (String)states[58];;
		_onselected = (String)states[59];;
		_preserveDataInRequest = ((Boolean)states[60]).booleanValue();
		_preserveDataInRequestSet = ((Boolean)states[61]).booleanValue();
		_preserveModel = (String)states[62];;
		_process = (Object)restoreAttachedState(context, states[63]);
		_reRender = (Object)restoreAttachedState(context, states[64]);
		_rejectCursors = (String)states[65];;
		_requestDelay = ((Integer)states[66]).intValue();
		_requestDelaySet = ((Boolean)states[67]).booleanValue();
		_selectedClass = (String)states[68];;
		_showConnectingLines = ((Boolean)states[69]).booleanValue();
		_showConnectingLinesSet = ((Boolean)states[70]).booleanValue();
		_stateAdvisor = (Object)restoreAttachedState(context, states[71]);
		_status = (String)states[72];;
		_style = (String)states[73];;
		_styleClass = (String)states[74];;
		_switchType = (String)states[75];;
		_timeout = ((Integer)states[76]).intValue();
		_timeoutSet = ((Boolean)states[77]).booleanValue();
		_toggleOnClick = ((Boolean)states[78]).booleanValue();
		_toggleOnClickSet = ((Boolean)states[79]).booleanValue();
		_typeMapping = (Object)restoreAttachedState(context, states[80]);
		_varState = (String)states[81];;
	
}

}
