/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import org.ajax4jsf.util.InputUtils;
import org.ajax4jsf.util.SelectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.component.UIInplaceSelect;
import org.richfaces.json.JSONArray;
import org.richfaces.renderkit.ComboBoxBaseRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InplaceSelectBaseRenderer
extends ComboBoxBaseRenderer {
    private static Log logger = LogFactory.getLog(InplaceSelectBaseRenderer.class);
    private static final String RICH_INPLACE_SELECT_CLASSES = "rich-inplace-select-item rich-inplace-select-font";
    private static final String CONTROLS_FACET = "controls";
    private JSONArray jsonParentArray;

    @Override
    protected void doDecode(FacesContext context, UIComponent component) {
        String newValue;
        String clientId;
        UIInplaceSelect inplaceInput = null;
        if (!(component instanceof UIInplaceSelect)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No decoding necessary since the component " + component.getId() + " is not an instance or a sub class of UIInplaceSelect"));
            }
            return;
        }
        inplaceInput = (UIInplaceSelect)component;
        if ((InputUtils.isDisabled((UIComponent)inplaceInput) || InputUtils.isReadOnly((UIComponent)inplaceInput)) && logger.isDebugEnabled()) {
            logger.debug((Object)("No decoding necessary since the component " + component.getId() + " is disabled"));
        }
        if ((clientId = component.getClientId(context)) == null) {
            throw new NullPointerException("component " + inplaceInput.getClientId(context) + " client id is NULL");
        }
        clientId = clientId + "inplaceValue";
        Map request = context.getExternalContext().getRequestParameterMap();
        if (request.containsKey(clientId) && (newValue = (String)request.get(clientId)) != null) {
            inplaceInput.setSubmittedValue(newValue);
        }
    }

    @Override
    public void encodeItems(FacesContext context, UIComponent component) throws IOException {
        ArrayList<String> labels = new ArrayList<String>();
        ResponseWriter writer = context.getResponseWriter();
        this.jsonParentArray = new JSONArray();
        List selectItems = SelectUtils.getSelectItems((FacesContext)context, (UIComponent)component);
        if (!selectItems.isEmpty()) {
            for (SelectItem selectItem : selectItems) {
                String value = this.getConvertedStringValue(context, component, selectItem.getValue());
                String label = selectItem.getLabel();
                labels.add(label);
                this.encodeSuggestion(writer, component, label, RICH_INPLACE_SELECT_CLASSES);
                JSONArray jsonChildArray = new JSONArray();
                jsonChildArray.put((Object)label);
                jsonChildArray.put((Object)value);
                this.jsonParentArray.put((Object)jsonChildArray);
            }
        }
        this.setValuesList(labels);
    }

    public void encodeControlsFacet(FacesContext context, UIComponent component) throws IOException {
        UIComponent facet = component.getFacet(CONTROLS_FACET);
        if (facet != null && facet.isRendered()) {
            this.renderChild(context, facet);
        }
    }

    public boolean isControlsFacetExists(FacesContext context, UIComponent component) {
        UIComponent facet = component.getFacet(CONTROLS_FACET);
        return facet != null && facet.isRendered();
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return UIInplaceSelect.class;
    }

    @Override
    public String getItemsTextAsJSArray(FacesContext context, UIComponent component) {
        StringBuffer attributes = new StringBuffer();
        attributes.append(this.jsonParentArray.toString());
        return attributes.toString();
    }

    public String getSelectedItemLabel(FacesContext context, UIInplaceSelect component) {
        String defaultLabel = null;
        Object value = component.getSubmittedValue();
        if (value == null) {
            value = component.getAttributes().get("value");
        }
        if (value == null) {
            return this.createDefaultLabel((UIComponent)component);
        }
        defaultLabel = this.getItemLabel(context, (UIComponent)component, value);
        if (defaultLabel == null) {
            return this.createDefaultLabel((UIComponent)component);
        }
        return defaultLabel;
    }

    protected String getItemLabel(FacesContext context, UIComponent component, Object value) {
        String itemLabel = null;
        List selectItems = SelectUtils.getSelectItems((FacesContext)context, (UIComponent)component);
        if (!selectItems.isEmpty()) {
            for (SelectItem item : selectItems) {
                if (!value.equals(item.getValue())) continue;
                itemLabel = item.getLabel();
            }
        }
        return itemLabel;
    }

    protected String createDefaultLabel(UIComponent component) {
        String defaultLabel = (String)component.getAttributes().get("defaultLabel");
        if (defaultLabel == null || defaultLabel.equals("")) {
            defaultLabel = "&#160;&#160;&#160;";
        }
        return defaultLabel;
    }
}

