/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.ajax4jsf.util.InputUtils;
import org.ajax4jsf.util.SelectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.component.UIComboBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboBoxBaseRenderer
extends HeaderResourcesRendererBase {
    private static final String RICH_COMBOBOX_ITEM_CLASSES = "rich-combobox-item rich-combobox-item-normal";
    private static Log logger = LogFactory.getLog(ComboBoxBaseRenderer.class);

    protected Class<? extends UIComponent> getComponentClass() {
        return UIComboBox.class;
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        String clientId;
        UIComboBox comboBox = null;
        if (!(component instanceof UIComboBox)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No decoding necessary since the component " + component.getId() + " is not an instance or a sub class of UIComboBox"));
            }
            return;
        }
        comboBox = (UIComboBox)component;
        if ((InputUtils.isDisabled((UIComponent)comboBox) || InputUtils.isReadOnly((UIComponent)comboBox)) && logger.isDebugEnabled()) {
            logger.debug((Object)("No decoding necessary since the component " + component.getId() + " is disabled"));
        }
        if ((clientId = component.getClientId(context)) == null) {
            throw new NullPointerException("component " + comboBox.getClientId(context) + " client id is NULL");
        }
        clientId = clientId + "comboboxValue";
        Map request = context.getExternalContext().getRequestParameterMap();
        if (request.containsKey(clientId)) {
            String newValue = (String)request.get(clientId);
            comboBox.setSubmittedValue(newValue);
        }
    }

    public List encodeItems(FacesContext context, UIComponent component) throws IOException {
        List selectItems;
        if (!this.isAcceptableComponent(component)) {
            return null;
        }
        UIComboBox comboBox = (UIComboBox)component;
        Object suggestionValues = comboBox.getSuggestionValues();
        ResponseWriter writer = context.getResponseWriter();
        ArrayList<String> values = new ArrayList<String>();
        if (suggestionValues != null) {
            if (suggestionValues instanceof Collection) {
                Iterator iterator = ((Collection)suggestionValues).iterator();
                while (iterator.hasNext()) {
                    String value = this.getConvertedStringValue(context, (UIComponent)comboBox, iterator.next());
                    values.add(value);
                    this.encodeSuggestion(writer, (UIComponent)comboBox, value, RICH_COMBOBOX_ITEM_CLASSES);
                }
            } else if (suggestionValues.getClass().isArray()) {
                Object[] suggestions = (Object[])suggestionValues;
                for (int i = 0; i < suggestions.length; ++i) {
                    String value = this.getConvertedStringValue(context, (UIComponent)comboBox, suggestions[i]);
                    values.add(value);
                    this.encodeSuggestion(writer, (UIComponent)comboBox, value, RICH_COMBOBOX_ITEM_CLASSES);
                }
            } else {
                throw new IllegalArgumentException("suggestionValues should be Collection or array");
            }
        }
        if (!(selectItems = SelectUtils.getSelectItems((FacesContext)context, (UIComponent)component)).isEmpty()) {
            for (SelectItem selectItem : selectItems) {
                String value = this.getConvertedStringValue(context, (UIComponent)comboBox, selectItem.getValue());
                values.add(value);
                this.encodeSuggestion(writer, (UIComponent)comboBox, value, RICH_COMBOBOX_ITEM_CLASSES);
            }
        }
        return values;
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return InputUtils.getConvertedValue((FacesContext)context, (UIComponent)component, (Object)submittedValue);
    }

    protected String getConvertedStringValue(FacesContext context, UIComponent component, Object value) {
        return InputUtils.getConvertedStringValue((FacesContext)context, (UIComponent)component, (Object)value);
    }

    public void encodeSuggestion(ResponseWriter writer, UIComponent component, String value, String classes) throws IOException {
        writer.startElement("span", component);
        writer.writeAttribute("class", (Object)classes, null);
        writer.writeText((Object)value, null);
        writer.endElement("span");
    }

    protected boolean isAcceptableComponent(UIComponent component) {
        return component instanceof UIComboBox;
    }

    public String getItemsTextAsJSArray(FacesContext context, UIComponent component, List items) {
        return ScriptUtils.toScript((Object)items);
    }

    public String getAsEventHandler(FacesContext context, UIComponent component, String attributeName) {
        String event = (String)component.getAttributes().get(attributeName);
        JSReference result = JSReference.NULL;
        if (event != null && (event = event.trim()).length() != 0) {
            JSFunctionDefinition function = new JSFunctionDefinition(new Object[0]);
            function.addParameter((Object)"event");
            function.addToBody((Object)event);
            result = function;
        }
        return ScriptUtils.toScript((Object)result);
    }

    public String encodeValue(String value) {
        return ScriptUtils.toScript((Object)value);
    }
}

