/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.el.ValueExpression;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.context.AjaxContextImpl;
import org.ajax4jsf.event.AjaxEvent;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSLiteral;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.RendererBase;
import org.ajax4jsf.renderkit.RendererUtils;
import org.ajax4jsf.request.MultipartRequest;
import org.ajax4jsf.resource.CountingOutputWriter;
import org.richfaces.component.UIFileUpload;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.event.UploadEvent;
import org.richfaces.model.UploadItem;
import org.richfaces.renderkit.TemplateEncoderRendererBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileUploadRendererBase
extends TemplateEncoderRendererBase {
    private static final String _FILES_UPLOADED_ATTRIBUTE_NAME = "uploadData";
    private static final String _MULTIPART_REQUEST_CLASS_NAME = MultipartRequest.class.getName();
    private static final String FILE_UPLOAD_BUNDLE = "org.richfaces.renderkit.fileUpload";
    private static final String bundlePrefix = "RICH_FILE_UPLOAD_";
    private static final String bundlePostfix = "_LABEL";
    private static final String[] bundlesLables = new String[]{"add", "upload", "stop", "clear_all", "entry_cancel", "entry_clear", "entry_stop", "done", "size_error", "transfer_error", "progress"};
    private static final String[] defaultLables = new String[]{"Add...", "<b>Upload</b>", "<b>Stop</b>", "Clear All", "Cancel", "Clear", "Stop", "<b>Done</b>", "File size restricted", "Transfer error occuried", "uploading"};
    private static final String[] labelAttribues = new String[]{"addControlLabel", "uploadControlLabel", "stopControlLabel", "clearAllControlLabel", "cancelEntryControlLabel", "clearControlLabel", "stopEntryControlLabel", null, null, null, null};

    protected void doDecode(FacesContext context, UIComponent component) {
        UIFileUpload fileUpload = (UIFileUpload)component;
        ServletRequest request = (ServletRequest)context.getExternalContext().getRequest();
        String clientId = component.getClientId(context);
        new AjaxEvent(component).queue();
        Class<?> requestClazz = request.getClass();
        if (_MULTIPART_REQUEST_CLASS_NAME.equals(requestClazz.getName()) || "org.jboss.seam.web.MultipartRequest".equals(requestClazz.getName())) {
            HttpSession session = (HttpSession)context.getExternalContext().getSession(false);
            String uid = request.getParameter("_richfaces_upload_uid");
            String id = request.getParameter("id");
            this.decreaseFileCounter(session, id);
            Map map = (Map)session.getAttribute("_richfaces_upload_sessions");
            MultipartRequest multipartRequest = (MultipartRequest)map.get(uid);
            clientId = clientId + ":file";
            String fileName = multipartRequest.getFileName(clientId);
            Object file = multipartRequest.getFile(clientId);
            fileUpload.setLocalFileName(fileName);
            this.onUploadComplete(context, file, fileUpload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer initMaxFilesCount(FacesContext context, UIComponent component, String clientId) {
        HttpSession session;
        Integer max = (Integer)component.getAttributes().get("maxFilesQuantity");
        HttpSession httpSession = session = (HttpSession)context.getExternalContext().getSession(false);
        synchronized (httpSession) {
            Map<String, Integer> map = (Map<String, Integer>)session.getAttribute("_richfaces_uploaded_file_counter");
            if (map == null) {
                map = Collections.synchronizedMap(new HashMap());
            }
            map.put(clientId, max);
        }
        return max;
    }

    public String getFormId(FacesContext context, UIComponent component) {
        UIComponent form = AjaxRendererUtils.getNestingForm((UIComponent)component);
        if (form != null) {
            return form.getClientId(context);
        }
        return "";
    }

    public String getContainerId(FacesContext context, UIComponent component) {
        UIComponent container = (UIComponent)AjaxRendererUtils.findAjaxContainer((FacesContext)context, (UIComponent)component);
        if (container != null) {
            return container.getClientId(context);
        }
        return null;
    }

    public Object _getLabels(Object o) {
        return ScriptUtils.toScript((Object)o);
    }

    public Map<String, String> getLabels(FacesContext context, UIComponent component) {
        HashMap<String, String> labelsMap = new HashMap<String, String>();
        ResourceBundle bundle1 = null;
        ResourceBundle bundle2 = null;
        UIFileUpload fileUpload = (UIFileUpload)component;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String messageBundle = context.getApplication().getMessageBundle();
        Object locale = fileUpload.getLocale();
        if (locale == null) {
            HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
            locale = request.getLocale();
        }
        if (null != messageBundle) {
            bundle1 = ResourceBundle.getBundle(messageBundle, fileUpload.getAsLocale(locale), loader);
        }
        try {
            bundle2 = ResourceBundle.getBundle(FILE_UPLOAD_BUNDLE, fileUpload.getAsLocale(locale), loader);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        this.initLabels(labelsMap, bundle1, bundle2, fileUpload);
        return labelsMap;
    }

    private void initLabels(Map<String, String> map, ResourceBundle bundle1, ResourceBundle bundle2, UIFileUpload fileUpload) {
        int i = 0;
        for (String name : bundlesLables) {
            String label;
            boolean found = false;
            if (labelAttribues[i] != null) {
                String attributeName = labelAttribues[i];
                if (fileUpload.getAttributes().get(attributeName) != null) {
                    map.put(name, (String)fileUpload.getAttributes().get(attributeName));
                    found = true;
                }
            }
            if (!(found || bundle1 == null && bundle2 == null || (label = this.getFromBundle(name, bundle1, bundle2)) == null)) {
                map.put(name, this.getFromBundle(name, bundle1, bundle2));
                found = true;
            }
            if (!found) {
                map.put(name, defaultLables[i]);
            }
            ++i;
        }
    }

    private String getFromBundle(String name, ResourceBundle bundle1, ResourceBundle bundle2) {
        String v;
        block7: {
            block8: {
                name = bundlePrefix + name.toUpperCase() + bundlePostfix;
                v = null;
                if (bundle1 == null) break block8;
                try {
                    v = bundle1.getString(name);
                }
                catch (Exception e) {
                    if (bundle2 == null) break block7;
                    try {
                        v = bundle2.getString(name);
                        break block7;
                    }
                    catch (Exception ex) {}
                }
                break block7;
            }
            if (bundle2 != null) {
                try {
                    v = bundle2.getString(name);
                    ByteArrayOutputStream b = new ByteArrayOutputStream();
                    b.write(v.getBytes());
                    b.toString("UTF-8");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return v;
    }

    private void decreaseFileCounter(HttpSession session, String id) {
        Map map = (Map)session.getAttribute("_richfaces_uploaded_file_counter");
        if (map != null) {
            Integer i = (Integer)map.get(id);
            if (i == null) {
                i = 0;
            } else {
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i - 1);
            }
            map.put(id, i);
        }
    }

    private void storeData(FacesContext context, UIFileUpload fileUpload, Object file) {
        ValueExpression data = fileUpload.getValueExpression(_FILES_UPLOADED_ATTRIBUTE_NAME);
        UploadItem item = new UploadItem(fileUpload.getLocalFileName(), file);
        if (data != null && data.getValue(context.getELContext()) instanceof Collection) {
            Collection collection = (Collection)data.getValue(context.getELContext());
            collection.add(item);
        }
        new UploadEvent((UIComponent)fileUpload, item).queue();
    }

    private void onUploadComplete(FacesContext context, Object file, UIFileUpload fileUpload) {
        this.storeData(context, fileUpload, file);
        try {
            AjaxContext ajaxContext = AjaxContextImpl.getCurrentInstance((FacesContext)context);
            if (((Boolean)fileUpload.getAttributes().get("ajaxSingle")).booleanValue()) {
                ajaxContext.setAjaxSingleClientId(fileUpload.getClientId(context));
            }
            ajaxContext.setAjaxRequest(true);
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    protected Class<? extends UIComponent> getComponentClass() {
        return UIFileUpload.class;
    }

    private String getActionScript(FacesContext context, UIComponent component, String action, Object oncomplete) throws IOException {
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)component);
        String clientId = component.getClientId(context);
        String containerId = (String)variables.getVariable("containerId");
        JSFunction ajaxFunction = new JSFunction("A4J.AJAX.Submit", new Object[0]);
        ajaxFunction.addParameter((Object)containerId);
        ajaxFunction.addParameter((Object)new JSReference("formId"));
        ajaxFunction.addParameter((Object)new JSReference("event"));
        Map options = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)component);
        Map parameters = (Map)options.get("parameters");
        parameters.put("action", action);
        parameters.put("_richfaces_upload_uid", new JSReference("uid"));
        parameters.put(clientId, clientId);
        parameters.put("ajaxSingle", clientId);
        if (oncomplete != null) {
            options.put("onbeforedomupdate", oncomplete);
        }
        ajaxFunction.addParameter((Object)options);
        JSFunctionDefinition function = new JSFunctionDefinition(new Object[]{"uid"});
        function.addParameter((Object)"formId");
        function.addParameter((Object)"event");
        function.addToBody((Object)ajaxFunction.toScript());
        return function.toScript();
    }

    public Object getAcceptedTypes(FacesContext context, UIComponent component) {
        String acceptedTypes = (String)component.getAttributes().get("acceptedTypes");
        if (acceptedTypes != null && acceptedTypes.length() > 0) {
            HashMap<String, Boolean> accepted = new HashMap<String, Boolean>();
            String[] types = (acceptedTypes = acceptedTypes.replaceAll("[\\s]", "")).split("[,;|]");
            if (types != null) {
                for (String type : types) {
                    accepted.put(type.toLowerCase(), true);
                }
                return ScriptUtils.toScript(accepted);
            }
        }
        return JSReference.NULL;
    }

    public String getStopScript(FacesContext context, UIComponent component) throws IOException {
        return this.getActionScript(context, component, "stop", null);
    }

    public String getFileSizeScript(FacesContext context, UIComponent component) throws IOException {
        JSFunctionDefinition oncomplete = new JSFunctionDefinition(new Object[0]);
        oncomplete.addParameter((Object)"request");
        oncomplete.addParameter((Object)"event");
        oncomplete.addParameter((Object)"data");
        StringBuffer body = new StringBuffer("$('");
        body.append(component.getClientId(context));
        body.append("').component.getFileSize(data);");
        oncomplete.addToBody((Object)body);
        return this.getActionScript(context, component, "progress", oncomplete);
    }

    public Object getLabelMarkup(FacesContext context, UIComponent component) throws IOException {
        CountingOutputWriter customWriter = new CountingOutputWriter();
        StringBuffer result = null;
        UIComponent label = component.getFacet("label");
        try {
            if (label != null) {
                ResponseWriter writer = context.getResponseWriter();
                String defaultRenderKitId = context.getApplication().getDefaultRenderKitId();
                if (null == defaultRenderKitId) {
                    defaultRenderKitId = "HTML_BASIC";
                }
                RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
                RenderKit renderKit = renderKitFactory.getRenderKit(context, defaultRenderKitId);
                ResponseWriter responseWriter = renderKit.createResponseWriter((Writer)customWriter, null, "UTF-8");
                context.setResponseWriter(responseWriter);
                this.writeScriptBody(context, label, false);
                if (writer != null) {
                    context.setResponseWriter(writer);
                }
                result = customWriter.getContent();
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
        return result != null ? new JSLiteral(result.toString()) : JSReference.NULL;
    }

    public String getFileListHeight(UIFileUpload component) {
        return HtmlUtil.qualifySize((String)component.getListHeight());
    }

    public String getFileListWidth(UIFileUpload component) {
        return HtmlUtil.qualifySize((String)component.getListWidth());
    }

    public String getAsEventHandler(FacesContext context, UIComponent component, String attributeName) {
        JSFunctionDefinition eventHandler = RendererUtils.getInstance().getAsEventHandler(context, component, attributeName, "");
        if (eventHandler != null) {
            return eventHandler.toString();
        }
        return JSReference.NULL.toScript();
    }

    public String getProgressBarId(FacesContext context, UIComponent component) throws IOException {
        return this.getProgressBar(context, component).getClientId(context);
    }

    public void renderProgress(FacesContext context, UIComponent component) throws IOException {
        UIComponent progressBar = this.getProgressBar(context, component);
        this.renderChild(context, progressBar);
    }

    private UIComponent createProgressBar(FacesContext context, UIComponent fileUpload) {
        UIComponent progressBar = fileUpload.getFacet("progress");
        if (null == progressBar) {
            progressBar = context.getApplication().createComponent("org.richfaces.ProgressBar");
        }
        fileUpload.getFacets().put("progress", progressBar);
        return progressBar;
    }

    public UIComponent getProgressBar(FacesContext context, UIComponent component) {
        UIComponent progressBar = component.getFacet("progress");
        if (null == progressBar) {
            progressBar = this.createProgressBar(context, component);
        }
        progressBar.getAttributes().put("minValue", -1);
        progressBar.getAttributes().put("enabled", false);
        progressBar.setTransient(false);
        return progressBar;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
    }
}

