package org.richfaces.component.html;

import java.util.Comparator;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIColumn;

public class HtmlColumn extends UIColumn{

static public final  String COMPONENT_FAMILY = "org.richfaces.Column";

static public final  String COMPONENT_TYPE = "org.richfaces.Column";

/*
* if "true" next column begins from the first row
*/
private  boolean _breakBefore = false;

private  boolean _breakBeforeSet = false;

/*
* Corresponds to the HTML colspan attribute
*/
private  int _colspan = Integer.MIN_VALUE;

private  boolean _colspanSet = false;

/*
* Defines value binding to the comparator that is used to compare the values
*/
private  Comparator _comparator = null;

/*
* Direction indication for text that does not inherit
			directionality. Valid values are "LTR" (left-to-right)
			and "RTL" (right-to-left)
*/
private  String _dir = null;

/*
* Defines iterable object property which is used when filtering performed.
*/
private  Object _filterBy = null;

/*
* Event for filter input that forces the filtration (default = onchange)
*/
private  String _filterEvent = null;

/*
* Attribute defines a bean property which is used for filtering of a column
*/
private  boolean _filterExpression = false;

private  boolean _filterExpressionSet = false;

/*
* This attribute is defined with method binding. This method accepts on Object parameter and return boolean value
*/
private  MethodExpression _filterMethod = null;

/*
* Space-separated list of CSS style class(es) that are be applied to any footer generated for this table
*/
private  String _footerClass = null;

/*
* Space-separated list of CSS style class(es) that are be applied to any header generated for this table
*/
private  String _headerClass = null;

/*
* Code describing the language used in the generated markup for this component
*/
private  String _lang = null;

/*
* Corresponds to the HTML rowspan attribute
*/
private  int _rowspan = Integer.MIN_VALUE;

private  boolean _rowspanSet = false;

/*
* Manages if the header of the column is clickable, icons rendered and sorting is fired after click on the header. You need to define this attribute inside &amp;lt;rich:dataTable&amp;gt; component
*/
private  boolean _selfSorted = true;

private  boolean _selfSortedSet = false;

/*
* Attribute defines a bean property which is used for sorting of a column
*/
private  String _sortBy = null;

/*
* DEPRECATED(use sortBy)Attribute defines a bean property which is used for sorting of a column
*/
private  String _sortExpression = null;

/*
* Defines sort icon
*/
private  String _sortIcon = null;

/*
* Defines sort icon in ascending order
*/
private  String _sortIconAscending = null;

/*
* Defines sort icon in descending order
*/
private  String _sortIconDescending = null;

/*
* Boolean attribute. If "true" it's possible to sort the column content after click on the header.
	Default value is "true"
*/
private  boolean _sortable = true;

private  boolean _sortableSet = false;

/*
* CSS style(s) is/are to be applied when this component is rendered
*/
private  String _style = null;

/*
* Corresponds to the HTML class attribute
*/
private  String _styleClass = null;

/*
* Advisory title information about markup elements generated for this component
*/
private  String _title = null;

/*
* Attribute defines width of column.
*/
private  String _width = null;


public HtmlColumn(){
setRendererType("org.richfaces.renderkit.CellRenderer");
}

public boolean isBreakBefore(){
	if (this._breakBeforeSet) {
	    return (this._breakBefore);
	}
	ValueExpression ve = getValueExpression("breakBefore");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._breakBefore);
	    }
	    
	    return value;
	} else {
	    return (this._breakBefore);
	}

}

public void setBreakBefore(boolean _breakBefore){
this._breakBefore = _breakBefore;
this._breakBeforeSet = true;
}

public int getColspan(){
	if (this._colspanSet) {
	    return (this._colspan);
	}
	ValueExpression ve = getValueExpression("colspan");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._colspan);
	    }
	    
	    return value;
	} else {
	    return (this._colspan);
	}

}

public void setColspan(int _colspan){
this._colspan = _colspan;
this._colspanSet = true;
}

public Comparator getComparator(){
	if (this._comparator != null) {
		return this._comparator;
	}
	ValueExpression ve = getValueExpression("comparator");
	if (ve != null) {
	    Comparator value = null;
	    
	    try {
			value = (Comparator) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setComparator(Comparator _comparator){
this._comparator = _comparator;
}

public String getDir(){
	if (this._dir != null) {
		return this._dir;
	}
	ValueExpression ve = getValueExpression("dir");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setDir(String _dir){
this._dir = _dir;
}

public Object getFilterBy(){
	if (this._filterBy != null) {
		return this._filterBy;
	}
	ValueExpression ve = getValueExpression("filterBy");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFilterBy(Object _filterBy){
this._filterBy = _filterBy;
}

public String getFilterEvent(){
	if (this._filterEvent != null) {
		return this._filterEvent;
	}
	ValueExpression ve = getValueExpression("filterEvent");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "onchange";
	

}

public void setFilterEvent(String _filterEvent){
this._filterEvent = _filterEvent;
}

public boolean isFilterExpression(){
	if (this._filterExpressionSet) {
	    return (this._filterExpression);
	}
	ValueExpression ve = getValueExpression("filterExpression");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._filterExpression);
	    }
	    
	    return value;
	} else {
	    return (this._filterExpression);
	}

}

public void setFilterExpression(boolean _filterExpression){
this._filterExpression = _filterExpression;
this._filterExpressionSet = true;
}

public MethodExpression getFilterMethod(){
return _filterMethod;
}

public void setFilterMethod(MethodExpression _filterMethod){
this._filterMethod = _filterMethod;
}

public String getFooterClass(){
	if (this._footerClass != null) {
		return this._footerClass;
	}
	ValueExpression ve = getValueExpression("footerClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setFooterClass(String _footerClass){
this._footerClass = _footerClass;
}

public String getHeaderClass(){
	if (this._headerClass != null) {
		return this._headerClass;
	}
	ValueExpression ve = getValueExpression("headerClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setHeaderClass(String _headerClass){
this._headerClass = _headerClass;
}

public String getLang(){
	if (this._lang != null) {
		return this._lang;
	}
	ValueExpression ve = getValueExpression("lang");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setLang(String _lang){
this._lang = _lang;
}

public int getRowspan(){
	if (this._rowspanSet) {
	    return (this._rowspan);
	}
	ValueExpression ve = getValueExpression("rowspan");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._rowspan);
	    }
	    
	    return value;
	} else {
	    return (this._rowspan);
	}

}

public void setRowspan(int _rowspan){
this._rowspan = _rowspan;
this._rowspanSet = true;
}

public boolean isSelfSorted(){
	if (this._selfSortedSet) {
	    return (this._selfSorted);
	}
	ValueExpression ve = getValueExpression("selfSorted");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._selfSorted);
	    }
	    
	    return value;
	} else {
	    return (this._selfSorted);
	}

}

public void setSelfSorted(boolean _selfSorted){
this._selfSorted = _selfSorted;
this._selfSortedSet = true;
}

public String getSortBy(){
	if (this._sortBy != null) {
		return this._sortBy;
	}
	ValueExpression ve = getValueExpression("sortBy");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSortBy(String _sortBy){
this._sortBy = _sortBy;
}

public String getSortExpression(){
	if (this._sortExpression != null) {
		return this._sortExpression;
	}
	ValueExpression ve = getValueExpression("sortExpression");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSortExpression(String _sortExpression){
this._sortExpression = _sortExpression;
}

public String getSortIcon(){
	if (this._sortIcon != null) {
		return this._sortIcon;
	}
	ValueExpression ve = getValueExpression("sortIcon");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSortIcon(String _sortIcon){
this._sortIcon = _sortIcon;
}

public String getSortIconAscending(){
	if (this._sortIconAscending != null) {
		return this._sortIconAscending;
	}
	ValueExpression ve = getValueExpression("sortIconAscending");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSortIconAscending(String _sortIconAscending){
this._sortIconAscending = _sortIconAscending;
}

public String getSortIconDescending(){
	if (this._sortIconDescending != null) {
		return this._sortIconDescending;
	}
	ValueExpression ve = getValueExpression("sortIconDescending");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSortIconDescending(String _sortIconDescending){
this._sortIconDescending = _sortIconDescending;
}

public boolean isSortable(){
	if (this._sortableSet) {
	    return (this._sortable);
	}
	ValueExpression ve = getValueExpression("sortable");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._sortable);
	    }
	    
	    return value;
	} else {
	    return (this._sortable);
	}

}

public void setSortable(boolean _sortable){
this._sortable = _sortable;
this._sortableSet = true;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public String getTitle(){
	if (this._title != null) {
		return this._title;
	}
	ValueExpression ve = getValueExpression("title");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTitle(String _title){
this._title = _title;
}

public String getWidth(){
	if (this._width != null) {
		return this._width;
	}
	ValueExpression ve = getValueExpression("width");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setWidth(String _width){
this._width = _width;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[30];
state[0] = super.saveState(context);
state[1] = Boolean.valueOf(_breakBefore);
state[2] = Boolean.valueOf(_breakBeforeSet);
state[3] = Integer.valueOf(_colspan);
state[4] = Boolean.valueOf(_colspanSet);
state[5] = saveAttachedState(context, _comparator);
state[6] = _dir;
state[7] = saveAttachedState(context, _filterBy);
state[8] = _filterEvent;
state[9] = Boolean.valueOf(_filterExpression);
state[10] = Boolean.valueOf(_filterExpressionSet);
state[11] = saveAttachedState(context, _filterMethod);
state[12] = _footerClass;
state[13] = _headerClass;
state[14] = _lang;
state[15] = Integer.valueOf(_rowspan);
state[16] = Boolean.valueOf(_rowspanSet);
state[17] = Boolean.valueOf(_selfSorted);
state[18] = Boolean.valueOf(_selfSortedSet);
state[19] = _sortBy;
state[20] = _sortExpression;
state[21] = _sortIcon;
state[22] = _sortIconAscending;
state[23] = _sortIconDescending;
state[24] = Boolean.valueOf(_sortable);
state[25] = Boolean.valueOf(_sortableSet);
state[26] = _style;
state[27] = _styleClass;
state[28] = _title;
state[29] = _width;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_breakBefore = ((Boolean)states[1]).booleanValue();
		_breakBeforeSet = ((Boolean)states[2]).booleanValue();
		_colspan = ((Integer)states[3]).intValue();
		_colspanSet = ((Boolean)states[4]).booleanValue();
		_comparator = (Comparator)restoreAttachedState(context, states[5]);
		_dir = (String)states[6];;
		_filterBy = (Object)restoreAttachedState(context, states[7]);
		_filterEvent = (String)states[8];;
		_filterExpression = ((Boolean)states[9]).booleanValue();
		_filterExpressionSet = ((Boolean)states[10]).booleanValue();
		_filterMethod = (MethodExpression)restoreAttachedState(context, states[11]);
		_footerClass = (String)states[12];;
		_headerClass = (String)states[13];;
		_lang = (String)states[14];;
		_rowspan = ((Integer)states[15]).intValue();
		_rowspanSet = ((Boolean)states[16]).booleanValue();
		_selfSorted = ((Boolean)states[17]).booleanValue();
		_selfSortedSet = ((Boolean)states[18]).booleanValue();
		_sortBy = (String)states[19];;
		_sortExpression = (String)states[20];;
		_sortIcon = (String)states[21];;
		_sortIconAscending = (String)states[22];;
		_sortIconDescending = (String)states[23];;
		_sortable = ((Boolean)states[24]).booleanValue();
		_sortableSet = ((Boolean)states[25]).booleanValue();
		_style = (String)states[26];;
		_styleClass = (String)states[27];;
		_title = (String)states[28];;
		_width = (String)states[29];;
	
}

}
