package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIGmap;

public class HtmlGmap extends UIGmap{

static public final  String COMPONENT_FAMILY = "org.richfaces.Gmap";

static public final  String COMPONENT_TYPE = "org.richfaces.Gmap";

/*
* Enables continuous smooth zooming for selected browsers. Default value is "false".
*/
private  String _enableContinuousZoom = null;

/*
* Enables zooming in by a double click. Default value is "false".
*/
private  String _enableDoubleClickZoom = null;

/*
* Enables a map dragging with the mouse. Default value is "true".
*/
private  String _enableDragging = null;

/*
* Enables Info Window. Default value is "true".
*/
private  String _enableInfoWindow = null;

/*
* Google Map key. A single Map API key is valid for a single "directory" on your web server. Default value is "internal".
*/
private  String _gmapKey = null;

/*
* The JavaScript variable that is used to access the Google Map API. If you have
			 more than one Google Map components on the same page, use individual
			 key for each of them. The default variable name is "map" (without quotes).
*/
private  String _gmapVar = null;

/*
* Initial latitude coordinate in degrees, as a number between -90 and +90. Default value is "37.9721046".
*/
private  String _lat = null;

/*
* Initial longitude coordinate in degrees, as a number between -180 and +180. Default value is "-122.0424842834".
*/
private  String _lng = null;

/*
* Initial map type. The possible values are  G_NORMAL_MAP, G_SATELLITE_MAP,
                        G_HYBRID_MAP. Default value is "G_SATELLITE_MAP".
*/
private  String _mapType = null;

/*
* HTML: a script expression; a pointer button is clicked
*/
private  String _onclick = null;

/*
* HTML: a script expression; a pointer button is double-clicked
*/
private  String _ondblclick = null;

/*
* JavaScript code invoked just after the Google Map object is initiated.
*/
private  String _oninit = null;

/*
* HTML: a script expression; a key is pressed down
*/
private  String _onkeydown = null;

/*
* HTML: a script expression; a key is pressed and released
*/
private  String _onkeypress = null;

/*
* HTML: a script expression; a key is released
*/
private  String _onkeyup = null;

/*
* HTML: script expression; a pointer button is pressed down
*/
private  String _onmousedown = null;

/*
* HTML: a script expression; a pointer is moved within
*/
private  String _onmousemove = null;

/*
* HTML: a script expression; a pointer is moved away
*/
private  String _onmouseout = null;

/*
* HTML: a script expression; a pointer is moved onto
*/
private  String _onmouseover = null;

/*
* HTML: script expression; a pointer button is released
*/
private  String _onmouseup = null;

/*
* Shows the GLarge control. Default value is "true".
*/
private  String _showGLargeMapControl = null;

/*
* Shows the Type switch control. Default value is "true".
*/
private  String _showGMapTypeControl = null;

/*
* It shows the scale control. Default value is "true".
*/
private  String _showGScaleControl = null;

/*
* CSS style(s) is/are to be applied when this component is rendered
*/
private  String _style = null;

/*
* Corresponds to the HTML class attribute
*/
private  String _styleClass = null;

/*
* The warning message that appears if a browser is not compatible with Google Map.
			Default value is "Your browser does not support Google Maps".
*/
private  String _warningMessage = null;

/*
* Initial zoom level as a number between 1 and 18. Default value is "17".
*/
private  String _zoom = null;


public HtmlGmap(){
setRendererType("org.richfaces.GmapRenderer");
}

public String getEnableContinuousZoom(){
	if (this._enableContinuousZoom != null) {
		return this._enableContinuousZoom;
	}
	ValueExpression ve = getValueExpression("enableContinuousZoom");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "false";
	

}

public void setEnableContinuousZoom(String _enableContinuousZoom){
this._enableContinuousZoom = _enableContinuousZoom;
}

public String getEnableDoubleClickZoom(){
	if (this._enableDoubleClickZoom != null) {
		return this._enableDoubleClickZoom;
	}
	ValueExpression ve = getValueExpression("enableDoubleClickZoom");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "false";
	

}

public void setEnableDoubleClickZoom(String _enableDoubleClickZoom){
this._enableDoubleClickZoom = _enableDoubleClickZoom;
}

public String getEnableDragging(){
	if (this._enableDragging != null) {
		return this._enableDragging;
	}
	ValueExpression ve = getValueExpression("enableDragging");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "true";
	

}

public void setEnableDragging(String _enableDragging){
this._enableDragging = _enableDragging;
}

public String getEnableInfoWindow(){
	if (this._enableInfoWindow != null) {
		return this._enableInfoWindow;
	}
	ValueExpression ve = getValueExpression("enableInfoWindow");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "true";
	

}

public void setEnableInfoWindow(String _enableInfoWindow){
this._enableInfoWindow = _enableInfoWindow;
}

public String getGmapKey(){
	if (this._gmapKey != null) {
		return this._gmapKey;
	}
	ValueExpression ve = getValueExpression("gmapKey");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "internal";
	

}

public void setGmapKey(String _gmapKey){
this._gmapKey = _gmapKey;
}

public String getGmapVar(){
	if (this._gmapVar != null) {
		return this._gmapVar;
	}
	ValueExpression ve = getValueExpression("gmapVar");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "map";
	

}

public void setGmapVar(String _gmapVar){
this._gmapVar = _gmapVar;
}

public String getLat(){
	if (this._lat != null) {
		return this._lat;
	}
	ValueExpression ve = getValueExpression("lat");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "37.9721046";
	

}

public void setLat(String _lat){
this._lat = _lat;
}

public String getLng(){
	if (this._lng != null) {
		return this._lng;
	}
	ValueExpression ve = getValueExpression("lng");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "-122.0424842834";
	

}

public void setLng(String _lng){
this._lng = _lng;
}

public String getMapType(){
	if (this._mapType != null) {
		return this._mapType;
	}
	ValueExpression ve = getValueExpression("mapType");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "G_SATELLITE_MAP";
	

}

public void setMapType(String _mapType){
this._mapType = _mapType;
}

public String getOnclick(){
	if (this._onclick != null) {
		return this._onclick;
	}
	ValueExpression ve = getValueExpression("onclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnclick(String _onclick){
this._onclick = _onclick;
}

public String getOndblclick(){
	if (this._ondblclick != null) {
		return this._ondblclick;
	}
	ValueExpression ve = getValueExpression("ondblclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndblclick(String _ondblclick){
this._ondblclick = _ondblclick;
}

public String getOninit(){
	if (this._oninit != null) {
		return this._oninit;
	}
	ValueExpression ve = getValueExpression("oninit");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOninit(String _oninit){
this._oninit = _oninit;
}

public String getOnkeydown(){
	if (this._onkeydown != null) {
		return this._onkeydown;
	}
	ValueExpression ve = getValueExpression("onkeydown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeydown(String _onkeydown){
this._onkeydown = _onkeydown;
}

public String getOnkeypress(){
	if (this._onkeypress != null) {
		return this._onkeypress;
	}
	ValueExpression ve = getValueExpression("onkeypress");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeypress(String _onkeypress){
this._onkeypress = _onkeypress;
}

public String getOnkeyup(){
	if (this._onkeyup != null) {
		return this._onkeyup;
	}
	ValueExpression ve = getValueExpression("onkeyup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeyup(String _onkeyup){
this._onkeyup = _onkeyup;
}

public String getOnmousedown(){
	if (this._onmousedown != null) {
		return this._onmousedown;
	}
	ValueExpression ve = getValueExpression("onmousedown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousedown(String _onmousedown){
this._onmousedown = _onmousedown;
}

public String getOnmousemove(){
	if (this._onmousemove != null) {
		return this._onmousemove;
	}
	ValueExpression ve = getValueExpression("onmousemove");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousemove(String _onmousemove){
this._onmousemove = _onmousemove;
}

public String getOnmouseout(){
	if (this._onmouseout != null) {
		return this._onmouseout;
	}
	ValueExpression ve = getValueExpression("onmouseout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseout(String _onmouseout){
this._onmouseout = _onmouseout;
}

public String getOnmouseover(){
	if (this._onmouseover != null) {
		return this._onmouseover;
	}
	ValueExpression ve = getValueExpression("onmouseover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseover(String _onmouseover){
this._onmouseover = _onmouseover;
}

public String getOnmouseup(){
	if (this._onmouseup != null) {
		return this._onmouseup;
	}
	ValueExpression ve = getValueExpression("onmouseup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseup(String _onmouseup){
this._onmouseup = _onmouseup;
}

public String getShowGLargeMapControl(){
	if (this._showGLargeMapControl != null) {
		return this._showGLargeMapControl;
	}
	ValueExpression ve = getValueExpression("showGLargeMapControl");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "true";
	

}

public void setShowGLargeMapControl(String _showGLargeMapControl){
this._showGLargeMapControl = _showGLargeMapControl;
}

public String getShowGMapTypeControl(){
	if (this._showGMapTypeControl != null) {
		return this._showGMapTypeControl;
	}
	ValueExpression ve = getValueExpression("showGMapTypeControl");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "true";
	

}

public void setShowGMapTypeControl(String _showGMapTypeControl){
this._showGMapTypeControl = _showGMapTypeControl;
}

public String getShowGScaleControl(){
	if (this._showGScaleControl != null) {
		return this._showGScaleControl;
	}
	ValueExpression ve = getValueExpression("showGScaleControl");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "true";
	

}

public void setShowGScaleControl(String _showGScaleControl){
this._showGScaleControl = _showGScaleControl;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public String getWarningMessage(){
	if (this._warningMessage != null) {
		return this._warningMessage;
	}
	ValueExpression ve = getValueExpression("warningMessage");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "Your browser does not support Google Maps";
	

}

public void setWarningMessage(String _warningMessage){
this._warningMessage = _warningMessage;
}

public String getZoom(){
	if (this._zoom != null) {
		return this._zoom;
	}
	ValueExpression ve = getValueExpression("zoom");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "17";
	

}

public void setZoom(String _zoom){
this._zoom = _zoom;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[28];
state[0] = super.saveState(context);
state[1] = _enableContinuousZoom;
state[2] = _enableDoubleClickZoom;
state[3] = _enableDragging;
state[4] = _enableInfoWindow;
state[5] = _gmapKey;
state[6] = _gmapVar;
state[7] = _lat;
state[8] = _lng;
state[9] = _mapType;
state[10] = _onclick;
state[11] = _ondblclick;
state[12] = _oninit;
state[13] = _onkeydown;
state[14] = _onkeypress;
state[15] = _onkeyup;
state[16] = _onmousedown;
state[17] = _onmousemove;
state[18] = _onmouseout;
state[19] = _onmouseover;
state[20] = _onmouseup;
state[21] = _showGLargeMapControl;
state[22] = _showGMapTypeControl;
state[23] = _showGScaleControl;
state[24] = _style;
state[25] = _styleClass;
state[26] = _warningMessage;
state[27] = _zoom;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_enableContinuousZoom = (String)states[1];;
		_enableDoubleClickZoom = (String)states[2];;
		_enableDragging = (String)states[3];;
		_enableInfoWindow = (String)states[4];;
		_gmapKey = (String)states[5];;
		_gmapVar = (String)states[6];;
		_lat = (String)states[7];;
		_lng = (String)states[8];;
		_mapType = (String)states[9];;
		_onclick = (String)states[10];;
		_ondblclick = (String)states[11];;
		_oninit = (String)states[12];;
		_onkeydown = (String)states[13];;
		_onkeypress = (String)states[14];;
		_onkeyup = (String)states[15];;
		_onmousedown = (String)states[16];;
		_onmousemove = (String)states[17];;
		_onmouseout = (String)states[18];;
		_onmouseover = (String)states[19];;
		_onmouseup = (String)states[20];;
		_showGLargeMapControl = (String)states[21];;
		_showGMapTypeControl = (String)states[22];;
		_showGScaleControl = (String)states[23];;
		_style = (String)states[24];;
		_styleClass = (String)states[25];;
		_warningMessage = (String)states[26];;
		_zoom = (String)states[27];;
	
}

}
