/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.FilterIterator;
import org.richfaces.component.UISwitchablePanel;
import org.richfaces.component.UITab;
import org.richfaces.event.SwitchablePanelSwitchEvent;

public abstract class UITabPanel
extends UISwitchablePanel {
    public static final String COMPONENT_TYPE = "org.richfaces.TabPanel";
    private transient boolean processedTabImmediate;
    private Object renderedValue;
    private transient Object restoredRenderedValue;
    private static final Predicate RENDERED_TAB_PREDICATE = new Predicate(){

        public boolean evaluate(Object object) {
            if (object instanceof UITab) {
                UITab tab = (UITab)((Object)object);
                return tab.isRendered();
            }
            return false;
        }
    };

    public boolean getRendersChildren() {
        return true;
    }

    protected Iterator getSwitchedFacetsAndChildren() {
        final Object renderedValue = this.restoredRenderedValue;
        return new FilterIterator(this.getRenderedTabs(), new Predicate(){

            public boolean evaluate(Object object) {
                UITab tab = (UITab)((Object)object);
                if (tab.isDisabled()) {
                    return false;
                }
                if ("client".equals(tab.getSwitchTypeOrDefault())) {
                    return true;
                }
                return renderedValue != null && renderedValue.equals(tab.getName());
            }
        });
    }

    public boolean isImmediate() {
        if (!super.isImmediate()) {
            return this.processedTabImmediate;
        }
        return super.isImmediate();
    }

    public Object convertSwitchValue(UIComponent component, Object object) {
        if (object != null) {
            return object;
        }
        return ((UITab)component).getName();
    }

    public Object getValue() {
        if (this.renderedValue != null) {
            return this.renderedValue;
        }
        return super.getValue();
    }

    public void setValue(Object value) {
        super.setValue(value);
    }

    public Object getSelectedTab() {
        return this.getValue();
    }

    public void setSelectedTab(Object tab) {
        this.setValue(tab);
    }

    public Object getRenderedValue() {
        return this.getValue();
    }

    public void setRenderedValue(Object renderedValue) {
        this.renderedValue = renderedValue;
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("FacesContext is null!");
        }
        if (!this.isRendered()) {
            return;
        }
        if (this.restoredRenderedValue == null) {
            this.restoredRenderedValue = this.getRenderedValue();
        }
        super.processDecodes(context);
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{super.saveState(context), this.renderedValue};
        return state;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] states = (Object[])state;
        super.restoreState(context, states[0]);
        this.renderedValue = states[1];
        this.restoredRenderedValue = this.getRenderedValue();
    }

    public Iterator getRenderedTabs() {
        if (this.getChildCount() > 0) {
            return new FilterIterator(this.getChildren().iterator(), RENDERED_TAB_PREDICATE);
        }
        return CollectionUtils.EMPTY_COLLECTION.iterator();
    }

    public abstract String getSwitchType();

    public abstract void setSwitchType(String var1);

    public abstract String getHeaderAlignment();

    public abstract void setHeaderAlignment(String var1);

    public abstract String getHeaderSpacing();

    public abstract void setHeaderSpacing(String var1);

    public abstract String getHeaderClass();

    public abstract void setHeaderClass(String var1);

    private UITab processedTab(UIComponent component, Object object) {
        if (object != null) {
            return this.getTabWithName(object);
        }
        return (UITab)component;
    }

    private UITab getTabWithName(Object tabName) {
        List children = this.getChildren();
        for (UIComponent childComponent : children) {
            if (!(childComponent instanceof UITab) || !((UITab)childComponent).getName().equals(tabName)) continue;
            return (UITab)childComponent;
        }
        return null;
    }

    public void queueEvent(FacesEvent event) {
        if (event instanceof SwitchablePanelSwitchEvent && ((Object)((Object)this)).equals(event.getComponent())) {
            SwitchablePanelSwitchEvent switchEvent = (SwitchablePanelSwitchEvent)event;
            UITab tab = this.processedTab(switchEvent.getEventSource(), switchEvent.getValue());
            this.processedTabImmediate = tab.isImmediate();
        }
        if (event instanceof ActionEvent && event.getComponent() instanceof UITab) {
            if (this.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
        super.queueEvent(event);
    }
}

