/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.ajax4jsf.renderkit.RendererBase;
import org.ajax4jsf.renderkit.compiler.TemplateContext;
import org.ajax4jsf.util.style.CSSFormat;
import org.richfaces.component.UIPanelMenu;
import org.richfaces.component.UIPanelMenuGroup;
import org.richfaces.component.UIPanelMenuItem;
import org.richfaces.renderkit.html.PanelMenuGroupRenderer;
import org.richfaces.renderkit.html.iconimages.PanelMenuIconChevron;
import org.richfaces.renderkit.html.iconimages.PanelMenuIconChevronDown;
import org.richfaces.renderkit.html.iconimages.PanelMenuIconChevronLeft;
import org.richfaces.renderkit.html.iconimages.PanelMenuIconChevronUp;
import org.richfaces.renderkit.html.iconimages.PanelMenuIconDisc;
import org.richfaces.renderkit.html.iconimages.PanelMenuIconGrid;
import org.richfaces.renderkit.html.iconimages.PanelMenuIconSpacer;
import org.richfaces.renderkit.html.iconimages.PanelMenuIconTriangle;
import org.richfaces.renderkit.html.iconimages.PanelMenuIconTriangleDown;
import org.richfaces.renderkit.html.iconimages.PanelMenuIconTriangleLeft;
import org.richfaces.renderkit.html.iconimages.PanelMenuIconTriangleUp;

public abstract class PanelMenuRendererBase
extends HeaderResourcesRendererBase {
    public static final String PANEL_MENU_SPACER_ICON_NAME = "spacer";

    public void insertSpacerImages(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        int level = this.calculateLevel(component);
        String src = this.getIconByType("custom", false, context, component);
        int w = 16;
        for (int i = 0; i < level; ++i) {
            writer.startElement("img", component);
            writer.writeAttribute("src", (Object)src, null);
            writer.writeAttribute("alt", (Object)"", null);
            writer.writeAttribute("hspace", (Object)"0", null);
            writer.writeAttribute("vspace", (Object)"0", null);
            writer.writeAttribute("height", (Object)String.valueOf(w), null);
            writer.writeAttribute("width", (Object)String.valueOf(w), null);
            writer.endElement("img");
        }
    }

    protected int calculateLevel(UIComponent component) {
        int level = 0;
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof UIPanelMenu) {
                return level;
            }
            if (!(parent instanceof UIPanelMenuGroup)) continue;
            ++level;
        }
        return level;
    }

    protected String getIconByType(String iconType, boolean isTopLevel, FacesContext context, UIComponent component) {
        String source = "";
        Boolean topLevel = new Boolean(isTopLevel);
        if (iconType != null && !iconType.equals("none")) {
            source = iconType.equals("custom") || "".equals(iconType) ? this.getResource(PanelMenuIconSpacer.class.getName()).getUri(context, (Object)topLevel) : (iconType.equals(PANEL_MENU_SPACER_ICON_NAME) ? this.getResource(PanelMenuIconSpacer.class.getName()).getUri(context, (Object)topLevel) : (iconType.equals("triangle") ? this.getResource(PanelMenuIconTriangle.class.getName()).getUri(context, (Object)topLevel) : (iconType.equals("triangleLeft") ? this.getResource(PanelMenuIconTriangleLeft.class.getName()).getUri(context, (Object)topLevel) : (iconType.equals("triangleDown") ? this.getResource(PanelMenuIconTriangleDown.class.getName()).getUri(context, (Object)topLevel) : (iconType.equals("triangleUp") ? this.getResource(PanelMenuIconTriangleUp.class.getName()).getUri(context, (Object)topLevel) : (iconType.equals("chevron") ? this.getResource(PanelMenuIconChevron.class.getName()).getUri(context, (Object)topLevel) : (iconType.equals("chevronLeft") ? this.getResource(PanelMenuIconChevronLeft.class.getName()).getUri(context, (Object)topLevel) : (iconType.equals("chevronUp") ? this.getResource(PanelMenuIconChevronUp.class.getName()).getUri(context, (Object)topLevel) : (iconType.equals("chevronDown") ? this.getResource(PanelMenuIconChevronDown.class.getName()).getUri(context, (Object)topLevel) : (iconType.equals("disc") ? this.getResource(PanelMenuIconDisc.class.getName()).getUri(context, (Object)topLevel) : (iconType.equals("grid") ? this.getResource(PanelMenuIconGrid.class.getName()).getUri(context, (Object)topLevel) : this.getUtils().encodeResourceURL(new TemplateContext((RendererBase)this, context, component), (Object)iconType))))))))))));
        }
        return source;
    }

    protected UIPanelMenu findMenu(UIComponent component) {
        UIComponent parent;
        if (component instanceof UIPanelMenu) {
            return (UIPanelMenu)component;
        }
        for (parent = component; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof UIPanelMenu)) continue;
            return (UIPanelMenu)parent;
        }
        return (UIPanelMenu)parent;
    }

    public String getHideStyle(FacesContext context, UIComponent component) {
        if (!(component.getParent() instanceof UIPanelMenu)) {
            CSSFormat format = new CSSFormat();
            format.add("display", "none");
            if (component.getParent() instanceof UIPanelMenuGroup) {
                UIPanelMenuGroup parent = (UIPanelMenuGroup)component.getParent();
                PanelMenuGroupRenderer renderer = (PanelMenuGroupRenderer)context.getRenderKit().getRenderer(parent.getFamily(), parent.getRendererType());
                try {
                    if (renderer.isOpened(context, (UIComponent)parent)) {
                        return "";
                    }
                    return format.toString();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                return format.toString();
            }
        }
        return "";
    }

    public void insertLabel(FacesContext context, UIComponent component) throws IOException {
        Object value = component.getAttributes().get("label");
        if (value != null) {
            context.getResponseWriter().write(value.toString());
        }
    }

    protected boolean isChildrenExpanded(UIComponent component) {
        if (component.getChildren() != null) {
            for (UIComponent child : component.getChildren()) {
                if (!(child instanceof UIPanelMenuGroup)) continue;
                if (((UIPanelMenuGroup)child).isExpanded()) {
                    return true;
                }
                return this.isChildrenExpanded(child);
            }
        }
        return false;
    }

    protected boolean isParentDisabled(UIComponent component) {
        boolean returnValue = false;
        UIComponent parent = component.getParent();
        if (parent instanceof UIPanelMenuGroup) {
            UIPanelMenuGroup parentGroup = (UIPanelMenuGroup)parent;
            returnValue = parentGroup.isDisabled() ? true : this.isParentDisabled((UIComponent)parentGroup);
        }
        return returnValue;
    }

    protected boolean isSubmitted(FacesContext context, UIComponent component) {
        boolean submitted = false;
        String clientId = component.getClientId(context);
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        Object value = requestParameterMap.get("panelMenuAction" + clientId);
        if (clientId != null && value != null && value.equals(clientId)) {
            submitted = true;
        }
        return submitted;
    }

    protected String getItemMode(UIComponent component) {
        String parentExpandMode = this.findMenu(component).getExpandMode();
        String parentMode = this.findMenu(component).getMode();
        if (null == parentMode || "".equals(parentMode)) {
            parentMode = "server";
        }
        if (null == parentExpandMode || "".equals(parentExpandMode)) {
            parentExpandMode = "none";
        }
        String mode = "none";
        if (component instanceof UIPanelMenuGroup) {
            UIPanelMenuGroup group = (UIPanelMenuGroup)component;
            mode = null != group.getExpandMode() && !"".equals(group.getExpandMode()) ? group.getExpandMode() : parentExpandMode;
        } else if (component instanceof UIPanelMenuItem) {
            UIPanelMenuItem item = (UIPanelMenuItem)component;
            mode = null != item.getMode() && !"".equals(item.getMode()) ? item.getMode() : parentMode;
        }
        return mode;
    }

    public boolean isTopLevel(UIComponent component) {
        UIComponent parent = component.getParent();
        while (!(parent instanceof UIPanelMenu) && !(parent instanceof UIPanelMenuGroup)) {
            parent = parent.getParent();
        }
        return parent instanceof UIPanelMenu;
    }

    public void drawIcon(ResponseWriter writer, String iconType, String imageSrc, UIComponent component, String id, boolean drawHidden) throws IOException {
        if (iconType != null && !iconType.equals("") && !iconType.equals("none")) {
            int h = 16;
            writer.startElement("img", component);
            if (drawHidden) {
                writer.writeAttribute("style", (Object)"display: none;", null);
            }
            writer.writeAttribute("src", (Object)imageSrc, null);
            writer.writeAttribute("alt", (Object)"", null);
            writer.writeAttribute("vspace", (Object)"0", null);
            writer.writeAttribute("hspace", (Object)"0", null);
            writer.writeAttribute("width", (Object)String.valueOf(h), null);
            writer.writeAttribute("height", (Object)String.valueOf(h), null);
            writer.writeAttribute("id", (Object)id, null);
            writer.endElement("img");
        }
    }
}

