/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.DateTimeConverter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import org.ajax4jsf.component.AjaxComponent;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.event.AjaxEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.event.CurrentDateChangeEvent;
import org.richfaces.event.CurrentDateChangeListener;
import org.richfaces.model.CalendarDataModel;
import org.richfaces.model.CalendarDataModelItem;
import org.richfaces.renderkit.CalendarRendererBase;

public abstract class UICalendar
extends UIInput
implements AjaxComponent {
    private int _firstWeekDay = 0;
    private boolean _firstWeekDaySet = false;
    private int _minDaysInFirstWeek = 0;
    private boolean _minDaysInFirstWeekSet = false;
    public static final String COMPONENT_TYPE = "org.richfaces.Calendar";
    private static final String COMPONENT_FAMILY = "org.richfaces.Calendar";
    private static String DEFAULT_TIME_VALUE = "hours:12,minutes:0";
    private static String DEFAULT_TIME_PATTERN = "HH:mm";
    private static String HOURS_VALUE = "hours";
    private static String MINUTES_VALUE = "minutes";
    public static final String AJAX_MODE = "ajax";
    public static final String CLIENT_MODE = "client";
    private static final Log log = LogFactory.getLog(UICalendar.class);

    public abstract Object getLocale();

    public abstract void setLocale(Object var1);

    public abstract TimeZone getTimeZone();

    public abstract void setTimeZone(TimeZone var1);

    public abstract Object getPreloadDateRangeBegin();

    public abstract void setPreloadDateRangeBegin(Object var1);

    public abstract Object getPreloadDateRangeEnd();

    public abstract void setPreloadDateRangeEnd(Object var1);

    public abstract Object getCurrentDate();

    public abstract void setCurrentDate(Object var1);

    public abstract CalendarDataModel getDataModel();

    public abstract void setDataModel(CalendarDataModel var1);

    public abstract String getDatePattern();

    public abstract void setDatePattern(String var1);

    public abstract Object getDefaultTime();

    public abstract void setDefaultTime(Object var1);

    public abstract boolean isResetTimeOnDateSelect();

    public abstract void setResetTimeOnDateSelect(boolean var1);

    public abstract Object getMonthLabels();

    public abstract void setMonthLabels(Object var1);

    public abstract Object getMonthLabelsShort();

    public abstract void setMonthLabelsShort(Object var1);

    public abstract Object getWeekDayLabels();

    public abstract void setWeekDayLabels(Object var1);

    public abstract Object getWeekDayLabelsShort();

    public abstract void setWeekDayLabelsShort(Object var1);

    public abstract String getJointPoint();

    public abstract void setJointPoint(String var1);

    public abstract String getDirection();

    public abstract void setDirection(String var1);

    public abstract boolean isPopup();

    public abstract void setPopup(boolean var1);

    public abstract boolean isDisabled();

    public abstract void setDisabled(boolean var1);

    public abstract String getButtonLabel();

    public abstract void setButtonLabel(String var1);

    public abstract String getToolTipMode();

    public abstract void setToolTipMode(String var1);

    public abstract String getBoundaryDatesMode();

    public abstract void setBoundaryDatesMode(String var1);

    public abstract MethodBinding getCurrentDateChangeListener();

    public abstract void setCurrentDateChangeListener(MethodBinding var1);

    public abstract String getMode();

    public abstract void setMode(String var1);

    public abstract int getVerticalOffset();

    public abstract void setVerticalOffset(int var1);

    public abstract int getHorizontalOffset();

    public abstract void setHorizontalOffset(int var1);

    public abstract String getDayStyleClass();

    public abstract void setDayStyleClass(String var1);

    public abstract String getIsDayEnabled();

    public abstract void setIsDayEnabled(String var1);

    public abstract String getCellHeight();

    public abstract void setCellHeight(String var1);

    public abstract String getCellWidth();

    public abstract void setCellWidth(String var1);

    public abstract boolean isShowWeekDaysBar();

    public abstract void setShowWeekDaysBar(boolean var1);

    public abstract boolean isShowWeeksBar();

    public abstract void setShowWeeksBar(boolean var1);

    public abstract boolean isShowHeader();

    public abstract void setShowHeader(boolean var1);

    public abstract boolean isShowFooter();

    public abstract void setShowFooter(boolean var1);

    public abstract String getTodayControlMode();

    public abstract void setTodayControlMode(String var1);

    public abstract boolean isShowApplyButton();

    public abstract void setShowApplyButton(boolean var1);

    public Calendar getCalendar() {
        return Calendar.getInstance(this.getTimeZone(), this.getAsLocale(this.getLocale()));
    }

    public Date getConvertedValue(FacesContext context, String currentDateString) throws ConverterException {
        DateTimeConverter datetime = new DateTimeConverter();
        datetime.setPattern("m/y");
        Date newCurrentDate = (Date)datetime.getAsObject(context, (UIComponent)this, currentDateString);
        return newCurrentDate;
    }

    protected Object getDefaultValueOfDefaultTime() {
        Calendar calendar = this.getCalendar();
        calendar.set(11, 12);
        calendar.set(12, 0);
        return calendar.getTime();
    }

    public Date getFormattedDefaultTime() {
        Date result = null;
        Object defaultTime = this.getDefaultTime();
        if (defaultTime instanceof Calendar) {
            result = ((Calendar)defaultTime).getTime();
        } else if (defaultTime instanceof Date) {
            result = (Date)defaultTime;
        } else {
            String defaultTimeString = defaultTime.toString();
            String datePattern = this.getDatePattern();
            String timePattern = "\\s*[hHkKma]+[\\W&&\\S]+[hHkKma]+\\s*";
            Pattern pattern = Pattern.compile(timePattern);
            Matcher matcher = pattern.matcher(datePattern);
            String subTimePattern = DEFAULT_TIME_PATTERN;
            if (matcher.find()) {
                subTimePattern = matcher.group().trim();
            }
            SimpleDateFormat format = new SimpleDateFormat(subTimePattern);
            try {
                result = format.parse(defaultTimeString);
            }
            catch (ParseException parseException) {
                result = null;
            }
        }
        return result;
    }

    public String getPreparedDefaultTime() {
        Date date = this.getFormattedDefaultTime();
        if (date == null) {
            return DEFAULT_TIME_VALUE;
        }
        StringBuilder result = new StringBuilder();
        Calendar calendar = this.getCalendar();
        calendar.setTime(date);
        result.append("{").append(HOURS_VALUE).append(":");
        result.append(calendar.get(11));
        result.append(",");
        result.append(MINUTES_VALUE).append(":");
        result.append(calendar.get(12)).append("}");
        return result.toString();
    }

    protected void validateValue(FacesContext context, Object newValue) {
        this.setSubmittedValue(newValue);
        super.validateValue(context, newValue);
    }

    public void updateCurrentDate(FacesContext context, Object currentDate) {
        if (context == null) {
            throw new NullPointerException();
        }
        try {
            ValueBinding vb = this.getValueBinding("currentDate");
            if (vb != null) {
                if (vb.getType(context).equals(String.class)) {
                    DateTimeConverter convert = new DateTimeConverter();
                    convert.setLocale(this.getAsLocale(this.getLocale()));
                    convert.setPattern(this.getDatePattern());
                    vb.setValue(context, (Object)convert.getAsString(context, (UIComponent)this, currentDate));
                    return;
                }
                if (vb.getType(context).equals(Calendar.class)) {
                    Calendar c = Calendar.getInstance();
                    c.setTime((Date)currentDate);
                    vb.setValue(context, (Object)c);
                    return;
                }
                vb.setValue(context, currentDate);
                return;
            }
            this.setCurrentDate(currentDate);
        }
        catch (Exception e) {
            this.setValid(false);
            if (log.isDebugEnabled()) {
                log.debug((Object)(" updateCurrentDate method throws exception: " + e.toString()), (Throwable)e);
            }
            e.printStackTrace();
            String messageString = e.toString();
            FacesMessage message = new FacesMessage(messageString);
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            context.addMessage(this.getClientId(context), message);
        }
    }

    public Date getCurrentDateOrDefault() {
        Date date = this.getAsDate(this.getCurrentDate());
        if (date != null) {
            return date;
        }
        Date value = this.getAsDate(this.getValue());
        if (value != null) {
            return value;
        }
        return Calendar.getInstance(this.getTimeZone()).getTime();
    }

    public Date getAsDate(Object date) {
        if (date == null) {
            return null;
        }
        if (date instanceof Date) {
            return (Date)date;
        }
        if (date instanceof String) {
            DateTimeConverter converter = new DateTimeConverter();
            converter.setPattern(this.getDatePattern());
            converter.setLocale(this.getAsLocale(this.getLocale()));
            converter.setTimeZone(this.getTimeZone());
            FacesContext context = FacesContext.getCurrentInstance();
            return (Date)converter.getAsObject(context, (UIComponent)this, (String)date);
        }
        if (date instanceof Calendar) {
            return ((Calendar)date).getTime();
        }
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        Converter converter = application.createConverter(date.getClass());
        if (null != converter) {
            return this.getAsDate(converter.getAsString(context, (UIComponent)this, date));
        }
        throw new FacesException("Wrong attibute type or there is no converter for custom attibute type");
    }

    public Object getTooltip(Date date) {
        CalendarDataModel calendarDM = this.getDataModel();
        if (calendarDM != null) {
            return calendarDM.getToolTip(date);
        }
        return null;
    }

    protected Date getDefaultPreloadBegin(Date date) {
        Calendar calendar = Calendar.getInstance(this.getTimeZone(), this.getAsLocale(this.getLocale()));
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMinimum(5));
        return calendar.getTime();
    }

    protected Date getDefaultPreloadEnd(Date date) {
        Calendar calendar = Calendar.getInstance(this.getTimeZone(), this.getAsLocale(this.getLocale()));
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    protected Locale getDefaultLocale() {
        Locale locale;
        UIViewRoot viewRoot;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && (viewRoot = facesContext.getViewRoot()) != null && (locale = viewRoot.getLocale()) != null) {
            return locale;
        }
        return Locale.US;
    }

    protected TimeZone getDefaultTimeZone() {
        return TimeZone.getDefault();
    }

    public Date convertCurrentDate(String currentDateString) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(5, 1);
        int idx = currentDateString.indexOf(47);
        if (idx != -1) {
            calendar.set(2, Integer.parseInt(currentDateString.substring(0, idx)) - 1);
            calendar.set(1, Integer.parseInt(currentDateString.substring(idx + 1)));
            return calendar.getTime();
        }
        return null;
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        block9: {
            if (event instanceof AjaxEvent) {
                FacesContext facesContext = FacesContext.getCurrentInstance();
                AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)facesContext);
                ajaxContext.addRegionsFromComponent((UIComponent)this);
                if (this.getPreload() != null) {
                    ajaxContext.setResponseData(this.getPreload());
                }
            } else if (event instanceof CurrentDateChangeEvent) {
                FacesContext facesContext = this.getFacesContext();
                CurrentDateChangeEvent dateChangeEvent = (CurrentDateChangeEvent)event;
                String currentDateString = dateChangeEvent.getCurrentDateString();
                try {
                    Date currentDate = this.getAsDate(this.getCurrentDate());
                    Date submittedCurrentDate = this.convertCurrentDate(currentDateString);
                    dateChangeEvent.setCurrentDate(submittedCurrentDate);
                    if (submittedCurrentDate.equals(currentDate)) break block9;
                    this.updateCurrentDate(facesContext, submittedCurrentDate);
                    MethodBinding binding = this.getCurrentDateChangeListener();
                    if (binding != null) {
                        binding.invoke(facesContext, new Object[]{dateChangeEvent});
                    }
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(" currentDate convertion fails with following exception: " + e.toString()), (Throwable)e);
                    }
                    this.setValid(false);
                    String messageString = e.toString();
                    e.printStackTrace();
                    FacesMessage message = new FacesMessage(messageString);
                    message.setSeverity(FacesMessage.SEVERITY_ERROR);
                    facesContext.addMessage(this.getClientId(facesContext), message);
                    facesContext.renderResponse();
                }
            } else {
                super.broadcast(event);
            }
        }
    }

    public Object getPreload() {
        CalendarDataModel calendarDataModel;
        Date[] preloadDateRange = this.getPreloadDateRange();
        if (preloadDateRange != null && preloadDateRange.length != 0 && (calendarDataModel = this.getDataModel()) != null) {
            CalendarDataModelItem[] calendarDataModelItems = calendarDataModel.getData(preloadDateRange);
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("startDate", CalendarRendererBase.formatDate(preloadDateRange[0]));
            args.put("days", calendarDataModelItems);
            return args;
        }
        return null;
    }

    public Date[] getPreloadDateRange() {
        Date dateRangeBegin = this.getAsDate(this.getPreloadDateRangeBegin());
        Date dateRangeEnd = this.getAsDate(this.getPreloadDateRangeEnd());
        if (dateRangeBegin == null && dateRangeEnd == null) {
            return null;
        }
        if (dateRangeBegin.after(dateRangeEnd)) {
            FacesMessage message = new FacesMessage("preloadDateRangeBegin is greater than preloadDateRangeEnd");
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            FacesContext context = FacesContext.getCurrentInstance();
            context.addMessage(this.getClientId(context), message);
            throw new IllegalArgumentException();
        }
        ArrayList<Date> dates = new ArrayList<Date>();
        Calendar calendar = Calendar.getInstance(this.getTimeZone(), this.getAsLocale(this.getLocale()));
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar.setTime(dateRangeBegin);
        calendar2.setTime(dateRangeEnd);
        do {
            dates.add(calendar.getTime());
            calendar.add(5, 1);
        } while (!calendar.after(calendar2));
        return dates.toArray(new Date[dates.size()]);
    }

    public void addCurrentDateChangeListener(CurrentDateChangeListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public CurrentDateChangeListener[] getCurrentDateChangeListeners() {
        return (CurrentDateChangeListener[])this.getFacesListeners(CurrentDateChangeListener.class);
    }

    public void removeCurrentDateChangeListener(CurrentDateChangeListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public Locale parseLocale(String localeStr) {
        int length = localeStr.length();
        if (null == localeStr || length < 2) {
            return Locale.getDefault();
        }
        int index1 = localeStr.indexOf("_");
        String language = null;
        if (index1 == -1) {
            return new Locale(localeStr);
        }
        language = localeStr.substring(0, index1);
        int index2 = localeStr.indexOf("_", index1 + 1);
        String country = null;
        if (index2 != -1) {
            country = localeStr.substring(index1 + 1, index2);
            String variant = localeStr.substring(index2 + 1);
            return new Locale(language, country, variant);
        }
        country = localeStr.substring(index1 + 1);
        return new Locale(language, country);
    }

    public Locale getAsLocale(Object locale) {
        if (locale instanceof Locale) {
            return (Locale)locale;
        }
        if (locale instanceof String) {
            return this.parseLocale((String)locale);
        }
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        Converter converter = application.createConverter(locale.getClass());
        if (null != converter) {
            return this.parseLocale(converter.getAsString(context, (UIComponent)this, locale));
        }
        throw new FacesException("Wrong locale attibute type or there is no converter for custom attibute type");
    }

    protected int getDefaultFirstWeekDay() {
        Calendar cal = this.getCalendar();
        return cal.getFirstDayOfWeek() - cal.getActualMinimum(7);
    }

    protected int getDefaultMinDaysInFirstWeek() {
        return this.getCalendar().getMinimalDaysInFirstWeek();
    }

    public void setMinDaysInFirstWeek(int __minDaysInFirstWeek) {
        this._minDaysInFirstWeek = __minDaysInFirstWeek;
        this._minDaysInFirstWeekSet = true;
    }

    public int getMinDaysInFirstWeek() {
        if (this._minDaysInFirstWeekSet) {
            return this._minDaysInFirstWeek;
        }
        ValueBinding vb = this.getValueBinding("minDaysInFirstWeek");
        if (vb != null) {
            Integer value = (Integer)vb.getValue(this.getFacesContext());
            if (null == value) {
                return this.getDefaultMinDaysInFirstWeek();
            }
            return value;
        }
        return this.getDefaultMinDaysInFirstWeek();
    }

    public void setFirstWeekDay(int __firstWeekDay) {
        this._firstWeekDay = __firstWeekDay;
        this._firstWeekDaySet = true;
    }

    public int getFirstWeekDay() {
        if (this._firstWeekDaySet) {
            return this._firstWeekDay;
        }
        ValueBinding vb = this.getValueBinding("firstWeekDay");
        if (vb != null) {
            Integer value = (Integer)vb.getValue(this.getFacesContext());
            if (null == value) {
                return this.getDefaultFirstWeekDay();
            }
            return value;
        }
        return this.getDefaultFirstWeekDay();
    }

    public Object saveState(FacesContext context) {
        return new Object[]{super.saveState(context), new Integer(this._firstWeekDay), new Boolean(this._firstWeekDaySet), new Integer(this._minDaysInFirstWeek), new Boolean(this._minDaysInFirstWeekSet)};
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] states = (Object[])state;
        super.restoreState(context, states[0]);
        this._firstWeekDay = (Integer)states[1];
        this._firstWeekDaySet = (Boolean)states[2];
        this._minDaysInFirstWeek = (Integer)states[3];
        this._minDaysInFirstWeekSet = (Boolean)states[4];
    }
}

