if(!window.Richfaces) window.Richfaces = {};
Richfaces.InplaceSelect = Class.create(Richfaces.InplaceInput, {
	initialize : function($super, listObj, clientId, temValueKeepId, valueKeepId, tabberId, attributes, events, classes, barParams, buttonId) {
		this.button = $(buttonId);
		this.comboList = listObj;
		$super(clientId, temValueKeepId, valueKeepId, tabberId, attributes, events, classes, barParams);
		this.clickOnBar = false;
		this.inplaceSelect = $(clientId);		
		this.inplaceSelect.component = this;
				
		this.currentItemValue = this.value;
		this.button.style.top = Richfaces.getBorderWidth(this.tempValueKeeper, "tb") + "px";
		this["rich:destructor"] = "destroy";
	},
	
	destroy: function() {
		this.inplaceSelect.component = null;
	},
	
	
	initHandlers : function($super) {
		$super();
		this.tempValueKeeper.observe("click", function(e){this.tempKeeperClickHandler(e);}.bindAsEventListener(this));
		
		this.button.observe("mousedown", function(e){this.buttonClickHandler(e);}.bindAsEventListener(this));
		
		this.comboList.listParent.observe("mousedown", function(e){this.listMousedownHandler(e);}.bindAsEventListener(this));
		this.comboList.listParent.observe("mousemove", function(e){this.listMouseMoveHandler(e)}.bindAsEventListener(this));
		this.comboList.listParent.observe("click", function(e){this.listClickHandler(e);}.bindAsEventListener(this));
	},
	
	setInputWidth : function($super, textSize) {
		$super(textSize);
		this.button.show();
		var width = parseInt(this.tempValueKeeper.style.width);
		this.button.style.left = ( width - this.button.offsetWidth) + "px";
		return width;
	},
	
	switchingStatesHandler : function($super, e) {
		var el = (e.srcElement) ? e.srcElement : e.target;
		if ((el.id == this.inplaceInput.id) || (e.type == "focus")) {
			$super(e);
		} else if(this.tempValueKeeper.style.display != "none") {
			this.tempValueKeeper.focus();
		}
	},
	
	startEditableState : function($super) {
		$super();
		this.button.show();
		if (this.attributes.openOnEdit) {
			this.comboList.showWithDelay();
		}
	},
	
	endEditableState : function($super) {
		this.inplaceInput.style.position = "";
		$super();
		this.button.hide();
	},
	
	tempKeeperClickHandler : function() {
		this.comboList.isList = false;
		this.comboList.showWithDelay();
	},
	
	buttonClickHandler : function(e) {
		this.tempKeeperClickHandler();
		this.tempValueKeeper.focus();
		this.button.isClicked = true;
		Event.stop(e);
	},
	
	tmpValueBlurHandler : function($super, event) {
		if (this.clickOnBar || this.byTab) {
			//tab navigation&clickOnbar handler
			this.clickOnBar = false;
			this.byTab = false;
			return;
		}
		
		if (!this.comboList.isList) {
			//click somewhere out of the component area 
			if (this.comboList.activeItem) {
				this.comboList.doNormalItem(this.comboList.activeItem);
			}
			/*if (!this.attributes.closeOnSelect && !this.attributes.showControls && this.comboList.isListOpened) {
				this.comboList.hideWithDelay();
				this.comboList.isList = false;
				this.tempValueKeeper.focus();
				return;
			}*/
			this.comboList.hideWithDelay();
		}
		
		if (this.clickOnScroll) {
			//click on scroll under IE 
			this.clickOnScroll = false;
			this.tempValueKeeper.focus();
			this.comboList.isList = false;
			return;		
		}
		
		if (!this.attributes.showControls) {
			this.save();
		} else {
			this.applyTmpValue();
		}
		this.comboList.isList = false;
		
	},
	
	listClickHandler : function(event) {
		this.tempValueKeeper.focus();
		this.comboList.hideWithDelay();
	},
	
	listMouseMoveHandler : function(event) {
		//changes item's decoration
		var item = this.comboList.getEventItem(event);
		if (item) {
			this.comboList.doActiveItem(this.comboList.getEventItem(event));			
		}
	},
	
	listMousedownHandler : function(e) {
		//TODO:fix it
		if (Prototype.Browser.Gecko) {
			if (this.comboList.getEventItem(e)) {
				this.comboList.isList = true;			
			}
		} else {
			if (!this.comboList.getEventItem(e)) {
				this.clickOnScroll = true;
			}
			this.comboList.isList = true;
		}
	},
	
	tmpValueKeyDownHandler : function(event) {
		switch (event.keyCode) {
			case Event.KEY_RETURN :
				this.comboList.isList = false; 
				this.save();
				this.comboList.hideWithDelay();
				Event.stop(event);
				break;
			case Event.KEY_DOWN : 
				this.comboList.moveActiveItem(event);
				Event.stop(event);
				break;
			case Event.KEY_UP :
				this.comboList.moveActiveItem(event);
				Event.stop(event);
				break; 
			case Event.KEY_ESC : 
				this.comboList.resetSelection();
				this.comboList.hideWithDelay();
				this.cancel(event);
				break;
			case Event.KEY_TAB :
				this.save();
				this.byTab = true;
				break;
		}
	},
	
	save : function($super) {
		this.applyTmpValue();
		this.comboList.hide();
		if (((this.attributes.closeOnSelect && !this.attributes.showControls) && this.comboList.isList) 
			|| (this.clickOnBar || !this.comboList.isList)) {
			//bug : http://jira.jboss.com/jira/browse/RF-2810, 
			//will be corrected in a future version (http://jira.jboss.com/jira/browse/RF-2814)
				var unescapedValue = this.currentItemValue;
				this.invokeEvent(this.events.onchange, this.inplaceSelect, "onchange", {itemValue : unescapedValue, itemText : this.tempValueKeeper.value});
//				var unescapeText = this.tempValueKeeper.value.unescapeHTML();
				this.saveValue(unescapedValue, this.tempValueKeeper.value);
		}
	},
	
	saveValue : function(userValue, currentText) {
		var value = this.valueKeeper.value;
		if (this.invokeEvent(this.events.onviewactivation, this.inplaceInput, "rich:onviewactivation", {oldValue : this.valueKeeper.value, value : this.tempValueKeeper.value})) {
			this.endEditableState();
			if (userValue == "") {
				this.setDefaultText();
				this.valueKeeper.value = "";
					//this.startViewState();
			} else {
				if (currentText == "") {
					this.setDefaultText();
				} else {
					this.currentText = currentText;
				}
				this.valueKeeper.value = userValue;
			}
			if (userValue != this.value) {
				this.startChangedState();
			} else {
				this.startViewState();
			}
			
			if (this.events.onviewactivated) {
				this.inplaceInput.fire("rich:onviewactivated", {oldValue : this.valueKeeper.value, value : this.tempValueKeeper.value});
			}
		}
	},
	
	applyTmpValue : function() {
		if (this.comboList.activeItem) {
			var userLabel = this.comboList.activeItem.innerHTML.unescapeHTML();
			this.currentItemValue = this.comboList.activeItem.value;
			this.tempValueKeeper.value = userLabel;
			this.comboList.selectedItem = this.comboList.activeItem;
		}
	},
	
	deleteViewArtifacts : function () {
		var text;
		// IE6 support TODO: remove???? 
		if (this.comboList.iframe) {
			text = this.inplaceInput.childNodes[7];
		} else {
			text = this.inplaceInput.childNodes[6];	
		}	
		
		if (text) {
			this.inplaceInput.removeChild(text);
		}
	},
	
	getCurrentText : function() {
		var currentText; 
		// IE6 support	
		if (this.comboList.iframe) {
			currentText = this.inplaceInput.childNodes[7];
		} else {
			currentText = this.inplaceInput.childNodes[6];
		}
		
		return currentText;
	},
	
	getLabelItem : function(value) {
		var length = this.comboList.getItems().length;
		for (var i = 0; i < length; i++) {
			var item = this.comboList.getItems()[i];
			if (item.value == value) {
				return item;
			}
		}
	},
	
	cancel : function($super, e) {
		var item = this.getLabelItem(this.valueKeeper.value);
		this.comboList.resetSelection();
		this.comboList.hide();
		if (item) {
			this.comboList.doSelectItem(item);
			$super(e, item.innerHTML.unescapeHTML());
		} else {
			$super(e, "");
		}
	}
});
	

