/**
 * 
 */
package org.richfaces.taglib;

import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.webapp.UIComponentClassicTagBase;
import javax.servlet.jsp.JspException;

import org.ajax4jsf.webapp.taglib.UIComponentTagBase;
import org.richfaces.component.UIBeanValidator;
import org.richfaces.renderkit.html.BeanValidatorRenderer;
import org.richfaces.validator.FacesBeanValidator;

/**
 * @author asmirnov
 *
 */
public class AjaxValidatorTagBase extends UIComponentTagBase {

    /**
     * Generate script for given event ( onclick, onenter ... )
     */
    private String event = null;

    /* (non-Javadoc)
	 * @see javax.faces.webapp.UIComponentTagBase#getComponentType()
	 */
	@Override
	public String getComponentType() {
		return UIBeanValidator.COMPONENT_TYPE;
	}

	/**
	 * @param event the event to set
	 */
	public void setEvent(String event) {
		this.event = event;
	}
	
	@Override
	public int doStartTag() throws JspException {
        // Locate our parent UIComponentTag
        UIComponentClassicTagBase tag =
             UIComponentClassicTagBase.getParentUIComponentClassicTagBase(pageContext);
        if (tag == null) { 
       	    //PENDING i18n
            throw new JspException("Not nested in a UIComponentTag Error for tag with handler class:"+
                    this.getClass().getName());
        }
		UIComponent component = tag.getComponentInstance();
		if( !(component instanceof EditableValueHolder)){
       	    //PENDING i18n
            throw new JspException("Not nested in a UIInput  component. Error for tag with handler class:"+
                    this.getClass().getName());
			
		}
        // Nothing to do unless this tag created a component
        if (tag.getCreated()) {
			// New created component, add validator.
			FacesContext facesContext = FacesContext.getCurrentInstance();
			FacesBeanValidator validator = (FacesBeanValidator) facesContext
					.getApplication().createValidator(
							FacesBeanValidator.BEAN_VALIDATOR_TYPE);
			((EditableValueHolder) component).addValidator(validator);

        }
		return super.doStartTag();
	}

	@Override
	protected void setProperties(UIComponent component) {
		super.setProperties(component);
        setStringProperty(component, "event", event);
	}
	
	@Override
	public void release() {
		super.release();
		event = null;
	}
	/* (non-Javadoc)
	 * @see javax.faces.webapp.UIComponentTagBase#getRendererType()
	 */
	@Override
	public String getRendererType() {
		return BeanValidatorRenderer.RENDERER_TYPE;
	}

	@Override
	protected String getFacetName() {
		return UIBeanValidator.BEAN_VALIDATOR_FACET + (null == event?"":event);
	}
}
