/**
 * 
 */
package org.richfaces.validator;

import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.FunctionMapper;
import javax.el.VariableMapper;

/**
 * @author asmirnov
 *
 */
public class ELContextWrapper extends ELContext {
	
	private final ELContext parent;
	
	private final ELResolver resolver;

	/**
	 * @param parent
	 */
	public ELContextWrapper(ELContext parent,ELResolver resolver) {
		super();
		this.resolver = resolver;
		this.parent = parent;
	}

	/* (non-Javadoc)
	 * @see javax.el.ELContext#getELResolver()
	 */
	@Override
	public ELResolver getELResolver() {
		return resolver;
	}

	/**
	 * @return
	 * @see javax.el.ELContext#getFunctionMapper()
	 */
	public FunctionMapper getFunctionMapper() {
		return parent.getFunctionMapper();
	}

	/**
	 * @return
	 * @see javax.el.ELContext#getVariableMapper()
	 */
	public VariableMapper getVariableMapper() {
		return parent.getVariableMapper();
	}

	/**
	 * @param key
	 * @return
	 * @see javax.el.ELContext#getContext(java.lang.Class)
	 */
	public Object getContext(Class key) {
		return parent.getContext(key);
	}

	/**
	 * @param key
	 * @param contextObject
	 * @see javax.el.ELContext#putContext(java.lang.Class, java.lang.Object)
	 */
	public void putContext(Class key, Object contextObject) {
		parent.putContext(key, contextObject);
	}

}
