/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.validator;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.richfaces.validator.BeanValidator;

public class FacesBeanValidator
implements Validator {
    public static final String BEAN_VALIDATOR_TYPE = "org.richfaces.BeanValidator";

    public void validate(FacesContext context, UIComponent component, Object convertedValue) throws ValidatorException {
        if (component instanceof EditableValueHolder) {
            EditableValueHolder input = (EditableValueHolder)component;
            try {
                String[] messages;
                ValueExpression valueExpression = component.getValueExpression("value");
                if (null != valueExpression && null != (messages = BeanValidator.getInstance(context).validate(context, valueExpression, convertedValue))) {
                    input.setValid(false);
                    for (String msg : messages) {
                        context.addMessage(component.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_ERROR, "", msg));
                    }
                }
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
    }
}

