/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;


// 
// Imports
//
import java.util.Iterator;
import java.util.Collection;
import java.util.Map;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResource;
//
//
//


import org.richfaces.renderkit.FileUploadRendererBase;



/**
 * Renderer for component class org.richfaces.renderkit.html.FileUploadRenderer
 */
public class FileUploadRenderer extends FileUploadRendererBase {

	public FileUploadRenderer () {
		super();
	}

	// 
	// Declarations
	//
	private final InternetResource[] styles = {
						getResource("/org/richfaces/renderkit/html/css/fileUpload.xcss")
						,
				getResource("/org/richfaces/renderkit/html/css/progressBar.xcss")
	};

private InternetResource[] stylesAll = null;

protected InternetResource[] getStyles() {
	synchronized (this) {
		if (stylesAll == null) {
			InternetResource[] rsrcs = super.getStyles();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = styles == null || styles.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					stylesAll = new InternetResource[0];	
				} else {
					stylesAll = styles;
				}
			} else {
				if (ignoreThis) {
					stylesAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < styles.length; i++ ) {
						rsrcsSet.add(styles[i]);
					}

					stylesAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return stylesAll;
}
	private final InternetResource[] scripts = {
						new org.ajax4jsf.javascript.PrototypeScript()
						,
				new org.ajax4jsf.javascript.AjaxScript()
						,
				getResource("/org/richfaces/renderkit/html/scripts/utils.js")
						,
				getResource("/org/richfaces/renderkit/html/scripts/json/json-dom.js")
						,
				getResource("/org/richfaces/renderkit/html/js/FileUpload.js")
						,
				getResource("/org/richfaces/renderkit/html/js/swfobject.js")
						,
				getResource("/org/richfaces/renderkit/html/js/progressBar.js")
						,
				getResource("/org/ajax4jsf/javascript/scripts/form.js")
	};

private InternetResource[] scriptsAll = null;

protected InternetResource[] getScripts() {
	synchronized (this) {
		if (scriptsAll == null) {
			InternetResource[] rsrcs = super.getScripts();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = scripts == null || scripts.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					scriptsAll = new InternetResource[0];	
				} else {
					scriptsAll = scripts;
				}
			} else {
				if (ignoreThis) {
					scriptsAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < scripts.length; i++ ) {
						rsrcsSet.add(scripts[i]);
					}

					scriptsAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return scriptsAll;
}
	// 
	// 
	//


	private String convertToString(Object obj ) {
		return ( obj == null ? "" : obj.toString() );
	}
	private String convertToString(boolean b ) {
		return String.valueOf(b);
	}
	private String convertToString(int b ) {
		return b!=Integer.MIN_VALUE?String.valueOf(b):"";
	}
	private String convertToString(long b ) {
		return b!=Long.MIN_VALUE?String.valueOf(b):"";
	}
	
	private boolean isEmpty(Object o) {
		if (null == o) {
			return true;
		}
		if (o instanceof String ) {
			return (0 == ((String)o).length());
		}
		if (o instanceof Collection) {
			return (0 == ((Collection)o).size());
		}
		if (o instanceof Map) {
			return (0 == ((Map)o).size());
		}
		if (o.getClass().isArray()) {
			return (0 == ((Object [])o).length);
		}
		return false;
	}
	
	/**
	 * Get base component class, targetted for this renderer. Used for check arguments in decode/encode.
	 * @return
	 */
	protected Class getComponentClass() {
		return org.richfaces.component.UIFileUpload.class;
	}


	public void doEncodeEnd(ResponseWriter writer, FacesContext context, org.richfaces.component.UIFileUpload component, ComponentVariables variables) throws IOException {
	  java.lang.String clientId = component.getClientId(context);
variables.setVariable("flashComponent", getResource( "/org/richfaces/renderkit/html/swf/fileUploadComponent.swf" ).getUri(context, component) );


		
 		Integer max = initMaxFilesCount(context, component, clientId);
		variables.setVariable("maxCount", max);

		boolean disabled = (Boolean)component.getAttributes().get("disabled");
		String addButtonClass = (disabled) ? "rich-fileupload-button-dis rich-fileupload-font " + (String)component.getAttributes().get("addButtonClassDisabled") 
									: "rich-fileupload-button rich-fileupload-font " + (String)component.getAttributes().get("addButtonClass");
		String addButtonClassContent = (disabled) ? "rich-fileupload-button-content rich-fileupload-font rich-fileupload-ico rich-fileupload-ico-add-dis " + (String)component.getAttributes().get("addButtonClassDisabled") 
				: "rich-fileupload-button-content rich-fileupload-font rich-fileupload-ico rich-fileupload-ico-add " + (String)component.getAttributes().get("addButtonClass");
		
		String uploadListClass = (disabled) ? (String)component.getAttributes().get("uploadListClassDisabled") : (String)component.getAttributes().get("uploadListClass");
		variables.setVariable("addButtonClass",addButtonClass);
		variables.setVariable("addButtonClassContent",addButtonClassContent);
		variables.setVariable("uploadListClass",uploadListClass);
		
		Map<String, String> labels = getLabels(context, component);
		variables.setVariable("labels",labels);
		variables.setVariable("addLabel",labels.get("add"));
		variables.setVariable("uploadLabel",labels.get("upload"));
		variables.setVariable("clearAllLabel",labels.get("clear_all"));

		variables.setVariable("actionUrl",org.ajax4jsf.context.AjaxContextImpl.getCurrentInstance().getAjaxActionURL(context));
		variables.setVariable("formId",getFormId(context, component));
		variables.setVariable("containerId",getContainerId(context, component));

		variables.setVariable("listWidth", getFileListWidth(component));
		variables.setVariable("listHeight", getFileListHeight(component));
	
		  

writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-fileupload-list-decor" );
						getUtils().writeAttribute(writer, "id", clientId );
						getUtils().writeAttribute(writer, "onclick", component.getAttributes().get("onclick") );
						getUtils().writeAttribute(writer, "onmouseover", component.getAttributes().get("onmouseover") );
						getUtils().writeAttribute(writer, "style", "width: " + convertToString(variables.getVariable("listWidth")) );
			
getUtils().encodeBeginFormIfNessesary(context, component);

writer.startElement("span", component);
			getUtils().writeAttribute(writer, "style", "display: none;" );
			

		
	renderProgress(context, component);
		  
	
writer.endElement("span");
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "class", "rich-fileupload-toolbar-decor" );
			
writer.startElement("tr", component);

writer.startElement("td", component);

writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-fileupload-button-border" );
						getUtils().writeAttribute(writer, "style", " float:left;" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", variables.getVariable("addButtonClass") );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":add1" );
						getUtils().writeAttribute(writer, "onmousedown", "this.className='rich-fileupload-button-press rich-fileupload-font'" );
						getUtils().writeAttribute(writer, "onmouseout", "this.className='rich-fileupload-button rich-fileupload-font'" );
						getUtils().writeAttribute(writer, "onmouseover", "this.className='rich-fileupload-button-light rich-fileupload-font'" );
						getUtils().writeAttribute(writer, "onmouseup", "this.className='rich-fileupload-button rich-fileupload-font'" );
						getUtils().writeAttribute(writer, "style", "position: relative;" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", variables.getVariable("addButtonClassContent") );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":add2" );
						getUtils().writeAttribute(writer, "style", "position: relative;" );
			
writer.writeText(convertToString(variables.getVariable("addLabel")),null);

writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "style", "overflow : hidden; position : absolute; top : 0px; left : 0px; padding: 0px;" );
			
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "class", "rich-fileupload-hidden" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":file" );
						getUtils().writeAttribute(writer, "name", convertToString(clientId) + ":file" );
						getUtils().writeAttribute(writer, "onchange", "return $('" + convertToString(clientId) + "').component.add(this);" );
						getUtils().writeAttribute(writer, "onmousedown", "$('" + convertToString(clientId) + "').component.createFrame();" );
						getUtils().writeAttribute(writer, "style", "cursor: pointer; right: 0px; top: 0px; font-size: 10em; position: absolute; padding: 0px" );
						getUtils().writeAttribute(writer, "type", "file" );
			
writer.endElement("input");
writer.endElement("div");
writer.endElement("div");
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-fileupload-button-border" );
						getUtils().writeAttribute(writer, "style", " float:left; display: none;" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-file-upload-button rich-fileupload-font " + convertToString(component.getAttributes().get("uploadButtonClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":upload1" );
						getUtils().writeAttribute(writer, "onclick", "return $('" + convertToString(clientId) + "').component.upload();" );
						getUtils().writeAttribute(writer, "onmousedown", "this.className='rich-fileupload-button-press rich-fileupload-font'" );
						getUtils().writeAttribute(writer, "onmouseout", "this.className='rich-fileupload-button rich-fileupload-font'" );
						getUtils().writeAttribute(writer, "onmouseover", "this.className='rich-fileupload-button-light rich-fileupload-font'" );
						getUtils().writeAttribute(writer, "onmouseup", "this.className='rich-fileupload-button rich-fileupload-font'" );
			
writer.startElement("a", component);
			getUtils().writeAttribute(writer, "class", "rich-fileupload-button-selection" );
						getUtils().writeAttribute(writer, "href", "#" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-fileupload-button-content rich-fileupload-font rich-fileupload-ico rich-fileupload-ico-start " + convertToString(component.getAttributes().get("uploadButtonClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":upload2" );
			
writer.writeText(convertToString(variables.getVariable("uploadLabel")),null);

writer.endElement("div");
writer.endElement("a");
writer.endElement("div");
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-fileupload-button-border" );
						getUtils().writeAttribute(writer, "style", " float:right; display: none;" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-fileupload-button rich-fileupload-font " + convertToString(component.getAttributes().get("cleanButtonClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":clean1" );
						getUtils().writeAttribute(writer, "onclick", "return $('" + convertToString(clientId) + "').component.clear();" );
						getUtils().writeAttribute(writer, "onmousedown", "this.className='rich-fileupload-button-press rich-fileupload-font'" );
						getUtils().writeAttribute(writer, "onmouseout", "this.className='rich-fileupload-button rich-fileupload-font'" );
						getUtils().writeAttribute(writer, "onmouseover", "this.className='rich-fileupload-button-light rich-fileupload-font'" );
						getUtils().writeAttribute(writer, "onmouseup", "this.className='rich-fileupload-button rich-fileupload-font'" );
			
writer.startElement("a", component);
			getUtils().writeAttribute(writer, "class", "rich-fileupload-button-selection" );
						getUtils().writeAttribute(writer, "href", "#" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-fileupload-button-content rich-fileupload-font rich-fileupload-ico rich-fileupload-ico-clear-dis " + convertToString(component.getAttributes().get("cleanButtonClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":clean2" );
			
writer.writeText(convertToString(variables.getVariable("clearAllLabel")),null);

writer.endElement("div");
writer.endElement("a");
writer.endElement("div");
writer.endElement("div");
writer.endElement("td");
writer.endElement("tr");
writer.endElement("table");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-fileupload-list-overflow " + convertToString(variables.getVariable("uploadListClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":fileItems" );
						getUtils().writeAttribute(writer, "style", "width: 100%; height: " + convertToString(variables.getVariable("listHeight")) );
			
writer.endElement("div");

	
		String useFlashComponent = ((String) component.getAttributes().get("allowFlash")).trim().toLowerCase();
		variables.setVariable("allowFlash", useFlashComponent);
	
	
writer.startElement("span", component);

writer.startElement("script", component);
			getUtils().writeAttribute(writer, "type", "text/javascript" );
			
writer.writeText(convertToString("FileUpload.CLASSES = {\n				ADD : {	\n					ENABLED  : 'rich-fileupload-button rich-fileupload-font " + convertToString(component.getAttributes().get("addButtonClass")) + "',\n					DISABLED : 'rich-fileupload-button-dis rich-file-upload-font " + convertToString(component.getAttributes().get("addButtonClassDisabled")) + "'\n				},\n				ADD_CONTENT	: {\n					ENABLED  : 'rich-fileupload-button-content rich-fileupload-font rich-fileupload-ico rich-fileupload-ico-add " + convertToString(component.getAttributes().get("addButtonClass")) + "',\n					DISABLED : 'rich-fileupload-button-content rich-fileupload-font rich-fileupload-ico rich-fileupload-ico-add-dis " + convertToString(component.getAttributes().get("addButtonClassDisabled")) + "'\n				},\n				UPDATE : {\n					ENABLED  : 'rich-fileupload-button rich-fileupload-font " + convertToString(component.getAttributes().get("uploadButtonClass")) + "',\n					DISABLED : 'rich-fileupload-button-dis rich-fileupload-font " + convertToString(component.getAttributes().get("uploadButtonClassDisabled")) + "'\n				},\n				UPDATE_CONTENT : {\n					ENABLED  : 'rich-fileupload-button-content rich-fileupload-font rich-fileupload-ico rich-fileupload-ico-start " + convertToString(component.getAttributes().get("uploadButtonClass")) + "',\n					DISABLED : 'rich-fileupload-button-content rich-fileupload-font rich-fileupload-ico rich-fileupload-ico-start-dis " + convertToString(component.getAttributes().get("uploadButtonClassDisabled")) + "'\n				},\n				STOP : {\n					ENABLED  : 'rich-fileupload-button rich-fileupload-font " + convertToString(component.getAttributes().get("stopButtonClass")) + "',\n					DISABLED : 'rich-fileupload-button-dis rich-fileupload-font " + convertToString(component.getAttributes().get("stopButtonClassDisabled")) + "'\n				},\n				STOP_CONTENT : {\n					ENABLED  : 'rich-fileupload-button-content rich-file-upload-font rich-fileupload-ico rich-fileupload-ico-stop " + convertToString(component.getAttributes().get("stopButtonClass")) + "',\n					DISABLED : 'rich-fileupload-button-content rich-file-upload-font rich-fileupload-ico rich-fileupload-ico-stop-dis " + convertToString(component.getAttributes().get("stopButtonClassDisabled")) + "'\n				},\n				CLEAN : {\n					ENABLED  : 'rich-fileupload-button rich-fileupload-font " + convertToString(component.getAttributes().get("cleanButtonClass")) + "',\n					DISABLED : 'rich-fileupload-button-dis rich-fileupload-font " + convertToString(component.getAttributes().get("cleanButtonClassDisabled")) + "'\n				},\n				CLEAN_CONTENT : {\n					ENABLED  : 'rich-fileupload-button-content rich-fileupload-font rich-fileupload-ico rich-fileupload-ico-clear " + convertToString(component.getAttributes().get("cleanButtonClass")) + "',\n					DISABLED : 'rich-fileupload-button-content rich-fileupload-font rich-fileupload-ico rich-fileupload-ico-clear-dis " + convertToString(component.getAttributes().get("cleanButtonClassDisabled")) + "'\n				},\n				FILE_ENTRY : {\n					ENABLED : '" + convertToString(component.getAttributes().get("fileEntryClass")) + "',\n					DISABLED : '" + convertToString(component.getAttributes().get("fileEntryClassDisabled")) + "'\n				},\n				FILE_ENTRY_CONTROL : {\n					ENABLED : '" + convertToString(component.getAttributes().get("fileEntryControlClass")) + "',\n					DISABLED : '" + convertToString(component.getAttributes().get("fileEntryControlClassDisabled")) + "'\n				},\n				UPLOAD_LIST : {\n					ENABLED : '" + convertToString(component.getAttributes().get("uploadListClass")) + "',\n					DISABLED : '" + convertToString(component.getAttributes().get("uploadListClassDisabled")) + "'\n				}\n			};\n\n				var events = {\n						onupload : " + convertToString(getAsEventHandler(context,component,"onupload")) + ",\n						onuploadcomplete : " + convertToString(getAsEventHandler(context,component,"onuploadcomplete")) + ",\n						onuploadcanceled : " + convertToString(getAsEventHandler(context,component,"onuploadcanceled")) + ",\n						onerror : " + convertToString(getAsEventHandler(context,component,"onerror")) + ",\n						ontyperejected : " + convertToString(getAsEventHandler(context,component,"ontyperejected")) + ",\n						onsizerejected : " + convertToString(getAsEventHandler(context,component,"onsizerejected")) + ",\n						onclear : " + convertToString(getAsEventHandler(context,component,"onclear")) + ",\n						onadd : " + convertToString(getAsEventHandler(context,component,"onadd")) + "\n						};\n\n			new FileUpload('" + convertToString(clientId) + "','" + convertToString(variables.getVariable("formId")) + "','" + convertToString(variables.getVariable("actionUrl")) + "'," + convertToString(getStopScript(context,component)) + ", " + convertToString(getFileSizeScript(context,component)) + " ,'" + convertToString(getProgressBarId(context,component)) + "', FileUpload.CLASSES, " + convertToString(getLabelMarkup(context,component)) + ", " + convertToString(variables.getVariable("maxCount")) + ", events, " + convertToString(component.getAttributes().get("disabled")) + ", " + convertToString(getAcceptedTypes(context,component)) + ", {'autoclear':" + convertToString(component.getAttributes().get("autoclear")) + ",'autoUpload':" + convertToString(component.getAttributes().get("immediateUpload")) + ",'noDuplicate':" + convertToString(component.getAttributes().get("noDuplicate")) + ", 'allowFlash':'" + convertToString(variables.getVariable("allowFlash")) + "', 'flashComponentUrl':'" + convertToString(variables.getVariable("flashComponent")) + "'}," + convertToString(_getLabels(variables.getVariable("labels"))) + "," + convertToString(getChildrenParams(context,component)) + ",'" + convertToString(getSessionId(context,component)) + "');"),null);

writer.endElement("script");
writer.endElement("span");
getUtils().encodeEndFormIfNessesary(context, component);

writer.endElement("div");

	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeEnd(writer, context, (org.richfaces.component.UIFileUpload)component, variables );

		ComponentsVariableResolver.removeVariables(this, component);
	}		
	

}
