/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.component.UIDataAdaptor;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.richfaces.component.Column;
import org.richfaces.component.Row;
import org.richfaces.component.UIDataTable;
import org.richfaces.model.Ordering;
import org.richfaces.renderkit.AbstractRowsRenderer;
import org.richfaces.renderkit.HeaderEncodeStrategy;
import org.richfaces.renderkit.ScriptOptions;
import org.richfaces.renderkit.TableHolder;
import org.richfaces.renderkit.html.iconimages.DataTableIconSortAsc;
import org.richfaces.renderkit.html.iconimages.DataTableIconSortDesc;
import org.richfaces.renderkit.html.iconimages.DataTableIconSortNone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTableRenderer
extends AbstractRowsRenderer {
    private static final String SORT_FILTER_PARAMETER = "fsp";
    private static final String FILTER_INPUT_FACET_NAME = "filterValueInput";

    public void encodeTBody(FacesContext context, UIDataTable table) throws IOException {
        String clientId = table.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("tbody", (UIComponent)table);
        writer.writeAttribute("id", (Object)(clientId + ":tb"), null);
        this.encodeRows(context, (UIComponent)table);
        writer.endElement("tbody");
    }

    @Override
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        this.encodeTBody(context, (UIDataTable)component);
    }

    public void encodeTBodyAjax(FacesContext context, UIDataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("table", (UIComponent)table);
        this.encodeTBody(context, table);
        writer.endElement("table");
    }

    public boolean renderBodyOnly(FacesContext context, UIDataTable table) {
        Map map = context.getExternalContext().getRequestParameterMap();
        return table.isRendered() && SORT_FILTER_PARAMETER.equals(map.get(table.getClientId(context)));
    }

    public void encodeTableStructure(FacesContext context, UIDataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Object key = table.getRowKey();
        table.captureOrigValue(context);
        table.setRowKey(context, null);
        int columns = this.getColumnsCount(table);
        writer.startElement("colgroup", (UIComponent)table);
        writer.writeAttribute("span", (Object)String.valueOf(columns), null);
        String columnsWidth = (String)table.getAttributes().get("columnsWidth");
        if (null != columnsWidth) {
            String[] widths = columnsWidth.split(",");
            for (int i = 0; i < widths.length; ++i) {
                writer.startElement("col", (UIComponent)table);
                writer.writeAttribute("width", (Object)widths[i], null);
                writer.endElement("col");
            }
        }
        writer.endElement("colgroup");
        this.encodeCaption(context, table);
        this.encodeHeader(context, table, columns);
        this.encodeFooter(context, table, columns);
        table.setRowKey(context, key);
        table.restoreOrigValue(context);
    }

    public void encodeHeader(FacesContext context, UIDataTable table, int numberOfColumns) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent header = table.getHeader();
        boolean columnFacetPresent = this.isColumnFacetPresent(table, "header");
        boolean isFilterByPresent = this.isHeaderFactoryColumnAttributePresent(table, "filterBy");
        Iterator<UIComponent> colums = table.columns();
        if (header != null || columnFacetPresent || isFilterByPresent) {
            writer.startElement("thead", (UIComponent)table);
            writer.writeAttribute("class", (Object)"dr-table-thead", null);
            String headerClass = (String)table.getAttributes().get("headerClass");
            if (header != null) {
                this.encodeTableHeaderFacet(context, numberOfColumns, writer, header, "dr-table-header rich-table-header", "dr-table-header-continue rich-table-header-continue", "dr-table-headercell rich-table-headercell", headerClass, "th");
            }
            if (columnFacetPresent || isFilterByPresent) {
                writer.startElement("tr", (UIComponent)table);
                this.encodeStyleClass(writer, null, "dr-table-subheader rich-table-subheader", null, headerClass);
                this.encodeHeaderFacets(context, writer, colums, "dr-table-subheadercell rich-table-subheadercell", headerClass, "header", "th", numberOfColumns);
                writer.endElement("tr");
            }
            writer.endElement("thead");
        }
    }

    public boolean isColumnFacetPresent(UIDataTable table, String facetName) {
        Iterator<UIComponent> columns = table.columns();
        boolean result = false;
        while (columns.hasNext() && !result) {
            UIComponent component = columns.next();
            if (!this.isColumnRendered(component) || null == component.getFacet(facetName)) continue;
            result = true;
        }
        return result;
    }

    public boolean isHeaderFactoryColumnAttributePresent(UIDataTable table, String attributeName) {
        Iterator<UIComponent> columns = table.columns();
        boolean result = false;
        while (columns.hasNext() && !result) {
            UIComponent column = columns.next();
            if (!this.isColumnRendered(column) || null == column.getValueExpression(attributeName)) continue;
            result = true;
        }
        return result;
    }

    protected boolean isColumnRendered(UIComponent component) {
        boolean rendered = true;
        try {
            rendered = component.isRendered();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rendered;
    }

    protected void encodeHeaderFacets(FacesContext context, ResponseWriter writer, Iterator<UIComponent> headers, String skinCellClass, String headerClass, String facetName, String element, int colCount) throws IOException {
        int t_colCount = 0;
        RichHeaderEncodeStrategy richEncodeStrategy = new RichHeaderEncodeStrategy();
        SimpleHeaderEncodeStrategy simpleEncodeStrategy = new SimpleHeaderEncodeStrategy();
        while (headers.hasNext()) {
            UIComponent column = headers.next();
            if (!this.isColumnRendered(column)) continue;
            t_colCount = (Integer)column.getAttributes().get("colspan") != null ? (t_colCount += ((Integer)column.getAttributes().get("colspan")).intValue()) : ++t_colCount;
            if (t_colCount > colCount) break;
            String classAttribute = facetName + "Class";
            String columnHeaderClass = (String)column.getAttributes().get(classAttribute);
            writer.startElement(element, column);
            this.encodeStyleClass(writer, null, skinCellClass, headerClass, columnHeaderClass);
            writer.writeAttribute("scope", (Object)"col", null);
            this.getUtils().encodeAttribute(context, column, "colspan");
            boolean sortableColumn = column.getValueExpression("comparator") != null || column.getValueExpression("sortBy") != null;
            SimpleHeaderEncodeStrategy strategy = column instanceof org.richfaces.component.UIColumn && "header".equals(facetName) ? richEncodeStrategy : simpleEncodeStrategy;
            strategy.encodeBegin(context, writer, column, facetName, sortableColumn);
            UIComponent facet = column.getFacet(facetName);
            if (facet != null && this.isColumnRendered(facet)) {
                this.renderChild(context, facet);
            }
            strategy.encodeEnd(context, writer, column, facetName, sortableColumn);
            writer.endElement(element);
        }
    }

    public void encodeFooter(FacesContext context, UIDataTable table, int columns) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent footer = table.getFooter();
        boolean columnFacetPresent = this.isColumnFacetPresent(table, "footer");
        Iterator<UIComponent> tableColumns = table.columns();
        if (footer != null || columnFacetPresent) {
            writer.startElement("tfoot", (UIComponent)table);
            String footerClass = (String)table.getAttributes().get("footerClass");
            if (columnFacetPresent) {
                writer.startElement("tr", (UIComponent)table);
                this.encodeStyleClass(writer, null, "dr-table-subfooter rich-table-subfooter", null, footerClass);
                this.encodeHeaderFacets(context, writer, tableColumns, "dr-table-subfootercell rich-table-subfootercell", footerClass, "footer", "td", columns);
                writer.endElement("tr");
            }
            if (footer != null) {
                this.encodeTableHeaderFacet(context, columns, writer, footer, "dr-table-footer rich-table-footer", "dr-table-footer-continue rich-table-footer-continue", "dr-table-footercell rich-table-footercell", footerClass, "td");
            }
            writer.endElement("tfoot");
        }
    }

    @Override
    public void encodeOneRow(FacesContext context, TableHolder holder) throws IOException {
        UIDataTable table = (UIDataTable)holder.getTable();
        ResponseWriter writer = context.getResponseWriter();
        Iterator<UIComponent> iter = table.columns();
        boolean first = true;
        int currentColumn = 0;
        UIComponent column = null;
        while (iter.hasNext()) {
            column = iter.next();
            if (first && !(column instanceof Row)) {
                this.encodeRowStart(context, this.getFirstRowSkinClass(), holder.getRowClass(), table, writer);
            }
            if (column instanceof Column) {
                boolean breakBefore;
                boolean bl = breakBefore = ((Column)column).isBreakBefore() || column instanceof Row;
                if (breakBefore && !first) {
                    writer.endElement("tr");
                    currentColumn = 0;
                    if (!(column instanceof Row)) {
                        holder.nextRow();
                        this.encodeRowStart(context, holder.getRowClass(), table, writer);
                    }
                }
                this.encodeCellChildren(context, column, first ? this.getFirstRowSkinClass() : null, this.getRowSkinClass(), holder.getRowClass(), this.getCellSkinClass(), holder.getColumnClass(currentColumn));
                if (column instanceof Row && iter.hasNext()) {
                    holder.nextRow();
                    this.encodeRowStart(context, holder.getRowClass(), table, writer);
                    currentColumn = -1;
                }
            } else if (column.isRendered()) {
                writer.startElement("td", (UIComponent)table);
                this.getUtils().encodeId(context, column);
                String columnClass = holder.getColumnClass(currentColumn);
                this.encodeStyleClass(writer, null, this.getCellSkinClass(), null, columnClass);
                this.renderChildren(context, column);
                writer.endElement("td");
            }
            ++currentColumn;
            first = false;
        }
        if (!first && !(column instanceof Row)) {
            writer.endElement("tr");
        }
    }

    protected void encodeRowStart(FacesContext context, String rowClass, UIDataTable table, ResponseWriter writer) throws IOException {
        this.encodeRowStart(context, this.getRowSkinClass(), rowClass, table, writer);
    }

    protected String getRowSkinClass() {
        return "dr-table-row rich-table-row";
    }

    protected String getFirstRowSkinClass() {
        return "dr-table-firstrow rich-table-firstrow";
    }

    protected String getCellSkinClass() {
        return "dr-table-cell rich-table-cell";
    }

    protected void encodeRowStart(FacesContext context, String skinClass, String rowClass, UIDataTable table, ResponseWriter writer) throws IOException {
        writer.startElement("tr", (UIComponent)table);
        this.encodeStyleClass(writer, null, skinClass, null, rowClass);
        this.encodeRowEvents(context, (UIDataAdaptor)table);
    }

    protected int getColumnsCount(UIDataTable table) {
        int count = 0;
        Integer span = (Integer)table.getAttributes().get("columns");
        if (null != span && span != Integer.MIN_VALUE) {
            count = span;
        } else {
            Iterator<UIComponent> col = table.columns();
            count = this.calculateRowColumns(col);
        }
        return count;
    }

    protected int calculateRowColumns(Iterator<UIComponent> col) {
        int count = 0;
        int currentLength = 0;
        while (col.hasNext()) {
            UIComponent column = col.next();
            if (!column.isRendered()) continue;
            if (column instanceof Row) {
                if (currentLength > count) {
                    count = currentLength;
                }
                if ((currentLength = this.calculateRowColumns(((Row)column).columns())) > count) {
                    count = currentLength;
                }
                currentLength = 0;
                continue;
            }
            if (column instanceof Column) {
                Integer colspan;
                Column tableColumn = (Column)column;
                if (tableColumn.isBreakBefore()) {
                    if (currentLength > count) {
                        count = currentLength;
                    }
                    currentLength = 0;
                }
                if (null != (colspan = (Integer)column.getAttributes().get("colspan")) && colspan != Integer.MIN_VALUE) {
                    currentLength += colspan.intValue();
                    continue;
                }
                ++currentLength;
                continue;
            }
            if (!(column instanceof UIColumn)) continue;
            ++currentLength;
        }
        if (currentLength > count) {
            count = currentLength;
        }
        return count;
    }

    public void encodeScriptIfNecessary(FacesContext context, UIDataTable component) throws IOException {
        boolean shouldRender = false;
        Iterator<UIComponent> columns = component.columns();
        while (columns.hasNext() && !shouldRender) {
            UIComponent next = columns.next();
            shouldRender = next instanceof Column && ((Column)next).isSortable();
        }
        if (shouldRender) {
            JSFunction function = new JSFunction("new RichFaces.DataTable", new Object[0]);
            function.addParameter((Object)component.getBaseClientId(context));
            ScriptOptions scriptOptions = new ScriptOptions((UIComponent)component);
            scriptOptions.addOption("sortMode", (Object)new JSFunction("new RichFaces.SortMode.Single", new Object[0]));
            function.addParameter((Object)scriptOptions);
            this.getUtils().writeScript(context, (UIComponent)component, (Object)function.toScript());
        }
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        String clientId;
        Map map = context.getExternalContext().getRequestParameterMap();
        if (SORT_FILTER_PARAMETER.equals(map.get(clientId = component.getClientId(context)))) {
            String sortColumnId = (String)map.get(SORT_FILTER_PARAMETER);
            List list = component.getChildren();
            UIDataTable table = (UIDataTable)component;
            boolean isSingleSortMode = !"multi".equals(table.getSortMode());
            for (UIComponent child : list) {
                UIInput filterValueInput;
                if (!(child instanceof org.richfaces.component.UIColumn)) continue;
                org.richfaces.component.UIColumn column = (org.richfaces.component.UIColumn)child;
                child.setId(child.getId());
                if (sortColumnId != null) {
                    if (sortColumnId.equals(child.getClientId(context))) {
                        String id = child.getId();
                        Collection<Object> sortPriority = table.getSortPriority();
                        if (isSingleSortMode) {
                            sortPriority.clear();
                        }
                        if (!sortPriority.contains(id)) {
                            sortPriority.add(id);
                        }
                        column.toggleSortOrder();
                    } else if (isSingleSortMode) {
                        column.setSortOrder(Ordering.UNSORTED);
                    }
                }
                if (null == (filterValueInput = (UIInput)child.getFacet(FILTER_INPUT_FACET_NAME))) continue;
                filterValueInput.setId(filterValueInput.getId());
                filterValueInput.decode(context);
                Object submittedValue = filterValueInput.getSubmittedValue();
                if (null == submittedValue) continue;
                column.setFilterValue(filterValueInput.getSubmittedValue().toString());
            }
            AjaxContext ajaxContext = AjaxContext.getCurrentInstance();
            ajaxContext.addRegionsFromComponent(component);
            ajaxContext.addComponentToAjaxRender(component);
            ajaxContext.addRegionsFromComponent(component);
            ajaxContext.addRenderedArea(clientId + ":tb");
            Set ajaxRenderedAreas = ajaxContext.getAjaxRenderedAreas();
            Set areasToRender = ajaxContext.getAjaxAreasToRender();
            for (String area : areasToRender) {
                if (!area.startsWith(':' + clientId) || (area = area.substring(1)).equals(clientId) || ajaxRenderedAreas.contains(area)) continue;
                ajaxContext.addRenderedArea(area);
            }
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeEnd(context, component);
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance();
        Set ajaxRenderedAreas = ajaxContext.getAjaxRenderedAreas();
        String clientId = component.getClientId(context);
        if (ajaxRenderedAreas.contains(clientId + ":tb")) {
            ajaxRenderedAreas.remove(clientId);
        }
    }

    protected void addInplaceInput(FacesContext context, UIComponent column, String buffer) throws IOException {
        String filterEvent;
        UIInput filterValueInput = (UIInput)column.getFacet(FILTER_INPUT_FACET_NAME);
        if (null == filterValueInput) {
            filterValueInput = (UIInput)context.getApplication().createComponent("javax.faces.Input");
            filterValueInput.setId(column.getId() + SORT_FILTER_PARAMETER);
            filterValueInput.setImmediate(true);
            column.getFacets().put(FILTER_INPUT_FACET_NAME, filterValueInput);
            filterValueInput.getAttributes().put("onclick", "Event.stop(event);");
            filterValueInput.getAttributes().put("styleClass", "rich-filter-input");
        }
        if (null == (filterEvent = (String)column.getAttributes().get("filterEvent")) || "".equals(filterEvent)) {
            filterEvent = "onchange";
        }
        filterValueInput.getAttributes().put(filterEvent, buffer);
        filterValueInput.setValue(column.getAttributes().get("filterValue"));
        this.getUtils().encodeBeginFormIfNessesary(context, column);
        this.renderChild(context, (UIComponent)filterValueInput);
        this.getUtils().encodeEndFormIfNessesary(context, column);
    }

    protected String buildAjaxFunction(FacesContext context, UIComponent column, boolean sortable) {
        UIComponent table = column.getParent();
        String id = table.getClientId(context);
        JSFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction((UIComponent)table, (FacesContext)context);
        Map eventOptions = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)table);
        Map parameters = (Map)eventOptions.get("parameters");
        parameters.put(id, SORT_FILTER_PARAMETER);
        if (sortable) {
            parameters.put(SORT_FILTER_PARAMETER, column.getClientId(context));
        }
        ajaxFunction.addParameter((Object)eventOptions);
        StringBuffer buffer = new StringBuffer();
        ajaxFunction.appendScript(buffer);
        return buffer.toString();
    }

    protected class RichHeaderEncodeStrategy
    implements HeaderEncodeStrategy {
        protected RichHeaderEncodeStrategy() {
        }

        public void encodeBegin(FacesContext context, ResponseWriter writer, UIComponent column, String facetName, boolean sortableColumn) throws IOException {
            org.richfaces.component.UIColumn col = (org.richfaces.component.UIColumn)column;
            String clientId = col.getClientId(context) + facetName;
            writer.writeAttribute("id", (Object)clientId, null);
            if (sortableColumn && col.isSelfSorted()) {
                writer.writeAttribute("onclick", (Object)AbstractTableRenderer.this.buildAjaxFunction(context, column, true).toString(), null);
                writer.writeAttribute("style", (Object)"cursor: pointer;", null);
            }
            writer.startElement("div", column);
            writer.writeAttribute("id", (Object)(clientId + ":sortDiv"), null);
            AjaxContext.getCurrentInstance().addRenderedArea(clientId + ":sortDiv");
            if (sortableColumn) {
                writer.startElement("span", column);
                writer.writeAttribute("class", (Object)"dr-table-sortable-header", null);
            }
        }

        public void encodeEnd(FacesContext context, ResponseWriter writer, UIComponent column, String facetName, boolean sortableColumn) throws IOException {
            org.richfaces.component.UIColumn col = (org.richfaces.component.UIColumn)column;
            if (sortableColumn) {
                String imageUrl = null;
                if (Ordering.ASCENDING.equals((Object)col.getSortOrder())) {
                    imageUrl = null != col.getSortIconAscending() ? col.getSortIconAscending() : AbstractTableRenderer.this.getResource(DataTableIconSortAsc.class.getName()).getUri(context, null);
                } else if (Ordering.DESCENDING.equals((Object)col.getSortOrder())) {
                    imageUrl = null != col.getSortIconDescending() ? col.getSortIconDescending() : AbstractTableRenderer.this.getResource(DataTableIconSortDesc.class.getName()).getUri(context, null);
                } else if (col.isSelfSorted()) {
                    imageUrl = null != col.getSortIcon() ? col.getSortIcon() : AbstractTableRenderer.this.getResource(DataTableIconSortNone.class.getName()).getUri(context, null);
                }
                if (imageUrl != null) {
                    writer.startElement("img", column);
                    writer.writeAttribute("src", (Object)imageUrl, null);
                    writer.writeAttribute("width", (Object)"15", null);
                    writer.writeAttribute("height", (Object)"15", null);
                    writer.writeAttribute("class", (Object)"dr-table-header-sort-img rich-sort-icon", null);
                    writer.endElement("img");
                }
                writer.endElement("span");
            }
            writer.endElement("div");
            if (col.getFilterMethod() == null && col.getValueExpression("filterExpression") == null && col.getValueExpression("filterBy") != null) {
                writer.startElement("div", column);
                AbstractTableRenderer.this.addInplaceInput(context, column, AbstractTableRenderer.this.buildAjaxFunction(context, column, false));
                writer.endElement("div");
            }
        }
    }

    protected class SimpleHeaderEncodeStrategy
    implements HeaderEncodeStrategy {
        protected SimpleHeaderEncodeStrategy() {
        }

        public void encodeBegin(FacesContext context, ResponseWriter writer, UIComponent column, String facetName, boolean sortableColumn) throws IOException {
        }

        public void encodeEnd(FacesContext context, ResponseWriter writer, UIComponent column, String facetName, boolean sortableColumn) throws IOException {
        }
    }
}

