/**
 * 
 */
package org.richfaces.component;

/**
 * Columns iterator that returns column in sort order.
 * 
 * @see UIExtendedDataTable#getSortedChildren()
 * @author pawelgo
 * 
 */
public class SortedColumnsIterator extends ExtendedTableColumnsIterator {

    /**
     * Creates iterator for table.
     * 
     * @param dataTable
     *            table for which iterator is created
     */
    public SortedColumnsIterator(UIExtendedDataTable dataTable) {
        super(dataTable);
        childrenIterator = dataTable.getSortedChildren().iterator();
    }

}
