package org.richfaces.ui.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.ui.component.UIInsert;

public class HtmlInsert extends UIInsert{

public final static  String COMPONENT_FAMILY = "org.richfaces.ui.Insert";

public final static  String COMPONENT_TYPE = "org.richfaces.ui.Insert";

/*
* Defines the String, inserted with this component. This attribute is alternative to "src" attribute.
*/
private  String _content = null;

/*
* Attribute defines encoding for inserted content
*/
private  String _encoding = null;

/*
* Attribute defines the alternative content that will be shown in case
component cannot read the resource defined with 'src' attribute. If "errorContent" attribute is not defined,
the component shown the actual error message in the place where the content is expected
*/
private  String _errorContent = null;

/*
* Defines a type of code
*/
private  String _highlight = null;

/*
* Defines the path to the file with source code
*/
private  String _src = null;


public HtmlInsert(){
setRendererType("org.richfaces.ui.InsertRenderer");
}

public String getContent(){
	if (this._content != null) {
		return this._content;
	}
	ValueExpression ve = getValueExpression("content");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setContent(String _content){
this._content = _content;
}

public String getEncoding(){
	if (this._encoding != null) {
		return this._encoding;
	}
	ValueExpression ve = getValueExpression("encoding");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setEncoding(String _encoding){
this._encoding = _encoding;
}

public String getErrorContent(){
	if (this._errorContent != null) {
		return this._errorContent;
	}
	ValueExpression ve = getValueExpression("errorContent");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setErrorContent(String _errorContent){
this._errorContent = _errorContent;
}

public String getHighlight(){
	if (this._highlight != null) {
		return this._highlight;
	}
	ValueExpression ve = getValueExpression("highlight");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setHighlight(String _highlight){
this._highlight = _highlight;
}

public String getSrc(){
	if (this._src != null) {
		return this._src;
	}
	ValueExpression ve = getValueExpression("src");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSrc(String _src){
this._src = _src;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[6];
state[0] = super.saveState(context);
state[1] = _content;
state[2] = _encoding;
state[3] = _errorContent;
state[4] = _highlight;
state[5] = _src;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_content = (String)states[1];;
		_encoding = (String)states[2];;
		_errorContent = (String)states[3];;
		_highlight = (String)states[4];;
		_src = (String)states[5];;
	
}

}
