/**
 * 
 */
package org.richfaces.validator;

import java.io.Serializable;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.EditableValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

/**
 * Implementation of the JSF validator to use with Bean Validation / Hibernate
 * validator
 * 
 * @author asmirnov
 * 
 */
public class FacesBeanValidator implements Validator,Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -264568176252121853L;
	public static final String BEAN_VALIDATOR_TYPE = "org.richfaces.BeanValidator";

	private ValueExpression summary = null;
	
	private String summaryString = null;
	/**
	 * @return the summary
	 */
	public String getSummary() {
		String summaryString = null;
		if(null != summary){
				summaryString = (String) summary.getValue(FacesContext.getCurrentInstance().getELContext());
		}else {
			summaryString = this.summaryString;
		}
		return summaryString;
	}
	
	/**
	 * @param summary the summary to set
	 */
	public void setSummary(ValueExpression summary) {
		this.summary = summary;
	}

	
	/**
	 * @param summary the summary to set
	 */
	public void setSummary(String summary) {
		this.summaryString = summary;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.faces.validator.Validator#validate(javax.faces.context.FacesContext,
	 *      javax.faces.component.UIComponent, java.lang.Object)
	 */
	public void validate(FacesContext context, UIComponent component,
			Object convertedValue) throws ValidatorException {
		if (component instanceof EditableValueHolder) {
			// Validate input component
			EditableValueHolder input = (EditableValueHolder) component;
			try {
				ValueExpression valueExpression = component
						.getValueExpression("value");
				if (null != valueExpression) {
					// TODO - check EL Exceptions ?
					String[] messages = BeanValidator.getInstance(context)
							.validate(context, valueExpression, convertedValue);
					if (null != messages) {
						input.setValid(false);
						// send all validation messages.
						for (String msg : messages) {
							// TODO - create Summary message ?
							context.addMessage(component.getClientId(context), new FacesMessage(
									FacesMessage.SEVERITY_ERROR, getSummary(), msg));
						}
					}
				}
			} catch (ELException e) {
				throw new FacesException(e);
			}
		}
	}
}
