/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessages;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.component.UIRichMessages;
import org.richfaces.renderkit.RichMessageBaseRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlRichMessagesRenderer
extends RichMessageBaseRenderer {
    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        Iterator<FacesMessage> messagesIter;
        UIRichMessages uiMessages = (UIRichMessages)component;
        String layout = null;
        String forIds = null;
        if (uiMessages.isGlobalOnly()) {
            forIds = "";
        }
        boolean isDisplayNone = !(messagesIter = this.getMessageIterator(context, forIds, component)).hasNext();
        String[] levels = uiMessages.getLevel().split(",");
        List<String> acceptLevels = this.creatAcceptLevels(levels);
        if (!isDisplayNone && !this.isAcceptableMessagesPresent(acceptLevels, messagesIter)) {
            isDisplayNone = true;
        }
        boolean isWroteTable = false;
        layout = (String)uiMessages.getAttributes().get("layout");
        if (layout != null && layout.equals("table")) {
            writer.startElement("table", (UIComponent)uiMessages);
            this.getUtils().writeAttribute(writer, "id", (Object)uiMessages.getClientId(context));
            this.getUtils().writeAttribute(writer, "cellpadding", (Object)"0");
            this.getUtils().writeAttribute(writer, "cellspacing", (Object)"0");
            this.renderComponentOuterStyles((UIComponent)uiMessages, context, writer, isDisplayNone);
            writer.startElement("tbody", (UIComponent)uiMessages);
            isWroteTable = true;
        } else if (layout != null && layout.equals("list")) {
            isWroteTable = false;
            writer.startElement("dl", (UIComponent)uiMessages);
            this.getUtils().writeAttribute(writer, "id", (Object)uiMessages.getClientId(context));
            this.renderComponentOuterStyles((UIComponent)uiMessages, context, writer, isDisplayNone);
        }
        messagesIter = this.getMessageIterator(context, forIds, component);
        if (!messagesIter.hasNext()) {
            this.renderBody(uiMessages, context, writer, null, isWroteTable);
        } else {
            while (messagesIter.hasNext()) {
                FacesMessage facesMsg = messagesIter.next();
                if (!this.isAcceptableMessage(facesMsg, acceptLevels)) continue;
                this.renderBody(uiMessages, context, writer, facesMsg, isWroteTable);
            }
        }
        if (isWroteTable) {
            writer.endElement("tbody");
            writer.endElement("table");
        } else {
            writer.endElement("dl");
        }
    }

    @Override
    public void renderLabelHtml(UIComponent component, FacesContext context, ResponseWriter writer, FacesMessage facesMsg, String labelClass, String labelStyle, String passLabel) throws IOException {
        String summary = null;
        String detail = null;
        String title = null;
        UIRichMessages uiMessages = null;
        if (!(component instanceof UIRichMessages)) {
            return;
        }
        uiMessages = (UIRichMessages)component;
        boolean isTooltip = this.getUtils().isBooleanAttribute((UIComponent)uiMessages, "tooltip");
        boolean showSummary = uiMessages.isShowSummary();
        boolean showDetail = uiMessages.isShowDetail();
        if (facesMsg != null) {
            summary = facesMsg.getSummary();
            summary = null != summary ? summary : "";
            detail = facesMsg.getDetail();
            detail = null != detail ? detail : "";
        }
        labelClass = labelClass == null ? "rich-messages-label" : "rich-messages-label " + labelClass;
        writer.startElement("span", (UIComponent)uiMessages);
        this.getUtils().writeAttribute(writer, "class", (Object)labelClass);
        this.getUtils().writeAttribute(writer, "style", (Object)labelStyle);
        title = (String)component.getAttributes().get("title");
        if (title != null) {
            writer.writeAttribute("title", (Object)title, "title");
        }
        if (facesMsg != null) {
            boolean wroteTooltip = false;
            if (showSummary && showDetail && isTooltip) {
                if (title == null || title.length() == 0) {
                    writer.writeAttribute("title", (Object)summary, "title");
                }
                wroteTooltip = true;
            }
            if (!wroteTooltip && showSummary) {
                writer.writeText((Object)summary, component, null);
            }
            if (showDetail) {
                writer.writeText((Object)detail, component, null);
            }
        } else if (passLabel != null) {
            writer.writeText((Object)passLabel, null);
            writer.writeText((Object)"\t", null);
        }
        writer.endElement("span");
    }

    @Override
    public void renderMarkerHtml(UIComponent component, UIComponent markerFacet, FacesContext context, ResponseWriter writer, String markerClass, String markerStyle) throws IOException {
        UIRichMessages uiMessages = null;
        if (!(component instanceof UIRichMessages)) {
            return;
        }
        uiMessages = (UIRichMessages)component;
        writer.startElement("span", (UIComponent)uiMessages);
        String classes = markerClass == null ? "rich-messages-marker" : "rich-messages-marker " + markerClass;
        this.getUtils().writeAttribute(writer, "class", (Object)classes);
        this.getUtils().writeAttribute(writer, "style", (Object)markerStyle);
        this.renderChild(context, markerFacet);
        writer.endElement("span");
    }

    public void renderComponentOuterStyles(UIComponent component, FacesContext context, ResponseWriter writer, boolean isDisplayNone) throws IOException {
        UIRichMessages uiMessages = null;
        if (!(component instanceof UIRichMessages)) {
            return;
        }
        uiMessages = (UIRichMessages)component;
        String parentStyle = (String)uiMessages.getAttributes().get("style");
        String parentClass = (String)uiMessages.getAttributes().get("styleClass");
        parentStyle = (isDisplayNone ? "display: none; " : "") + parentStyle;
        String richMessageClass = "rich-messages";
        parentClass = parentClass != null ? richMessageClass + " " + parentClass : richMessageClass;
        this.getUtils().writeAttribute(writer, "class", (Object)parentClass);
        this.getUtils().writeAttribute(writer, "style", (Object)parentStyle);
    }

    @Override
    public void renderOuterStyles(UIComponent component, FacesContext context, ResponseWriter writer, String outerStyle, String outerClass) throws IOException {
        String richMessageClass = null != outerClass ? outerClass : "";
        String richMessageStyle = null != outerStyle ? outerStyle : "";
        this.getUtils().writeAttribute(writer, "class", (Object)richMessageClass);
        this.getUtils().writeAttribute(writer, "style", (Object)richMessageStyle);
    }

    public void renderBody(UIRichMessages uiMessages, FacesContext context, ResponseWriter writer, FacesMessage facesMsg, boolean isWroteTable) throws IOException {
        if (uiMessages.isPassed() || facesMsg != null) {
            if (isWroteTable) {
                writer.startElement("tr", (UIComponent)uiMessages);
                writer.startElement("td", (UIComponent)uiMessages);
            } else {
                writer.startElement("dt", (UIComponent)uiMessages);
            }
            this.outerStyles((UIComponent)uiMessages, context, writer, facesMsg);
            this.renderMarkerFacet((UIComponent)uiMessages, context, writer, facesMsg);
            this.renderLabel((UIComponent)uiMessages, context, writer, facesMsg);
            if (isWroteTable) {
                writer.endElement("td");
                writer.endElement("tr");
            } else {
                writer.endElement("dt");
            }
        }
    }

    protected Class<? extends UIComponent> getComponentClass() {
        return UIMessages.class;
    }
}

