/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import org.richfaces.validator.BeanValidator;
import org.richfaces.validator.FacesBeanValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIGraphValidator
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "org.richfaces.GraphValidator";
    public static final String COMPONENT_FAMILY = "org.richfaces.GraphValidator";

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public abstract String getSummary();

    public abstract void setSummary(String var1);

    public abstract Set<String> getProfile();

    public abstract void setProfile(Set<String> var1);

    public void processUpdates(FacesContext context) {
        BeanValidator beanValidator;
        String[] messages;
        super.processUpdates(context);
        Object value = this.getValue();
        if (null != value && null != (messages = (beanValidator = BeanValidator.getInstance(context)).validateGraph(context, value, this.getProfile()))) {
            context.renderResponse();
            for (String msg : messages) {
                String summary = null != this.getSummary() ? this.getSummary() + msg : msg;
                context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, msg));
            }
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        FacesBeanValidator validator = (FacesBeanValidator)context.getApplication().createValidator("org.richfaces.BeanValidator");
        validator.setSummary(this.getSummary());
        this.setupValidators((UIComponent)this, validator);
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (this.isRendered()) {
            for (UIComponent child : this.getChildren()) {
                if (!child.isRendered()) continue;
                child.encodeAll(context);
            }
        }
    }

    private void setupValidators(UIComponent component, Validator validator) {
        Iterator facetsAndChildren = component.getFacetsAndChildren();
        while (facetsAndChildren.hasNext()) {
            UIComponent child = (UIComponent)facetsAndChildren.next();
            if (child instanceof EditableValueHolder) {
                EditableValueHolder input = (EditableValueHolder)child;
                this.setupValidator(input, validator);
            }
            this.setupValidators(child, validator);
        }
    }

    private void setupValidator(EditableValueHolder input, Validator validator) {
        Validator[] validators = input.getValidators();
        for (int i = 0; i < validators.length; ++i) {
            if (!(validators[i] instanceof FacesBeanValidator)) continue;
            return;
        }
        input.addValidator(validator);
    }

    public boolean getRendersChildren() {
        return true;
    }
}

