/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.RendererBase;
import org.richfaces.component.Draggable;
import org.richfaces.component.Dropzone;
import org.richfaces.component.UITree;
import org.richfaces.component.UITreeNode;
import org.richfaces.component.state.TreeState;
import org.richfaces.component.state.events.CollapseNodeCommandEvent;
import org.richfaces.component.state.events.ExpandNodeCommandEvent;
import org.richfaces.component.util.ViewUtil;
import org.richfaces.event.AjaxExpandedEvent;
import org.richfaces.event.AjaxSelectedEvent;
import org.richfaces.event.NodeExpandedEvent;
import org.richfaces.event.NodeSelectedEvent;
import org.richfaces.model.TreeRowKey;
import org.richfaces.renderkit.CompositeRenderer;
import org.richfaces.renderkit.DnDParametersEncoder;
import org.richfaces.renderkit.DraggableRendererContributor;
import org.richfaces.renderkit.DropzoneRendererContributor;
import org.richfaces.renderkit.ScriptOptions;

public abstract class NodeRendererBase
extends CompositeRenderer {
    protected static final String NODE_EXPANDED_INPUT_SUFFIX = "NodeExpanded";
    protected static final String AJAX_EXPANDED_SUFFIX = "AjaxExpanded";

    public NodeRendererBase() {
        this.addContributor(DropzoneRendererContributor.getInstance());
        this.addContributor(DraggableRendererContributor.getInstance());
        this.addParameterEncoder(DnDParametersEncoder.getInstance());
    }

    protected String getToggleScript(FacesContext context, UITreeNode treeNode, String to) {
        UITree tree = treeNode.getUITree();
        if ("handle".equals(to) && tree.isToggleOnClick() || "mainRow".equals(to) && !tree.isToggleOnClick()) {
            return "";
        }
        boolean showLines = tree.isShowConnectingLines();
        String id = treeNode.getClientId(context);
        StringBuilder script = new StringBuilder();
        script.append("Tree.");
        boolean expanded = tree.isExpanded();
        if (expanded) {
            script.append("fireCollapsionEvent(this);");
        } else {
            script.append("fireExpansionEvent(this);");
        }
        if ("ajax".equals(tree.getSwitchType())) {
            UITreeNode nodeFacet = tree.getNodeFacet();
            JSFunction function = AjaxRendererUtils.buildAjaxFunction((UIComponent)nodeFacet, (FacesContext)context);
            Map eventOptions = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)nodeFacet);
            Map parameters = (Map)eventOptions.get("parameters");
            parameters.remove(id);
            parameters.put(id + NODE_EXPANDED_INPUT_SUFFIX, String.valueOf(!expanded));
            parameters.put(id + AJAX_EXPANDED_SUFFIX, Boolean.TRUE);
            function.addParameter((Object)eventOptions);
            StringBuffer buffer = new StringBuffer();
            buffer.append((CharSequence)script);
            buffer.append(";");
            function.appendScript(buffer);
            buffer.append(";");
            return buffer.toString();
        }
        if ("server".equals(tree.getSwitchType())) {
            String paramName = id + NODE_EXPANDED_INPUT_SUFFIX;
            StringBuffer result = new StringBuffer();
            result.append((CharSequence)script);
            result.append(";");
            result.append('{');
            result.append("var form = A4J.findForm(this);");
            result.append("var params = new Object();");
            result.append("params['");
            result.append(paramName);
            result.append("'] = ");
            result.append(!expanded);
            result.append(';');
            result.append("Richfaces.jsFormSubmit('");
            result.append(id);
            result.append("', ");
            result.append("form.id, ");
            result.append("'', ");
            result.append("params);};");
            return result.toString();
        }
        return "";
    }

    public void initializeLines(FacesContext context, UITreeNode treeNode) throws IOException {
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)treeNode);
        UITree tree = treeNode.getUITree();
        if (tree.isShowConnectingLines()) {
            if (Boolean.TRUE.equals(treeNode.getAttributes().get("isLastElement"))) {
                variables.setVariable("line", (Object)"dr-tree-h-ic-line-last");
            } else {
                variables.setVariable("line", (Object)"dr-tree-h-ic-line-node");
            }
            if (tree.isExpanded() && !tree.isLeaf()) {
                variables.setVariable("lineFirst", (Object)"dr-tree-h-ic-line-exp");
            } else {
                variables.setVariable("lineFirst", (Object)"dr-tree-h-ic-line-clp");
            }
        }
    }

    public void initializeResources(FacesContext context, UITreeNode treeNode) throws IOException {
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)treeNode);
        UITree tree = treeNode.getUITree();
        String resource = "dr-tree-i-hl";
        resource = resource + " rich-tree-node-highlighted";
        String cssClass = tree.getHighlightedClass();
        if (cssClass != null) {
            resource = resource + " " + cssClass;
        }
        if ((cssClass = treeNode.getHighlightedClass()) != null) {
            resource = resource + " " + cssClass;
        }
        variables.setVariable("highlightedClass", (Object)resource);
        resource = "dr-tree-i-sel";
        resource = resource + " rich-tree-node-selected";
        cssClass = tree.getSelectedClass();
        if (cssClass != null) {
            resource = resource + " " + cssClass;
        }
        if ((cssClass = treeNode.getSelectedClass()) != null) {
            resource = resource + " " + cssClass;
        }
        variables.setVariable("selectedClass", (Object)resource);
        resource = ViewUtil.getResourceURL((String)treeNode.getIcon());
        if (resource == null) {
            resource = ViewUtil.getResourceURL((String)tree.getIcon());
        }
        if (resource != null) {
            variables.setVariable("folder", (Object)resource);
        }
        if ((resource = ViewUtil.getResourceURL((String)treeNode.getIconCollapsed())) == null) {
            resource = ViewUtil.getResourceURL((String)tree.getIconCollapsed());
        }
        if (resource != null) {
            variables.setVariable("collapsed", (Object)resource);
        }
        if ((resource = ViewUtil.getResourceURL((String)treeNode.getIconExpanded())) == null) {
            resource = ViewUtil.getResourceURL((String)tree.getIconExpanded());
        }
        if (resource != null) {
            variables.setVariable("expanded", (Object)resource);
        }
        if ((resource = ViewUtil.getResourceURL((String)treeNode.getIconLeaf())) == null) {
            resource = ViewUtil.getResourceURL((String)tree.getIconLeaf());
        }
        if (resource != null) {
            variables.setVariable("leaf", (Object)resource);
        }
    }

    private String getHandleDisplayStyle(FacesContext context, UITreeNode node, boolean expandHandle) {
        if (node.getUITree().isExpanded() ^ expandHandle) {
            return "display: none;";
        }
        return "";
    }

    public String getHandleCollapsedDisplayStyle(FacesContext context, UITreeNode node) {
        return this.getHandleDisplayStyle(context, node, false);
    }

    public String getHandleExpandedDisplayStyle(FacesContext context, UITreeNode node) {
        return this.getHandleDisplayStyle(context, node, true);
    }

    public String getExpandedValue(FacesContext context, UITreeNode node) {
        return Boolean.toString(node.getUITree().isExpanded());
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        UITreeNode node = (UITreeNode)component;
        UITree tree = node.getUITree();
        TreeRowKey key = (TreeRowKey)tree.getRowKey();
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String id = node.getClientId(context);
        TreeState componentState = (TreeState)tree.getComponentState();
        String nodeExpandedId = id + NODE_EXPANDED_INPUT_SUFFIX;
        Object nodeExpandedValue = requestMap.get(nodeExpandedId);
        if (nodeExpandedValue != null) {
            boolean nodeExpanded = Boolean.valueOf(nodeExpandedValue.toString());
            if (tree.isExpanded() ^ nodeExpanded) {
                if (nodeExpanded) {
                    new ExpandNodeCommandEvent((UIComponent)tree, key).queue();
                } else {
                    new CollapseNodeCommandEvent((UIComponent)tree, key).queue();
                }
                if (Boolean.valueOf((String)requestMap.get(id + AJAX_EXPANDED_SUFFIX)).booleanValue()) {
                    new AjaxExpandedEvent((UIComponent)node).queue();
                    new AjaxExpandedEvent((UIComponent)tree).queue();
                } else {
                    new NodeExpandedEvent((UIComponent)node).queue();
                    new NodeExpandedEvent((UIComponent)tree).queue();
                }
            }
        }
        if (id.equals(tree.getAttributes().get("_selectionInput"))) {
            if (!componentState.isSelected(key)) {
                if (tree.getAttributes().get(":selectedNode") == null) {
                    new NodeSelectedEvent((UIComponent)tree, componentState.getSelectedNode()).queue();
                    new NodeSelectedEvent((UIComponent)node, componentState.getSelectedNode()).queue();
                } else {
                    new AjaxSelectedEvent((UIComponent)tree, componentState.getSelectedNode()).queue();
                    new AjaxSelectedEvent((UIComponent)node, componentState.getSelectedNode()).queue();
                }
            }
            tree.getAttributes().remove("_selectionInput");
        }
        super.doDecode(context, component);
    }

    public String getAjaxSelectedListenerFlag(FacesContext context, UITreeNode treeNode) throws IOException {
        if (treeNode.hasAjaxSubmitSelection()) {
            return "ajax_selected_listener_flag";
        }
        return null;
    }

    private void convertOptions(Map opts) {
        for (Map.Entry entry : opts.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof JSFunctionDefinition)) continue;
            JSFunctionDefinition definition = (JSFunctionDefinition)value;
            entry.setValue(definition.toScript());
        }
    }

    private ScriptOptions createOptions(FacesContext context, UITreeNode component, Class clazz) {
        TreeNodeOptions options = new TreeNodeOptions((UIComponent)component);
        this.mergeScriptOptions(options, context, (UIComponent)component, clazz);
        this.convertOptions(options.getMap());
        return options;
    }

    protected DnDOptionsHolder getScriptOptions(FacesContext context, UITreeNode component) {
        ScriptOptions dragOptions = this.createOptions(context, component, Draggable.class);
        ScriptOptions dropOptions = this.createOptions(context, component, Dropzone.class);
        return new DnDOptionsHolder(ScriptUtils.toScript((Object)dragOptions), null, ScriptUtils.toScript((Object)dropOptions), null);
    }

    protected static final class DnDOptionsHolder {
        private String dragOptions;
        private String dropOptions;
        private String dragCursorOptions;
        private String dropCursorOptions;

        public DnDOptionsHolder(String dragOptions, String dragCursorOptions, String dropOptions, String dropCursorOptions) {
            this.dragOptions = dragOptions;
            this.dragCursorOptions = dragCursorOptions;
            this.dropOptions = dropOptions;
            this.dropCursorOptions = dropCursorOptions;
        }

        public String getDragOptions() {
            return this.dragOptions;
        }

        public String getDropOptions() {
            return this.dropOptions;
        }

        public String getDragCursorOptions() {
            return this.dragCursorOptions;
        }

        public String getDropCursorOptions() {
            return this.dropCursorOptions;
        }
    }

    private static class TreeNodeOptions
    extends ScriptOptions {
        public TreeNodeOptions(UIComponent component) {
            super(component);
        }
    }
}

