package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import org.richfaces.component.UIOrderingList;

public class HtmlOrderingList extends UIOrderingList{

public final static  String COMPONENT_FAMILY = "org.richfaces.OrderingList";

public final static  String COMPONENT_TYPE = "org.richfaces.OrderingList";

/*
* Defines a label for a 'Bottom' control
*/
private  String _bottomControlLabel = null;

/*
* Defines caption representation text
*/
private  String _captionLabel = null;

/*
* CSS class for a column
*/
private  String _columnClasses = null;

/*
* Controls horizontal rendering. Possible values:
				"left" - controls should be rendered to the left side of a list.
				"right"- controls should be rendered to the right side of a list. Default value is "right".
*/
private  String _controlsHorizontalAlign = null;

/*
* Defines type of a control: button or none. Default value is "button".
*/
private  String _controlsType = null;

/*
* Controls vertical rendering. Possible values:
				"top" - controls should be rendered aligned to top side of a list.
				"bottom" - controls should be rendered aligned to bottom side of a list.
				"middle" (default) - controls should be rendered centered relatively to a list.
*/
private  String _controlsVerticalAlign = null;

/*
* Id of Converter to be used or reference to a Converter
*/
private  Converter _converter = null;

/*
* Defines a label for a 'Down' control
*/
private  String _downControlLabel = null;

/*
* If "false", 'Top' and 'Bottom' controls aren't displayed. Default value is "true".
*/
private  boolean _fastOrderControlsVisible = true;

private  boolean _fastOrderControlsVisibleSet = false;

/*
* A flag indicating that this component value must be converted
            and validated immediately (that is, during Apply Request Values
            phase), rather than waiting until a Process Validations phase
*/
private  boolean _immediate = false;

private  boolean _immediateSet = false;

/*
* Defines height of a list. Default value is "140".
*/
private  String _listHeight = null;

/*
* Defines width of a list. Default value is "140".
*/
private  String _listWidth = null;

/*
* A JavaScript event handler; a button "Bottom" is clicked
*/
private  String _onbottomclick = null;

/*
* HTML: a script expression; a pointer button is clicked
*/
private  String _onclick = null;

/*
* HTML: a script expression; a pointer button is double-clicked
*/
private  String _ondblclick = null;

/*
* A JavaScript event handler; a button "Down" is clicked
*/
private  String _ondownclick = null;

/*
* A JavaScript event handler; a header is clicked
*/
private  String _onheaderclick = null;

/*
* HTML: a script expression; a pointer is moved within
*/
private  String _onmousemove = null;

/*
* HTML: a script expression; a pointer is moved away
*/
private  String _onmouseout = null;

/*
* HTML: a script expression; a pointer is moved onto
*/
private  String _onmouseover = null;

/*
* A JavaScript event handler called on an order operation
*/
private  String _onorderchanged = null;

/*
* A JavaScript event handler; a button "Top" is clicked
*/
private  String _ontopclick = null;

/*
* HTML: a script expression; a button "Up" is clicked
*/
private  String _onupclick = null;

/*
* If "false", 'Up' and 'Down' controls aren't displayed. Default value is "true".
*/
private  boolean _orderControlsVisible = true;

private  boolean _orderControlsVisibleSet = false;

/*
* If "true", this component is checked for non-empty input
*/
private  boolean _required = false;

private  boolean _requiredSet = false;

/*
* CSS class for a row
*/
private  String _rowClasses = null;

/*
* If "true", shows a label for a button
*/
private  boolean _showButtonLabels = true;

private  boolean _showButtonLabelsSet = false;

/*
* CSS style(s) is/are to be applied when this component is rendered
*/
private  String _style = null;

/*
* Corresponds to the HTML class attribute
*/
private  String _styleClass = null;

/*
* Defines a label for a 'Top' control
*/
private  String _topControlLabel = null;

/*
* Defines a label for a 'Up' control
*/
private  String _upControlLabel = null;

/*
* valid
*/
private  boolean _valid = false;

private  boolean _validSet = false;

/*
* Listener for value changes
*/
private  MethodBinding _valueChangeListener = null;


public HtmlOrderingList(){
setRendererType("org.richfaces.OrderingListRenderer");
}

public String getBottomControlLabel(){
	if (this._bottomControlLabel != null) {
		return this._bottomControlLabel;
	}
	ValueExpression ve = getValueExpression("bottomControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setBottomControlLabel(String _bottomControlLabel){
this._bottomControlLabel = _bottomControlLabel;
}

public String getCaptionLabel(){
	if (this._captionLabel != null) {
		return this._captionLabel;
	}
	ValueExpression ve = getValueExpression("captionLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setCaptionLabel(String _captionLabel){
this._captionLabel = _captionLabel;
}

public String getColumnClasses(){
	if (this._columnClasses != null) {
		return this._columnClasses;
	}
	ValueExpression ve = getValueExpression("columnClasses");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setColumnClasses(String _columnClasses){
this._columnClasses = _columnClasses;
}

public String getControlsHorizontalAlign(){
	if (this._controlsHorizontalAlign != null) {
		return this._controlsHorizontalAlign;
	}
	ValueExpression ve = getValueExpression("controlsHorizontalAlign");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "right";
	

}

public void setControlsHorizontalAlign(String _controlsHorizontalAlign){
this._controlsHorizontalAlign = _controlsHorizontalAlign;
}

public String getControlsType(){
	if (this._controlsType != null) {
		return this._controlsType;
	}
	ValueExpression ve = getValueExpression("controlsType");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "button";
	

}

public void setControlsType(String _controlsType){
this._controlsType = _controlsType;
}

public String getControlsVerticalAlign(){
	if (this._controlsVerticalAlign != null) {
		return this._controlsVerticalAlign;
	}
	ValueExpression ve = getValueExpression("controlsVerticalAlign");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "middle";
	

}

public void setControlsVerticalAlign(String _controlsVerticalAlign){
this._controlsVerticalAlign = _controlsVerticalAlign;
}

public Converter getConverter(){
	if (this._converter != null) {
		return this._converter;
	}
	ValueExpression ve = getValueExpression("converter");
	if (ve != null) {
	    Converter value = null;
	    
	    try {
			value = (Converter) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setConverter(Converter _converter){
this._converter = _converter;
}

public String getDownControlLabel(){
	if (this._downControlLabel != null) {
		return this._downControlLabel;
	}
	ValueExpression ve = getValueExpression("downControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setDownControlLabel(String _downControlLabel){
this._downControlLabel = _downControlLabel;
}

public boolean isFastOrderControlsVisible(){
	if (this._fastOrderControlsVisibleSet) {
	    return (this._fastOrderControlsVisible);
	}
	ValueExpression ve = getValueExpression("fastOrderControlsVisible");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._fastOrderControlsVisible);
	    }
	    
	    return value;
	} else {
	    return (this._fastOrderControlsVisible);
	}

}

public void setFastOrderControlsVisible(boolean _fastOrderControlsVisible){
this._fastOrderControlsVisible = _fastOrderControlsVisible;
this._fastOrderControlsVisibleSet = true;
}

public boolean isImmediate(){
	if (this._immediateSet) {
	    return (this._immediate);
	}
	ValueExpression ve = getValueExpression("immediate");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._immediate);
	    }
	    
	    return value;
	} else {
	    return (this._immediate);
	}

}

public void setImmediate(boolean _immediate){
this._immediate = _immediate;
this._immediateSet = true;
}

public String getListHeight(){
	if (this._listHeight != null) {
		return this._listHeight;
	}
	ValueExpression ve = getValueExpression("listHeight");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "140";
	

}

public void setListHeight(String _listHeight){
this._listHeight = _listHeight;
}

public String getListWidth(){
	if (this._listWidth != null) {
		return this._listWidth;
	}
	ValueExpression ve = getValueExpression("listWidth");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "140";
	

}

public void setListWidth(String _listWidth){
this._listWidth = _listWidth;
}

public String getOnbottomclick(){
	if (this._onbottomclick != null) {
		return this._onbottomclick;
	}
	ValueExpression ve = getValueExpression("onbottomclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnbottomclick(String _onbottomclick){
this._onbottomclick = _onbottomclick;
}

public String getOnclick(){
	if (this._onclick != null) {
		return this._onclick;
	}
	ValueExpression ve = getValueExpression("onclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnclick(String _onclick){
this._onclick = _onclick;
}

public String getOndblclick(){
	if (this._ondblclick != null) {
		return this._ondblclick;
	}
	ValueExpression ve = getValueExpression("ondblclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOndblclick(String _ondblclick){
this._ondblclick = _ondblclick;
}

public String getOndownclick(){
	if (this._ondownclick != null) {
		return this._ondownclick;
	}
	ValueExpression ve = getValueExpression("ondownclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOndownclick(String _ondownclick){
this._ondownclick = _ondownclick;
}

public String getOnheaderclick(){
	if (this._onheaderclick != null) {
		return this._onheaderclick;
	}
	ValueExpression ve = getValueExpression("onheaderclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnheaderclick(String _onheaderclick){
this._onheaderclick = _onheaderclick;
}

public String getOnmousemove(){
	if (this._onmousemove != null) {
		return this._onmousemove;
	}
	ValueExpression ve = getValueExpression("onmousemove");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnmousemove(String _onmousemove){
this._onmousemove = _onmousemove;
}

public String getOnmouseout(){
	if (this._onmouseout != null) {
		return this._onmouseout;
	}
	ValueExpression ve = getValueExpression("onmouseout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnmouseout(String _onmouseout){
this._onmouseout = _onmouseout;
}

public String getOnmouseover(){
	if (this._onmouseover != null) {
		return this._onmouseover;
	}
	ValueExpression ve = getValueExpression("onmouseover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnmouseover(String _onmouseover){
this._onmouseover = _onmouseover;
}

public String getOnorderchanged(){
	if (this._onorderchanged != null) {
		return this._onorderchanged;
	}
	ValueExpression ve = getValueExpression("onorderchanged");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnorderchanged(String _onorderchanged){
this._onorderchanged = _onorderchanged;
}

public String getOntopclick(){
	if (this._ontopclick != null) {
		return this._ontopclick;
	}
	ValueExpression ve = getValueExpression("ontopclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOntopclick(String _ontopclick){
this._ontopclick = _ontopclick;
}

public String getOnupclick(){
	if (this._onupclick != null) {
		return this._onupclick;
	}
	ValueExpression ve = getValueExpression("onupclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnupclick(String _onupclick){
this._onupclick = _onupclick;
}

public boolean isOrderControlsVisible(){
	if (this._orderControlsVisibleSet) {
	    return (this._orderControlsVisible);
	}
	ValueExpression ve = getValueExpression("orderControlsVisible");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._orderControlsVisible);
	    }
	    
	    return value;
	} else {
	    return (this._orderControlsVisible);
	}

}

public void setOrderControlsVisible(boolean _orderControlsVisible){
this._orderControlsVisible = _orderControlsVisible;
this._orderControlsVisibleSet = true;
}

public boolean isRequired(){
	if (this._requiredSet) {
	    return (this._required);
	}
	ValueExpression ve = getValueExpression("required");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._required);
	    }
	    
	    return value;
	} else {
	    return (this._required);
	}

}

public void setRequired(boolean _required){
this._required = _required;
this._requiredSet = true;
}

public String getRowClasses(){
	if (this._rowClasses != null) {
		return this._rowClasses;
	}
	ValueExpression ve = getValueExpression("rowClasses");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setRowClasses(String _rowClasses){
this._rowClasses = _rowClasses;
}

public boolean isShowButtonLabels(){
	if (this._showButtonLabelsSet) {
	    return (this._showButtonLabels);
	}
	ValueExpression ve = getValueExpression("showButtonLabels");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._showButtonLabels);
	    }
	    
	    return value;
	} else {
	    return (this._showButtonLabels);
	}

}

public void setShowButtonLabels(boolean _showButtonLabels){
this._showButtonLabels = _showButtonLabels;
this._showButtonLabelsSet = true;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public String getTopControlLabel(){
	if (this._topControlLabel != null) {
		return this._topControlLabel;
	}
	ValueExpression ve = getValueExpression("topControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTopControlLabel(String _topControlLabel){
this._topControlLabel = _topControlLabel;
}

public String getUpControlLabel(){
	if (this._upControlLabel != null) {
		return this._upControlLabel;
	}
	ValueExpression ve = getValueExpression("upControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setUpControlLabel(String _upControlLabel){
this._upControlLabel = _upControlLabel;
}

public boolean isValid(){
return _valid;
}

public void setValid(boolean _valid){
this._valid = _valid;
this._validSet = true;
}

public MethodBinding getValueChangeListener(){
return _valueChangeListener;
}

public void setValueChangeListener(MethodBinding _valueChangeListener){
this._valueChangeListener = _valueChangeListener;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[40];
state[0] = super.saveState(context);
state[1] = _bottomControlLabel;
state[2] = _captionLabel;
state[3] = _columnClasses;
state[4] = _controlsHorizontalAlign;
state[5] = _controlsType;
state[6] = _controlsVerticalAlign;
state[7] = saveAttachedState(context, _converter);
state[8] = _downControlLabel;
state[9] = Boolean.valueOf(_fastOrderControlsVisible);
state[10] = Boolean.valueOf(_fastOrderControlsVisibleSet);
state[11] = Boolean.valueOf(_immediate);
state[12] = Boolean.valueOf(_immediateSet);
state[13] = _listHeight;
state[14] = _listWidth;
state[15] = _onbottomclick;
state[16] = _onclick;
state[17] = _ondblclick;
state[18] = _ondownclick;
state[19] = _onheaderclick;
state[20] = _onmousemove;
state[21] = _onmouseout;
state[22] = _onmouseover;
state[23] = _onorderchanged;
state[24] = _ontopclick;
state[25] = _onupclick;
state[26] = Boolean.valueOf(_orderControlsVisible);
state[27] = Boolean.valueOf(_orderControlsVisibleSet);
state[28] = Boolean.valueOf(_required);
state[29] = Boolean.valueOf(_requiredSet);
state[30] = _rowClasses;
state[31] = Boolean.valueOf(_showButtonLabels);
state[32] = Boolean.valueOf(_showButtonLabelsSet);
state[33] = _style;
state[34] = _styleClass;
state[35] = _topControlLabel;
state[36] = _upControlLabel;
state[37] = Boolean.valueOf(_valid);
state[38] = Boolean.valueOf(_validSet);
state[39] = saveAttachedState(context, _valueChangeListener);
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_bottomControlLabel = (String)states[1];;
		_captionLabel = (String)states[2];;
		_columnClasses = (String)states[3];;
		_controlsHorizontalAlign = (String)states[4];;
		_controlsType = (String)states[5];;
		_controlsVerticalAlign = (String)states[6];;
		_converter = (Converter)restoreAttachedState(context, states[7]);
		_downControlLabel = (String)states[8];;
		_fastOrderControlsVisible = ((Boolean)states[9]).booleanValue();
		_fastOrderControlsVisibleSet = ((Boolean)states[10]).booleanValue();
		_immediate = ((Boolean)states[11]).booleanValue();
		_immediateSet = ((Boolean)states[12]).booleanValue();
		_listHeight = (String)states[13];;
		_listWidth = (String)states[14];;
		_onbottomclick = (String)states[15];;
		_onclick = (String)states[16];;
		_ondblclick = (String)states[17];;
		_ondownclick = (String)states[18];;
		_onheaderclick = (String)states[19];;
		_onmousemove = (String)states[20];;
		_onmouseout = (String)states[21];;
		_onmouseover = (String)states[22];;
		_onorderchanged = (String)states[23];;
		_ontopclick = (String)states[24];;
		_onupclick = (String)states[25];;
		_orderControlsVisible = ((Boolean)states[26]).booleanValue();
		_orderControlsVisibleSet = ((Boolean)states[27]).booleanValue();
		_required = ((Boolean)states[28]).booleanValue();
		_requiredSet = ((Boolean)states[29]).booleanValue();
		_rowClasses = (String)states[30];;
		_showButtonLabels = ((Boolean)states[31]).booleanValue();
		_showButtonLabelsSet = ((Boolean)states[32]).booleanValue();
		_style = (String)states[33];;
		_styleClass = (String)states[34];;
		_topControlLabel = (String)states[35];;
		_upControlLabel = (String)states[36];;
		_valid = ((Boolean)states[37]).booleanValue();
		_validSet = ((Boolean)states[38]).booleanValue();
		_valueChangeListener = (MethodBinding)restoreAttachedState(context, states[39]);
	
}

}
