/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.ajax4jsf.util.SelectUtils;
import org.richfaces.component.UIDataFltrSlider;
import org.richfaces.event.DataFilterSliderEvent;

public class DataFilterSliderRendererBase
extends HeaderResourcesRendererBase {
    protected Class getComponentClass() {
        return UIDataFltrSlider.class;
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return SelectUtils.getConvertedUIInputValue((FacesContext)context, (UIInput)((UIInput)component), (String)((String)submittedValue));
    }

    public Map getRequestMap() {
        return FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap();
    }

    public String getEventHandlerFunction(UIDataFltrSlider slider, String eventName) {
        String returnScript = null;
        Object script = slider.getAttributes().get(eventName);
        if (script != null && !script.equals("")) {
            JSFunctionDefinition jsFunctionDefinition = new JSFunctionDefinition(new Object[0]);
            jsFunctionDefinition.addParameter((Object)"event");
            jsFunctionDefinition.addToBody(script);
            returnScript = jsFunctionDefinition.toScript();
        }
        return returnScript;
    }

    public String renderSliderJs1(FacesContext context, UIDataFltrSlider slider) throws IOException {
        String onchange;
        StringBuffer script = new StringBuffer();
        String clientId = slider.getClientId(context);
        script.append("var dataFilterSlider = ");
        script.append("new ");
        StringBuffer options = new StringBuffer();
        options.append("{");
        options.append("range: $R(" + slider.getStartRange() + "," + slider.getEndRange() + ")");
        options.append(",values: [" + slider.getSliderRange() + "]");
        options.append(",startSpan: '" + clientId + "slider-trailer'");
        options.append(",sliderInputId: '" + clientId + "slider_val'");
        options.append(",sliderValue:$('" + clientId + "slider_val').value");
        String onslide = this.getEventHandlerFunction(slider, "onslide");
        if (onslide != null) {
            options.append(", onslide: " + onslide);
        }
        if ((onchange = this.getEventHandlerFunction(slider, "onchange")) != null) {
            options.append(", onchange: " + onchange);
        }
        if (slider.isSubmitOnSlide()) {
            options.append(",onSlideSubmit: function(event, v) { updateSlider1(event, v);}");
        }
        options.append("}");
        JSReference reference = new JSReference(options.toString());
        JSFunction function = new JSFunction("Richfaces.DFSControl.Slider", new Object[0]);
        function.addParameter((Object)(clientId + "slider-handle"));
        function.addParameter((Object)(clientId + "slider-track"));
        function.addParameter((Object)reference);
        function.appendScript(script);
        script.append(";");
        return script.toString();
    }

    public String renderSliderJs2(FacesContext context, UIDataFltrSlider slider) throws IOException {
        String clientId = slider.getClientId(context);
        String formClientId = this._findFormClientId(context, (UIComponent)slider);
        String sliderClientId = slider.getClientId(context);
        String id = slider.getId();
        JSFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction((UIComponent)slider, (FacesContext)context);
        ajaxFunction.addParameter((Object)AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)slider));
        StringBuffer script = new StringBuffer();
        ajaxFunction.appendScript(script);
        script.append("; return false");
        String sliderHandlerScript = "function updateSlider1(event, value) {\n$('" + clientId + "slider_val').value = value;\n" + script.toString() + "}\n";
        return sliderHandlerScript;
    }

    private String _findFormClientId(FacesContext context, UIComponent component) {
        while (component != null && !(component instanceof UIForm)) {
            component = component.getParent();
        }
        return component != null ? component.getClientId(context) : null;
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        ExternalContext external = context.getExternalContext();
        Map requestParams = external.getRequestParameterMap();
        String clientId = component.getClientId(context);
        UIDataFltrSlider dataFilterSlider = (UIDataFltrSlider)component;
        Integer oldSliderVal = dataFilterSlider.getHandleValue();
        Integer newSliderVal = dataFilterSlider.getStartRange();
        if (requestParams.get(clientId + "slider_val") != null && !"".equals(requestParams.get(clientId + "slider_val"))) {
            try {
                newSliderVal = Integer.valueOf(requestParams.get(clientId + "slider_val").toString());
            }
            catch (NumberFormatException nfe) {
                newSliderVal = oldSliderVal;
            }
        }
        if (!newSliderVal.equals(oldSliderVal)) {
            dataFilterSlider.setHandleValue(newSliderVal);
            DataFilterSliderEvent event = new DataFilterSliderEvent((UIComponent)dataFilterSlider, oldSliderVal, newSliderVal);
            event.queue();
            if (dataFilterSlider.isStoreResults()) {
                dataFilterSlider.filterDataTable(newSliderVal);
            }
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        component.encodeBegin(context);
        if (component.getChildCount() > 0) {
            if (component.getRendersChildren()) {
                component.encodeChildren(context);
            }
            component.encodeEnd(context);
        }
    }

    protected boolean attributeToBoolean(UIComponent component, String attributeName) {
        Object object = component.getAttributes().get(attributeName);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return new Boolean((String)object);
        }
        return object != null && object.equals(Boolean.TRUE);
    }
}

