/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.ajax4jsf.renderkit.RendererUtils;
import org.ajax4jsf.util.SelectUtils;
import org.apache.commons.collections.CollectionUtils;
import org.richfaces.component.UIPickList;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.renderkit.OrderingComponentRendererBase;
import org.richfaces.renderkit.PickListControlsHelper;
import org.richfaces.utils.PickListUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PickListRenderer
extends HeaderResourcesRendererBase {
    private static final String HIDDEN_SUFFIX = "valueKeeper";
    protected static final OrderingComponentRendererBase.ControlsHelper[] SHUTTLE_HELPERS = PickListControlsHelper.HELPERS;
    protected static final String SHOW_LABELS_ATTRIBUTE_NAME = "showButtonsLabel";
    private static final String MESSAGE_BUNDLE_NAME = PickListRenderer.class.getPackage().getName() + ".pickList";
    private boolean isSelectedList;
    private boolean isAvailableList;

    protected List<SelectItem> selectItemsForSelectedList(FacesContext facesContext, UIComponent uiComponent, List<SelectItem> selectItemList, Converter converter, List<SelectItem> lookupList) {
        ArrayList<SelectItem> selectItemForSelectedValues = new ArrayList<SelectItem>();
        for (SelectItem value : lookupList) {
            for (SelectItem selectItem : selectItemList) {
                String itemStrValue = PickListUtils.getConvertedStringValue(facesContext, uiComponent, converter, selectItem.getValue());
                if (!value.equals(itemStrValue)) continue;
                selectItemForSelectedValues.add(selectItem);
            }
        }
        return selectItemForSelectedValues;
    }

    protected List selectItemsForAvailableList(FacesContext facesContext, UIComponent uiComponent, List<SelectItem> selectItemList, List<SelectItem> selectItemsForSelectedList, Converter converter) {
        Collection collection = CollectionUtils.subtract(selectItemList, selectItemsForSelectedList);
        return new ArrayList(collection);
    }

    protected List getSelectItemsList(FacesContext context, UIComponent component) {
        return SelectUtils.getSelectItems((FacesContext)context, (UIComponent)component);
    }

    public void decode(FacesContext context, UIComponent component) {
        UIPickList picklist = (UIPickList)component;
        if (!(picklist instanceof EditableValueHolder)) {
            throw new IllegalArgumentException("Component " + picklist.getClientId(context) + " is not an EditableValueHolder");
        }
        String hiddenClientId = picklist.getClientId(context) + HIDDEN_SUFFIX;
        Map paramValuesMap = context.getExternalContext().getRequestParameterValuesMap();
        if (picklist.isDisabled()) {
            return;
        }
        if (paramValuesMap.containsKey(hiddenClientId)) {
            String[] valuesInline = (String[])paramValuesMap.get(hiddenClientId);
            if (valuesInline[0].trim().equals("")) {
                picklist.setSubmittedValue(new String[0]);
            } else {
                String[] reqValues = valuesInline[0].split(",");
                picklist.setSubmittedValue(reqValues);
            }
        } else {
            picklist.setSubmittedValue(new String[0]);
        }
    }

    private static boolean isTrue(Object obj) {
        if (!(obj instanceof Boolean)) {
            return false;
        }
        return (Boolean)obj;
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        if (component instanceof UISelectMany && submittedValue instanceof String[]) {
            return SelectUtils.getConvertedUISelectManyValue((FacesContext)context, (UISelectMany)((UISelectMany)component), (String[])((String[])submittedValue));
        }
        if (component instanceof UISelectOne && submittedValue instanceof String) {
            return SelectUtils.getConvertedUIInputValue((FacesContext)context, (UIInput)((UISelectOne)component), (String)((String)submittedValue));
        }
        throw new ConverterException("Unsupported component class " + component.getClass().getName());
    }

    private void encodeRows(FacesContext context, UIComponent component, boolean source) throws IOException {
        List selectItemsList = SelectUtils.getSelectItems((FacesContext)context, (UIComponent)component);
        Converter converter = PickListUtils.findUISelectManyConverterFailsafe(context, component);
        List lookupList = PickListUtils.getValuesList(component, context, converter);
        List<SelectItem> selectItemsForSelectedValues = this.selectItemsForSelectedList(context, component, selectItemsList, converter, lookupList);
        List<SelectItem> selectItemsForAvailableList = this.selectItemsForAvailableList(context, component, selectItemsList, selectItemsForSelectedValues, converter);
        this.isSelectedList = !selectItemsForSelectedValues.isEmpty();
        this.isAvailableList = !selectItemsForAvailableList.isEmpty();
        List<SelectItem> selectItemList = null;
        selectItemList = source ? selectItemsForAvailableList : selectItemsForSelectedValues;
        int i = 0;
        Iterator<SelectItem> it = selectItemList.iterator();
        while (it.hasNext()) {
            ++i;
            SelectItem selectItem = it.next();
            if (selectItem instanceof SelectItemGroup) {
                SelectItem[] items = ((SelectItemGroup)selectItem).getSelectItems();
                for (int j = 0; j < items.length; ++j) {
                    this.encodeItem(context, component, converter, items[i], source, "group:" + Integer.toString(j));
                }
                continue;
            }
            this.encodeItem(context, component, converter, selectItem, source, Integer.toString(i));
        }
    }

    public void encodeItem(FacesContext context, UIComponent component, Converter converter, SelectItem selectItem, boolean source, String suff) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("tr", component);
        String clientId = component.getClientId(context);
        if (source) {
            clientId = clientId + ":source:";
        }
        String id = clientId + ":" + suff;
        writer.writeAttribute("id", (Object)id, null);
        StringBuffer rowClassName = new StringBuffer();
        StringBuffer cellClassName = new StringBuffer();
        if (source) {
            rowClassName.append("rich-picklist-source-row");
            cellClassName.append("rich-picklist-source-cell");
        } else {
            rowClassName.append("rich-picklist-target-row");
            cellClassName.append("rich-picklist-target-cell");
        }
        writer.writeAttribute("class", (Object)rowClassName.toString(), null);
        writer.startElement("td", component);
        Object width = component.getAttributes().get("width");
        writer.writeAttribute("class", (Object)cellClassName, null);
        if (width != null) {
            writer.writeAttribute("style", (Object)("width: " + HtmlUtil.qualifySize((String)width.toString())), null);
        }
        this.encodeSpacer(context, component, writer);
        boolean escape = PickListRenderer.isTrue(component.getAttributes().get("escape"));
        if (escape) {
            writer.writeText((Object)selectItem.getLabel(), null);
        } else {
            writer.write(selectItem.getLabel());
        }
        String itemValue = PickListUtils.getConvertedStringValue(context, component, converter, selectItem.getValue());
        this.encodeItemValue(context, component, writer, id, itemValue);
        writer.endElement("td");
        writer.endElement("tr");
    }

    public void encodeTargetRows(FacesContext context, UIComponent component) throws IOException {
        this.encodeRows(context, component, false);
    }

    public void encodeSourceRows(FacesContext context, UIComponent component) throws IOException {
        this.encodeRows(context, component, true);
    }

    private void encodeItemValue(FacesContext context, UIComponent component, ResponseWriter writer, String id, String itemValue) throws IOException {
        writer.startElement("input", component);
        writer.writeAttribute("type", RendererUtils.HTML.INPUT_TYPE_HIDDEN, null);
        writer.writeAttribute("name", (Object)id, null);
        StringBuffer value = new StringBuffer();
        value.append(itemValue);
        writer.writeAttribute("value", (Object)value.toString(), null);
        writer.writeAttribute("id", (Object)(id + "StateInput"), null);
        writer.endElement("input");
    }

    protected void encodeSpacer(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        writer.startElement("img", component);
        writer.writeAttribute("src", (Object)this.getResource("/org/richfaces/renderkit/html/images/spacer.gif").getUri(context, null), null);
        writer.writeAttribute("style", (Object)"width:1px;height:1px;", null);
        writer.endElement("img");
    }

    public void encodeHiddenField(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Converter converter = PickListUtils.findUISelectManyConverterFailsafe(context, component);
        List lookupList = PickListUtils.getValuesList(component, context, converter);
        this.encodeHiddenField(context, component, lookupList, writer);
    }

    private void encodeHiddenField(FacesContext context, UIComponent component, List lookupList, ResponseWriter writer) throws IOException {
        String hiddenFieldCliendId = component.getClientId(context) + HIDDEN_SUFFIX;
        writer.startElement("input", component);
        writer.writeAttribute("type", (Object)"hidden", "type");
        writer.writeAttribute("id", (Object)hiddenFieldCliendId, "id");
        writer.writeAttribute("name", (Object)hiddenFieldCliendId, null);
        StringBuffer sb = new StringBuffer();
        int n = 0;
        Iterator i = lookupList.iterator();
        while (i.hasNext()) {
            if (n > 0) {
                sb.append(",");
            }
            String value = (String)i.next();
            sb.append(value);
            ++n;
        }
        writer.writeAttribute("value", (Object)sb.toString(), null);
        writer.endElement("input");
    }

    protected Class<? extends UIComponent> getComponentClass() {
        return UIPickList.class;
    }

    public String getAsEventHandler(FacesContext context, UIComponent component, String attributeName) {
        String event = (String)component.getAttributes().get(attributeName);
        JSReference result = JSReference.NULL;
        if (event != null && (event = event.trim()).length() != 0) {
            JSFunctionDefinition function = new JSFunctionDefinition(new Object[0]);
            function.addParameter((Object)"event");
            function.addToBody((Object)event);
            result = function;
        }
        return ScriptUtils.toScript((Object)result);
    }

    public String getColumnClassesAsJSArray(FacesContext context, UIComponent component) {
        return ScriptUtils.toScript((Object)this.getClassesAsList(context, component, "columnClasses"));
    }

    public String getRowClassesAsJSArray(FacesContext context, UIComponent component) {
        return ScriptUtils.toScript((Object)this.getClassesAsList(context, component, "rowClasses"));
    }

    protected List getClassesAsList(FacesContext context, UIComponent component, String attr) {
        String value = (String)component.getAttributes().get(attr);
        if (value != null && value.length() != 0) {
            return Arrays.asList(value.split(","));
        }
        return null;
    }

    public void encodePickListControlsFacets(FacesContext context, UIComponent component) throws IOException {
        String clientId = component.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        boolean enable = false;
        for (int i = 0; i < SHUTTLE_HELPERS.length; ++i) {
            OrderingComponentRendererBase.ControlsHelper helper = SHUTTLE_HELPERS[i];
            boolean isDisabled = helper.getButtonStyleClass().equals("-disabled");
            enable = helper.getBundlePropertyName().equals("RICH_PICK_LIST_REMOVE_ALL_LABEL") ? (enable = this.isSelectedList) != isDisabled : (helper.getBundlePropertyName().equals("RICH_PICK_LIST_COPY_ALL_LABEL") ? (enable = this.isAvailableList) != isDisabled : helper.getButtonStyleClass().equals("-disabled"));
            this.encodeControlFacet(context, component, SHUTTLE_HELPERS[i], clientId, writer, enable, "rich-list-picklist-button", " rich-picklist-control");
        }
    }

    protected void encodeControlFacet(FacesContext context, UIComponent component, OrderingComponentRendererBase.ControlsHelper helper, String clientId, ResponseWriter writer, boolean enabled, String baseStyle, String baseControlStyle) throws IOException {
        this.renderDefaultControl(context, component, writer, helper, clientId, enabled, baseStyle, baseControlStyle);
    }

    protected ClassLoader getCurrentLoader(Object fallbackClass) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return loader;
    }

    protected String findLocalisedLabel(FacesContext context, String propertyId, String bundleName) {
        String label = null;
        Locale locale = null;
        String userBundleName = null;
        ResourceBundle bundle = null;
        UIViewRoot viewRoot = context.getViewRoot();
        locale = viewRoot != null ? viewRoot.getLocale() : Locale.getDefault();
        try {
            userBundleName = context.getApplication().getMessageBundle();
            if (null != userBundleName && (bundle = ResourceBundle.getBundle(userBundleName, locale, this.getCurrentLoader(userBundleName))) != null) {
                label = bundle.getString(propertyId);
            }
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (label == null && bundleName != null) {
            try {
                bundle = ResourceBundle.getBundle(bundleName, locale, this.getCurrentLoader(bundleName));
                if (bundle != null) {
                    label = bundle.getString(propertyId);
                }
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        return label;
    }

    protected void renderDefaultControl(FacesContext context, UIComponent component, ResponseWriter writer, OrderingComponentRendererBase.ControlsHelper helper, String clientId, boolean enabled, String baseStyle, String baseControlStyle) throws IOException {
        UIComponent facet = component.getFacet(helper.getFacetName());
        boolean useFacet = facet != null && facet.isRendered();
        String customEvent = null;
        Map attributes = component.getAttributes();
        if (helper.customEvent != null) {
            customEvent = (String)attributes.get(helper.customEvent);
        }
        String styleFromAttribute = (String)attributes.get(helper.styleFromAttribute);
        String baseStyleLight = baseStyle.concat("-light");
        String baseStylePress = baseStyle.concat("-press");
        String currentStyle = baseControlStyle + helper.getStyleClassName();
        if (styleFromAttribute != null) {
            currentStyle = styleFromAttribute.concat(currentStyle);
        }
        writer.startElement("div", component);
        String controlId = clientId + helper.getIdSuffix();
        writer.writeAttribute("id", (Object)controlId, null);
        writer.writeAttribute("class", (Object)currentStyle, null);
        String style = null;
        style = enabled ? "display:block;" : "display:none;";
        writer.writeAttribute("style", (Object)style, null);
        if (!useFacet) {
            writer.startElement("div", component);
            writer.writeAttribute("class", (Object)(baseStyle + helper.getButtonStyleClass()), null);
            if (helper.enable) {
                writer.writeAttribute("onmouseover", (Object)("this.className='" + baseStyleLight + "'"), null);
                writer.writeAttribute("onmousedown", (Object)("this.className='" + baseStylePress + "'"), null);
                writer.writeAttribute("onmouseup", (Object)("this.className='" + baseStyle + "'"), null);
                writer.writeAttribute("onmouseout", (Object)("this.className='" + baseStyle + "'"), null);
            }
            if (helper.enable) {
                writer.startElement("a", component);
                writer.writeAttribute("id", (Object)(controlId + "link"), null);
                writer.writeAttribute("onclick", (Object)"return false;", null);
                writer.writeAttribute("class", (Object)(baseStyle + "-selection"), null);
                writer.writeAttribute("onblur", (Object)"Richfaces.Control.onblur(this);", null);
                writer.writeAttribute("onfocus", (Object)"Richfaces.Control.onfocus(this);", null);
            }
            writer.startElement("div", component);
            writer.writeAttribute("class", (Object)(baseStyle + "-content"), null);
        }
        if (customEvent != null) {
            writer.writeAttribute("onclick", (Object)customEvent, null);
        }
        if (useFacet) {
            this.renderChild(context, facet);
        } else {
            writer.startElement("img", component);
            writer.writeAttribute("class", (Object)"rich-picklist-control-img", null);
            writer.writeAttribute("alt", (Object)helper.getFacetName(), null);
            writer.writeAttribute("src", (Object)this.getResource(helper.getImageURI()).getUri(context, null), null);
            writer.endElement("img");
            if (this.getUtils().isBooleanAttribute(component, SHOW_LABELS_ATTRIBUTE_NAME)) {
                String label = (String)attributes.get(helper.getLabelAttributeName());
                if (label == null || label.equals("")) {
                    label = this.findLocalisedLabel(context, helper.getBundlePropertyName(), MESSAGE_BUNDLE_NAME);
                }
                if (label == null || label.equals("")) {
                    label = helper.getDefaultText();
                }
                writer.write(label);
            }
        }
        if (!useFacet) {
            writer.endElement("div");
            if (helper.enable) {
                writer.endElement("a");
            }
            writer.endElement("div");
        }
        writer.endElement("div");
    }

    public void reRenderScript(FacesContext context, UIComponent component) throws IOException {
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)context);
        Set areas = ajaxContext.getAjaxRenderedAreas();
        String clientId = component.getClientId(context);
        if (ajaxContext.isAjaxRequest() && areas.contains(clientId)) {
            areas.add(clientId + "script");
        }
    }
}

