/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;


// 
// Imports
//
import java.util.Iterator;
import java.util.Collection;
import java.util.Map;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.resource.InternetResource;
//
//
//


import org.richfaces.renderkit.EffectRendererBase;



/**
 * Renderer for component class org.richfaces.renderkit.html.EffectRenderer
 */
public class EffectRenderer extends EffectRendererBase {

	public EffectRenderer () {
		super();
	}

	// 
	// Declarations
	//
	private final InternetResource[] scripts = {
						new org.ajax4jsf.javascript.PrototypeScript()
						,
				getResource("scripts/scriptaculous/effects.js")
						,
				getResource("/org/richfaces/renderkit/html/script/processEffect.js")
	};

private InternetResource[] scriptsAll = null;

protected InternetResource[] getScripts() {
	synchronized (this) {
		if (scriptsAll == null) {
			InternetResource[] rsrcs = super.getScripts();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = scripts == null || scripts.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					scriptsAll = new InternetResource[0];	
				} else {
					scriptsAll = scripts;
				}
			} else {
				if (ignoreThis) {
					scriptsAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < scripts.length; i++ ) {
						rsrcsSet.add(scripts[i]);
					}

					scriptsAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return scriptsAll;
}
	// 
	// 
	//


	private String convertToString(Object obj ) {
		return ( obj == null ? "" : obj.toString() );
	}
	private String convertToString(boolean b ) {
		return String.valueOf(b);
	}
	private String convertToString(int b ) {
		return b!=Integer.MIN_VALUE?String.valueOf(b):"";
	}
	private String convertToString(long b ) {
		return b!=Long.MIN_VALUE?String.valueOf(b):"";
	}
	
	private boolean isEmpty(Object o) {
		if (null == o) {
			return true;
		}
		if (o instanceof String ) {
			return (0 == ((String)o).length());
		}
		if (o instanceof Collection) {
			return (0 == ((Collection)o).size());
		}
		if (o instanceof Map) {
			return (0 == ((Map)o).size());
		}
		if (o.getClass().isArray()) {
			return (0 == ((Object [])o).length);
		}
		return false;
	}
	
	/**
	 * Get base component class, targetted for this renderer. Used for check arguments in decode/encode.
	 * @return
	 */
	protected Class getComponentClass() {
		return org.richfaces.component.UIEffect.class;
	}


	public void doEncodeEnd(ResponseWriter writer, FacesContext context, org.richfaces.component.UIEffect component, ComponentVariables variables) throws IOException {
	  java.lang.String clientId = component.getClientId(context);
variables.setVariable("for", component.getAttributes().get("for") );
variables.setVariable("event", component.getAttributes().get("event") );
variables.setVariable("name", component.getAttributes().get("name") );
variables.setVariable("type", component.getAttributes().get("type") );
variables.setVariable("targetId", component.getAttributes().get("targetId") );
variables.setVariable("params", convertParameters(context,component) );


	String sid = (String) variables.getVariable("for");
        variables.setVariable("attachObj","''");
	if (! "".equals(sid)) {
		UIComponent forcomp = getUtils().findComponentFor((UIComponent)component,sid);
        	if (forcomp != null) {
        		String cid= forcomp.getClientId(context);
			variables.setVariable("forPart",
			"{targetId:'"+cid+"',attachId:'"+cid+"'}");
		} else {
	 		// if no corresponded component id,  may be it is non-jsf id.
	        	// So, returning the id as is
	                variables.setVariable("forPart","{targetId:'"+sid+"',attachId:'"+sid+"'}");
	                // it might be the DOM object
		        variables.setVariable("attachObj",sid);
	       }
	} else {
           variables.setVariable("forPart","{}");
	}
	String tid = (String) variables.getVariable("targetId");
        variables.setVariable("targetObj","''");
	if (! "".equals(tid)) {
		UIComponent targetcomp = getUtils().findComponentFor(component,tid);
        	if (targetcomp != null) {
			variables.setVariable("targetPart","{targetId:'"+targetcomp.getClientId(context)+"'}");
		} else {
	 		// if no corresponded component id,  may be it is non-jsf id.
	        	// So, returning the id as is
	                variables.setVariable("targetPart","{targetId:'"+tid+"'}");
		        variables.setVariable("targetObj",tid);
	       }
	}  else {
         	variables.setVariable("targetPart","{}");
	}

	String type = (String) variables.getVariable("type");
	if (!"".equals(type)) {
		variables.setVariable("typePart","{type:'"+type+"'}");
	} else {
		variables.setVariable("typePart","{}");
	}

	String event = (String) variables.getVariable("event");
        String name = (String)variables.getVariable("name");
        Boolean needsFunction = new Boolean(! "".equals(name) && "".equals(event));
        variables.setVariable("needsFunction",needsFunction);

        Boolean needsObserver = new Boolean(! "".equals(event) && ! "".equals(sid) );
        variables.setVariable("needsObserver",needsObserver);


if ( Boolean.valueOf( String.valueOf(variables.getVariable("needsFunction")) ).booleanValue() ) {


writer.startElement("script", component);
			getUtils().writeAttribute(writer, "type", "text/javascript" );
			//
// pass thru attributes
//
getUtils().encodeAttributesFromArray(context,component,new String[] {
    "charset" ,
	    "defer" ,
	    "language" ,
	    "src" ,
	    "xml:space" });
//
//
//

writer.writeText(convertToString("//"),null);

     writer.write("<![CDATA[");
     writer.write(convertToString("\n" + convertToString(variables.getVariable("name")) + " = function () { return Richfaces.processEffect(Object.extend(Object.extend( Object.extend(" + convertToString(variables.getVariable("typePart")) + "," + convertToString(variables.getVariable("forPart")) + "), Object.extend (" + convertToString(variables.getVariable("targetPart")) + "," + convertToString(variables.getVariable("params")) + ")), arguments[0]||{})); };\n//"));
     writer.write("]]>");

writer.endElement("script");
}
if ( Boolean.valueOf( String.valueOf(variables.getVariable("needsObserver")) ).booleanValue() ) {


writer.startElement("script", component);
			getUtils().writeAttribute(writer, "type", "text/javascript" );
			//
// pass thru attributes
//
getUtils().encodeAttributesFromArray(context,component,new String[] {
    "charset" ,
	    "defer" ,
	    "language" ,
	    "src" ,
	    "xml:space" });
//
//
//

writer.writeText(convertToString("//"),null);

     writer.write("<![CDATA[");
     writer.write(convertToString("\n{\nvar pm = Object.extend( Object.extend(" + convertToString(variables.getVariable("typePart")) + "," + convertToString(variables.getVariable("forPart")) + "), " + convertToString(variables.getVariable("targetPart")) + " );\n/* pm.id can have a special meaning, let's check */\n//pm.id = " + convertToString(convertElementParameter(variables.getVariable("pmId"))) + ";\nvar attachObj;\ntry {\n	attachObj = eval('" + convertToString(escapeJavaScript(variables.getVariable("attachObj"))) + "');\n} catch (e) {\n}\n\nvar targetObj;\ntry {\n	targetObj = eval('" + convertToString(escapeJavaScript(variables.getVariable("targetObj"))) + "');\n} catch (e) {\n}\n\nif (typeof attachObj == 'object') {pm.attachId = attachObj;if (targetObj == '') pm.targetId = attachObj; };\nif (typeof targetObj == 'object') pm.targetId = targetObj;\n\npm = Object.extend(pm, " + convertToString(variables.getVariable("params")) + ");\nvar ename = Richfaces.effectEventOnOut('" + convertToString(variables.getVariable("event")) + "');\nvar bindedFunction = function(event){ return Richfaces.processEffect(this); }.bindAsEventListener(pm);\nEvent.observe(pm.attachId,ename, bindedFunction, pm.useCapture||false);\n}\n//"));
     writer.write("]]>");

writer.endElement("script");
}

	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeEnd(writer, context, (org.richfaces.component.UIEffect)component, variables );

		ComponentsVariableResolver.removeVariables(this, component);
	}		
	

}
