/**
 * 
 */
package org.richfaces.renderkit.html;

import javax.faces.component.UIComponent;

import org.richfaces.component.UIScrollableDataTable;

/**
 * @author Maksim Kaszynski
 *
 */
public class ScrollableDataTableUtils {
	
	public static final String FROZEN_COL_COUNT_ATTR = "frozenColCount";
	public static final String CLIENT_ROW_KEY = "clientIndex";
	
	public static int getFrozenColumnsCount(UIScrollableDataTable grid) {
		return getIntOr0(grid, FROZEN_COL_COUNT_ATTR);
	}
	
	public static int getClientRowIndex(UIScrollableDataTable grid) {
		return getIntOr0(grid, CLIENT_ROW_KEY);
	}
	
	public static int getIntOr0(UIComponent grid, String attribute) {
		Object value = grid.getAttributes().get(attribute);
		int i = 0;
		if (value instanceof Number) {
			i = ((Number) value).intValue();
		}
		
		return i;
	}
	
}
