/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.Serializable;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.richfaces.component.ColumnGroupingState;
import org.richfaces.component.ColumnsOrder;
import org.richfaces.component.ColumnsSizeState;
import org.richfaces.component.ColumnsVisibility;
import org.richfaces.component.UIExtendedDataTable;
import org.richfaces.model.Ordering;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedDataTableState
implements Serializable {
    private static final long serialVersionUID = -3103664821855261335L;
    public static final String TABLE_STATE_ATTR_NAME = "tableState";
    protected static final String SEP = ":";
    protected ColumnsOrder columnsOrder;
    protected ColumnsVisibility columnsVisibility;
    protected ColumnsSizeState columnsSizeState;
    protected ColumnGroupingState columnGroupingState;

    public static ExtendedDataTableState getExtendedDataTableState(UIExtendedDataTable extendedDataTable) {
        ExtendedDataTableState state = new ExtendedDataTableState();
        state.init(extendedDataTable);
        return state;
    }

    protected void init(UIExtendedDataTable extendedDataTable) {
        String value = (String)extendedDataTable.getAttributes().get(TABLE_STATE_ATTR_NAME);
        String[] values = this.fromString(value);
        String val = values != null && values.length > 0 ? values[0] : null;
        this.columnsOrder = ColumnsOrder.getColumnsOrder(extendedDataTable, val);
        val = values != null && values.length > 1 ? values[1] : null;
        this.columnsVisibility = ColumnsVisibility.getColumnsVisibility(extendedDataTable, val);
        val = values != null && values.length > 2 ? values[2] : null;
        this.columnsSizeState = ColumnsSizeState.getColumnsSize(extendedDataTable, val);
        val = values != null && values.length > 3 ? values[3] : null;
        this.columnGroupingState = ColumnGroupingState.getColumnGropingState(extendedDataTable, val);
    }

    public void publishChanges(FacesContext context, UIExtendedDataTable extendedDataTable) {
        ValueExpression ve = extendedDataTable.getValueExpression(TABLE_STATE_ATTR_NAME);
        if (null != ve && !ve.isReadOnly(context.getELContext())) {
            ve.setValue(context.getELContext(), (Object)this.toString());
        }
    }

    public String toString() {
        String[] values = new String[]{this.columnsOrder.toString(), this.columnsVisibility.toString(), this.columnsSizeState.toString(), this.columnGroupingState.toString()};
        StringBuilder builder = new StringBuilder();
        for (String str : values) {
            builder.append(str).append(SEP);
        }
        return builder.toString();
    }

    public String[] fromString(String value) {
        return value == null ? null : value.split(SEP);
    }

    public void changeColumnsOrder(String sourceColumnId, String targetColumnId, boolean dropBefore) {
        this.columnsOrder.changeOrder(sourceColumnId, targetColumnId, dropBefore);
    }

    public List<UIComponent> sortColumns(FacesContext context, List<UIComponent> children) {
        return this.columnsOrder.sortColumns(context, children);
    }

    public boolean isColumnVisible(String columnId) {
        return this.columnsVisibility.isVisible(columnId);
    }

    public void toggleColumnVisibility(UIExtendedDataTable extendedDataTable, String columnId) {
        this.columnsVisibility.toggleVisibility(extendedDataTable, columnId);
    }

    public void changeColumnSize(UIExtendedDataTable extendedDataTable, String newValue) {
        this.columnsSizeState.changeColumnSize(extendedDataTable, newValue);
    }

    public String getColumnSize(UIComponent column) {
        return this.columnsSizeState.getColumnSize(column);
    }

    public boolean isGroupingOn() {
        return this.columnGroupingState.isGroupingOn();
    }

    public String getGroupingColumnId() {
        return this.columnGroupingState.getGroupingColumnId();
    }

    public void groupBy(String colId, Ordering ordering) {
        this.columnGroupingState.groupBy(colId, ordering);
    }

    public void resetGroupVisibilityState() {
        this.columnGroupingState.resetGroupVisibilityState();
    }

    public void disableGrouping() {
        this.columnGroupingState.disableGrouping();
    }

    public boolean groupIsExpanded(int index) {
        return this.columnGroupingState.groupIsExpanded(index);
    }

    public void toggleGroup(int index) {
        this.columnGroupingState.toggleGroup(index);
    }
}

