if (!window.Richfaces) window.Richfaces = {};
tinymce.richfaces = Richfaces;
Richfaces.Editor = {};
Richfaces.Editor.REGEXP_CSS = /(\/tiny_mce\/(?:themes|plugins)\/[\w\.\\\/]*[\w\.]+\.)(c|C)[sS]{2}$/;

RichEditor = Class.create();
Object.extend(RichEditor.prototype, {
    initialize: function(id, params, tinyparams) {

    	this.id = id;
    	this.editorTextAreaId = this.id +'TextArea';
    	this.params = params;
		this.tinyparams = tinyparams;
		
		var obj = $(this.id);
		obj.component = this;
		obj.richfacesComponent="richfaces:editor";
    	this["rich:destructor"] = "destruct";
    	
    	Richfaces.Editor.extScriptSuffix = params.extScriptSuffix;
    	Richfaces.Editor.extCssSuffix = params.extCssSuffix;
    	
    	this.synchronizeConfiguration();
    	
    	this.tinyMCE_editor = null;
    	this.onInitInstanceCallbackFunction =  this.tinyparams.onInitInstanceCallback;
    	
    	this.tinyparams.mode = 'exact';
    	this.tinyparams.elements = this.editorTextAreaId;
    	this.tinyparams.editor_selector = null;
    	this.tinyparams.editor_deselector = null;
    	this.tinyparams.init_instance_callback = this.onInitInstanceCallback.bind(this);
    	
    	tinyMCE.init(this.tinyparams);
        	
        this.onBeforeAjaxListener = new A4J.AJAX.AjaxListener("onbeforeajax", this.onBeforeAjax.bind(this));
		A4J.AJAX.AddListener(this.onBeforeAjaxListener);
        
    },
    destruct: function(isAjax) { 
    	A4J.AJAX.removeListener(this.onBeforeAjaxListener);
		
		if(isAjax){
			this.tinyMCE_editor.remove();
		}
		this.onInitInstanceCallbackFunction = null;
		this.tinyMCE_editor = null;
	},
	
	onBeforeAjax: function() {
        this.tinyMCE_editor.save();
	},
	
	onInitInstanceCallback: function(inst) {		
        this.tinyMCE_editor = tinyMCE.get(this.editorTextAreaId);
        if (this.onInitInstanceCallbackFunction) this.onInitInstanceCallbackFunction.call(this, inst);
	},
	
	synchronizeConfiguration: function(){
		if(this.params.useSeamText){
			this.tinyparams.plugins = Richfaces.Editor.SeamTextConfiguration.plugins;
			this.tinyparams.convert_fonts_to_spans = false;
			this.tinyparams.inline_styles = false;
			this.tinyparams.verify_html = false;
			
			//this.tinyparams.trim_span_elements = false;
			//this.tinyparams.theme_advanced_buttons1 = Richfaces.Editor.SeamTextConfiguration.theme_advanced_buttons1;
			//this.tinyparams.theme_advanced_buttons2 = Richfaces.Editor.SeamTextConfiguration.theme_advanced_buttons2;
			//this.tinyparams.theme_advanced_buttons3 = Richfaces.Editor.SeamTextConfiguration.theme_advanced_buttons3;
			//this.tinyparams.theme_advanced_buttons4 = Richfaces.Editor.SeamTextConfiguration.theme_advanced_buttons4;
		}
	}
	
	
});

Richfaces.Editor.SeamTextConfiguration = {
	plugins : "safari,spellchecker,style,table,save,advhr,advimage,advlink,iespell,inlinepopups,insertdatetime,preview,searchreplace,print,contextmenu,paste,directionality,fullscreen,noneditable,visualchars,nonbreaking,xhtmlxtras,template"

	// Theme options
	//theme_advanced_buttons1 : "save,newdocument,|,bold,italic,underline,|,justifyleft,justifycenter,justifyright,justifyfull,|,styleselect,formatselect,|,cut,copy,paste,pastetext,pasteword",
	//theme_advanced_buttons2 : "search,replace,|,bullist,numlist,|,outdent,indent,blockquote,|,undo,redo,|,link,unlink,image,cleanup,help,code,|,insertdate,inserttime,preview,|,forecolor,backcolor",
	//theme_advanced_buttons3 : "tablecontrols,|,hr,removeformat,visualaid,|,sub,sup,|,iespell,advhr,|,print,|,ltr,rtl,|,fullscreen",
	//theme_advanced_buttons4 : "styleprops,spellchecker,|,cite,abbr,acronym,del,ins,attribs,|,visualchars,nonbreaking,template,blockquote"
}
    