/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.PrototypeScript;
import org.ajax4jsf.javascript.SmartPositionScript;
import org.ajax4jsf.renderkit.AjaxComponentRendererBase;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.RendererBase;
import org.ajax4jsf.renderkit.RendererUtils;
import org.ajax4jsf.renderkit.compiler.HtmlCompiler;
import org.ajax4jsf.renderkit.compiler.PreparedTemplate;
import org.ajax4jsf.renderkit.compiler.TemplateContext;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.TemplateCSSResource;
import org.richfaces.component.AjaxSuggestionEvent;
import org.richfaces.component.UISuggestionBox;
import org.richfaces.component.util.FormUtil;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;
import org.richfaces.util.ReferenceMap;

public class SuggestionBoxRenderer
extends AjaxComponentRendererBase {
    private static final Map<String, Pattern> tokensCache = new ReferenceMap();
    private static final String[] OPTIONS = new String[]{"popupClass", "popupStyle", "width", "height", "entryClass", "selectedClass", "param", "frequency", "minChars", "tokens", "rows", "selectValueClass", "useSuggestObjects"};
    public static final int SHADOW_DEPTH = 4;
    private InternetResource[] styles = new InternetResource[]{new TemplateCSSResource("org/richfaces/renderkit/html/css/suggestionbox.xcss")};
    private final InternetResource[] additionalScripts = new InternetResource[]{new PrototypeScript(), this.getResource("/org/richfaces/renderkit/html/scripts/jquery/jquery.js"), this.getResource("/org/richfaces/renderkit/html/scripts/available.js"), new SmartPositionScript(), this.getResource("/org/richfaces/renderkit/html/scripts/browser_info.js"), this.getResource("/org/richfaces/renderkit/html/scripts/utils.js"), this.getResource("/org/richfaces/renderkit/html/scripts/scriptaculous/effects.js"), this.getResource("scripts/suggestionbox.js")};
    private PreparedTemplate body = HtmlCompiler.compileResource((String)"org/richfaces/renderkit/html/templates/table.jspx");
    private PreparedTemplate popup = HtmlCompiler.compileResource((String)"org/richfaces/renderkit/html/templates/popup.jspx");

    protected final Class getComponentClass() {
        return UISuggestionBox.class;
    }

    public final boolean getRendersChildren() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pattern getTokensPattern(UIComponent component) {
        String tokens = (String)component.getAttributes().get("tokens");
        if (tokens != null && tokens.length() != 0) {
            Pattern pattern;
            Map<String, Pattern> map = tokensCache;
            synchronized (map) {
                pattern = tokensCache.get(tokens);
                if (pattern == null) {
                    StringBuilder patternSource = new StringBuilder();
                    char[] array = tokens.toCharArray();
                    int l = array.length;
                    for (int i = 0; i < l; ++i) {
                        if (i != 0) {
                            patternSource.append('|');
                        }
                        patternSource.append(Pattern.quote(String.valueOf(array[i])));
                    }
                    pattern = Pattern.compile(patternSource.toString());
                    tokensCache.put(tokens, pattern);
                }
            }
            return pattern;
        }
        return null;
    }

    protected final void doDecode(FacesContext context, UIComponent component) {
        String clientId = component.getClientId(context);
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String reqValue = (String)requestParameterMap.get(clientId);
        if (reqValue != null && reqValue.equals(clientId)) {
            String requestedParamName;
            String requestedValuesParam;
            UISuggestionBox suggestionBox = (UISuggestionBox)component;
            String paramName = (String)component.getAttributes().get("param");
            if (null == paramName) {
                paramName = "inputvalue";
            }
            String elementValue = (String)requestParameterMap.get(paramName);
            suggestionBox.setSubmitted(true);
            component.queueEvent((FacesEvent)new AjaxSuggestionEvent(component, elementValue));
            String[] requestedValues = null;
            if (suggestionBox.isUsingSuggestObjects() && (requestedValuesParam = (String)requestParameterMap.get(requestedParamName = paramName + "request")) != null) {
                String requestedString = requestedValuesParam.toString();
                Pattern pattern = this.getTokensPattern(component);
                requestedValues = pattern != null ? pattern.split(requestedString) : new String[]{requestedString};
            }
            suggestionBox.setSubmitedValue(elementValue, requestedValues);
        }
    }

    protected final void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        super.doEncodeBegin(writer, context, component);
        FormUtil.throwEnclFormReqExceptionIfNeed((FacesContext)context, (UIComponent)component);
    }

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        UISuggestionBox suggestionBox = (UISuggestionBox)component;
        if (!suggestionBox.isSubmitted()) {
            suggestionBox.setRowIndex(-1);
            writer.startElement("div", component);
            this.getUtils().encodeId(context, component);
            StringBuffer clazz = new StringBuffer("dr-sb-common-container rich-sb-common-container ");
            clazz.append(suggestionBox.getPopupClass() + " ").append(suggestionBox.getStyleClass());
            writer.writeAttribute("class", (Object)clazz, "popupClass");
            int zIndex = suggestionBox.getZindex();
            StringBuffer style = new StringBuffer("display:none; z-index: " + (zIndex + 1) + ";");
            style.append(this.getSizeForStyle(component, "width", null, false));
            style.append(this.getSizeForStyle(component, "height", null, false));
            style.append(suggestionBox.getPopupStyle() + ";").append(suggestionBox.getStyle() + ";");
            writer.writeAttribute("style", (Object)style, "popupStyle");
            UIComponent popupFacet = component.getFacet("popup");
            if (null == popupFacet) {
                this.popup.encode((RendererBase)this, context, component);
            } else {
                this.renderChild(context, popupFacet);
            }
            writer.endElement("div");
            writer.startElement("div", component);
            writer.writeAttribute("id", (Object)(component.getClientId(context) + "_script"), null);
            writer.writeAttribute("style", (Object)"display:none;", null);
            writer.startElement("script", component);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.writeText((Object)this.getScript(context, component), "script");
            writer.endElement("script");
            writer.endElement("div");
            writer.startElement("iframe", component);
            writer.writeAttribute("src", (Object)this.getResource("/org/richfaces/renderkit/html/images/spacer.gif").getUri(context, null), null);
            writer.writeAttribute("id", (Object)(component.getClientId(context) + "_iframe"), null);
            writer.writeAttribute("style", (Object)("position:absolute;display:none;z-index:" + zIndex + ";"), null);
            writer.endElement("iframe");
            writer.startElement("input", component);
            writer.writeAttribute("type", (Object)"hidden", null);
            writer.writeAttribute("id", (Object)(component.getClientId(context) + "_selection"), null);
            writer.writeAttribute("name", (Object)(component.getClientId(context) + "_selection"), null);
            writer.endElement("input");
        } else {
            suggestionBox.setSubmitted(false);
        }
        ((UISuggestionBox)component).setValue(null);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        UISuggestionBox suggestionBox = (UISuggestionBox)component;
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)context);
        Set ajaxRenderedAreas = ajaxContext.getAjaxRenderedAreas();
        String clientId = component.getClientId(context);
        if (suggestionBox.isSubmitted()) {
            this.body.encode(this.getTemplateContext(context, suggestionBox));
            suggestionBox.setRowIndex(-1);
            ajaxContext.removeRenderedArea(clientId);
            ajaxContext.addRenderedArea(this.getContentId(context, component));
        } else if (ajaxContext.isAjaxRequest() && ajaxRenderedAreas.contains(clientId)) {
            ajaxRenderedAreas.add(clientId + "_script");
        }
    }

    private UIComponent getTarget(UIComponent component) {
        String target = ((UISuggestionBox)component).getFor();
        if (null != target) {
            target = RendererUtils.getInstance().correctForIdReference(target, component);
            UIComponent targetComponent = RendererUtils.getInstance().findComponentFor(component, target);
            if (null != targetComponent) {
                return targetComponent;
            }
            throw new FacesException("Component for target " + target + " not found in SuggestionBox " + component.getId());
        }
        UIComponent parent = component.getParent();
        if (parent != null) {
            if (HtmlUtil.shouldWriteId((UIComponent)parent)) {
                return parent;
            }
            throw new FacesException("SuggestonBox cannot be attached to the component with id = " + parent.getId() + ", because a client identifier of the component won't be rendered onto the page. Please, set the identifier.");
        }
        throw new FacesException("Parent component is null for SuggestionBox " + component.getId());
    }

    private String getScript(FacesContext context, UIComponent component) {
        String onobjectchange;
        String onselect;
        UIComponent targetComponent = this.getTarget(component);
        String targetId = targetComponent.getClientId(context);
        Map attributes = component.getAttributes();
        StringBuffer script = new StringBuffer(" new ");
        JSFunction submitSuggest = AjaxRendererUtils.buildAjaxFunction((UIComponent)component, (FacesContext)context, (String)"RichFaces.Suggestion");
        submitSuggest.addParameter((Object)targetId);
        submitSuggest.addParameter((Object)component.getClientId(context));
        submitSuggest.addParameter(component.getAttributes().get("onsubmit"));
        Map options = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)component);
        options.put("popup", component.getClientId(context));
        for (int i = 0; i < OPTIONS.length; ++i) {
            String option = OPTIONS[i];
            Object value = attributes.get(option);
            if (null == value || "frequency".equals(option) && !((Double)value > 1.0E-9)) continue;
            options.put(option, value);
        }
        String eventsQueue = (String)options.get("eventsQueue");
        if (null == eventsQueue) {
            options.put("eventsQueue", component.getClientId(context));
        }
        if (null != (onselect = (String)attributes.get("onselect"))) {
            JSFunctionDefinition function = new JSFunctionDefinition(new Object[]{"suggestion"});
            function.addParameter((Object)"event");
            function.addToBody((Object)onselect);
            options.put("onselect", function);
        }
        if (null != (onobjectchange = (String)attributes.get("onobjectchange"))) {
            JSFunctionDefinition function = new JSFunctionDefinition(new Object[]{"suggestion", "event"});
            function.addToBody((Object)onobjectchange);
            options.put("onobjectchange", function);
        }
        if (component.getValueBinding("fetchValue") != null || attributes.get("fetchValue") != null) {
            options.put("select", attributes.get("selectValueClass"));
        }
        UISuggestionBox suggestionBox = (UISuggestionBox)component;
        options.put("usingSuggestObjects", suggestionBox.isUsingSuggestObjects());
        options.put("zindex", suggestionBox.getZindex());
        submitSuggest.addParameter((Object)options);
        script.append(submitSuggest.toScript()).append(";\n");
        return "Richfaces.onAvailable('" + targetId + "', function() {" + script.toString() + "});";
    }

    private TemplateContext getTemplateContext(FacesContext context, UIData data) {
        data.setRowIndex(-1);
        return new DataTemplateContext((RendererBase)this, context, (UIComponent)data);
    }

    public final String opacityStyle(FacesContext context, UIComponent component) {
        String filterOpacity;
        String opacity = (String)component.getAttributes().get("shadowOpacity");
        if (null == opacity) {
            Skin skin = SkinFactory.getInstance().getSkin(context);
            opacity = (String)skin.getParameter(context, "shadowOpacity");
        }
        try {
            Double op = Double.valueOf(opacity);
            filterOpacity = Integer.toString(op.intValue() * 10);
            opacity = Double.toString(op / 10.0);
        }
        catch (Exception e) {
            return ";";
        }
        return "opacity:" + opacity + "; filter:alpha(opacity=" + filterOpacity + ");";
    }

    public final String border(FacesContext context, UIComponent component) {
        String border = (String)component.getAttributes().get("border");
        String frame = (String)component.getAttributes().get("frame");
        if (null == frame) {
            frame = "box";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (null != border && Pattern.matches("\\d*", border)) {
            border = border + "px";
        }
        boolean top = false;
        boolean right = false;
        boolean bottom = false;
        boolean left = false;
        if (frame.equalsIgnoreCase("above")) {
            top = true;
        } else if (frame.equalsIgnoreCase("below")) {
            bottom = true;
        } else if (frame.equalsIgnoreCase("hsides")) {
            top = true;
            bottom = true;
        } else if (frame.equalsIgnoreCase("lhs")) {
            left = true;
        } else if (frame.equalsIgnoreCase("rhs")) {
            right = true;
        } else if (frame.equalsIgnoreCase("vsides")) {
            right = true;
            left = true;
        } else {
            top = true;
            right = true;
            bottom = true;
            left = true;
        }
        stringBuffer.append("; border-width:");
        if (top) {
            stringBuffer.append(" ").append(border).append(" ");
        } else {
            stringBuffer.append(" 0px ");
        }
        if (right) {
            stringBuffer.append(" ").append(border).append(" ");
        } else {
            stringBuffer.append(" 0px ");
        }
        if (bottom) {
            stringBuffer.append(" ").append(border).append(" ");
        } else {
            stringBuffer.append(" 0px ");
        }
        if (left) {
            stringBuffer.append(" ").append(border).append(" ");
        } else {
            stringBuffer.append(" 0px ");
        }
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    public final String bgcolor(FacesContext context, UIComponent component) {
        String bgcolor = (String)component.getAttributes().get("bgcolor");
        if (bgcolor != null) {
            return "background-color: " + bgcolor + ";";
        }
        return ";";
    }

    public final String cellPadding(FacesContext context, UIComponent component) {
        UISuggestionBox box = (UISuggestionBox)component;
        String cp = box.getCellpadding();
        if (cp != null) {
            return "padding: " + this.getUtils().encodePctOrPx(cp) + ";";
        }
        return ";";
    }

    public final String getBorder(FacesContext context, UIComponent component) {
        String border = (String)component.getAttributes().get("border");
        if (border == null || border.length() == 0) {
            return "0";
        }
        return border;
    }

    public final String getContentId(FacesContext context, UIComponent component) {
        return component.getClientId(context) + ':' + "suggest";
    }

    public final String overflowSize(FacesContext context, UIComponent component) {
        StringBuffer style = new StringBuffer();
        style.append(this.getSizeForStyle(component, "width", null, true));
        style.append(this.getSizeForStyle(component, "height", null, true));
        return style.toString();
    }

    public final String shadowDepth(FacesContext context, UIComponent component) {
        String shadow = (String)component.getAttributes().get("shadowDepth");
        if (shadow == null) {
            shadow = Integer.toString(4);
        }
        return "top: " + shadow + "px; left: " + shadow + "px; ";
    }

    protected final InternetResource[] getAdditionalScripts() {
        return this.additionalScripts;
    }

    protected final InternetResource[] getStyles() {
        return this.styles;
    }

    private String getSizeForStyle(UIComponent component, String attr, String def, boolean isShadow) {
        Map attributes = component.getAttributes();
        StringBuffer style = new StringBuffer();
        String attribute = (String)attributes.get(attr);
        if (attribute == null && def != null) {
            attribute = def;
        }
        if (attribute != null && !attribute.equals("")) {
            if (isShadow) {
                attribute = String.valueOf(Integer.parseInt(attribute) - 4);
            }
            style.append(attr).append(":").append(attribute);
            if (Pattern.matches("\\d*", attribute)) {
                style.append("px");
            }
            style.append(";");
        }
        return style.toString();
    }

    public void insertNothingLabel(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UISuggestionBox suggestionBox = (UISuggestionBox)component;
        String startHtml = "<tr id=\"" + suggestionBox.getClientId(context) + "NothingLabel\" class=\"dr-sb-int rich-sb-int " + suggestionBox.getRowClasses() + "\" style=\"display: none;\">" + "<td nowrap=\"nowrap\" class=\"dr-sb-cell-padding rich-sb-cell-padding\" style=\"" + this.cellPadding(context, component) + "\">";
        String endHtml = "</td></tr>";
        UIComponent nothingLabelFacet = component.getFacet("nothingLabel");
        if (null != nothingLabelFacet && nothingLabelFacet.isRendered()) {
            writer.write(startHtml);
            this.renderChild(context, nothingLabelFacet);
            writer.write("</td></tr>");
        } else {
            String nothingLabel = suggestionBox.getNothingLabel();
            if (null != nothingLabel && !"".equals(nothingLabel)) {
                writer.write(startHtml);
                writer.write(nothingLabel);
                writer.write("</td></tr>");
            }
        }
    }

    public final String getEntryClass(FacesContext context, UIComponent component) {
        String rowClass;
        String entryClass = (String)component.getAttributes().get("entryClass");
        if (null == entryClass) {
            entryClass = "";
        }
        if (null == (rowClass = (String)component.getAttributes().get("rowClasses"))) {
            rowClass = "";
        }
        return "dr-sb-int rich-sb-int " + entryClass + " " + rowClass;
    }

    private static class DataTemplateContext
    extends TemplateContext {
        private List columns;
        private int first;
        private int last;
        private int rows;
        private int rowCount;
        private int current;
        private String[] rowClasses = new String[0];
        private String entryClass;

        public DataTemplateContext(RendererBase renderer, FacesContext facesContext, UIComponent component) {
            super(renderer, facesContext, component);
            if (component.getFacet("header") != null) {
                this.putParameter("hasHead", Boolean.TRUE);
            }
            this.columns = new ArrayList(component.getChildCount());
            for (UIComponent column : component.getChildren()) {
                if (!(column instanceof UIColumn)) continue;
                this.columns.add(column);
                if (column.getFacet("header") != null) {
                    this.putParameter("hasHead", Boolean.TRUE);
                    this.putParameter("hasColumnHead", Boolean.TRUE);
                }
                if (column.getFacet("footer") == null) continue;
                this.putParameter("hasFooter", Boolean.TRUE);
                this.putParameter("hasColumnFooter", Boolean.TRUE);
            }
            UISuggestionBox box = (UISuggestionBox)component;
            this.first = box.getFirst();
            this.rows = box.getRows();
            this.rowCount = box.getRowCount();
            if (this.rows > 0) {
                // empty if block
            }
            this.rows = this.rowCount - this.first;
            this.last = this.first + this.rows;
            if (this.last > this.rowCount) {
                this.last = this.rowCount;
            }
            this.current = this.first;
            this.entryClass = box.getEntryClass();
            String rowClasses = box.getRowClasses();
            if (null != rowClasses && rowClasses.length() > 0) {
                this.rowClasses = rowClasses.split("\\s+");
            }
        }

        public Object getParameter(Object key) {
            if ("rows".equals(key)) {
                return new Iterator(){

                    public boolean hasNext() {
                        if (DataTemplateContext.this.current >= DataTemplateContext.this.last) {
                            return false;
                        }
                        UIData data = (UIData)DataTemplateContext.this.getComponent();
                        data.setRowIndex(DataTemplateContext.this.current);
                        return data.isRowAvailable();
                    }

                    public Object next() {
                        DataTemplateContext.this.current++;
                        return DataTemplateContext.this.getComponent();
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("remove row from UIData not supported");
                    }
                };
            }
            if ("rowClass".equals(key)) {
                StringBuffer rowClass = new StringBuffer();
                if (null != this.entryClass) {
                    rowClass.append(this.entryClass);
                    if (this.rowClasses.length > 0) {
                        rowClass.append(" ");
                    }
                }
                if (this.rowClasses.length > 0) {
                    int currentClass = (this.current - this.first - 1) % this.rowClasses.length;
                    if (currentClass < 0) {
                        currentClass = 0;
                    }
                    rowClass.append(this.rowClasses[currentClass]);
                }
                return rowClass.toString();
            }
            if ("columns".equals(key)) {
                return this.columns;
            }
            if ("columnsCount".equals(key)) {
                return new Integer(this.columns.size());
            }
            return super.getParameter(key);
        }
    }
}

