/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit;

import java.text.MessageFormat;
import java.util.Set;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.richfaces.component.Draggable;
import org.richfaces.component.Dropzone;
import org.richfaces.component.util.MessageUtil;

/**
 * @author Nick - mailto:nbelaevski@exadel.com
 * created 06.02.2007
 * 
 */
class DnDValidator {
	private final static String MESSAGE_FORMAT = "Dropzone [{0}] with accepted types {1} cannot accept Draggable [{2}] with dragType [{3}]";

	static boolean validateAcceptTypes(FacesContext context, Draggable draggable, Dropzone dropzone, String dragType, Object acceptedTypes) {
		Set<String> set = AjaxRendererUtils.asSet(acceptedTypes);
		if (set == null || !set.contains(dragType)) {
			UIComponent component = (UIComponent) dropzone;
			String text = MessageFormat.format(
					MESSAGE_FORMAT, 
					new Object[] {
							MessageUtil.getLabel(context, component), 
							set, 
							MessageUtil.getLabel(context, (UIComponent) draggable), 
							dragType});

			FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, text, text);

			context.addMessage(component.getClientId(context), message);

			context.renderResponse();
		
			return false;
		}
		
		return true;
	}
}
