/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.model.DataModel;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.event.AjaxEvent;
import org.ajax4jsf.model.ExtendedDataModel;
import org.apache.commons.collections.iterators.IteratorChain;
import org.richfaces.component.Column;
import org.richfaces.component.ExtendedDataTableState;
import org.richfaces.component.ExtendedTableColumnsIterator;
import org.richfaces.component.Filterable;
import org.richfaces.component.Selectable;
import org.richfaces.component.Sortable2;
import org.richfaces.component.SortedColumnsIterator;
import org.richfaces.component.UIColumn;
import org.richfaces.component.UIDataTable;
import org.richfaces.event.extdt.ChangeColumnVisibilityEvent;
import org.richfaces.event.extdt.ColumnResizeEvent;
import org.richfaces.event.extdt.DragDropEvent;
import org.richfaces.event.extdt.ExtTableFilterEvent;
import org.richfaces.event.extdt.ExtTableSortEvent;
import org.richfaces.model.ExtendedTableDataModel;
import org.richfaces.model.ExtendedTableDataModifiableModel;
import org.richfaces.model.FilterField;
import org.richfaces.model.Modifiable;
import org.richfaces.model.ModifiableModel;
import org.richfaces.model.Ordering;
import org.richfaces.model.SortField2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIExtendedDataTable
extends UIDataTable
implements Selectable,
Filterable,
Sortable2 {
    public static final String COMPONENT_TYPE = "org.richfaces.ExtendedDataTable";
    public static final String COMPONENT_FAMILY = "org.richfaces.ExtendedDataTable";
    protected ExtendedDataTableState state;

    public abstract Object getActiveRowKey();

    public abstract void setActiveRowKey(Object var1);

    public abstract String getGroupingColumn();

    public abstract void setGroupingColumn(String var1);

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof AjaxEvent) {
            AjaxContext.getCurrentInstance().addComponentToAjaxRender((UIComponent)this);
        } else if (event instanceof DragDropEvent) {
            this.processDradDrop((DragDropEvent)event);
        } else if (event instanceof ChangeColumnVisibilityEvent) {
            this.processChangeColumnVisibility((ChangeColumnVisibilityEvent)event);
        } else if (event instanceof ColumnResizeEvent) {
            this.processColumnResize((ColumnResizeEvent)event);
        } else if (event instanceof ExtTableSortEvent) {
            this.processSortingChange((ExtTableSortEvent)event);
        } else if (event instanceof ExtTableFilterEvent) {
            this.processFilteringChange((ExtTableFilterEvent)event);
        }
    }

    public void queueEvent(FacesEvent event) {
        if (event.getSource() instanceof UIExtendedDataTable) {
            if (event instanceof AjaxEvent) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else if (event instanceof DragDropEvent) {
                new AjaxEvent((UIComponent)this).queue();
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else if (event instanceof ChangeColumnVisibilityEvent) {
                new AjaxEvent((UIComponent)this).queue();
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else if (event instanceof ColumnResizeEvent) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else if (event instanceof ExtTableSortEvent) {
                new AjaxEvent((UIComponent)this).queue();
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            } else if (event instanceof ExtTableFilterEvent) {
                new AjaxEvent((UIComponent)this).queue();
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
        super.queueEvent(event);
    }

    public Iterator<UIColumn> getSortedColumns() {
        return new SortedColumnsIterator(this);
    }

    public Iterator<UIColumn> getChildColumns() {
        return new ExtendedTableColumnsIterator(this);
    }

    public void processDradDrop(DragDropEvent event) {
        String dragValue = event.getDragValue().toString();
        String dropValue = event.getDropValue().toString();
        this.ensureTableStateInitialized();
        this.state.changeColumnsOrder(dragValue, dropValue, event.isDropBefore());
        this.state.publishChanges(this.getFacesContext(), this);
        this.getFacesContext().renderResponse();
    }

    public List<UIComponent> getSortedChildren() {
        this.ensureTableStateInitialized();
        return this.state.sortColumns(this.getFacesContext(), super.getChildren());
    }

    public void ensureTableStateInitialized() {
        if (this.state == null) {
            this.state = ExtendedDataTableState.getExtendedDataTableState(this);
        }
    }

    public void processChangeColumnVisibility(ChangeColumnVisibilityEvent event) {
        this.ensureTableStateInitialized();
        this.state.toggleColumnVisibility(this, event.getColumnId());
        this.state.publishChanges(this.getFacesContext(), this);
        this.getFacesContext().renderResponse();
    }

    public void processSortingChange(ExtTableSortEvent event) {
        DataModel dataModel = this.getDataModel();
        if (dataModel instanceof ExtendedTableDataModifiableModel) {
            ((ExtendedTableDataModifiableModel)dataModel).resetSort();
        } else {
            super.resetDataModel();
        }
        this.getFacesContext().renderResponse();
    }

    public void processFilteringChange(ExtTableFilterEvent event) {
        DataModel dataModel = this.getDataModel();
        if (dataModel instanceof ExtendedTableDataModifiableModel) {
            ((ExtendedTableDataModifiableModel)dataModel).resetFilter();
        } else {
            super.resetDataModel();
        }
        this.resetGroupVisibilityState();
        this.getFacesContext().renderResponse();
    }

    public boolean isColumnVisible(UIComponent column) {
        this.ensureTableStateInitialized();
        return this.state.isColumnVisible(column.getId());
    }

    public void processColumnResize(ColumnResizeEvent event) {
        this.ensureTableStateInitialized();
        this.state.changeColumnSize(this, event.getColumnWidths());
        this.state.publishChanges(this.getFacesContext(), this);
        this.getFacesContext().renderResponse();
    }

    public String getColumnSize(UIComponent column) {
        this.ensureTableStateInitialized();
        return this.state.getColumnSize(column);
    }

    public boolean isGroupingOn() {
        String groupingColumnId = this.getGroupByColumnId();
        return groupingColumnId != null && !"".equals(groupingColumnId) && !"none".equals(groupingColumnId);
    }

    public String getGroupByColumnId() {
        this.ensureTableStateInitialized();
        String id = this.state.getGroupingColumnId();
        if (id == null) {
            id = this.getGroupingColumn();
        }
        return id;
    }

    public UIColumn getGroupByColumn() {
        if (!this.isGroupingOn()) {
            return null;
        }
        String groupingColumnId = this.getGroupByColumnId();
        Iterator<UIColumn> columns = this.getChildColumns();
        while (columns.hasNext()) {
            UIColumn child = columns.next();
            if (!groupingColumnId.equalsIgnoreCase(child.getId())) continue;
            return child;
        }
        return null;
    }

    public void setGroupByColumn(UIColumn column) {
        this.ensureTableStateInitialized();
        if (column == null) {
            this.state.disableGrouping();
        } else {
            this.state.groupBy(column.getId(), column.getSortOrder());
        }
        this.state.publishChanges(this.getFacesContext(), this);
    }

    protected void resetGroupVisibilityState() {
        this.ensureTableStateInitialized();
        this.state.resetGroupVisibilityState();
    }

    public void disableGrouping() {
        this.ensureTableStateInitialized();
        this.state.disableGrouping();
        this.state.publishChanges(this.getFacesContext(), this);
    }

    public boolean groupIsExpanded(int index) {
        this.ensureTableStateInitialized();
        return this.state.groupIsExpanded(index);
    }

    public void toggleGroup(int index) {
        this.ensureTableStateInitialized();
        this.state.toggleGroup(index);
        this.state.publishChanges(this.getFacesContext(), this);
    }

    protected Collection<Object> getGroupPriority() {
        Collection<Object> priority = this.getSortPriority();
        if (this.isGroupingOn()) {
            String groupColId;
            UIColumn column = this.getGroupByColumn();
            if (column.getSortOrder() == null || column.getSortOrder().equals((Object)Ordering.UNSORTED)) {
                column.setSortOrder(Ordering.ASCENDING);
            }
            if (priority.contains(groupColId = column.getId())) {
                priority.remove(groupColId);
            }
            if (priority instanceof List) {
                ((List)priority).add(0, groupColId);
            } else {
                priority.add(groupColId);
            }
        }
        return priority;
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.state};
        return values;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.state = (ExtendedDataTableState)values[1];
    }

    public int getVisibleColumnsCount() {
        int count = 0;
        Iterator<UIColumn> iter = this.getChildColumns();
        while (iter.hasNext()) {
            UIColumn column = iter.next();
            if (!column.isRendered()) continue;
            ++count;
        }
        return count;
    }

    @Override
    protected ExtendedDataModel createDataModel() {
        SortField2 sortField;
        LinkedList<FilterField> filterFields = new LinkedList<FilterField>();
        LinkedHashMap<String, SortField2> sortFieldsMap = new LinkedHashMap<String, SortField2>();
        Collection<Object> sortPriority = this.getGroupPriority();
        List list = this.getChildren();
        for (UIComponent component : list) {
            if (!(component instanceof UIColumn)) continue;
            UIColumn column = (UIColumn)component;
            FilterField filterField = column.getFilterField();
            if (filterField != null) {
                filterFields.add(filterField);
            }
            if ((sortField = column.getSortField()) == null) continue;
            sortFieldsMap.put(component.getId(), sortField);
        }
        LinkedList<Object> sortFields = new LinkedList<Object>();
        if (sortPriority != null) {
            for (Object object : sortPriority) {
                String id;
                if (!(object instanceof String) || (sortField = (SortField2)sortFieldsMap.get(id = (String)object)) == null) continue;
                sortFields.add(sortField);
                sortFieldsMap.remove(id);
            }
        }
        sortFields.addAll(sortFieldsMap.values());
        this.setFilterFields(filterFields);
        this.setSortFields(sortFields);
        ExtendedDataModel dataModel = (ExtendedDataModel)this.getDataModel();
        if (dataModel instanceof ExtendedTableDataModifiableModel) {
            ((ExtendedTableDataModifiableModel)dataModel).setVar(this.getVar());
        }
        if (filterFields != null && !filterFields.isEmpty() || sortFields != null && !sortFields.isEmpty()) {
            Modifiable modifiable = null;
            if (dataModel instanceof Modifiable) {
                modifiable = (Modifiable)dataModel;
            } else if (dataModel instanceof ExtendedTableDataModel) {
                ExtendedTableDataModel tableDataModel = (ExtendedTableDataModel)dataModel;
                ExtendedTableDataModifiableModel modifiableModel = new ExtendedTableDataModifiableModel(tableDataModel, this.getVar());
                dataModel = modifiableModel;
                modifiable = modifiableModel;
            } else {
                ModifiableModel modifiableModel = new ModifiableModel(dataModel, this.getVar());
                dataModel = modifiableModel;
                modifiable = modifiableModel;
            }
            modifiable.modify(filterFields, sortFields);
        }
        return dataModel;
    }

    protected void resetDataModel() {
        if (!(this.getDataModel() instanceof ExtendedTableDataModel)) {
            super.resetDataModel();
        }
    }

    @Override
    public Iterator<UIComponent> fixedChildren() {
        IteratorChain chain = new IteratorChain(this.getFacets().values().iterator());
        for (UIComponent kid : this.getChildren()) {
            if (!(kid instanceof Column) && !(kid instanceof UIColumn)) continue;
            chain.addIterator(kid.getFacets().values().iterator());
        }
        return chain;
    }
}

