/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;


// 
// Imports
//
import java.util.Iterator;
import java.util.Collection;
import java.util.Map;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.ComponentVariables;
//
//
//


import org.richfaces.renderkit.TabHeaderRendererBase;



/**
 * Renderer for component class org.richfaces.renderkit.html.TabHeaderRenderer
 */
public class TabHeaderRenderer extends TabHeaderRendererBase {

	public TabHeaderRenderer () {
		super();
	}

	// 
	// Declarations
	//
	// 
	// 
	//


	private String convertToString(Object obj ) {
		return ( obj == null ? "" : obj.toString() );
	}
	private String convertToString(boolean b ) {
		return String.valueOf(b);
	}
	private String convertToString(int b ) {
		return b!=Integer.MIN_VALUE?String.valueOf(b):"";
	}
	private String convertToString(long b ) {
		return b!=Long.MIN_VALUE?String.valueOf(b):"";
	}
	
	private boolean isEmpty(Object o) {
		if (null == o) {
			return true;
		}
		if (o instanceof String ) {
			return (0 == ((String)o).length());
		}
		if (o instanceof Collection) {
			return (0 == ((Collection)o).size());
		}
		if (o instanceof Map) {
			return (0 == ((Map)o).size());
		}
		if (o.getClass().isArray()) {
			return (0 == ((Object [])o).length);
		}
		return false;
	}
	
	/**
	 * Get base component class, targetted for this renderer. Used for check arguments in decode/encode.
	 * @return
	 */
	protected Class getComponentClass() {
		return org.richfaces.component.UITab.class;
	}


	public void doEncodeEnd(ResponseWriter writer, FacesContext context, org.richfaces.component.UITab component, ComponentVariables variables) throws IOException {
	  java.lang.String clientId = component.getClientId(context);
variables.setVariable("spacer", getResource( "images/spacer.gif" ).getUri(context, component) );

writer.startElement("td", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + "_cell" );
						getUtils().writeAttribute(writer, "style", "height: 100%; vertical-align: bottom;" );
			
encodeCellClasses(context, component);

writer.startElement("table", component);
			getUtils().writeAttribute(writer, "border", "0" );
						getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "_shifted" );
			
encodeTabLabel(context, component);

writer.startElement("tr", component);

writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "dr-tbpnl-tbbrdr rich-tabhdr-side-border" );
			
writer.startElement("img", component);
			getUtils().writeAttribute(writer, "alt", " " );
						getUtils().writeAttribute(writer, "height", "1" );
						getUtils().writeAttribute(writer, "src", variables.getVariable("spacer") );
						getUtils().writeAttribute(writer, "style", "border:0" );
						getUtils().writeAttribute(writer, "width", "1" );
			
writer.endElement("img");
writer.endElement("td");
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "dr-tbpnl-tbtopbrdr rich-tabhdr-side-cell" );
						getUtils().writeAttribute(writer, "style", encodeTabLabelWidth(context,component) );
			
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "border", "0" );
						getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "style", "height: 100%; width: 100%;" );
			
writer.startElement("tr", component);

writer.startElement("td", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + "_lbl" );
						getUtils().writeAttribute(writer, "onclick", component.getAttributes().get("onlabelclick") );
						getUtils().writeAttribute(writer, "ondblclick", component.getAttributes().get("onlabeldblclick") );
						getUtils().writeAttribute(writer, "onkeydown", component.getAttributes().get("onlabelkeydown") );
						getUtils().writeAttribute(writer, "onkeypress", component.getAttributes().get("onlabelkeypress") );
						getUtils().writeAttribute(writer, "onkeyup", component.getAttributes().get("onlabelkeyup") );
						getUtils().writeAttribute(writer, "onmousedown", component.getAttributes().get("onlabelmousedown") );
						getUtils().writeAttribute(writer, "onmousemove", component.getAttributes().get("onlabelmousemove") );
						getUtils().writeAttribute(writer, "onmouseup", component.getAttributes().get("onlabelmouseup") );
			
writeLabel(context, component);

writer.endElement("td");
writer.endElement("tr");
writer.endElement("table");
writer.endElement("td");
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "dr-tbpnl-tbbrdr rich-tabhdr-side-border" );
			
writer.startElement("img", component);
			getUtils().writeAttribute(writer, "alt", " " );
						getUtils().writeAttribute(writer, "height", "1" );
						getUtils().writeAttribute(writer, "src", variables.getVariable("spacer") );
						getUtils().writeAttribute(writer, "style", "border:0" );
						getUtils().writeAttribute(writer, "width", "1" );
			
writer.endElement("img");
writer.endElement("td");
writer.endElement("tr");
writer.endElement("table");
writer.endElement("td");
writer.startElement("td", component);

writer.startElement("img", component);
			getUtils().writeAttribute(writer, "alt", " " );
						getUtils().writeAttribute(writer, "height", "1" );
						getUtils().writeAttribute(writer, "src", variables.getVariable("spacer") );
						getUtils().writeAttribute(writer, "style", convertToString(encodeHeaderSpacing(context,component)) + ";border:0" );
			
writer.endElement("img");
writer.endElement("td");

	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeEnd(writer, context, (org.richfaces.component.UITab)component, variables );

		ComponentsVariableResolver.removeVariables(this, component);
	}		
	

}
