/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.Serializable;
import java.util.Iterator;
import org.richfaces.component.UIColumn;
import org.richfaces.component.UIExtendedDataTable;
import org.richfaces.json.JSONException;
import org.richfaces.json.JSONMap;
import org.richfaces.json.JSONStringer;
import org.richfaces.json.JSONWriter;

class ColumnsVisibility
implements Serializable {
    private static final long serialVersionUID = -3923409650272094713L;
    private static final String TRUE = "1";
    private static final String FALSE = "0";
    private JSONMap value;

    private ColumnsVisibility() {
    }

    static ColumnsVisibility getColumnsVisibility(UIExtendedDataTable extendedDataTable, String val) throws JSONException {
        ColumnsVisibility columnsVisibility = new ColumnsVisibility();
        columnsVisibility.init(extendedDataTable, new JSONMap(val));
        return columnsVisibility;
    }

    static ColumnsVisibility getColumnsVisibility(UIExtendedDataTable extendedDataTable, JSONMap map) {
        ColumnsVisibility columnsVisibility = new ColumnsVisibility();
        columnsVisibility.init(extendedDataTable, map);
        return columnsVisibility;
    }

    private void init(UIExtendedDataTable extendedDataTable, JSONMap map) {
        this.value = null;
        if (map != null && map.size() > 0) {
            this.value = map;
        }
        if (this.value == null) {
            this.createDefaultColumnsVisibility(extendedDataTable);
        }
        Iterator<UIColumn> iter = extendedDataTable.getChildColumns();
        while (iter.hasNext()) {
            UIColumn child = iter.next();
            if (!(child instanceof UIColumn)) continue;
            UIColumn dataColumn = child;
            dataColumn.setVisible(this.isVisible(dataColumn.getId()));
        }
    }

    public String toString() {
        if (this.value == null) {
            return "";
        }
        return this.value.toString();
    }

    public JSONMap toJSON() {
        return this.value;
    }

    private void createDefaultColumnsVisibility(UIExtendedDataTable extendedDataTable) {
        try {
            JSONWriter writer = new JSONStringer().object();
            Iterator<UIColumn> iter = extendedDataTable.getChildColumns();
            while (iter.hasNext()) {
                UIColumn col = iter.next();
                writer.key(col.getId()).value((Object)TRUE);
            }
            this.value = new JSONMap(writer.endObject().toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    boolean isVisible(String columnId) {
        if (this.value == null) {
            return true;
        }
        return TRUE.equals(this.value.get((Object)columnId));
    }

    void toggleVisibility(UIExtendedDataTable extendedDataTable, String columnId) {
        if (this.value == null) {
            return;
        }
        UIColumn column = null;
        Iterator<UIColumn> iter = extendedDataTable.getChildColumns();
        while (iter.hasNext()) {
            UIColumn col = iter.next();
            if (!col.getId().equalsIgnoreCase(columnId)) continue;
            if (!(col instanceof UIColumn)) break;
            column = col;
            break;
        }
        if (column == null) {
            return;
        }
        boolean visible = column.isVisible();
        visible = !visible;
        column.setVisible(visible);
        this.value.put((Object)columnId, (Object)(visible ? TRUE : FALSE));
    }
}

