/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.component.UIDataAdaptor;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.component.Column;
import org.richfaces.component.Row;
import org.richfaces.component.UIColumn;
import org.richfaces.component.UIDataTable;
import org.richfaces.component.UIExtendedDataTable;
import org.richfaces.component.nsutils.NSUtils;
import org.richfaces.event.extdt.ChangeColumnVisibilityEvent;
import org.richfaces.event.extdt.ColumnResizeEvent;
import org.richfaces.event.extdt.DragDropEvent;
import org.richfaces.event.extdt.ExtTableFilterEvent;
import org.richfaces.event.extdt.ExtTableSortEvent;
import org.richfaces.model.Ordering;
import org.richfaces.model.impl.expressive.JavaBeanWrapper;
import org.richfaces.model.impl.expressive.ObjectWrapperFactory;
import org.richfaces.model.impl.expressive.WrappedBeanComparator2;
import org.richfaces.renderkit.AbstractExtendedRowsRenderer;
import org.richfaces.renderkit.ExtendedTableHolder;
import org.richfaces.renderkit.HeaderEncodeStrategy;
import org.richfaces.renderkit.RendererContributor;
import org.richfaces.renderkit.ScriptOptions;
import org.richfaces.renderkit.TableHolder;
import org.richfaces.renderkit.html.HTMLEncodingContributor;
import org.richfaces.renderkit.html.RichTableMenuRenderer;
import org.richfaces.renderkit.html.TableDragDropRenderer;
import org.richfaces.renderkit.html.iconimages.DataTableIconSortNone;
import org.richfaces.renderkit.html.images.TriangleIconDown;
import org.richfaces.renderkit.html.images.TriangleIconUp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExtendedTableRenderer
extends AbstractExtendedRowsRenderer {
    private static final String SORT_FILTER_PARAMETER = "fsp";
    private static final String SORT_DIR_PARAMETER = "sortDir";
    private static final String SORT_DIR_PARAMETER_ASC = "asc";
    private static final String SORT_DIR_PARAMETER_DESC = "desc";
    private static final String FILTER_INPUT_FACET_NAME = "filterValueInput";
    private static final String COL_RESIZE_ACTION_NAME = "columnResizeAction";
    private static final String CHANGE_COL_VISIBILITY = "change_col_v";
    private static final String SORT_FUNCTION = "sortFunction";
    private static final String GROUP_FUNCTION = "groupFunction";
    private static final String SHOW_MENU_FUNCTION = "showMenuFunction";
    private static final String ON_RESIZE_FUNCTION = "onColumnResize";
    private static final String GROUP_FILTER_PARAMETER = "groupParam";
    private static final String ON_GROUP_TOGGLE_FUNCTION = "onGroupToggleFunction";
    private static final String GROUP_TOGGLE_ACTION_NAME = "groupToggleAction";
    private static final String MIN_COLUMN_WIDTH = "20";
    private final Log log = LogFactory.getLog(UIExtendedDataTable.class);

    public void encodeColumns(FacesContext context, UIExtendedDataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Iterator<UIColumn> cols = table.getSortedColumns();
        while (cols.hasNext()) {
            UIColumn col = cols.next();
            if (!col.isRendered()) continue;
            writer.startElement("col", (UIComponent)table);
            String colWidth = table.getColumnSize((UIComponent)col);
            writer.writeAttribute("width", (Object)colWidth, null);
            writer.endElement("col");
        }
        writer.startElement("col", (UIComponent)table);
        writer.endElement("col");
    }

    public void encodeHeader(FacesContext context, UIExtendedDataTable table) throws IOException {
        int i;
        ResponseWriter writer = context.getResponseWriter();
        UIComponent header = table.getHeader();
        boolean columnFacetHeaderPresent = this.isColumnFacetPresent(table, "header");
        Iterator<UIColumn> colums = table.getSortedColumns();
        int numberOfColumns = table.getVisibleColumnsCount() + 1;
        String headerClass = (String)table.getAttributes().get("headerClass");
        writer.startElement("thead", (UIComponent)table);
        writer.writeAttribute("id", (Object)(table.getBaseClientId(context) + ":header"), null);
        writer.writeAttribute("class", (Object)"extdt-thead", null);
        writer.startElement("tr", header);
        this.encodeStyleClass(writer, null, "extdt-header rich-extdt-header", headerClass, null);
        writer.writeAttribute("id", (Object)(table.getBaseClientId(context) + ":fakeIeRow"), null);
        for (i = 0; i < numberOfColumns; ++i) {
            writer.startElement("th", header);
            this.encodeStyleClass(writer, null, "extdt-headercell extdt-fakeierow rich-extdt-headercell", headerClass, null);
            writer.endElement("th");
        }
        writer.endElement("tr");
        if (header != null) {
            this.encodeTableHeaderFacet(context, numberOfColumns, writer, header, "extdt-header rich-extdt-header", "extdt-header-continue rich-extdt-header-continue", "extdt-headercell rich-extdt-headercell", headerClass, "th", "header");
        }
        writer.startElement("tr", (UIComponent)table);
        writer.writeAttribute("id", (Object)(table.getBaseClientId(context) + ":headerRow"), null);
        this.encodeStyleClass(writer, null, "extdt-subheader rich-extdt-subheader", null, headerClass);
        if (columnFacetHeaderPresent) {
            this.encodeHeaderFacets(context, writer, table, colums, "extdt-menucell extdt-subheadercell rich-extdt-subheadercell", headerClass, "header", "th", numberOfColumns);
            writer.startElement("th", (UIComponent)table);
            this.encodeStyleClass(writer, null, "extdt-empty-cell rich-extdt-subheadercell", null, null);
            this.encodeNBSP(writer);
            writer.endElement("th");
        } else {
            writer.writeAttribute("style", (Object)"height: 0px", null);
            for (i = 0; i < numberOfColumns; ++i) {
                writer.startElement("th", header);
                this.encodeNBSP(writer);
                writer.endElement("th");
            }
        }
        writer.endElement("tr");
        this.encodeFilterRow(context, writer, table, table.getSortedColumns(), "extdt-subheadercell rich-extdt-subheadercell", headerClass, "filter", "th");
        writer.endElement("thead");
    }

    private void encodeNBSP(ResponseWriter writer) throws IOException {
        writer.write("&nbsp;");
    }

    private void encodeFilterRow(FacesContext context, ResponseWriter writer, UIExtendedDataTable table, Iterator<UIColumn> headers, String skinCellClass, String headerClass, String facetName, String element) throws IOException {
        if (this.filteringEnabled(table)) {
            writer.startElement("tr", (UIComponent)table);
            writer.writeAttribute("id", (Object)(table.getBaseClientId(context) + ":filterRow"), null);
            this.encodeStyleClass(writer, null, "extdt-table-filterrow rich-extdt-subheader", null, headerClass);
            this.encodeFilterInputs(context, writer, table, headers, skinCellClass, headerClass, facetName, element);
            writer.startElement("th", (UIComponent)table);
            this.encodeStyleClass(writer, null, "extdt-empty-cell rich-extdt-subheadercell", null, null);
            this.encodeNBSP(writer);
            writer.endElement("th");
            writer.endElement("tr");
        }
    }

    private boolean internalFilterEnabledColumn(UIColumn dataColumn) {
        return dataColumn.getFilterMethod() == null && dataColumn.getValueExpression("filterExpression") == null && dataColumn.getValueExpression("filterBy") != null;
    }

    private boolean filteringEnabled(UIExtendedDataTable table) {
        Iterator<UIColumn> columns = table.getSortedColumns();
        boolean enabled = false;
        while (columns.hasNext()) {
            UIColumn dataColumn;
            UIColumn col = columns.next();
            if (!(col instanceof UIColumn) || !this.internalFilterEnabledColumn(dataColumn = col) && dataColumn.getFacet("filter") == null || !dataColumn.isRendered()) continue;
            enabled = true;
            break;
        }
        return enabled;
    }

    private void encodeFilterInputs(FacesContext context, ResponseWriter writer, UIDataTable table, Iterator<UIColumn> headers, String skinCellClass, String headerClass, String facetName, String element) throws IOException {
        while (headers.hasNext()) {
            UIColumn column = headers.next();
            if (!(column instanceof UIColumn) || !column.isRendered()) continue;
            writer.startElement(element, (UIComponent)table);
            String classAttribute = facetName + "Class";
            String columnHeaderClass = (String)column.getAttributes().get(classAttribute);
            this.encodeStyleClass(writer, null, skinCellClass, headerClass, columnHeaderClass);
            UIColumn dataColumn = column;
            if (this.internalFilterEnabledColumn(dataColumn)) {
                writer.startElement("div", (UIComponent)column);
                this.addInplaceInput(context, (UIComponent)column, this.buildAjaxFunction(context, (UIComponent)column, false, this.getOnAjaxCompleteFunction(context, (UIDataTable)column.getParent())));
                writer.endElement("div");
            } else if (dataColumn.getFacet("filter") != null) {
                writer.startElement("div", (UIComponent)column);
                dataColumn.getFacet("filter").encodeAll(context);
                writer.endElement("div");
            } else {
                this.encodeNBSP(writer);
            }
            writer.endElement(element);
        }
    }

    public boolean isColumnFacetPresent(UIDataTable table, String facetName) {
        Iterator<UIComponent> columns = table.columns();
        boolean result = false;
        while (columns.hasNext() && !result) {
            UIComponent component = columns.next();
            if (!this.isColumnRendered(component) || null == component.getFacet(facetName)) continue;
            result = true;
        }
        return result;
    }

    protected boolean isColumnRendered(UIComponent component) {
        boolean rendered = true;
        try {
            rendered = component.isRendered();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rendered;
    }

    protected void encodeHeaderFacets(FacesContext context, ResponseWriter writer, UIDataTable table, Iterator<UIColumn> headers, String skinCellClass, String headerClass, String facetName, String element, int colCount) throws IOException {
        int t_colCount = 0;
        while (headers.hasNext()) {
            UIColumn column = headers.next();
            if (!this.isColumnRendered((UIComponent)column)) continue;
            t_colCount = (Integer)column.getAttributes().get("colspan") != null ? (t_colCount += ((Integer)column.getAttributes().get("colspan")).intValue()) : ++t_colCount;
            if (t_colCount > colCount) break;
            String classAttribute = facetName + "Class";
            String columnHeaderClass = (String)column.getAttributes().get(classAttribute);
            writer.startElement(element, (UIComponent)column);
            this.encodeStyleClass(writer, null, skinCellClass, headerClass, columnHeaderClass);
            writer.writeAttribute("scope", (Object)"col", null);
            this.getUtils().encodeAttribute(context, (UIComponent)column, "colspan");
            boolean sortableColumn = column.getValueExpression("comparator") != null || column.getValueExpression("sortBy") != null;
            column.getAttributes().put("sortable", sortableColumn);
            SimpleHeaderEncodeStrategy strategy = column instanceof UIColumn && "header".equals(facetName) ? new G3HeaderEncodeStrategy() : new SimpleHeaderEncodeStrategy();
            strategy.encodeBegin(context, writer, (UIComponent)column, facetName, sortableColumn);
            UIComponent facet = column.getFacet(facetName);
            if (facet != null && this.isColumnRendered(facet)) {
                this.renderChild(context, facet);
            }
            strategy.encodeEnd(context, writer, (UIComponent)column, facetName, sortableColumn);
            writer.endElement(element);
        }
    }

    public void encodeFooter(FacesContext context, UIExtendedDataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent footer = table.getFooter();
        boolean columnFacetPresent = this.isColumnFacetPresent(table, "footer");
        Iterator<UIColumn> tableColumns = table.getSortedColumns();
        int columns = table.getVisibleColumnsCount() + 1;
        if (footer != null || columnFacetPresent) {
            writer.startElement("tfoot", (UIComponent)table);
            writer.writeAttribute("id", (Object)(table.getBaseClientId(context) + ":footer"), null);
            String footerClass = (String)table.getAttributes().get("footerClass");
            if (columnFacetPresent) {
                writer.startElement("tr", (UIComponent)table);
                this.encodeStyleClass(writer, null, "extdt-subfooter rich-extdt-subfooter", null, footerClass);
                this.encodeHeaderFacets(context, writer, table, tableColumns, "extdt-subfootercell rich-extdt-subfootercell", footerClass, "footer", "td", columns);
                writer.startElement("td", (UIComponent)table);
                this.encodeStyleClass(writer, null, "extdt-subfootercell rich-extdt-subfootercell", null, null);
                writer.endElement("td");
                writer.endElement("tr");
            }
            if (footer != null) {
                this.encodeTableHeaderFacet(context, columns, writer, footer, "extdt-footer rich-extdt-footer", "extdt-footer-continue rich-extdt-footer-continue", "extdt-footercell rich-extdt-footercell", footerClass, "td", "footer");
            }
            writer.endElement("tfoot");
        }
    }

    private void encodeFakeIeRow(FacesContext context, UIExtendedDataTable table, ExtendedTableHolder holder) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        int numberOfColumns = this.getColumnsCount(table) + 1;
        writer.startElement("tr", (UIComponent)table);
        this.encodeStyleClass(writer, null, "extdt-fakeierow ", null, null);
        writer.writeAttribute("id", (Object)(table.getBaseClientId(context) + ":body:fakeIeRow"), null);
        for (int i = 0; i < numberOfColumns; ++i) {
            writer.startElement("td", (UIComponent)table);
            this.encodeStyleClass(writer, null, "extdt-fakeierow " + this.getCellSkinClass(), null, null);
            writer.endElement("td");
        }
        writer.endElement("tr");
    }

    private void encodeGroupRow(FacesContext context, UIExtendedDataTable table, ExtendedTableHolder holder) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        int numberOfColumns = this.getColumnsCount(table) + 1;
        int actGroupRow = holder.getGroupRowCounter();
        writer.startElement("tr", (UIComponent)table);
        writer.writeAttribute("class", (Object)"extdt-group-row", null);
        writer.writeAttribute("id", (Object)(table.getBaseClientId(context) + ":group-row:" + actGroupRow), null);
        writer.writeAttribute("expanded", (Object)(table.groupIsExpanded(actGroupRow) ? "true" : "false"), null);
        writer.writeAttribute("groupindex", (Object)String.valueOf(actGroupRow), null);
        writer.startElement("td", (UIComponent)table);
        writer.writeAttribute("class", (Object)"extdt-group-cell", null);
        writer.writeAttribute("colspan", (Object)numberOfColumns, null);
        writer.startElement("span", (UIComponent)table);
        writer.startElement("img", (UIComponent)table);
        String imagePlusUri = this.getResource("/org/richfaces/renderkit/html/images/plusIcon.gif").getUri(context, null);
        String imageMinusUri = this.getResource("/org/richfaces/renderkit/html/images/minusIcon.gif").getUri(context, null);
        if (table.groupIsExpanded(actGroupRow)) {
            writer.writeAttribute("src", (Object)imageMinusUri, null);
            writer.writeAttribute("alternatesrc", (Object)imagePlusUri, null);
        } else {
            writer.writeAttribute("src", (Object)imagePlusUri, null);
            writer.writeAttribute("alternatesrc", (Object)imageMinusUri, null);
        }
        writer.endElement("img");
        writer.endElement("span");
        writer.startElement("span", (UIComponent)table);
        writer.writeAttribute("class", (Object)"extdt-group-text", null);
        writer.writeAttribute("style", (Object)"font-weight: bold;", null);
        String label = holder.getGroupingColumnLabel();
        writer.writeText((Object)(label == null ? "" : label + ": "), null);
        writer.endElement("span");
        this.renderChildren(context, (UIComponent)holder.getGroupingColumn());
        writer.startElement("span", (UIComponent)table);
        writer.writeAttribute("class", (Object)"extdt-group-text", null);
        writer.endElement("span");
        writer.endElement("td");
        writer.endElement("tr");
        holder.nextGroupRow();
    }

    protected boolean rowGroupChanged(FacesContext context, ExtendedTableHolder holder) {
        JavaBeanWrapper wrappedActD;
        ObjectWrapperFactory wrapperFactory;
        JavaBeanWrapper wrappedLstD;
        WrappedBeanComparator2 wrappedBeanComparator;
        UIExtendedDataTable table = holder.getTable();
        if (holder.getLastData() == null) {
            return true;
        }
        List sortFields = table.getSortFields();
        ArrayList groupFields = new ArrayList();
        if (!sortFields.isEmpty()) {
            groupFields.add(sortFields.get(0));
        }
        return (wrappedBeanComparator = new WrappedBeanComparator2(groupFields)).compare((Object)(wrappedLstD = (wrapperFactory = new ObjectWrapperFactory(context, table.getVar(), groupFields)).wrapObject(holder.getLastData())), (Object)(wrappedActD = wrapperFactory.wrapObject(table.getRowData()))) != 0;
    }

    @Override
    public void encodeOneRow(FacesContext context, ExtendedTableHolder holder) throws IOException {
        UIExtendedDataTable table = holder.getTable();
        ResponseWriter writer = context.getResponseWriter();
        Iterator<UIColumn> iter = table.getSortedColumns();
        boolean first = true;
        int currentColumn = 0;
        UIColumn column = null;
        if (holder.isFirstRow()) {
            this.encodeFakeIeRow(context, table, holder);
        }
        if (holder.isGroupingOn() && this.rowGroupChanged(context, holder)) {
            this.encodeGroupRow(context, table, holder);
        }
        holder.setFirstRow(false);
        while (iter.hasNext()) {
            column = iter.next();
            boolean isRow = column instanceof Row;
            if (first && !isRow) {
                this.encodeRowStart(context, this.getFirstRowSkinClass(), holder.getRowClass(), table, holder, writer);
            }
            if (column.isRendered()) {
                writer.startElement("td", (UIComponent)table);
                this.getUtils().encodeId(context, (UIComponent)column);
                this.encodeStyleClass(writer, null, this.getCellSkinClass(), holder.getColumnClass(currentColumn), column.getAttributes().get("styleClass"));
                this.encodeStyle(writer, null, null, null, column.getAttributes().get("style"));
                writer.startElement("div", (UIComponent)table);
                writer.writeAttribute("class", (Object)"extdt-cell-div", null);
                this.renderChildren(context, (UIComponent)column);
                writer.endElement("div");
                writer.endElement("td");
            }
            ++currentColumn;
            first = false;
        }
        writer.startElement("td", (UIComponent)table);
        String columnClass = holder.getColumnClass(currentColumn);
        this.encodeStyleClass(writer, null, "extdt-empty-cell rich-extdt-cell", null, columnClass);
        writer.endElement("td");
        if (!first && !(column instanceof Row)) {
            writer.endElement("tr");
        }
    }

    protected void encodeRowStart(FacesContext context, String rowClass, UIDataTable table, TableHolder holder, ResponseWriter writer) throws IOException {
        this.encodeRowStart(context, this.getRowSkinClass(), rowClass, table, holder, writer);
    }

    protected String getRowSkinClass() {
        return "extdt-row rich-extdt-row";
    }

    protected String getFirstRowSkinClass() {
        return "extdt-firstrow rich-extdt-firstrow";
    }

    protected String getCellSkinClass() {
        return "extdt-cell rich-extdt-cell";
    }

    protected void encodeRowStart(FacesContext context, String skinClass, String rowClass, UIDataTable table, TableHolder holder, ResponseWriter writer) throws IOException {
        writer.startElement("tr", (UIComponent)table);
        this.encodeRowId(context, writer, table, holder.getRowCounter());
        this.encodeStyleClass(writer, null, skinClass, null, rowClass);
        this.encodeRowEvents(context, (UIDataAdaptor)table);
    }

    protected void encodeRowId(FacesContext context, ResponseWriter writer, UIDataTable table, int rowId) throws IOException {
        String ownerId = table.getBaseClientId(context);
        this.getUtils().writeAttribute(writer, "id", (Object)(ownerId + ":n:" + rowId));
    }

    protected int getColumnsCount(UIDataTable table) {
        int count = 0;
        Integer span = (Integer)table.getAttributes().get("columns");
        if (null != span && span != Integer.MIN_VALUE) {
            count = span;
        } else {
            Iterator<UIComponent> col = table.columns();
            count = this.calculateRowColumns(col);
        }
        return count;
    }

    protected int calculateRowColumns(Iterator<UIComponent> col) {
        int count = 0;
        int currentLength = 0;
        while (col.hasNext()) {
            UIComponent column = col.next();
            if (!column.isRendered()) continue;
            if (column instanceof Row) {
                if (currentLength > count) {
                    count = currentLength;
                }
                if ((currentLength = this.calculateRowColumns(((Row)column).columns())) > count) {
                    count = currentLength;
                }
                currentLength = 0;
                continue;
            }
            if (column instanceof Column) {
                Integer colspan;
                Column tableColumn = (Column)column;
                if (tableColumn.isBreakBefore()) {
                    if (currentLength > count) {
                        count = currentLength;
                    }
                    currentLength = 0;
                }
                if (null != (colspan = (Integer)column.getAttributes().get("colspan")) && colspan != Integer.MIN_VALUE) {
                    currentLength += colspan.intValue();
                    continue;
                }
                ++currentLength;
                continue;
            }
            if (!(column instanceof javax.faces.component.UIColumn)) continue;
            ++currentLength;
        }
        if (currentLength > count) {
            count = currentLength;
        }
        return count;
    }

    public void encodeScriptIfNecessary(FacesContext context, UIExtendedDataTable table) throws IOException {
        boolean shouldRender = false;
        Iterator<UIColumn> columns = table.getSortedColumns();
        while (columns.hasNext() && !shouldRender) {
            UIColumn next = columns.next();
            shouldRender = next.isSortable();
            shouldRender = true;
        }
        shouldRender = true;
        if (shouldRender) {
            this.getUtils().writeScript(context, (UIComponent)table, (Object)this.createClientDataTable(context, table));
        }
    }

    public String createClientDataTable(FacesContext context, UIExtendedDataTable table) {
        JSFunction function = new JSFunction("new ExtendedDataTable.DataTable", new Object[0]);
        function.addParameter((Object)table.getBaseClientId(context));
        ScriptOptions scriptOptions = new ScriptOptions((UIComponent)table);
        scriptOptions.addOption(ON_RESIZE_FUNCTION, (Object)this.getOnResizeFunctionDef(context, table));
        scriptOptions.addOption(SORT_FUNCTION, (Object)this.getSortFunctionDef(context, table));
        scriptOptions.addOption(GROUP_FUNCTION, (Object)this.getGroupFunctionDef(context, table));
        scriptOptions.addOption(SHOW_MENU_FUNCTION, (Object)this.getShowMenuFunction(context, table));
        scriptOptions.addOption(ON_GROUP_TOGGLE_FUNCTION, (Object)this.getOnGroupToggleFunctionDef(context, table));
        scriptOptions.addOption("minColumnWidth", (Object)MIN_COLUMN_WIDTH);
        this.composite.mergeScriptOptions(scriptOptions, context, (UIComponent)table);
        function.addParameter((Object)scriptOptions);
        return function.toScript();
    }

    protected JSFunctionDefinition getShowMenuFunction(FacesContext context, UIDataTable table) {
        return new RichTableMenuRenderer().createShowMenuEventFunction();
    }

    protected JSFunctionDefinition getSortFunctionDef(FacesContext context, UIDataTable table) {
        return this.getSortFunctionDef(context, table, null);
    }

    protected JSFunctionDefinition getSortFunctionDef(FacesContext context, UIDataTable table, Boolean asc) {
        JSFunctionDefinition definition = new JSFunctionDefinition(new Object[0]);
        definition.addParameter((Object)"event");
        definition.addParameter((Object)"columnId");
        definition.addParameter((Object)"ascending");
        String id = table.getClientId(context);
        Map eventOptions = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)table);
        Map parameters = (Map)eventOptions.get("parameters");
        parameters.put(id, SORT_FILTER_PARAMETER);
        JSFunctionDefinition onAjaxCompleteFunction = this.getOnAjaxCompleteFunction(context, table);
        if (onAjaxCompleteFunction != null) {
            eventOptions.put("oncomplete", onAjaxCompleteFunction);
        }
        definition.addToBody((Object)"var options = ").addToBody((Object)ScriptUtils.toScript((Object)eventOptions)).addToBody((Object)";\n");
        definition.addToBody((Object)"options.parameters['fsp'] = columnId;\n");
        definition.addToBody((Object)"if (ascending != null){\toptions.parameters['sortDir'] = (ascending ? 'asc':'desc');}");
        JSFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction((UIComponent)table, (FacesContext)context);
        ajaxFunction.addParameter((Object)new JSReference("options"));
        definition.addToBody((Object)ajaxFunction.toScript()).addToBody((Object)";\n");
        return definition;
    }

    protected JSFunction getSortFunction(FacesContext context, UIDataTable table) {
        String id = table.getClientId(context);
        Map requestOpts = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)table);
        Map parameters = (Map)requestOpts.get("parameters");
        parameters.put(id, SORT_FILTER_PARAMETER);
        parameters.put(SORT_DIR_PARAMETER, "{sortDirection}");
        parameters.put(SORT_FILTER_PARAMETER, "{columnId}");
        JSFunctionDefinition onAjaxCompleteFunction = this.getOnAjaxCompleteFunction(context, table);
        if (onAjaxCompleteFunction != null) {
            requestOpts.put("oncomplete", onAjaxCompleteFunction);
        }
        JSFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction((UIComponent)table, (FacesContext)context);
        ajaxFunction.addParameter((Object)requestOpts);
        return ajaxFunction;
    }

    protected JSFunction getGroupFunction(FacesContext context, UIDataTable table) {
        String id = table.getClientId(context);
        Map requestOpts = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)table);
        Map parameters = (Map)requestOpts.get("parameters");
        parameters.put(id, GROUP_FILTER_PARAMETER);
        parameters.put(GROUP_FILTER_PARAMETER, "{columnId}");
        JSFunctionDefinition onAjaxCompleteFunction = this.getOnAjaxCompleteFunction(context, table);
        if (onAjaxCompleteFunction != null) {
            requestOpts.put("oncomplete", onAjaxCompleteFunction);
        }
        JSFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction((UIComponent)table, (FacesContext)context);
        ajaxFunction.addParameter((Object)requestOpts);
        return ajaxFunction;
    }

    protected JSFunctionDefinition getGroupFunctionDef(FacesContext context, UIDataTable table) {
        JSFunctionDefinition definition = new JSFunctionDefinition(new Object[0]);
        definition.addParameter((Object)"event");
        definition.addParameter((Object)"columnId");
        String id = table.getClientId(context);
        Map eventOptions = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)table);
        Map parameters = (Map)eventOptions.get("parameters");
        parameters.put(id, GROUP_FILTER_PARAMETER);
        JSFunctionDefinition onAjaxCompleteFunction = this.getOnAjaxCompleteFunction(context, table);
        if (onAjaxCompleteFunction != null) {
            eventOptions.put("oncomplete", onAjaxCompleteFunction);
        }
        definition.addToBody((Object)"var options = ").addToBody((Object)ScriptUtils.toScript((Object)eventOptions)).addToBody((Object)";\n");
        definition.addToBody((Object)"options.parameters['groupParam'] = columnId;\n");
        JSFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction((UIComponent)table, (FacesContext)context);
        ajaxFunction.addParameter((Object)new JSReference("options"));
        definition.addToBody((Object)ajaxFunction.toScript()).addToBody((Object)";\n");
        return definition;
    }

    protected JSFunctionDefinition getOnGroupToggleFunctionDef(FacesContext context, UIDataTable table) {
        JSFunctionDefinition definition = new JSFunctionDefinition(new Object[0]);
        definition.addParameter((Object)"event");
        definition.addParameter((Object)"groupIndex");
        Map eventOptions = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)table);
        Map parameters = (Map)eventOptions.get("parameters");
        parameters.put(GROUP_TOGGLE_ACTION_NAME, GROUP_TOGGLE_ACTION_NAME);
        definition.addToBody((Object)"var options = ").addToBody((Object)ScriptUtils.toScript((Object)eventOptions)).addToBody((Object)";\n");
        definition.addToBody((Object)"options.parameters['groupIndex'] = groupIndex;\n");
        JSFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction((UIComponent)table, (FacesContext)context);
        ajaxFunction.addParameter((Object)new JSReference("options"));
        definition.addToBody((Object)ajaxFunction.toScript()).addToBody((Object)";\n");
        return definition;
    }

    protected JSFunctionDefinition getOnResizeFunctionDef(FacesContext context, UIDataTable table) {
        JSFunctionDefinition definition = new JSFunctionDefinition(new Object[0]);
        definition.addParameter((Object)"event");
        definition.addParameter((Object)"columnWidths");
        Map eventOptions = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)table);
        Map parameters = (Map)eventOptions.get("parameters");
        parameters.put(COL_RESIZE_ACTION_NAME, COL_RESIZE_ACTION_NAME);
        definition.addToBody((Object)"var options = ").addToBody((Object)ScriptUtils.toScript((Object)eventOptions)).addToBody((Object)";\n");
        definition.addToBody((Object)"options.parameters['columnWidths'] = columnWidths;\n");
        JSFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction((UIComponent)table, (FacesContext)context);
        ajaxFunction.addParameter((Object)new JSReference("options"));
        definition.addToBody((Object)ajaxFunction.toScript()).addToBody((Object)";\n");
        return definition;
    }

    protected JSFunction getChangeColumnVisibilityFunction(FacesContext context, UIDataTable table) {
        HashMap<String, String> parameters;
        boolean ajaxSingle = true;
        Map requestOpts = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)table);
        JSFunctionDefinition onAjaxCompleteFunction = this.getOnAjaxCompleteFunction(context, table);
        if (onAjaxCompleteFunction != null) {
            requestOpts.put("oncomplete", onAjaxCompleteFunction);
        }
        if ((parameters = (HashMap<String, String>)requestOpts.get("parameters")) == null) {
            parameters = new HashMap<String, String>();
            requestOpts.put("parameters", parameters);
        }
        if (ajaxSingle) {
            if (!parameters.containsKey("ajaxSingle")) {
                parameters.put("ajaxSingle", table.getClientId(context));
            }
            if (!requestOpts.containsKey("control")) {
                requestOpts.put("control", JSReference.THIS);
            }
        }
        parameters.put(table.getClientId(context) + ":" + CHANGE_COL_VISIBILITY, "{columnId}");
        JSFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction((UIComponent)table, (FacesContext)context);
        ajaxFunction.addParameter((Object)requestOpts);
        return ajaxFunction;
    }

    protected JSFunction getPreSendAjaxRequestFunction(FacesContext context, UIDataTable table) {
        return new JSFunction(AbstractExtendedTableRenderer.getJavaScriptVarName(context, table) + ".preSendAjaxRequest", new Object[0]);
    }

    protected void preDecode(FacesContext context, UIComponent component) {
        if (component instanceof UIExtendedDataTable) {
            UIExtendedDataTable table = (UIExtendedDataTable)component;
            table.ensureTableStateInitialized();
        }
        super.preDecode(context, component);
    }

    protected void preEncodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (component instanceof UIExtendedDataTable) {
            UIColumn column;
            UIExtendedDataTable table = (UIExtendedDataTable)component;
            Iterator<UIColumn> columns = table.getChildColumns();
            while (columns.hasNext()) {
                UIColumn column2 = columns.next();
                column2.setId(column2.getId());
            }
            if (table.isGroupingOn() && (column = table.getGroupByColumn()).getSortOrder().equals((Object)Ordering.UNSORTED)) {
                column.setSortOrder(Ordering.ASCENDING);
            }
        }
        super.preEncodeBegin(context, component);
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        super.doDecode(context, component);
        this.composite.decode(context, component);
        if (component instanceof UIExtendedDataTable) {
            String columnToChange;
            String clientId;
            UIExtendedDataTable table = (UIExtendedDataTable)component;
            Map map = context.getExternalContext().getRequestParameterMap();
            if (SORT_FILTER_PARAMETER.equals(map.get(clientId = component.getClientId(context)))) {
                String sortColumnId = (String)map.get(SORT_FILTER_PARAMETER);
                boolean isSingleSortMode = !"multi".equals(table.getSortMode());
                boolean sorting = false;
                boolean filtering = false;
                boolean isGroupingOn = table.isGroupingOn();
                boolean sortByGroupingColumn = false;
                UIColumn groupingColumn = null;
                if (isGroupingOn) {
                    groupingColumn = table.getGroupByColumn();
                    sortByGroupingColumn = groupingColumn == null ? false : groupingColumn.getClientId(context).equals(sortColumnId);
                }
                Iterator<UIColumn> columns = table.getChildColumns();
                while (columns.hasNext()) {
                    boolean filterChanged;
                    UIInput filterValueInput;
                    UIColumn column = columns.next();
                    String id = column.getId();
                    column.setId(id);
                    if (sortColumnId != null) {
                        boolean isGroupingColumn;
                        sorting = true;
                        boolean bl = isGroupingColumn = isGroupingOn && ((Object)((Object)column)).equals((Object)groupingColumn);
                        if (sortColumnId.equals(column.getClientId(context))) {
                            if (map.containsKey(SORT_DIR_PARAMETER)) {
                                String sortDir = (String)map.get(SORT_DIR_PARAMETER);
                                column.setSortOrder(sortDir.equals(SORT_DIR_PARAMETER_ASC) ? Ordering.ASCENDING : (sortDir.equals(SORT_DIR_PARAMETER_DESC) ? Ordering.DESCENDING : Ordering.UNSORTED));
                            } else {
                                column.toggleSortOrder();
                            }
                            Collection<Object> sortPriority = table.getSortPriority();
                            if (isSingleSortMode) {
                                sortPriority.clear();
                            }
                            if (!sortPriority.contains(id)) {
                                sortPriority.add(id);
                            }
                            if (isGroupingColumn) {
                                table.setGroupByColumn(column);
                            }
                        } else if (isSingleSortMode && !isGroupingColumn && !sortByGroupingColumn) {
                            column.setSortOrder(Ordering.UNSORTED);
                        }
                    }
                    if (null == (filterValueInput = (UIInput)column.getFacet(FILTER_INPUT_FACET_NAME))) continue;
                    filterValueInput.decode(context);
                    String oldFilterValue = column.getFilterValue();
                    Object submittedValue = filterValueInput.getSubmittedValue();
                    String newFilterValue = null;
                    if (null != submittedValue) {
                        newFilterValue = filterValueInput.getSubmittedValue().toString();
                        if (newFilterValue != null && newFilterValue.length() == 0) {
                            newFilterValue = null;
                        }
                        column.setFilterValue(newFilterValue);
                    }
                    boolean bl = newFilterValue == null ? oldFilterValue != null : (filterChanged = !newFilterValue.equals(oldFilterValue));
                    if (filterChanged) {
                        AjaxContext.getCurrentInstance().getResponseDataMap().put("_A4J.AJAX.focus", filterValueInput.getClientId(context));
                    }
                    filtering = filtering || filterChanged;
                }
                if (sorting) {
                    new ExtTableSortEvent(component).queue();
                }
                if (filtering) {
                    new ExtTableFilterEvent(component).queue();
                }
            }
            if (GROUP_FILTER_PARAMETER.equals(map.get(clientId))) {
                String groupColumnId = (String)map.get(GROUP_FILTER_PARAMETER);
                table.disableGrouping();
                if (groupColumnId != null) {
                    table.getSortPriority().clear();
                    Iterator<UIColumn> columns = table.getChildColumns();
                    while (columns.hasNext()) {
                        UIColumn column = columns.next();
                        if (groupColumnId.equals(column.getClientId(context))) {
                            if (column.getSortOrder().equals((Object)Ordering.UNSORTED)) {
                                column.setSortOrder(Ordering.ASCENDING);
                            }
                            table.setGroupByColumn(column);
                            continue;
                        }
                        column.setSortOrder(Ordering.UNSORTED);
                    }
                }
                new ExtTableSortEvent(component).queue();
            }
            String dragSourceId = (String)map.get("dragSourceId");
            String dropTargetId = (String)map.get("dropTargetId");
            if (dragSourceId != null && dropTargetId != null) {
                Pattern sourcePattern = Pattern.compile(clientId + ":(\\w*):" + "dnd_drag_script");
                Pattern targetPattern = Pattern.compile(clientId + ":(\\w*):" + "dnd_drop_script" + "(" + "_left" + "|" + "_right" + ")");
                Matcher sourceMatcher = sourcePattern.matcher(dragSourceId);
                Matcher targetMatcher = targetPattern.matcher(dropTargetId);
                if (sourceMatcher.find() && targetMatcher.find()) {
                    String sourceColumnId = sourceMatcher.group(1);
                    String targetColumnId = targetMatcher.group(1);
                    String kind = targetMatcher.group(2);
                    DragDropEvent dragDropEvent = new DragDropEvent(component);
                    dragDropEvent.setDragValue((Object)sourceColumnId);
                    dragDropEvent.setDropValue((Object)targetColumnId);
                    dragDropEvent.setDropBefore(kind.equals("_left"));
                    dragDropEvent.queue();
                }
            }
            if ((columnToChange = (String)map.get(clientId + ":" + CHANGE_COL_VISIBILITY)) != null) {
                ChangeColumnVisibilityEvent event = new ChangeColumnVisibilityEvent(component, columnToChange);
                event.queue();
            }
            if (COL_RESIZE_ACTION_NAME.equals(map.get(COL_RESIZE_ACTION_NAME))) {
                String colWidths = (String)map.get("columnWidths");
                ColumnResizeEvent event = new ColumnResizeEvent(component, colWidths);
                event.queue();
            }
            if (GROUP_TOGGLE_ACTION_NAME.equals(map.get(GROUP_TOGGLE_ACTION_NAME))) {
                String group = (String)map.get("groupIndex");
                if (group != null) {
                    try {
                        table.toggleGroup(Integer.valueOf(group));
                    }
                    catch (NumberFormatException _) {
                        // empty catch block
                    }
                }
                context.renderResponse();
            }
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        super.encodeBegin(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeEnd(context, component);
        String clientId = component.getClientId(context);
        Set ajaxRenderedAreas = AjaxContext.getCurrentInstance().getAjaxRenderedAreas();
        if (ajaxRenderedAreas.contains(clientId)) {
            Iterator iter = ajaxRenderedAreas.iterator();
            while (iter.hasNext()) {
                String area = (String)iter.next();
                if (!area.startsWith(clientId) || area.equals(clientId)) continue;
                iter.remove();
            }
        }
    }

    protected void addInplaceInput(FacesContext context, UIComponent column, String buffer) throws IOException {
        String filterEvent;
        UIInput filterValueInput = (UIInput)column.getFacet(FILTER_INPUT_FACET_NAME);
        if (null == filterValueInput) {
            filterValueInput = (UIInput)context.getApplication().createComponent("javax.faces.Input");
            filterValueInput.setId(column.getId() + SORT_FILTER_PARAMETER);
            filterValueInput.setImmediate(true);
            filterValueInput.getAttributes().put("styleClass", "rich-filter-input");
            column.getFacets().put(FILTER_INPUT_FACET_NAME, filterValueInput);
            filterValueInput.getAttributes().put("onclick", "Event.stop(event);");
        }
        if (null == (filterEvent = (String)column.getAttributes().get("filterEvent")) || "".equals(filterEvent)) {
            filterEvent = "onchange";
        }
        filterValueInput.getAttributes().put(filterEvent, buffer);
        filterValueInput.setValue(column.getAttributes().get("filterValue"));
        this.getUtils().encodeBeginFormIfNessesary(context, column);
        this.renderChild(context, (UIComponent)filterValueInput);
        this.getUtils().encodeEndFormIfNessesary(context, column);
    }

    protected String buildAjaxFunction(FacesContext context, UIComponent column, boolean sortable, JSFunctionDefinition onAjaxCompleteFunction) {
        UIComponent table = column.getParent();
        String id = table.getClientId(context);
        JSFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction((UIComponent)table, (FacesContext)context);
        Map eventOptions = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)table);
        Map parameters = (Map)eventOptions.get("parameters");
        parameters.put(id, SORT_FILTER_PARAMETER);
        if (sortable) {
            parameters.put(SORT_FILTER_PARAMETER, column.getClientId(context));
        }
        if (onAjaxCompleteFunction != null) {
            eventOptions.put("oncomplete", onAjaxCompleteFunction);
        }
        ajaxFunction.addParameter((Object)eventOptions);
        StringBuffer buffer = new StringBuffer();
        ajaxFunction.appendScript(buffer);
        return buffer.toString();
    }

    public String encodeDragDropChildScripts(FacesContext context, UIDataTable component) throws IOException {
        TableDragDropRenderer.getInstance(context).encodeChildScripts(context, component);
        return "";
    }

    public void encodeNamespace(FacesContext context, UIComponent component) throws IOException {
        NSUtils.writeNameSpace((FacesContext)context, (UIComponent)component);
    }

    public void renderDragSupport(FacesContext context, UIColumn column, String dragSourceId, String indicatorId, String dragLabel) throws IOException {
        TableDragDropRenderer.getInstance(context).renderDragSupport(column, dragSourceId, indicatorId, dragLabel);
    }

    public void renderDropSupport(FacesContext context, UIColumn column, String dropTargetId, boolean before) throws IOException {
        TableDragDropRenderer renderer = TableDragDropRenderer.getInstance(context);
        renderer.setOnAjaxCompleteFunctionDef(this.getOnAjaxCompleteFunction(context, (UIDataTable)column.getParent()));
        renderer.setPreSendAjaxRequestFunction(this.getPreSendAjaxRequestFunction(context, (UIDataTable)column.getParent()));
        renderer.renderDropSupport(column, dropTargetId, before);
    }

    public static String getJavaScriptVarName(FacesContext context, UIDataTable grid) {
        String id = grid.getBaseClientId(context);
        String name = "ExtendedDataTable.DataTable_" + id.replaceAll("[^A-Za-z0-9_]", "_");
        return "window." + name;
    }

    protected String getScriptContributions(FacesContext context, UIDataTable grid) {
        return this.composite.getScriptContributions(AbstractExtendedTableRenderer.getJavaScriptVarName(context, grid), context, (UIComponent)grid);
    }

    protected JSFunctionDefinition getOnAjaxCompleteFunction(FacesContext context, UIDataTable table) {
        return null;
    }

    public void encodeTableMenu(FacesContext context, UIExtendedDataTable table) throws IOException {
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance();
        Object key = table.getRowKey();
        table.setRowKey(null);
        RichTableMenuRenderer menuRenderer = new RichTableMenuRenderer();
        menuRenderer.setSortFunction(this.getSortFunction(context, table));
        menuRenderer.setGroupFunction(this.getGroupFunction(context, table));
        menuRenderer.setChangeColumnVisibilityFunction(this.getChangeColumnVisibilityFunction(context, table));
        menuRenderer.setPrepareFunction(this.getPreSendAjaxRequestFunction(context, table));
        Iterator<UIColumn> colums = table.getSortedColumns();
        while (colums.hasNext()) {
            UIColumn col = colums.next();
            if (!(col instanceof UIColumn)) continue;
            UIColumn column = col;
            String menuId = menuRenderer.renderMenu(context, table, column);
            ajaxContext.addRenderedArea(menuId);
        }
        table.setRowKey(key);
    }

    public void contributorsEncodeHere(FacesContext context, UIDataTable table) throws IOException {
        RendererContributor[] contribs = this.composite.getContributors();
        if (contribs != null) {
            for (int i = 0; i < contribs.length; ++i) {
                RendererContributor rendererContributor = contribs[i];
                if (!(rendererContributor instanceof HTMLEncodingContributor)) continue;
                ((HTMLEncodingContributor)rendererContributor).encode(context, (UIComponent)table);
            }
        }
    }

    protected class G3HeaderEncodeStrategy
    implements HeaderEncodeStrategy {
        protected G3HeaderEncodeStrategy() {
        }

        public void encodeBegin(FacesContext context, ResponseWriter writer, UIComponent column, String facetName, boolean sortableColumn) throws IOException {
            if (column instanceof UIColumn) {
                boolean sortable;
                UIColumn dataColumn = (UIColumn)column;
                String clientId = dataColumn.getClientId(context);
                writer.writeAttribute("id", (Object)clientId, null);
                column.getAttributes().put("columnClientId", clientId);
                boolean bl = sortable = sortableColumn && dataColumn.isSelfSorted();
                if (sortable) {
                    writer.writeAttribute("style", (Object)"cursor: pointer;", null);
                }
                writer.writeAttribute("sortable", (Object)String.valueOf(sortable), null);
                writer.startElement("div", (UIComponent)dataColumn);
                writer.writeAttribute("id", (Object)(dataColumn.getParent().getClientId(context) + "_hdrag_" + dataColumn.getId()), null);
                writer.startElement("div", (UIComponent)dataColumn);
                writer.writeAttribute("id", (Object)(clientId + ":sortDiv"), null);
                AjaxContext.getCurrentInstance().addRenderedArea(clientId + ":sortDiv");
                writer.startElement("span", column);
                writer.writeAttribute("class", (Object)"extdt-sortable-header", null);
            }
        }

        public void encodeEnd(FacesContext context, ResponseWriter writer, UIComponent column, String facetName, boolean sortableColumn) throws IOException {
            if (column instanceof UIColumn) {
                UIColumn dataColumn = (UIColumn)column;
                String clientId = dataColumn.getClientId(context) + facetName;
                String tableId = dataColumn.getParent().getClientId(context);
                String imageUrl = null;
                if (sortableColumn) {
                    if (Ordering.ASCENDING.equals((Object)dataColumn.getSortOrder())) {
                        imageUrl = null != dataColumn.getSortIconAscending() ? dataColumn.getSortIconAscending() : AbstractExtendedTableRenderer.this.getResource(TriangleIconUp.class.getName()).getUri(context, null);
                    } else if (Ordering.DESCENDING.equals((Object)dataColumn.getSortOrder())) {
                        imageUrl = null != dataColumn.getSortIconDescending() ? dataColumn.getSortIconDescending() : AbstractExtendedTableRenderer.this.getResource(TriangleIconDown.class.getName()).getUri(context, null);
                    } else if (dataColumn.isSelfSorted()) {
                        imageUrl = null != dataColumn.getSortIcon() ? dataColumn.getSortIcon() : AbstractExtendedTableRenderer.this.getResource(DataTableIconSortNone.class.getName()).getUri(context, null);
                    }
                } else {
                    imageUrl = AbstractExtendedTableRenderer.this.getResource("/org/richfaces/renderkit/html/images/s.gif").getUri(context, null);
                }
                if (imageUrl != null) {
                    writer.startElement("img", column);
                    writer.writeAttribute("src", (Object)imageUrl, null);
                    writer.writeAttribute("class", (Object)"extdt-header-sort-img", null);
                    writer.endElement("img");
                }
                writer.endElement("span");
                writer.endElement("div");
                writer.endElement("div");
                String dragSourceId = tableId + "_hdrag_" + dataColumn.getId();
                String indicatorId = tableId + ":dataTable_indicator";
                AbstractExtendedTableRenderer.this.renderDragSupport(context, dataColumn, dragSourceId, indicatorId, (String)dataColumn.getAttributes().get("label"));
                writer.startElement("span", column);
                writer.writeAttribute("id", (Object)(clientId + ":sepSpan"), null);
                writer.writeAttribute("class", (Object)"extdt-hsep", null);
                writer.endElement("span");
                String spanId = tableId + "_hdrop_" + dataColumn.getId() + "left";
                writer.startElement("span", column);
                writer.writeAttribute("id", (Object)spanId, null);
                writer.writeAttribute("class", (Object)"extdt-hdrop", null);
                writer.writeAttribute("style", (Object)"visibility: hidden;", null);
                writer.startElement("span", column);
                writer.writeAttribute("class", (Object)"extdt-hdrop-top extdt-hdrop-top-left", null);
                writer.writeAttribute("style", (Object)"visibility: hidden;", null);
                writer.endElement("span");
                writer.startElement("span", column);
                writer.writeAttribute("class", (Object)"extdt-hdrop-bottom extdt-hdrop-bottom-left", null);
                writer.writeAttribute("style", (Object)"visibility: hidden;", null);
                writer.endElement("span");
                writer.endElement("span");
                AbstractExtendedTableRenderer.this.renderDropSupport(context, dataColumn, spanId, true);
                spanId = tableId + "_hdrop_" + dataColumn.getId() + "right";
                writer.startElement("span", column);
                writer.writeAttribute("id", (Object)spanId, null);
                writer.writeAttribute("class", (Object)"extdt-hdrop", null);
                writer.writeAttribute("style", (Object)"visibility: hidden;", null);
                writer.startElement("span", column);
                writer.writeAttribute("class", (Object)"extdt-hdrop-top extdt-hdrop-top-right", null);
                writer.writeAttribute("style", (Object)"visibility: hidden;", null);
                writer.endElement("span");
                writer.startElement("span", column);
                writer.writeAttribute("class", (Object)"extdt-hdrop-bottom extdt-hdrop-bottom-right", null);
                writer.writeAttribute("style", (Object)"visibility: hidden;", null);
                writer.endElement("span");
                writer.endElement("span");
                AbstractExtendedTableRenderer.this.renderDropSupport(context, dataColumn, spanId, false);
                if ("header".equals(facetName)) {
                    writer.startElement("div", column);
                    String menuDivId = clientId + ":menuDiv";
                    writer.writeAttribute("id", (Object)menuDivId, null);
                    writer.writeAttribute("class", (Object)"extdt-menu-div-out", null);
                    writer.endElement("div");
                }
            }
        }
    }

    protected class RichHeaderEncodeStrategy
    implements HeaderEncodeStrategy {
        protected RichHeaderEncodeStrategy() {
        }

        public void encodeBegin(FacesContext context, ResponseWriter writer, UIComponent column, String facetName, boolean sortableColumn) throws IOException {
            UIColumn col = (UIColumn)column;
            String clientId = col.getClientId(context) + facetName;
            writer.writeAttribute("id", (Object)clientId, null);
            if (sortableColumn && col.isSelfSorted()) {
                writer.writeAttribute("onclick", (Object)AbstractExtendedTableRenderer.this.buildAjaxFunction(context, column, true, null).toString(), null);
                writer.writeAttribute("style", (Object)"cursor: pointer;", null);
            }
            writer.startElement("div", column);
            writer.writeAttribute("id", (Object)(clientId + ":sortDiv"), null);
            AjaxContext.getCurrentInstance().addRenderedArea(clientId + ":sortDiv");
            if (sortableColumn) {
                writer.startElement("span", column);
                writer.writeAttribute("class", (Object)"extdt-sortable-header", null);
            }
        }

        public void encodeEnd(FacesContext context, ResponseWriter writer, UIComponent column, String facetName, boolean sortableColumn) throws IOException {
            UIColumn col = (UIColumn)column;
            if (sortableColumn) {
                String imageUrl = null;
                if (Ordering.ASCENDING.equals((Object)col.getSortOrder())) {
                    imageUrl = null != col.getSortIconAscending() ? col.getSortIconAscending() : AbstractExtendedTableRenderer.this.getResource(TriangleIconUp.class.getName()).getUri(context, null);
                } else if (Ordering.DESCENDING.equals((Object)col.getSortOrder())) {
                    imageUrl = null != col.getSortIconDescending() ? col.getSortIconDescending() : AbstractExtendedTableRenderer.this.getResource(TriangleIconDown.class.getName()).getUri(context, null);
                } else if (col.isSelfSorted()) {
                    imageUrl = null != col.getSortIcon() ? col.getSortIcon() : AbstractExtendedTableRenderer.this.getResource(DataTableIconSortNone.class.getName()).getUri(context, null);
                }
                if (imageUrl != null) {
                    writer.startElement("img", column);
                    writer.writeAttribute("src", (Object)imageUrl, null);
                    writer.writeAttribute("width", (Object)"15", null);
                    writer.writeAttribute("height", (Object)"15", null);
                    writer.writeAttribute("class", (Object)"extdt-header-sort-img", null);
                    writer.endElement("img");
                }
                writer.endElement("span");
            }
            writer.endElement("div");
            if (col.getFilterMethod() == null && col.getValueExpression("filterExpression") == null && col.getValueExpression("filterBy") != null) {
                writer.startElement("div", column);
                AbstractExtendedTableRenderer.this.addInplaceInput(context, column, AbstractExtendedTableRenderer.this.buildAjaxFunction(context, column, false, null));
                writer.endElement("div");
            }
        }
    }

    protected class SimpleHeaderEncodeStrategy
    implements HeaderEncodeStrategy {
        protected SimpleHeaderEncodeStrategy() {
        }

        public void encodeBegin(FacesContext context, ResponseWriter writer, UIComponent column, String facetName, boolean sortableColumn) throws IOException {
        }

        public void encodeEnd(FacesContext context, ResponseWriter writer, UIComponent column, String facetName, boolean sortableColumn) throws IOException {
        }
    }
}

