/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.component.ContextCallbackWrapper;
import org.ajax4jsf.javascript.DnDScript;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.javascript.PrototypeScript;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.richfaces.component.Draggable;
import org.richfaces.component.Dropzone;
import org.richfaces.event.DragEvent;
import org.richfaces.event.DropEvent;
import org.richfaces.json.JSONCollection;
import org.richfaces.json.JSONException;
import org.richfaces.json.JSONMap;
import org.richfaces.renderkit.CompositeRenderer;
import org.richfaces.renderkit.DnDValidator;
import org.richfaces.renderkit.RendererContributor;
import org.richfaces.renderkit.ScriptOptions;

public class DropzoneRendererContributor
implements RendererContributor {
    public static final String DROP_TARGET_ID = "dropTargetId";
    private static RendererContributor instance;

    private DropzoneRendererContributor() {
    }

    public static synchronized RendererContributor getInstance() {
        if (instance == null) {
            instance = new DropzoneRendererContributor();
        }
        return instance;
    }

    public ScriptOptions buildOptions(FacesContext context, UIComponent drop) {
        if (drop instanceof Dropzone) {
            return new DropZoneOptions((Dropzone)drop);
        }
        return null;
    }

    public void decode(FacesContext context, UIComponent component, CompositeRenderer compositeRenderer) {
        String dragSourceId;
        Map paramMap;
        String clientId = component.getClientId(context);
        if (clientId.equals((paramMap = context.getExternalContext().getRequestParameterMap()).get(DROP_TARGET_ID)) && (dragSourceId = (String)paramMap.get("dragSourceId")) != null && dragSourceId.length() != 0) {
            DraggableDecoderContextCallback draggableDecoderContextCallback = new DraggableDecoderContextCallback((Dropzone)component);
            context.getViewRoot().invokeOnComponent(context, dragSourceId, (ContextCallback)new ContextCallbackWrapper((ContextCallback)draggableDecoderContextCallback));
        }
    }

    public String getScriptContribution(FacesContext context, UIComponent component) {
        StringBuffer result = new StringBuffer();
        result.append(".drop = ");
        JSFunctionDefinition definition = new JSFunctionDefinition(new Object[0]);
        definition.addParameter((Object)"event");
        definition.addParameter((Object)"drag");
        Map requestOpts = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)component);
        definition.addToBody((Object)"var options = ").addToBody((Object)ScriptUtils.toScript((Object)requestOpts)).addToBody((Object)";");
        definition.addToBody((Object)("options.parameters['dropTargetId'] = '" + component.getClientId(context) + "';"));
        definition.addToBody((Object)"Richfaces.mergeObjects(options.parameters, drag.getParameters());");
        definition.addToBody((Object)"var dzOptions = this.getDropzoneOptions(); if (dzOptions.ondrop) { if (!dzOptions.ondrop.call(this, event)) return; };");
        JSFunction dropFunction = AjaxRendererUtils.buildAjaxFunction((UIComponent)component, (FacesContext)context);
        dropFunction.addParameter((Object)new JSReference("options"));
        definition.addToBody((Object)dropFunction.toScript()).addToBody((Object)";");
        definition.appendScript(result);
        result.append(";");
        return result.toString();
    }

    public String[] getStyleDependencies() {
        return null;
    }

    public String[] getScriptDependencies() {
        return new String[]{PrototypeScript.class.getName(), "/org/richfaces/renderkit/html/scripts/json/json-mini.js", DnDScript.class.getName(), "/org/richfaces/renderkit/html/scripts/utils.js", "/org/richfaces/renderkit/html/scripts/json/json-dom.js", "/org/richfaces/renderkit/html/scripts/dnd/dnd-common.js", "/org/richfaces/renderkit/html/scripts/dnd/dnd-dropzone.js"};
    }

    public Class getAcceptableClass() {
        return Dropzone.class;
    }

    private static final class DraggableDecoderContextCallback
    implements ContextCallback {
        private Dropzone dropzone;

        public DraggableDecoderContextCallback(Dropzone dropzone) {
            this.dropzone = dropzone;
        }

        public void invokeContextCallback(FacesContext context, UIComponent target) {
            Object acceptedTypes;
            Draggable draggable = (Draggable)target;
            String dragType = draggable.getDragType();
            if (DnDValidator.validateAcceptTypes(context, draggable, this.dropzone, dragType, acceptedTypes = this.dropzone.getAcceptedTypes())) {
                DragEvent dragEvent = new DragEvent((UIComponent)draggable);
                dragEvent.setDropTarget(this.dropzone);
                dragEvent.setAcceptedTypes(acceptedTypes);
                dragEvent.setDropValue(this.dropzone.getDropValue());
                DropEvent dropEvent = new DropEvent((UIComponent)this.dropzone);
                dropEvent.setDraggableSource(draggable);
                dropEvent.setDragType(dragType);
                dropEvent.setDragValue(draggable.getDragValue());
                dragEvent.queue();
                dropEvent.queue();
            }
        }
    }

    public class DropZoneOptions
    extends ScriptOptions {
        public DropZoneOptions(Dropzone zone) {
            String rejectCursors;
            super((UIComponent)zone);
            Object acceptedTypes = zone.getAcceptedTypes();
            if (acceptedTypes instanceof String) {
                try {
                    String typesString = ((String)acceptedTypes).trim();
                    if (!typesString.startsWith("[")) {
                        typesString = "[" + typesString + "]";
                    }
                    acceptedTypes = new JSONCollection(typesString);
                }
                catch (JSONException e) {
                    throw new FacesException((Throwable)e);
                }
            }
            this.addOption("acceptedTypes", acceptedTypes);
            Object typeMapping = zone.getTypeMapping();
            if (typeMapping instanceof String) {
                try {
                    typeMapping = new JSONMap((String)typeMapping);
                }
                catch (JSONException e) {
                    throw new FacesException((Throwable)e);
                }
            }
            this.addOption("typeMapping", typeMapping);
            Object cursorTypeMapping = zone.getCursorTypeMapping();
            if (cursorTypeMapping instanceof String) {
                try {
                    cursorTypeMapping = new JSONMap((String)cursorTypeMapping);
                }
                catch (JSONException e) {
                    throw new FacesException((Throwable)e);
                }
            }
            this.addOption("cursorTypeMapping", cursorTypeMapping);
            String acceptCursors = zone.getAcceptCursors();
            if (!acceptCursors.equals("")) {
                this.addOption("acceptCursor", acceptCursors);
            }
            if (!(rejectCursors = zone.getRejectCursors()).equals("")) {
                this.addOption("rejectCursor", rejectCursors);
            }
            this.addEventHandler("ondragenter", zone.getOndragenter());
            this.addEventHandler("ondragexit", zone.getOndragexit());
            this.addEventHandler("onafterdrag");
            this.addEventHandler("ondrop");
            this.addEventHandler("ondropend");
        }
    }
}

