/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSReference;
import org.richfaces.component.UIColumn;
import org.richfaces.component.UIContextMenu;
import org.richfaces.component.UIMenuGroup;
import org.richfaces.component.UIMenuItem;
import org.richfaces.component.UIMenuSeparator;
import org.richfaces.component.html.ContextMenu;
import org.richfaces.component.html.HtmlMenuGroup;
import org.richfaces.component.html.HtmlMenuItem;
import org.richfaces.component.util.ComponentMessageUtil;
import org.richfaces.renderkit.html.TableMenuRenderer;

public class RichTableMenuRenderer
extends TableMenuRenderer {
    private static final long serialVersionUID = -6812995542681604002L;
    private static final String MSG_COLUMNS = "org.richfaces.component.UIExtendedDataTable.Menu.Columns";
    private static final String MSG_SORT_ASC = "org.richfaces.component.UIExtendedDataTable.Menu.SortAscending";
    private static final String MSG_SORT_DESC = "org.richfaces.component.UIExtendedDataTable.Menu.SortDescending";
    private static final String MSG_GROUP_ON = "org.richfaces.component.UIExtendedDataTable.Menu.GroupByColumn";
    private static final String MSG_GROUP_OFF = "org.richfaces.component.UIExtendedDataTable.Menu.DisableGrouping";
    private int visibleColumnsCount;
    private UIContextMenu menu;
    private static String iconColumnsURI = "resource:///org/richfaces/renderkit/html/images/columns.png";
    private static String iconSortAscURI = "resource:///org/richfaces/renderkit/html/images/menu-sort-asc.png";
    private static String iconSortDescURI = "resource:///org/richfaces/renderkit/html/images/menu-sort-desc.png";
    private static String iconGroupURI = "resource:///org/richfaces/renderkit/html/images/group-by.png";
    private static String iconCheckedURI = "resource:///org/richfaces/renderkit/html/images/checked.gif";
    private static String iconUncheckedURI = "resource:///org/richfaces/renderkit/html/images/unchecked.gif";

    public String render() throws IOException {
        this.ensureMenuBuilt();
        String menuId = this.menu.getClientId(this.context);
        this.menu.encodeAll(this.context);
        return menuId;
    }

    protected void ensureMenuBuilt() throws IOException {
        this.menu = null;
        for (UIComponent comp : this.table.getChildren()) {
            if (!comp.getId().equals(this.buildMenuId()) || !(comp instanceof UIContextMenu)) continue;
            this.menu = (UIContextMenu)comp;
            break;
        }
        this.buildMenu();
    }

    protected String buildMenuId() {
        return this.column.getId() + "menu";
    }

    protected void createMenu() throws IOException {
        this.menu = (UIContextMenu)this.context.getApplication().createComponent("org.richfaces.ContextMenu");
        this.menu.setId(this.buildMenuId());
        this.menu.setAttached(false);
        this.menu.setSubmitMode("none");
        this.menu.setEvent("onclick");
        this.menu.setDisableDefaultMenu(false);
        if (this.menu instanceof ContextMenu) {
            ((ContextMenu)this.menu).setStyle("z-index: 100; text-align: left; font-weight: normal;");
        }
        this.table.getChildren().add(this.menu);
    }

    protected void buildMenu() throws IOException {
        if (this.menu == null) {
            this.createMenu();
        } else {
            this.menu.getChildren().clear();
        }
        this.buildSortMenuItem((UIComponent)this.menu, true);
        this.buildSortMenuItem((UIComponent)this.menu, false);
        UIMenuSeparator sep = (UIMenuSeparator)this.context.getApplication().createComponent("org.richfaces.MenuSeparator");
        this.menu.getChildren().add(sep);
        this.buildGroupMenuItem((UIComponent)this.menu);
        sep = (UIMenuSeparator)this.context.getApplication().createComponent("org.richfaces.MenuSeparator");
        this.menu.getChildren().add(sep);
        HtmlMenuGroup group = (HtmlMenuGroup)this.context.getApplication().createComponent("org.richfaces.MenuGroup");
        group.setValue(ComponentMessageUtil.getMessage((FacesContext)this.context, (String)MSG_COLUMNS, (Object[])new Object[0]).getSummary());
        ((UIMenuGroup)group).setIcon(iconColumnsURI);
        this.menu.getChildren().add(group);
        Iterator<UIColumn> columns = this.table.getSortedColumns();
        this.visibleColumnsCount = this.table.getVisibleColumnsCount();
        while (columns.hasNext()) {
            this.buildMenuItem((UIComponent)group, columns.next());
        }
    }

    protected void buildSortMenuItem(UIComponent parent, boolean asc) throws IOException {
        UIMenuItem menuItem = (UIMenuItem)this.context.getApplication().createComponent("org.richfaces.MenuItem");
        menuItem.setSubmitMode("none");
        String actionScript = null;
        StringBuilder actionScriptBuilder = new StringBuilder();
        if (((Boolean)this.column.getAttributes().get("sortable")).booleanValue()) {
            if (this.sortFunction != null) {
                if (this.prepareFunction != null) {
                    actionScriptBuilder.append(this.prepareFunction.toScript()).append("; ");
                }
                actionScriptBuilder.append(this.sortFunction.toScript());
                actionScript = actionScriptBuilder.toString();
                if (actionScript.contains("{columnId}")) {
                    String columnClientId = (String)this.column.getAttributes().get("columnClientId");
                    if (columnClientId == null) {
                        columnClientId = this.column.getClientId(this.context);
                    }
                    actionScript = actionScript.replace("{columnId}", columnClientId);
                }
                if (actionScript.contains("{sortDirection}")) {
                    actionScript = actionScript.replace("{sortDirection}", asc ? "asc" : "desc");
                }
            }
        } else {
            menuItem.setDisabled(true);
        }
        menuItem.setValue(ComponentMessageUtil.getMessage((FacesContext)this.context, (String)(asc ? MSG_SORT_ASC : MSG_SORT_DESC), (Object[])new Object[0]).getSummary());
        menuItem.setIcon(asc ? iconSortAscURI : iconSortDescURI);
        if (menuItem instanceof HtmlMenuItem) {
            ((HtmlMenuItem)menuItem).setOnclick(actionScript == null ? "return false;" : actionScript);
        }
        parent.getChildren().add(menuItem);
    }

    protected void buildGroupMenuItem(UIComponent parent) throws IOException {
        UIMenuItem menuItem = (UIMenuItem)this.context.getApplication().createComponent("org.richfaces.MenuItem");
        menuItem.setSubmitMode("none");
        String actionScript = null;
        StringBuilder actionScriptBuilder = new StringBuilder();
        boolean isGroupingColumn = this.column.getId().equalsIgnoreCase(this.table.getGroupByColumnId());
        if (((Boolean)this.column.getAttributes().get("sortable")).booleanValue()) {
            if (this.groupFunction != null) {
                if (this.prepareFunction != null) {
                    actionScriptBuilder.append(this.prepareFunction.toScript()).append("; ");
                }
                actionScriptBuilder.append(this.groupFunction.toScript());
                actionScript = actionScriptBuilder.toString();
                if (actionScript.contains("{columnId}")) {
                    String columnClientId = (String)this.column.getAttributes().get("columnClientId");
                    if (columnClientId == null) {
                        columnClientId = this.column.getClientId(this.context);
                    }
                    if (isGroupingColumn) {
                        columnClientId = "";
                    }
                    actionScript = actionScript.replace("{columnId}", columnClientId);
                }
            }
        } else {
            menuItem.setDisabled(true);
        }
        menuItem.setValue(ComponentMessageUtil.getMessage((FacesContext)this.context, (String)(isGroupingColumn ? MSG_GROUP_OFF : MSG_GROUP_ON), (Object[])new Object[0]).getSummary());
        menuItem.setIcon(iconGroupURI);
        if (menuItem instanceof HtmlMenuItem) {
            ((HtmlMenuItem)menuItem).setOnclick(actionScript == null ? "return false;" : actionScript);
        }
        parent.getChildren().add(menuItem);
    }

    protected void buildMenuItem(UIComponent parent, UIColumn col) throws IOException {
        if (((Boolean)col.getAttributes().get("rendered")).booleanValue() && col instanceof UIColumn) {
            String label;
            UIColumn dataColumn = col;
            UIMenuItem menuItem = (UIMenuItem)this.context.getApplication().createComponent("org.richfaces.MenuItem");
            menuItem.setSubmitMode("none");
            Boolean v = dataColumn.isVisible();
            boolean columnVisible = v == null ? Boolean.TRUE : v;
            String actionScript = null;
            StringBuilder actionScriptBuilder = new StringBuilder();
            menuItem.setStyle("text-align: left;");
            if (!(columnVisible && this.visibleColumnsCount <= 1 || this.changeColumnVisibilityFunction == null)) {
                if (this.prepareFunction != null) {
                    actionScriptBuilder.append(this.prepareFunction.toScript()).append("; ");
                }
                actionScriptBuilder.append(this.changeColumnVisibilityFunction.toScript());
                actionScript = actionScriptBuilder.toString();
                if (actionScript.contains("{columnId}")) {
                    actionScript = actionScript.replace("{columnId}", dataColumn.getId());
                }
            }
            menuItem.setValue((label = (String)dataColumn.getAttributes().get("label")) == null ? "" : label);
            menuItem.setIcon(columnVisible ? iconCheckedURI : iconUncheckedURI);
            if (menuItem instanceof HtmlMenuItem) {
                ((HtmlMenuItem)menuItem).setOnclick(actionScript == null ? "return false;" : actionScript);
            }
            parent.getChildren().add(menuItem);
        }
    }

    public JSFunctionDefinition createShowMenuEventFunction() {
        JSFunctionDefinition definition = new JSFunctionDefinition(new Object[0]);
        definition.addParameter((Object)"event");
        definition.addParameter((Object)"columnId");
        definition.addParameter((Object)"menuId");
        JSFunction invocation = new JSFunction("Richfaces.componentControl.performOperation", new Object[0]);
        invocation.addParameter((Object)new JSReference("event"));
        invocation.addParameter((Object)new JSReference("menuId"));
        invocation.addParameter((Object)"show");
        invocation.addParameter((Object)new JSReference("{}"));
        invocation.addParameter((Object)Boolean.FALSE);
        definition.addToBody((Object)invocation.toScript()).addToBody((Object)";\n");
        return definition;
    }
}

