/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.MethodBinding;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.Range;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.RendererBase;
import org.ajax4jsf.renderkit.RendererUtils;
import org.richfaces.component.UITree;
import org.richfaces.component.UITreeNode;
import org.richfaces.component.nsutils.NSUtils;
import org.richfaces.component.state.TreeState;
import org.richfaces.component.state.TreeStateAdvisor;
import org.richfaces.model.LastElementAware;
import org.richfaces.model.TreeRange;
import org.richfaces.model.TreeRowKey;
import org.richfaces.renderkit.CompositeRenderer;
import org.richfaces.renderkit.Context;
import org.richfaces.renderkit.DnDParametersEncoder;
import org.richfaces.renderkit.DraggableRendererContributor;
import org.richfaces.renderkit.DropzoneRendererContributor;
import org.richfaces.renderkit.Flag;
import org.richfaces.renderkit.TreeDataModelEventNavigator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TreeRendererBase
extends CompositeRenderer {
    private static final String[] OPTIONS_ATTRIBUTES_LIST = new String[]{"showConnectingLines", "toggleOnClick", "disableKeyboardNavigation"};

    public TreeRendererBase() {
        this.addContributor(DraggableRendererContributor.getInstance());
        this.addContributor(DropzoneRendererContributor.getInstance());
        this.addParameterEncoder(DnDParametersEncoder.getInstance());
    }

    public void writeNamespace(FacesContext context, UIComponent component) throws IOException {
        NSUtils.writeNameSpace((FacesContext)context, (UIComponent)component);
    }

    private List<RowKeyHolder> getKeyHoldersList(Set subTreeKeys, Set nodeKeys, String treePath) {
        if (subTreeKeys != null && subTreeKeys.contains(null)) {
            ArrayList<RowKeyHolder> list = new ArrayList<RowKeyHolder>(1);
            list.add(new RowKeyHolder(null, false));
            return list;
        }
        ArrayList<RowKeyHolder> list = new ArrayList<RowKeyHolder>((subTreeKeys == null ? 0 : subTreeKeys.size()) + (nodeKeys == null ? 0 : nodeKeys.size()));
        if (subTreeKeys != null) {
            for (Object subTreeKey : subTreeKeys) {
                list.add(new RowKeyHolder((TreeRowKey<Object>)((TreeRowKey)subTreeKey), false));
            }
        }
        if (nodeKeys != null) {
            for (Object nodeKey : nodeKeys) {
                TreeRowKey treeRowKey = (TreeRowKey)nodeKey;
                if (treeRowKey != null && treeRowKey.depth() != 0) {
                    list.add(new RowKeyHolder((TreeRowKey<Object>)treeRowKey, true));
                    continue;
                }
                log.warn((Object)("Top node of the [" + treePath + "] tree cannot be re-rendered without subnodes"));
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeAjaxChildren(FacesContext context, UIComponent component, String path, Set ids, Set renderedAreas) throws IOException {
        block24: {
            super.encodeAjaxChildren(context, component, path, ids, renderedAreas);
            try {
                if (!(component instanceof UITree)) break block24;
                UITree tree = (UITree)component;
                String id = path + tree.getId();
                tree.captureOrigValue();
                boolean encodeScripts = false;
                tree.setRowKey(context, null);
                ResponseWriter responseWriter = context.getResponseWriter();
                responseWriter.startElement("div", (UIComponent)tree);
                this.writeNamespace(context, component);
                ArrayList<String> encodedAreaIds = new ArrayList<String>();
                try {
                    List<RowKeyHolder> keyHoldersList = this.getKeyHoldersList(tree.getAllAjaxKeys(), tree.getAllAjaxNodeKeys(), id);
                    Collections.sort(keyHoldersList, new Comparator<RowKeyHolder>(){

                        @Override
                        public int compare(RowKeyHolder o1, RowKeyHolder o2) {
                            int d2;
                            int d1 = o1.rowKey == null ? 0 : o1.rowKey.depth();
                            int n = d2 = o2.rowKey == null ? 0 : o2.rowKey.depth();
                            return d1 < d2 ? -1 : (d2 > d1 ? 1 : 0);
                        }
                    });
                    ArrayList<RowKeyHolder> holders = new ArrayList<RowKeyHolder>();
                    for (RowKeyHolder holder : keyHoldersList) {
                        boolean isSubKey = false;
                        for (RowKeyHolder rowKeyHolder : holders) {
                            if (rowKeyHolder.rowKey != null && !rowKeyHolder.rowKey.isSubKey(holder.rowKey)) continue;
                            isSubKey = true;
                            break;
                        }
                        if (isSubKey) continue;
                        holders.add(holder);
                    }
                    for (RowKeyHolder keyHolder : holders) {
                        TreeRowKey<Object> key = keyHolder.getRowKey();
                        if (key != null && key.depth() == 0) {
                            key = null;
                        }
                        tree.setRowKey(context, key);
                        if (key == null || tree.isRowAvailable()) {
                            String treeClientId = key == null ? tree.getClientId(context) : tree.getNodeFacet().getClientId(context);
                            encodeScripts = true;
                            renderedAreas.add(treeClientId);
                            if (keyHolder.isNodeKey()) {
                                this.writeContent(context, tree, key, false);
                            } else {
                                this.writeContent(context, tree, key, true);
                                String treeChildrenId = treeClientId + ':' + "childs";
                                renderedAreas.add(treeChildrenId);
                            }
                            encodedAreaIds.add(treeClientId);
                            continue;
                        }
                        String cid = tree.getClientId(context);
                        String message = MessageFormat.format("Failed to re-render tree node: {0} due to model data unavailability! Maybe parent node should be re-rendered instead?", cid);
                        ExternalContext externalContext = context.getExternalContext();
                        externalContext.log(message);
                    }
                }
                catch (Exception e) {
                    throw new FacesException((Throwable)e);
                }
                finally {
                    try {
                        tree.setRowKey(context, null);
                        tree.restoreOrigValue();
                    }
                    catch (Exception e) {
                        context.getExternalContext().log(e.getMessage(), (Throwable)e);
                    }
                }
                if (encodeScripts) {
                    this.writeScript(context, tree, encodedAreaIds, renderedAreas);
                }
                responseWriter.endElement("div");
                tree.clearRequestKeysSet();
            }
            finally {
                try {
                    ComponentsVariableResolver.removeVariables((RendererBase)this, (UIComponent)component);
                }
                catch (Exception e) {
                    context.getExternalContext().log(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSelectionValue(FacesContext context, UITree tree) {
        String result = "";
        TreeState treeState = (TreeState)tree.getComponentState();
        TreeRowKey selectedNodeKey = treeState.getSelectedNode();
        if (selectedNodeKey != null) {
            Object rowKey = tree.getRowKey();
            try {
                tree.setRowKey(selectedNodeKey);
                if (tree.isRowAvailable()) {
                    result = tree.getNodeFacet().getClientId(context);
                }
            }
            finally {
                try {
                    tree.setRowKey(rowKey);
                }
                catch (Exception e) {
                    context.getExternalContext().log(e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }

    public String encodeSelectionStateInput(FacesContext context, UITree tree) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", (UIComponent)tree);
        writer.writeAttribute("type", (Object)"hidden", null);
        String selectionHolderInputId = tree.getSelectionStateInputName(context);
        writer.writeAttribute("id", (Object)selectionHolderInputId, null);
        writer.writeAttribute("name", (Object)selectionHolderInputId, null);
        writer.writeAttribute("value", (Object)ScriptUtils.toScript((Object)this.getSelectionValue(context, tree)), null);
        writer.endElement("input");
        return selectionHolderInputId;
    }

    protected String getAjaxScript(FacesContext context, UITree tree) {
        String id = tree.getBaseClientId(context);
        JSFunction function = AjaxRendererUtils.buildAjaxFunction((UIComponent)tree, (FacesContext)context);
        Map eventOptions = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)tree);
        Map parameters = (Map)eventOptions.get("parameters");
        parameters.remove(id);
        parameters.put(id + ":selectedNode", new JSReference("event.selectedNode"));
        function.addParameter((Object)eventOptions);
        StringBuffer buffer = new StringBuffer();
        function.appendScript(buffer);
        buffer.append("; return false;");
        return buffer.toString();
    }

    protected String getScriptContributions(FacesContext context, UITree tree) {
        return super.getScriptContributions(this.getJavaScriptVarName(context, tree), context, (UIComponent)tree);
    }

    protected String getJavaScriptVarName(FacesContext context, UITree tree) {
        String id = tree.getBaseClientId(context);
        return "Richfaces_Tree_" + id.replaceAll("[^A-Za-z0-9_]", "_");
    }

    private void writeScript(FacesContext context, UITree tree, List encodedAreaIds, Set renderedAreas) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = tree.getBaseClientId(context);
        String scriptId = clientId + ':' + "script";
        writer.startElement("div", (UIComponent)tree);
        this.getUtils().writeAttribute(writer, "id", (Object)scriptId);
        writer.startElement("script", (UIComponent)tree);
        this.getUtils().writeAttribute(writer, "type", (Object)"text/javascript");
        String varName = this.getJavaScriptVarName(context, tree);
        writer.writeText((Object)(varName + ".getNodeElements(" + ScriptUtils.toScript((Object)encodedAreaIds) + ");"), null);
        writer.writeText((Object)(varName + ".updateSelection(" + ScriptUtils.toScript((Object)this.getSelectionValue(context, tree)) + ");"), null);
        writer.endElement("script");
        writer.endElement("div");
        renderedAreas.add(tree.getClientId(context) + ':' + "input");
        renderedAreas.add(scriptId);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        this.writeContent(context, (UITree)component, null, true);
    }

    public void writeContent(FacesContext context, UITree input) throws IOException {
        this.writeContent(context, input, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeContent(final FacesContext context, final UITree input, TreeRowKey key, final boolean withSubnodes) throws IOException {
        Flag droppedDownToLevelFlag = new Flag();
        TreeRowKey rowKey = key;
        try {
            input.captureOrigValue();
            input.setRowKey(context, key);
            RendererDataModelEventNavigator levelNavigator = new RendererDataModelEventNavigator(input, rowKey, context, droppedDownToLevelFlag);
            final TreeRange stateRange = (TreeRange)input.getComponentState().getRange();
            TreeRange treeRange = new TreeRange(){

                public boolean processChildren(TreeRowKey rowKey) {
                    return withSubnodes ? stateRange.processChildren(rowKey) : false;
                }

                public boolean processNode(TreeRowKey rowKey) {
                    UITreeNode nodeFacet;
                    Object currentKey = input.getRowKey();
                    if (currentKey == null ? rowKey != null : !currentKey.equals(rowKey)) {
                        input.setRowKey(context, rowKey);
                    }
                    if (!(nodeFacet = input.getNodeFacet()).isRendered()) {
                        return false;
                    }
                    return stateRange.processNode(rowKey);
                }
            };
            input.transferQueuedNode();
            input.walk(context, new DataVisitorWithLastElement(droppedDownToLevelFlag, input, levelNavigator, key), (Range)treeRange, key, null);
            levelNavigator.followRowKey(context, null);
        }
        finally {
            input.setRowKey(context, null);
            input.restoreOrigValue();
        }
    }

    public String getOptions(FacesContext context, UITree tree) {
        Map attributes = tree.getAttributes();
        RendererUtils utils = this.getUtils();
        HashMap options = new HashMap();
        for (String optionAttributeName : OPTIONS_ATTRIBUTES_LIST) {
            Object value = attributes.get(optionAttributeName);
            if (!utils.shouldRenderAttribute(value)) continue;
            options.put(optionAttributeName, value);
        }
        return ScriptUtils.toScript(options);
    }

    private class DataVisitorWithLastElement
    implements DataVisitor,
    LastElementAware {
        private boolean isLastElement = false;
        private final Flag flag;
        private final UITree tree;
        private final RendererDataModelEventNavigator navigator;
        private TreeStateAdvisor methodBindingAdvisor = null;
        private Object floatingKey;

        private DataVisitorWithLastElement(Flag flag, UITree tree, RendererDataModelEventNavigator navigator, Object rowKey) {
            this.flag = flag;
            this.tree = tree;
            this.navigator = navigator;
            this.floatingKey = rowKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(FacesContext context, Object rowKey, Object argument) throws IOException {
            TreeRowKey treeRowKey = (TreeRowKey)rowKey;
            this.processAdvisors(context, treeRowKey);
            this.navigator.followRowKey(context, treeRowKey);
            Context c = this.flag.getContext();
            if (c != null) {
                c.setHasChildren(false);
                this.navigator.openDiv(c);
                this.navigator.closeDiv();
            }
            UITreeNode nodeFacet = this.tree.getNodeFacet();
            Object oldAttrValue = nodeFacet.getAttributes().get("isLastElement");
            Object oldAjaxRootAttrValue = nodeFacet.getAttributes().get("isAjaxUpdateRoot");
            try {
                nodeFacet.getAttributes().put("isLastElement", new Boolean(this.isLastElement));
                nodeFacet.getAttributes().put("isAjaxUpdateRoot", new Boolean(this.floatingKey != null && this.floatingKey.equals(rowKey)));
                ResponseWriter writer = context.getResponseWriter();
                if (this.isLastElement && this.navigator.showLines) {
                    writer.startElement("p", (UIComponent)this.tree);
                    writer.writeAttribute("class", (Object)"dr-tree-last-node-marker", null);
                    writer.endElement("p");
                }
                TreeRendererBase.this.renderChild(context, (UIComponent)nodeFacet);
                c = new Context();
                c.setClientId(nodeFacet.getClientId(context) + ':');
                c.setLast(this.isLastElement);
                c.setExpanded(this.tree.isExpanded());
                c.setRowKey(this.tree.getRowKey());
                this.flag.setContext(c);
            }
            finally {
                if (oldAttrValue != null) {
                    nodeFacet.getAttributes().put("isLastElement", oldAttrValue);
                } else {
                    nodeFacet.getAttributes().remove("isLastElement");
                }
                if (oldAjaxRootAttrValue != null) {
                    nodeFacet.getAttributes().put("isAjaxUpdateRoot", oldAjaxRootAttrValue);
                } else {
                    nodeFacet.getAttributes().remove("isAjaxUpdateRoot");
                }
            }
        }

        public void setLastElement() {
            this.isLastElement = true;
            this.navigator.setLastElement();
        }

        public void resetLastElement() {
            this.isLastElement = false;
            this.navigator.resetLastElement();
        }

        public void processAdvisors(FacesContext context, TreeRowKey rowKey) throws IOException {
            Boolean adviseSelected;
            Boolean adviseOpened;
            TreeState state = (TreeState)this.tree.getComponentState();
            TreeStateAdvisor stateAdvisor = (TreeStateAdvisor)this.tree.getStateAdvisor();
            if (null == stateAdvisor) {
                if (null == this.methodBindingAdvisor) {
                    this.methodBindingAdvisor = new TreeStateAdvisor(){

                        public Boolean adviseNodeOpened(UITree tree) {
                            MethodBinding adviseNodeOpened = tree.getAdviseNodeOpened();
                            if (null != adviseNodeOpened) {
                                return (Boolean)adviseNodeOpened.invoke(FacesContext.getCurrentInstance(), new Object[]{tree});
                            }
                            return null;
                        }

                        public Boolean adviseNodeSelected(UITree tree) {
                            MethodBinding adviseNodeSelected = tree.getAdviseNodeSelected();
                            if (null != adviseNodeSelected) {
                                return (Boolean)adviseNodeSelected.invoke(FacesContext.getCurrentInstance(), new Object[]{tree});
                            }
                            return null;
                        }
                    };
                }
                stateAdvisor = this.methodBindingAdvisor;
            }
            if (null != (adviseOpened = stateAdvisor.adviseNodeOpened(this.tree))) {
                if (adviseOpened.booleanValue()) {
                    state.makeExpanded(rowKey);
                } else {
                    state.makeCollapsed(rowKey);
                }
            }
            if (null != (adviseSelected = stateAdvisor.adviseNodeSelected(this.tree))) {
                if (adviseSelected.booleanValue()) {
                    if (!state.isSelected(rowKey)) {
                        state.setSelected(rowKey);
                    }
                } else if (state.isSelected(rowKey)) {
                    state.setSelected(null);
                }
            }
        }
    }

    private final class RendererDataModelEventNavigator
    extends TreeDataModelEventNavigator {
        private final FacesContext context;
        private final UITree tree;
        private final Flag droppedDownToLevelFlag;
        private final ResponseWriter writer;
        private String clientId;
        private boolean expanded;
        private boolean showLines;

        private RendererDataModelEventNavigator(UITree tree, TreeRowKey floatingKey, FacesContext context, Flag droppedDownToLevelFlag) {
            super(tree, floatingKey);
            this.context = context;
            this.tree = tree;
            this.droppedDownToLevelFlag = droppedDownToLevelFlag;
            this.writer = context.getResponseWriter();
            this.expanded = this.tree.isExpanded();
            this.showLines = this.tree.isShowConnectingLines();
            this.clientId = this.getClientId();
        }

        public void followRowKey(FacesContext context, TreeRowKey newRowKey) throws IOException {
            super.followRowKey(context, newRowKey);
            this.expanded = this.tree.isExpanded();
            this.clientId = this.getClientId();
        }

        private String getClientId() {
            Object rowKey = this.tree.getRowKey();
            String id = rowKey == null ? this.tree.getClientId(this.context) + ':' : this.tree.getNodeFacet().getClientId(this.context) + ':';
            return id;
        }

        public void afterUp(int levels) throws IOException {
            Context c = this.droppedDownToLevelFlag.getContext();
            if (c != null) {
                c.setHasChildren(false);
                this.openDiv(c);
                this.closeDiv();
                this.droppedDownToLevelFlag.setContext(null);
            }
            for (int i = 0; i < levels; ++i) {
                this.closeDiv();
            }
        }

        public void afterDown() throws IOException {
        }

        public void beforeDown() throws IOException {
            Context c = this.droppedDownToLevelFlag.getContext();
            this.droppedDownToLevelFlag.setContext(null);
            this.openDiv(c);
        }

        public void beforeUp(int levels) throws IOException {
        }

        public void openDiv(Context context) throws IOException {
            TreeRowKey floatingKey;
            this.writer.startElement("div", (UIComponent)this.tree);
            if (context == null) {
                context = new Context();
                context.setLast(this.actualLast);
                context.setClientId(this.clientId);
                context.setExpanded(this.expanded);
                context.setRowKey(this.getRowKey());
            }
            TreeRendererBase.this.getUtils().writeAttribute(this.writer, "id", (Object)(context.getClientId() + "childs"));
            if (!context.isExpanded() || !context.isHasChildren()) {
                TreeRendererBase.this.getUtils().writeAttribute(this.writer, "style", (Object)"display: none;");
            } else if (this.tree.isShowConnectingLines() && (floatingKey = this.getFloatingKey()) != null && floatingKey.equals(context.getRowKey())) {
                String expression = "background-image:expression(this.nextSibling ? '' : 'none')";
                TreeRendererBase.this.getUtils().writeAttribute(this.writer, "style", (Object)expression);
            }
            String styleClasses = "";
            if (context.getRowKey() != null) {
                styleClasses = "dr-tree-layout-on dr-tree-h-ic-div rich-tree-node-children rich-tree-node-cildren";
                if (!context.isLast() && this.showLines) {
                    styleClasses = styleClasses + " dr-tree-h-ic-line";
                }
            }
            if (styleClasses != "") {
                TreeRendererBase.this.getUtils().writeAttribute(this.writer, "class", (Object)styleClasses);
            }
        }

        public void closeDiv() throws IOException {
            this.writer.endElement("div");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class RowKeyHolder {
        private TreeRowKey<Object> rowKey;
        private boolean nodeKey;

        public RowKeyHolder(TreeRowKey<Object> rowKey, boolean nodeKey) {
            this.rowKey = rowKey;
            this.nodeKey = nodeKey;
        }

        public boolean isNodeKey() {
            return this.nodeKey;
        }

        public TreeRowKey<Object> getRowKey() {
            return this.rowKey;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.rowKey + "]";
        }
    }
}

