/**
 * License Agreement.
 *
 * Rich Faces - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.convert.seamtext;

import java.lang.reflect.Method;

import javax.faces.FacesException;

/**
 * Default seam text converter implementation factory
 * @author Anton Belevich
 *	
 */
public class SeamTextConverterFactory {
	
	private SeamTextConverter converter;
	
		
	public SeamTextConverter  getConverter() { 
		if(converter == null) {
			converter = createSeamTextConverter();
		} 
		return converter;
	}
	
	public SeamTextConverter createSeamTextConverter() {
		try {
			//TODO nick - use ThreadCCL
			Class clazz = Class.forName("org.richfaces.convert.seamtext.DefaultSeamTextConverter");
			Method method = clazz.getMethod("getInstance"); 
			
			//TODO nick - static method doesn't need any argument, better pass null
			return (SeamTextConverter) method.invoke(clazz);
		
		} catch(Exception e) {
			throw new FacesException(e);
		}
	}
}
